/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.resources;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import vlcskineditor.CustomFileFilter;
import vlcskineditor.Helper;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Resource;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.FontEditEvent;

public class Font
extends Resource
implements ActionListener {
    public String file;
    public final int SIZE_DEFAULT = 12;
    public int size = 12;
    JFrame frame = null;
    JTextField id_tf;
    JTextField file_tf;
    JTextField size_tf;
    JButton file_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    JFileChooser fc;
    public java.awt.Font f;

    public Font(Element element, Skin skin) {
        this.type = "Font";
        this.s = skin;
        if (element.hasAttribute("id")) {
            this.id = element.getAttribute("id");
        }
        if (element.hasAttribute("file")) {
            this.file = element.getAttribute("file");
        }
        if (element.hasAttribute("size")) {
            this.size = Integer.parseInt(element.getAttribute("size"));
        }
    }

    public Font(String string, Skin skin) {
        this.type = "Font";
        this.s = skin;
        this.id = XML.getValue(string, "id");
        this.file = XML.getValue(string, "file");
        if (string.indexOf("size=\"") != -1) {
            this.size = Integer.parseInt(XML.getValue(string, "size"));
        }
        this.updateFont();
    }

    public Font(String string, String string2, int n, Skin skin) {
        this.type = "Font";
        this.s = skin;
        this.id = string;
        this.file = string2;
        this.size = n;
        this.updateFont();
    }

    public Font(Skin skin, File file) {
        this.s = skin;
        this.type = "Font";
        String string = file.getName().substring(0, file.getName().lastIndexOf("."));
        if (this.s.idExists(string)) {
            string = string + "_" + this.s.getNewId();
        }
        this.id = string;
        this.file = file.getPath().replace(this.s.skinfolder, "");
        this.s.updateResources();
        this.s.expandResource(this.id);
        this.updateFont();
    }

    public Font(Skin skin) {
        this.s = skin;
        this.type = "Font";
        this.id = "Unnamed font #" + this.s.getNewId();
        this.file = "";
        this.s.updateResources();
        this.s.expandResource(this.id);
        this.showOptions();
    }

    public Integer updateFont() {
        try {
            this.f = java.awt.Font.createFont(0, new File(this.s.skinfolder + this.file));
            this.f = this.f.deriveFont((float)this.size);
        }
        catch (Exception exception) {
            if (this.file.indexOf(".otf") == -1) {
                this.f = new java.awt.Font("SansSerif", 0, this.size);
                return 0;
            }
            try {
                this.f = new java.awt.Font("SansSerif", 0, this.size);
                this.f = this.f.deriveFont(12);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                this.f = new java.awt.Font("SansSerif", 0, this.size);
            }
            return 2;
        }
        return 1;
    }

    @Override
    public void update() {
        FontEditEvent fontEditEvent = new FontEditEvent(this);
        this.type = "Font";
        this.file = this.file_tf.getText();
        this.size = Integer.parseInt(this.size_tf.getText());
        this.id = this.id_tf.getText();
        this.s.updateResources();
        this.s.expandResource(this.id);
        fontEditEvent.setNew();
        this.s.m.hist.addEvent(fontEditEvent);
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Font settings");
            this.frame.setResizable(false);
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            this.id_tf.setToolTipText("Identifiant of the font that will be used with controls.");
            JLabel jLabel2 = new JLabel("File*:");
            this.file_tf = new JTextField();
            this.file_tf.setToolTipText("This is the file containing a TrueType or OpenType font..");
            this.file_btn = new JButton("Open...");
            this.file_btn.addActionListener(this);
            JLabel jLabel3 = new JLabel("Size:");
            this.size_tf = new JTextField();
            this.size_tf.setDocument(new NumbersOnlyDocument());
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            JLabel jLabel4 = new JLabel("* Attributes marked with a star must be specified.");
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            int n3 = this.file_btn.getPreferredSize().width;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jPanel.add(jLabel2);
            jPanel.add(this.file_tf);
            this.file_tf.setPreferredSize(new Dimension(n2 - n3, this.file_tf.getPreferredSize().height));
            jPanel.add(this.file_btn);
            jPanel.add(jLabel3);
            jPanel.add(this.size_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.id_tf, 0, "East", (Component)this.file_btn);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)jLabel);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.file_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.file_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.file_btn, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.file_btn, 5, "East", (Component)this.file_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.file_btn);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.size_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.size_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.size_tf, 0, "East", (Component)this.file_btn);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)jLabel3);
            this.frame.add(jPanel);
            this.frame.add(jLabel4);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            SpringLayout springLayout2 = new SpringLayout();
            this.frame.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout2.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout2.putConstraint("North", (Component)jLabel4, 5, "South", (Component)jPanel);
            springLayout2.putConstraint("West", (Component)jLabel4, 5, "West", (Component)this.frame.getContentPane());
            springLayout2.putConstraint("East", (Component)jLabel4, 5, "East", (Component)this.frame.getContentPane());
            springLayout2.putConstraint("North", (Component)this.ok_btn, 5, "South", (Component)jLabel4);
            springLayout2.putConstraint("North", (Component)this.cancel_btn, 5, "South", (Component)jLabel4);
            springLayout2.putConstraint("North", (Component)this.help_btn, 5, "South", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout2.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout2.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout2.putConstraint("South", (Component)this.frame.getContentPane(), 5, "South", (Component)this.ok_btn);
            springLayout2.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.file_tf.setText(this.file);
        this.size_tf.setText(String.valueOf(this.size));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.file_btn)) {
            int n;
            if (this.fc == null) {
                this.fc = new JFileChooser();
                String[] stringArray = new String[]{"ttf", "otf"};
                this.fc.setFileFilter(new CustomFileFilter(this.fc, stringArray, "*.otf/*.ttf (Open and true type fonts) inside the XML file's directory", true, this.s.skinfolder));
                this.fc.setCurrentDirectory(new File(this.s.skinfolder));
                this.fc.setAcceptAllFileFilterUsed(false);
            }
            if ((n = this.fc.showOpenDialog(this.frame)) == 0) {
                this.file_tf.setText(this.fc.getSelectedFile().getPath().replace(this.s.skinfolder, ""));
            }
        } else if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (this.file_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please choose a file!", "File not valid", 1);
                return;
            }
            this.update();
            int n = this.updateFont();
            if (n == 0) {
                JOptionPane.showMessageDialog(this.frame, "Error while loading font file!\n Please choose another file\n", "Font file not valid", 0);
            } else if (n == 2) {
                JOptionPane.showMessageDialog(this.frame, "Error while loading font file!\n Please choose another file\n", "Font file not valid", 0);
            } else if (n == 1) {
                this.frame.setVisible(false);
                this.frame.dispose();
                this.frame = null;
            }
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/res-font.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/res-font.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Font id=\"" + this.id + "\" file=\"" + this.file + "\"";
        if (this.size != 12) {
            string2 = string2 + " size=\"" + String.valueOf(this.size) + "\"";
        }
        string2 = string2 + "/>\n";
        return string2;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Font: " + this.id);
        return defaultMutableTreeNode;
    }
}

