; Installer script for vlc 0.2.81-win32
; written by Pierre Baillet <oct@zoy.org> 
; 29/7/01 v0.2


; CHANGELOG
; .lists all installed file so as to prevent installer.nsi to be included in the release.
; .really remove the shortcuts
; .added an exec command to display the program file folder. (grOovy)



OutFile vlc-0.2.82.exe
Name "the VideoLAN Client"
Caption "VLC 0.2.82 win32 Setup"
#Icon ../icons/vlc_installer_low.ico

CRCCheck on

InstallDir $PROGRAMFILES\vlc
; check if the program has already been installed, if so, take this dir as install dir
InstallDirRegKey HKLM SOFTWARE\VideoLAN\VLC "Install_Dir"
DirText "Choose a directory to install in to:"

AutoCloseWindow false
ShowInstDetails show


; uninstall stuff
UninstallText "This will uninstall the VideoLAN Client. Hit next to continue."
UninstallExeName "vlc-uninst.exe"


SetOverwrite ifnewer

SetDatablockOptimize on

SetDateSave off

SetCompress auto

Section "Install"
	SetOutPath $INSTDIR
	File  INSTALL-win32.txt
	File  README-GTK.txt
	File  README-SDL.txt
	File  SDL.dll
	File  gdk-1.3.dll
	File  glib-1.3.dll
	File  gmodule-1.3.dll
	File  gnu-intl.dll
	File  vlc.exe
	File  directx.so
	File  gtk.so
	File  sdl.so
	File  gtk-1.3.dll
	File  AUTHORS
	File  COPYING
	File  ChangeLog
	File  INSTALL
	File  README
	File  TODO
	File  /r share
	CreateDirectory "$SMPROGRAMS\VideoLAN"
	CreateShortCut "$SMPROGRAMS\VideoLAN\vlc_0-2-82.lnk" "$INSTDIR\vlc.exe" 
	CreateShortCut "$SMPROGRAMS\VideoLAN\Uninstall VLC.lnk" "$INSTDIR\vlc-uninst.exe"
	WriteRegStr HKLM SOFTWARE\VideoLAN\VLC "Install_Dir" $INSTDIR
	WriteRegStr HKLM SOFTWARE\VideoLAN\VLC "version" "0.2.82"
	Exec "explorer $SMPROGRAMS\VideoLAN\"
SectionEnd

Section "Uninstall"
	Delete $SMPROGRAMS\VideoLAN\*
	RMDir $SMPROGRAMS\VideoLAN
	Delete $INSTDIR\share\*
	RMDir $INSTDIR\share
	Delete $INSTDIR\*
	RMDir $INSTDIR
	
	DeleteRegKey HKLM SOFTWARE\VideoLAN
SectionEnd





