/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.memory;

import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.visualvm.sampler.memory.ThreadsMemoryInfo;

public class ThreadsMemory {
    private static final ObjectName THREAD_NAME = ThreadsMemory.getThreadName();
    private final ThreadMXBean threadBean;
    private final MBeanServerConnection connection;

    public ThreadsMemory(ThreadMXBean bean, MBeanServerConnection conn) {
        this.threadBean = bean;
        this.connection = conn;
    }

    public ThreadsMemoryInfo getThreadsMemoryInfo() throws MBeanException, ReflectionException, IOException, InstanceNotFoundException {
        long[] ids = this.threadBean.getAllThreadIds();
        ThreadInfo[] tids = this.threadBean.getThreadInfo(ids);
        Object[] args = new Object[]{ids};
        String[] sigs = new String[]{"[J"};
        long[] memInfo = (long[])this.connection.invoke(THREAD_NAME, "getThreadAllocatedBytes", args, sigs);
        long time = System.currentTimeMillis();
        return new ThreadsMemoryInfo(time, tids, memInfo);
    }

    private static ObjectName getThreadName() {
        try {
            return new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }
}

