/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.Distance;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompileState;
import javax.media.j3d.Context;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.Pipeline;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderBin;
import javax.media.j3d.Renderer;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point4d;
import javax.vecmath.Point4f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

abstract class GeometryArrayRetained
extends GeometryRetained {
    int vertexFormat;
    int c4fAllocated = 0;
    int vertexCount;
    int validVertexCount;
    float[] vertexData;
    private float[][] mvertexData;
    int stride;
    int texCoordStride;
    int coordinateOffset;
    int normalOffset;
    int colorOffset;
    int textureOffset;
    int[] vertexAttrOffsets;
    int vertexAttrStride;
    private float[] lastAlpha = new float[1];
    float lastScreenAlpha = -1.0f;
    int colorChanged = 0;
    static final float ByteToFloatScale = 0.003921569f;
    static final float FloatToByteScale = 255.0f;
    boolean inUpdater = false;
    ArrayList gaList = new ArrayList(1);
    static final int targetThreads = 192;
    float[] floatRefCoords = null;
    double[] doubleRefCoords = null;
    Point3d[] p3dRefCoords = null;
    Point3f[] p3fRefCoords = null;
    J3DBuffer coordRefBuffer = null;
    FloatBufferWrapper floatBufferRefCoords = null;
    DoubleBufferWrapper doubleBufferRefCoords = null;
    int initialCoordIndex = 0;
    int initialColorIndex = 0;
    int initialNormalIndex = 0;
    int[] initialTexCoordIndex = null;
    int[] initialVertexAttrIndex = null;
    int initialVertexIndex = 0;
    float[] floatRefColors = null;
    byte[] byteRefColors = null;
    Color3f[] c3fRefColors = null;
    Color4f[] c4fRefColors = null;
    Color3b[] c3bRefColors = null;
    Color4b[] c4bRefColors = null;
    J3DBuffer colorRefBuffer = null;
    FloatBufferWrapper floatBufferRefColors = null;
    ByteBufferWrapper byteBufferRefColors = null;
    int vertexType = 0;
    static final int PF = 1;
    static final int PD = 2;
    static final int P3F = 4;
    static final int P3D = 8;
    static final int VERTEX_DEFINED = 15;
    static final int CF = 16;
    static final int CUB = 32;
    static final int C3F = 64;
    static final int C4F = 128;
    static final int C3UB = 256;
    static final int C4UB = 512;
    static final int COLOR_DEFINED = 1008;
    static final int NF = 1024;
    static final int N3F = 2048;
    static final int NORMAL_DEFINED = 3072;
    static final int TF = 4096;
    static final int T2F = 8192;
    static final int T3F = 16384;
    static final int TEXCOORD_DEFINED = 28672;
    static final int AF = 32768;
    static final int VATTR_DEFINED = 32768;
    private int texCoordType = 0;
    private int vertexAttrType = 0;
    static final int COORD_FLOAT = 1;
    static final int COORD_DOUBLE = 2;
    static final int COLOR_FLOAT = 4;
    static final int COLOR_BYTE = 8;
    static final int NORMAL_FLOAT = 16;
    static final int TEXCOORD_FLOAT = 32;
    static final int VATTR_FLOAT = 64;
    float[] floatRefNormals = null;
    Vector3f[] v3fRefNormals = null;
    J3DBuffer normalRefBuffer = null;
    FloatBufferWrapper floatBufferRefNormals = null;
    float[][] floatRefVertexAttrs = null;
    J3DBuffer[] vertexAttrsRefBuffer = null;
    FloatBufferWrapper[] floatBufferRefVertexAttrs = null;
    Object[] nioFloatBufferRefVertexAttrs = null;
    Object[] refTexCoords = null;
    TexCoord2f[] t2fRefTexCoords = null;
    TexCoord3f[] t3fRefTexCoords = null;
    Object[] refTexCoordsBuffer = null;
    float[] interLeavedVertexData = null;
    J3DBuffer interleavedVertexBuffer = null;
    FloatBufferWrapper interleavedFloatBufferImpl = null;
    float[] mirrorFloatRefCoords = null;
    double[] mirrorDoubleRefCoords = null;
    float[] mirrorFloatRefNormals = null;
    float[][] mirrorFloatRefVertexAttrs = null;
    float[] mirrorFloatRefTexCoords = null;
    Object[] mirrorRefTexCoords = null;
    float[][] mirrorFloatRefColors = new float[1][];
    byte[][] mirrorUnsignedByteRefColors = new byte[1][];
    float[][] mirrorInterleavedColorPointer = null;
    int mirrorVertexAllocated = 0;
    int mirrorColorAllocated = 0;
    boolean mirrorNormalAllocated = false;
    static final int COORDINATE_CHANGED = 1;
    static final int NORMAL_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int TEXTURE_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int INDEX_CHANGED = 32;
    static final int STRIPCOUNT_CHANGED = 64;
    static final int VATTR_CHANGED = 128;
    static final int VERTEX_CHANGED = 143;
    static final int[] defaultTexCoordSetMap = new int[]{0};
    int texCoordSetCount = 0;
    int[] texCoordSetMap = null;
    int[] texCoordSetMapOffset = null;
    int vertexAttrCount = 0;
    int[] vertexAttrSizes = null;
    long pVertexBuffers = 0L;
    int dirtyFlag = 175;
    int resourceCreationMask = 0;
    private HashMap dlistUsers = null;
    private long[] timeStampPerDlist = new long[2];
    int dlistId = -1;
    Integer dlistObj = null;
    static final int INIT_MIRROR_GEOMETRY = 2;
    ArrayList morphUniverseList = null;
    ArrayList morphUserLists = null;
    int[] geoOffset;
    int[] compileVcount;
    boolean isCompiled = false;
    boolean isShared = false;
    IndexedGeometryArrayRetained cloneSourceArray = null;
    static final double EPS = 1.0E-13;

    void freeD3DArray(boolean bl) {
        assert (VirtualUniverse.mc.isD3D());
        Pipeline.getPipeline().freeD3DArray(this, bl);
    }

    GeometryArrayRetained() {
        this.lastAlpha[0] = 1.0f;
    }

    void setLive(boolean bl, int n) {
        this.dirtyFlag = 175;
        this.isEditable = !this.isWriteStatic();
        super.doSetLive(bl, n);
        super.markAsLive();
        if (this.refCount > 1) {
            this.isShared = true;
        } else if (this instanceof IndexedGeometryArrayRetained) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 1024;
            j3dMessage.type = 17;
            j3dMessage.universe = null;
            j3dMessage.args[0] = null;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = new Integer(2);
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void clearLive(int n) {
        super.clearLive(n);
        if (this.refCount <= 0) {
            if (this.pVertexBuffers != 0L) {
                J3dMessage j3dMessage = new J3dMessage();
                j3dMessage.threads = 16;
                j3dMessage.type = 44;
                j3dMessage.universe = null;
                j3dMessage.view = null;
                j3dMessage.args[0] = null;
                j3dMessage.args[1] = this;
                Enumeration enumeration = Screen3D.deviceRendererMap.elements();
                Renderer renderer = (Renderer)enumeration.nextElement();
                renderer.rendererStructure.addMessage(j3dMessage);
                VirtualUniverse.mc.setWorkForRequestRenderer();
            }
            this.isShared = false;
        }
    }

    void computeBoundingBox() {
        if (this.boundsDirty && VirtualUniverse.mc.cacheAutoComputedBounds) {
            for (ArrayList arrayList : this.userLists) {
                for (Shape3DRetained shape3DRetained : arrayList) {
                    shape3DRetained.dirtyBoundsCache();
                }
            }
        }
        if ((this.vertexFormat & 0x80) == 0) {
            this.computeBoundingBox(this.initialVertexIndex, this.vertexData);
        } else if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                this.computeBoundingBox(this.initialCoordIndex, this.interleavedFloatBufferImpl);
            } else if ((this.vertexType & 1) != 0) {
                this.computeBoundingBox(this.floatBufferRefCoords);
            } else if ((this.vertexType & 2) != 0) {
                this.computeBoundingBox(this.doubleBufferRefCoords);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            this.computeBoundingBox(this.initialCoordIndex, this.interLeavedVertexData);
        } else if ((this.vertexType & 1) != 0) {
            this.computeBoundingBox(this.floatRefCoords);
        } else if ((this.vertexType & 4) != 0) {
            this.computeBoundingBox(this.p3fRefCoords);
        } else if ((this.vertexType & 8) != 0) {
            this.computeBoundingBox(this.p3dRefCoords);
        } else if ((this.vertexType & 2) != 0) {
            this.computeBoundingBox(this.doubleRefCoords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCoordsChanged(boolean bl) {
        if (bl) {
            BoundingBox boundingBox = this.geoBounds;
            synchronized (boundingBox) {
                this.geoBounds.setLower(-1.0, -1.0, -1.0);
                this.geoBounds.setUpper(1.0, 1.0, 1.0);
                this.boundsDirty = false;
            }
            boundingBox = this.centroid;
            synchronized (boundingBox) {
                this.recompCentroid = false;
                this.centroid.set((Tuple3d)this.geoBounds.getCenter());
            }
        }
        Object object = this.centroid;
        synchronized (object) {
            this.recompCentroid = true;
        }
        object = this.geoBounds;
        synchronized (object) {
            this.boundsDirty = true;
            this.computeBoundingBox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int n, float[] fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = n * this.stride + this.coordinateOffset;
            double d4 = d3 = (double)fArray[n2];
            double d5 = d2 = (double)fArray[n2 + 1];
            double d6 = d = (double)fArray[n2 + 2];
            n2 += this.stride;
            for (int i = 1; i < this.validVertexCount; ++i) {
                if ((double)fArray[n2] > d3) {
                    d3 = fArray[n2];
                }
                if ((double)fArray[n2] < d4) {
                    d4 = fArray[n2];
                }
                if ((double)fArray[n2 + 1] > d2) {
                    d2 = fArray[n2 + 1];
                }
                if ((double)fArray[n2 + 1] < d5) {
                    d5 = fArray[n2 + 1];
                }
                if ((double)fArray[n2 + 2] > d) {
                    d = fArray[n2 + 2];
                }
                if ((double)fArray[n2 + 2] < d6) {
                    d6 = fArray[n2 + 2];
                }
                n2 += this.stride;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(int n, FloatBufferWrapper floatBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n2 = n * this.stride + this.coordinateOffset;
            double d4 = d3 = (double)floatBufferWrapper.get(n2);
            double d5 = d2 = (double)floatBufferWrapper.get(n2 + 1);
            double d6 = d = (double)floatBufferWrapper.get(n2 + 2);
            n2 += this.stride;
            for (int i = 1; i < this.validVertexCount; ++i) {
                if ((double)floatBufferWrapper.get(n2) > d3) {
                    d3 = floatBufferWrapper.get(n2);
                }
                if ((double)floatBufferWrapper.get(n2) < d4) {
                    d4 = floatBufferWrapper.get(n2);
                }
                if ((double)floatBufferWrapper.get(n2 + 1) > d2) {
                    d2 = floatBufferWrapper.get(n2 + 1);
                }
                if ((double)floatBufferWrapper.get(n2 + 1) < d5) {
                    d5 = floatBufferWrapper.get(n2 + 1);
                }
                if ((double)floatBufferWrapper.get(n2 + 2) > d) {
                    d = floatBufferWrapper.get(n2 + 2);
                }
                if ((double)floatBufferWrapper.get(n2 + 2) < d6) {
                    d6 = floatBufferWrapper.get(n2 + 2);
                }
                n2 += this.stride;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(DoubleBufferWrapper doubleBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = doubleBufferWrapper.get(n++);
            double d5 = d2 = doubleBufferWrapper.get(n++);
            double d6 = d = doubleBufferWrapper.get(n++);
            for (int i = n; i < n2; i += 3) {
                int n3 = i + 1;
                int n4 = i + 2;
                if (doubleBufferWrapper.get(i) > d3) {
                    d3 = doubleBufferWrapper.get(i);
                }
                if (doubleBufferWrapper.get(i) < d4) {
                    d4 = doubleBufferWrapper.get(i);
                }
                if (doubleBufferWrapper.get(n3) > d2) {
                    d2 = doubleBufferWrapper.get(n3);
                }
                if (doubleBufferWrapper.get(n3) < d5) {
                    d5 = doubleBufferWrapper.get(n3);
                }
                if (doubleBufferWrapper.get(n4) > d) {
                    d = doubleBufferWrapper.get(n4);
                }
                if (!(doubleBufferWrapper.get(n4) < d6)) continue;
                d6 = doubleBufferWrapper.get(n4);
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(FloatBufferWrapper floatBufferWrapper) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = (double)floatBufferWrapper.get(n++);
            double d5 = d2 = (double)floatBufferWrapper.get(n++);
            double d6 = d = (double)floatBufferWrapper.get(n++);
            for (int i = n; i < n2; i += 3) {
                int n3 = i + 1;
                int n4 = i + 2;
                if ((double)floatBufferWrapper.get(i) > d3) {
                    d3 = floatBufferWrapper.get(i);
                }
                if ((double)floatBufferWrapper.get(i) < d4) {
                    d4 = floatBufferWrapper.get(i);
                }
                if ((double)floatBufferWrapper.get(n3) > d2) {
                    d2 = floatBufferWrapper.get(n3);
                }
                if ((double)floatBufferWrapper.get(n3) < d5) {
                    d5 = floatBufferWrapper.get(n3);
                }
                if ((double)floatBufferWrapper.get(n4) > d) {
                    d = floatBufferWrapper.get(n4);
                }
                if (!((double)floatBufferWrapper.get(n4) < d6)) continue;
                d6 = floatBufferWrapper.get(n4);
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(float[] fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = (double)fArray[n++];
            double d5 = d2 = (double)fArray[n++];
            double d6 = d = (double)fArray[n++];
            for (int i = n; i < n2; i += 3) {
                int n3 = i + 1;
                int n4 = i + 2;
                if ((double)fArray[i] > d3) {
                    d3 = fArray[i];
                }
                if ((double)fArray[i] < d4) {
                    d4 = fArray[i];
                }
                if ((double)fArray[n3] > d2) {
                    d2 = fArray[n3];
                }
                if ((double)fArray[n3] < d5) {
                    d5 = fArray[n3];
                }
                if ((double)fArray[n4] > d) {
                    d = fArray[n4];
                }
                if (!((double)fArray[n4] < d6)) continue;
                d6 = fArray[n4];
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(double[] dArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            int n = this.initialCoordIndex;
            int n2 = 3 * this.validVertexCount;
            double d4 = d3 = dArray[n++];
            double d5 = d2 = dArray[n++];
            double d6 = d = dArray[n++];
            for (int i = n; i < n2; i += 3) {
                int n3 = i + 1;
                int n4 = i + 2;
                if (dArray[i] > d3) {
                    d3 = dArray[i];
                }
                if (dArray[i] < d4) {
                    d4 = dArray[i];
                }
                if (dArray[n3] > d2) {
                    d2 = dArray[n3];
                }
                if (dArray[n3] < d5) {
                    d5 = dArray[n3];
                }
                if (dArray[n4] > d) {
                    d = dArray[n4];
                }
                if (!(dArray[n4] < d6)) continue;
                d6 = dArray[n4];
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3f[] point3fArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double d4 = d3 = (double)point3fArray[this.initialCoordIndex].x;
            double d5 = d2 = (double)point3fArray[this.initialCoordIndex].y;
            double d6 = d = (double)point3fArray[this.initialCoordIndex].z;
            for (int i = this.initialCoordIndex + 1; i < this.validVertexCount; ++i) {
                Point3f point3f = point3fArray[i];
                if ((double)point3f.x > d3) {
                    d3 = point3f.x;
                }
                if ((double)point3f.x < d4) {
                    d4 = point3f.x;
                }
                if ((double)point3f.y > d2) {
                    d2 = point3f.y;
                }
                if ((double)point3f.y < d5) {
                    d5 = point3f.y;
                }
                if ((double)point3f.z > d) {
                    d = point3f.z;
                }
                if (!((double)point3f.z < d6)) continue;
                d6 = point3f.z;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeBoundingBox(Point3d[] point3dArray) {
        BoundingBox boundingBox = this.geoBounds;
        synchronized (boundingBox) {
            double d;
            double d2;
            double d3;
            if (this.computeGeoBounds == 0 && this.refCount > 0) {
                return;
            }
            if (!this.boundsDirty) {
                return;
            }
            double d4 = d3 = point3dArray[this.initialCoordIndex].x;
            double d5 = d2 = point3dArray[this.initialCoordIndex].y;
            double d6 = d = point3dArray[this.initialCoordIndex].z;
            for (int i = this.initialCoordIndex + 1; i < this.validVertexCount; ++i) {
                Point3d point3d = point3dArray[i];
                if (point3d.x > d3) {
                    d3 = point3d.x;
                }
                if (point3d.x < d4) {
                    d4 = point3d.x;
                }
                if (point3d.y > d2) {
                    d2 = point3d.y;
                }
                if (point3d.y < d5) {
                    d5 = point3d.y;
                }
                if (point3d.z > d) {
                    d = point3d.z;
                }
                if (!(point3d.z < d6)) continue;
                d6 = point3d.z;
            }
            this.geoBounds.setUpper(d3, d2, d);
            this.geoBounds.setLower(d4, d5, d6);
            this.boundsDirty = false;
        }
    }

    synchronized void update() {
    }

    void setupMirrorVertexPointer(int n) {
        switch (n) {
            case 1: {
                if (this.floatRefCoords == null) {
                    if ((this.vertexType & 0xF) != 1) break;
                    this.vertexType &= 0xFFFFFFFE;
                    this.mirrorFloatRefCoords = null;
                    this.mirrorVertexAllocated &= 0xFFFFFFFE;
                    break;
                }
                this.vertexType |= 1;
                this.mirrorFloatRefCoords = this.floatRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFE;
                break;
            }
            case 2: {
                if (this.doubleRefCoords == null) {
                    if ((this.vertexType & 0xF) == 2) {
                        this.mirrorDoubleRefCoords = null;
                        this.mirrorVertexAllocated &= 0xFFFFFFFD;
                        this.vertexType &= 0xFFFFFFFD;
                    }
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                this.vertexType |= 2;
                this.mirrorDoubleRefCoords = this.doubleRefCoords;
                this.mirrorVertexAllocated &= 0xFFFFFFFD;
                break;
            }
            case 4: {
                if (this.p3fRefCoords == null) {
                    this.vertexType &= 0xFFFFFFFB;
                    break;
                }
                this.vertexType |= 4;
                if ((this.mirrorVertexAllocated & 1) == 0) {
                    this.mirrorFloatRefCoords = new float[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 1;
                }
                int n2 = this.initialCoordIndex * 3;
                for (int i = this.initialCoordIndex; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[i].x;
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[i].y;
                    this.mirrorFloatRefCoords[n2++] = this.p3fRefCoords[i].z;
                }
                break;
            }
            case 8: {
                if (this.p3dRefCoords == null) {
                    this.vertexType &= 0xFFFFFFF7;
                    break;
                }
                this.vertexType |= 8;
                if ((this.mirrorVertexAllocated & 2) == 0) {
                    this.mirrorDoubleRefCoords = new double[this.vertexCount * 3];
                    this.mirrorVertexAllocated |= 2;
                }
                int n3 = this.initialCoordIndex * 3;
                for (int i = this.initialCoordIndex; i < this.validVertexCount; ++i) {
                    this.mirrorDoubleRefCoords[n3++] = this.p3dRefCoords[i].x;
                    this.mirrorDoubleRefCoords[n3++] = this.p3dRefCoords[i].y;
                    this.mirrorDoubleRefCoords[n3++] = this.p3dRefCoords[i].z;
                }
                break;
            }
        }
    }

    void setupMirrorInterleavedColorPointer(boolean bl) {
        if (bl || this.c4fAllocated != 0) {
            int n = 4 * this.vertexCount;
            if (this.mirrorInterleavedColorPointer == null) {
                this.mirrorInterleavedColorPointer = new float[1][n];
            }
            int n2 = 4 * this.initialVertexIndex;
            int n3 = this.stride * this.initialVertexIndex + this.colorOffset;
            if ((this.vertexFormat & 0x800) == 0 && this.interLeavedVertexData != null) {
                if ((this.vertexFormat & 8) != 0) {
                    for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 1];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 2];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 3];
                        n3 += this.stride;
                    }
                } else {
                    for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 1];
                        this.mirrorInterleavedColorPointer[0][n2++] = this.interLeavedVertexData[n3 + 2];
                        this.mirrorInterleavedColorPointer[0][n2++] = 1.0f;
                        n3 += this.stride;
                    }
                }
            } else if ((this.vertexFormat & 8) != 0 && this.interleavedFloatBufferImpl != null) {
                for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                    this.interleavedFloatBufferImpl.position(n3);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], n2, 4);
                    n2 += 4;
                    n3 += this.stride;
                }
            } else {
                for (int i = this.initialVertexIndex; i < this.validVertexCount; ++i) {
                    this.interleavedFloatBufferImpl.position(n3);
                    this.interleavedFloatBufferImpl.get(this.mirrorInterleavedColorPointer[0], n2, 3);
                    this.mirrorInterleavedColorPointer[0][n2 + 3] = 1.0f;
                    n2 += 4;
                    n3 += this.stride;
                }
            }
            this.c4fAllocated = 8;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setupMirrorColorPointer(int n, boolean bl) {
        block61: {
            int n2;
            int n3;
            block63: {
                block62: {
                    int n4;
                    n3 = 0;
                    n2 = 0;
                    if (this.c4fAllocated == 0 && !bl) {
                        n4 = 3;
                    } else {
                        if (bl && this.c4fAllocated == 0 && (this.vertexFormat & 8) == 0) {
                            this.mirrorColorAllocated = 0;
                        }
                        this.c4fAllocated = 8;
                        n4 = 4;
                    }
                    if ((this.vertexFormat & 0x800) != 0) break block62;
                    switch (n) {
                        case 16: {
                            if (this.floatRefColors == null) {
                                if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 16) {
                                    this.mirrorFloatRefColors[0] = null;
                                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                                }
                                this.vertexType &= 0xFFFFFFEF;
                                return;
                            }
                            this.vertexType |= 0x10;
                            if (this.c4fAllocated == 0 && !bl) {
                                this.mirrorFloatRefColors[0] = this.floatRefColors;
                                this.mirrorColorAllocated &= 0xFFFFFFEF;
                                break;
                            }
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            if ((this.vertexFormat & 8) == 0) {
                                n3 = this.initialColorIndex * 3;
                                n2 = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorFloatRefColors[0][n2++] = this.floatRefColors[n3++];
                                    this.mirrorFloatRefColors[0][n2++] = this.floatRefColors[n3++];
                                    this.mirrorFloatRefColors[0][n2++] = this.floatRefColors[n3++];
                                    this.mirrorFloatRefColors[0][n2++] = 1.0f;
                                }
                                break block61;
                            } else {
                                n3 = this.initialColorIndex * 4;
                                System.arraycopy(this.floatRefColors, n3, this.mirrorFloatRefColors[0], n3, 4 * this.validVertexCount);
                                break;
                            }
                        }
                        case 32: {
                            if (this.byteRefColors == null) {
                                if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 32) {
                                    this.mirrorUnsignedByteRefColors[0] = null;
                                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                                }
                                this.vertexType &= 0xFFFFFFDF;
                                return;
                            }
                            this.vertexType |= 0x20;
                            if (this.c4fAllocated == 0 && !bl) {
                                this.mirrorUnsignedByteRefColors[0] = this.byteRefColors;
                                this.mirrorColorAllocated &= 0xFFFFFFDF;
                                break;
                            }
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            if ((this.vertexFormat & 8) == 0) {
                                n3 = this.initialColorIndex * 3;
                                n2 = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.byteRefColors[n3++];
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.byteRefColors[n3++];
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.byteRefColors[n3++];
                                    this.mirrorUnsignedByteRefColors[0][n2++] = -1;
                                }
                                break block61;
                            } else {
                                n3 = this.initialColorIndex * 4;
                                System.arraycopy(this.byteRefColors, n3, this.mirrorUnsignedByteRefColors[0], n3, 4 * this.validVertexCount);
                                break;
                            }
                        }
                        case 64: {
                            if (this.c3fRefColors == null) {
                                this.vertexType &= 0xFFFFFFBF;
                                return;
                            }
                            this.vertexType |= 0x40;
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[this.vertexCount * n4];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            if ((this.c4fAllocated & 8) == 0) {
                                n2 = this.initialColorIndex * 3;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorFloatRefColors[0][n2++] = this.c3fRefColors[i].x;
                                    this.mirrorFloatRefColors[0][n2++] = this.c3fRefColors[i].y;
                                    this.mirrorFloatRefColors[0][n2++] = this.c3fRefColors[i].z;
                                }
                                break block61;
                            } else {
                                n2 = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorFloatRefColors[0][n2++] = this.c3fRefColors[i].x;
                                    this.mirrorFloatRefColors[0][n2++] = this.c3fRefColors[i].y;
                                    this.mirrorFloatRefColors[0][n2++] = this.c3fRefColors[i].z;
                                    this.mirrorFloatRefColors[0][n2++] = 1.0f;
                                }
                            }
                            break block61;
                        }
                        case 128: {
                            if (this.c4fRefColors == null) {
                                this.vertexType &= 0xFFFFFF7F;
                                return;
                            }
                            this.vertexType |= 0x80;
                            if ((this.mirrorColorAllocated & 0x10) == 0) {
                                this.mirrorFloatRefColors[0] = new float[this.vertexCount << 2];
                                this.mirrorColorAllocated |= 0x10;
                            }
                            n2 = this.initialColorIndex * 4;
                            for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                this.mirrorFloatRefColors[0][n2++] = this.c4fRefColors[i].x;
                                this.mirrorFloatRefColors[0][n2++] = this.c4fRefColors[i].y;
                                this.mirrorFloatRefColors[0][n2++] = this.c4fRefColors[i].z;
                                this.mirrorFloatRefColors[0][n2++] = this.c4fRefColors[i].w;
                            }
                            break;
                        }
                        case 256: {
                            if (this.c3bRefColors == null) {
                                this.vertexType &= 0xFFFFFEFF;
                                return;
                            }
                            this.vertexType |= 0x100;
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount * n4];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            if ((this.c4fAllocated & 8) == 0) {
                                n2 = this.initialColorIndex * 3;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.c3bRefColors[i].x;
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.c3bRefColors[i].y;
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.c3bRefColors[i].z;
                                }
                                break block61;
                            } else {
                                n2 = this.initialColorIndex * 4;
                                for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.c3bRefColors[i].x;
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.c3bRefColors[i].y;
                                    this.mirrorUnsignedByteRefColors[0][n2++] = this.c3bRefColors[i].z;
                                    this.mirrorUnsignedByteRefColors[0][n2++] = -1;
                                }
                            }
                            break block61;
                        }
                        case 512: {
                            if (this.c4bRefColors == null) {
                                this.vertexType &= 0xFFFFFDFF;
                                return;
                            }
                            this.vertexType |= 0x200;
                            if ((this.mirrorColorAllocated & 0x20) == 0) {
                                this.mirrorUnsignedByteRefColors[0] = new byte[this.vertexCount << 2];
                                this.mirrorColorAllocated |= 0x20;
                            }
                            n2 = this.initialColorIndex * 4;
                            for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                                this.mirrorUnsignedByteRefColors[0][n2++] = this.c4bRefColors[i].x;
                                this.mirrorUnsignedByteRefColors[0][n2++] = this.c4bRefColors[i].y;
                                this.mirrorUnsignedByteRefColors[0][n2++] = this.c4bRefColors[i].z;
                                this.mirrorUnsignedByteRefColors[0][n2++] = this.c4bRefColors[i].w;
                            }
                            break;
                        }
                    }
                    break block61;
                }
                if (this.colorRefBuffer == null) {
                    if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 16) {
                        this.mirrorFloatRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFEF;
                    }
                    this.vertexType &= 0xFFFFFFEF;
                    if (this.c4fAllocated == 0 && !bl && (this.vertexType & 0x3F0) == 32) {
                        this.mirrorUnsignedByteRefColors[0] = null;
                        this.mirrorColorAllocated &= 0xFFFFFFDF;
                    }
                    this.vertexType &= 0xFFFFFFDF;
                    return;
                }
                if (this.floatBufferRefColors == null) break block63;
                this.vertexType |= 0x10;
                this.vertexType &= 0xFFFFFFDF;
                if (this.c4fAllocated == 0 && !bl) {
                    this.mirrorFloatRefColors[0] = null;
                    this.mirrorColorAllocated &= 0xFFFFFFEF;
                    break block61;
                } else {
                    if ((this.mirrorColorAllocated & 0x10) == 0) {
                        this.mirrorFloatRefColors[0] = new float[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 0x10;
                    }
                    this.floatBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        n3 = this.initialColorIndex * 3;
                        n2 = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(n3);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; n2 += 4, ++i) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], n2, 3);
                            this.mirrorFloatRefColors[0][n2 + 3] = 1.0f;
                        }
                        break block61;
                    } else {
                        n3 = this.initialColorIndex * 4;
                        n2 = this.initialColorIndex * 4;
                        this.floatBufferRefColors.position(n3);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; n2 += 4, ++i) {
                            this.floatBufferRefColors.get(this.mirrorFloatRefColors[0], n2, 4);
                        }
                    }
                }
                break block61;
            }
            if (this.byteBufferRefColors != null) {
                this.vertexType |= 0x20;
                this.vertexType &= 0xFFFFFFEF;
                if (this.c4fAllocated == 0 && !bl) {
                    this.mirrorUnsignedByteRefColors[0] = null;
                    this.mirrorColorAllocated &= 0xFFFFFFDF;
                } else {
                    if ((this.mirrorColorAllocated & 0x20) == 0) {
                        this.mirrorUnsignedByteRefColors[0] = new byte[4 * this.vertexCount];
                        this.mirrorColorAllocated |= 0x20;
                    }
                    this.byteBufferRefColors.rewind();
                    if ((this.vertexFormat & 8) == 0) {
                        n3 = this.initialColorIndex * 3;
                        n2 = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(n3);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; n2 += 4, ++i) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], n2, 3);
                            this.mirrorUnsignedByteRefColors[0][n2 + 3] = -1;
                        }
                    } else {
                        n3 = this.initialColorIndex * 4;
                        n2 = this.initialColorIndex * 4;
                        this.byteBufferRefColors.position(n3);
                        for (int i = this.initialColorIndex; i < this.validVertexCount; n2 += 4, ++i) {
                            this.byteBufferRefColors.get(this.mirrorUnsignedByteRefColors[0], n2, 4);
                        }
                    }
                }
            }
        }
        this.colorChanged = 65535;
    }

    void setupMirrorNormalPointer(int n) {
        switch (n) {
            case 1024: {
                if (this.floatRefNormals == null) {
                    if ((this.vertexType & 0xC00) != 1024) break;
                    this.vertexType &= 0xFFFFFBFF;
                    this.mirrorFloatRefNormals = null;
                    this.mirrorNormalAllocated = false;
                    break;
                }
                this.vertexType |= 0x400;
                this.mirrorFloatRefNormals = this.floatRefNormals;
                this.mirrorNormalAllocated = false;
                break;
            }
            case 2048: {
                if (this.v3fRefNormals == null) {
                    if ((this.vertexType & 0xC00) == 2048) {
                        this.vertexType &= 0xFFFFF7FF;
                    }
                    return;
                }
                this.vertexType |= 0x800;
                if (!this.mirrorNormalAllocated) {
                    this.mirrorFloatRefNormals = new float[this.vertexCount * 3];
                    this.mirrorNormalAllocated = true;
                }
                int n2 = this.initialNormalIndex * 3;
                for (int i = this.initialNormalIndex; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[i].x;
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[i].y;
                    this.mirrorFloatRefNormals[n2++] = this.v3fRefNormals[i].z;
                }
                break;
            }
        }
    }

    void setupMirrorTexCoordPointer(int n) {
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            this.doSetupMirrorTexCoordPointer(i, n);
        }
        this.validateTexCoordPointerType();
    }

    void setupMirrorTexCoordPointer(int n, int n2) {
        this.doSetupMirrorTexCoordPointer(n, n2);
        this.validateTexCoordPointerType();
    }

    private void validateTexCoordPointerType() {
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < this.texCoordSetCount; ++i) {
            if (this.refTexCoords[i] == null) {
                bl = false;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            this.texCoordType = 0;
        }
        this.vertexType &= 0xFFFF8FFF;
        if (bl) {
            this.vertexType |= this.texCoordType;
        }
    }

    private void doSetupMirrorTexCoordPointer(int n, int n2) {
        switch (n2) {
            case 4096: {
                this.texCoordType = 4096;
                this.mirrorRefTexCoords[n] = this.refTexCoords[n];
                break;
            }
            case 8192: {
                this.texCoordType = 8192;
                this.t2fRefTexCoords = (TexCoord2f[])this.refTexCoords[n];
                if (this.t2fRefTexCoords == null) {
                    this.mirrorRefTexCoords[n] = null;
                    break;
                }
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 2) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                        this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 2];
                    this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                }
                int n3 = this.initialTexCoordIndex[n] * 2;
                for (int i = this.initialTexCoordIndex[n]; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefTexCoords[n3++] = this.t2fRefTexCoords[i].x;
                    this.mirrorFloatRefTexCoords[n3++] = this.t2fRefTexCoords[i].y;
                }
                break;
            }
            case 16384: {
                this.texCoordType = 16384;
                this.t3fRefTexCoords = (TexCoord3f[])this.refTexCoords[n];
                if (this.t3fRefTexCoords == null) {
                    this.mirrorRefTexCoords[n] = null;
                    break;
                }
                this.mirrorFloatRefTexCoords = (float[])this.mirrorRefTexCoords[n];
                if (this.mirrorFloatRefTexCoords != null) {
                    if (this.mirrorFloatRefTexCoords.length < this.vertexCount * 3) {
                        this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                        this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                    }
                } else {
                    this.mirrorFloatRefTexCoords = new float[this.vertexCount * 3];
                    this.mirrorRefTexCoords[n] = this.mirrorFloatRefTexCoords;
                }
                int n4 = this.initialTexCoordIndex[n] * 3;
                for (int i = this.initialTexCoordIndex[n]; i < this.validVertexCount; ++i) {
                    this.mirrorFloatRefTexCoords[n4++] = this.t3fRefTexCoords[i].x;
                    this.mirrorFloatRefTexCoords[n4++] = this.t3fRefTexCoords[i].y;
                    this.mirrorFloatRefTexCoords[n4++] = this.t3fRefTexCoords[i].z;
                }
                break;
            }
        }
    }

    void setupMirrorVertexAttrPointer(int n) {
        for (int i = 0; i < this.vertexAttrCount; ++i) {
            this.doSetupMirrorVertexAttrPointer(i, n);
        }
        this.validateVertexAttrPointerType();
    }

    void setupMirrorVertexAttrPointer(int n, int n2) {
        this.doSetupMirrorVertexAttrPointer(n, n2);
        this.validateVertexAttrPointerType();
    }

    private void validateVertexAttrPointerType() {
        boolean bl = true;
        boolean bl2 = true;
        if ((this.vertexFormat & 0x800) == 0) {
            for (int i = 0; i < this.vertexAttrCount; ++i) {
                if (this.floatRefVertexAttrs[i] == null) {
                    bl = false;
                    continue;
                }
                bl2 = false;
            }
        } else {
            for (int i = 0; i < this.vertexAttrCount; ++i) {
                if (this.nioFloatBufferRefVertexAttrs[i] == null) {
                    bl = false;
                    continue;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            this.vertexAttrType = 0;
        }
        this.vertexType &= 0xFFFF7FFF;
        if (bl) {
            this.vertexType |= this.vertexAttrType;
        }
    }

    private void doSetupMirrorVertexAttrPointer(int n, int n2) {
        switch (n2) {
            case 32768: {
                this.vertexAttrType = 32768;
                this.mirrorFloatRefVertexAttrs[n] = this.floatRefVertexAttrs[n];
                break;
            }
        }
    }

    void createGeometryArrayData(int n, int n2) {
        if ((n2 & 0x460) != 0) {
            this.createGeometryArrayData(n, n2, 1, defaultTexCoordSetMap);
        } else {
            this.createGeometryArrayData(n, n2, 0, null);
        }
    }

    void createGeometryArrayData(int n, int n2, int n3, int[] nArray) {
        this.createGeometryArrayData(n, n2, n3, nArray, 0, null);
    }

    void createGeometryArrayData(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2) {
        this.vertexFormat = n2;
        this.vertexCount = n;
        this.validVertexCount = n;
        this.texCoordSetCount = n3;
        this.texCoordSetMap = (int[])(nArray == null ? null : (int[])nArray.clone());
        this.vertexAttrCount = n4;
        this.vertexAttrSizes = (int[])(nArray2 == null ? null : (int[])nArray2.clone());
        this.vertexAttrStride = this.vertexAttrStride();
        this.stride = this.stride();
        this.vertexAttrOffsets = this.vertexAttrOffsets();
        this.texCoordSetMapOffset = this.texCoordSetMapOffset();
        this.textureOffset = this.textureOffset();
        this.colorOffset = this.colorOffset();
        this.normalOffset = this.normalOffset();
        this.coordinateOffset = this.coordinateOffset();
        if ((n2 & 0x80) == 0) {
            this.vertexData = new float[this.vertexCount * this.stride];
        } else {
            this.vertexData = null;
            if ((n2 & 0x460) != 0) {
                this.mirrorRefTexCoords = new Object[n3];
                this.refTexCoords = new Object[n3];
                if ((n2 & 0x800) != 0) {
                    this.refTexCoordsBuffer = new Object[n3];
                }
            }
            if ((n2 & 0x1000) != 0) {
                this.floatRefVertexAttrs = new float[n4][];
                this.mirrorFloatRefVertexAttrs = new float[n4][];
                if ((n2 & 0x800) != 0) {
                    this.vertexAttrsRefBuffer = new J3DBuffer[n4];
                    this.floatBufferRefVertexAttrs = new FloatBufferWrapper[n4];
                    this.nioFloatBufferRefVertexAttrs = new Object[n4];
                }
            }
        }
        if ((n2 & 0x460) != 0) {
            this.initialTexCoordIndex = new int[n3];
        }
        if ((n2 & 0x1000) != 0) {
            this.initialVertexAttrIndex = new int[n4];
        }
        this.noAlpha = (n2 & 8) == 0;
        this.lastAlpha[0] = 1.0f;
    }

    void setVertexFormat(boolean bl, boolean bl2, Context context) {
        Pipeline.getPipeline().setVertexFormat(context, this, this.vertexFormat, bl, bl2);
    }

    void disableGlobalAlpha(Context context, boolean bl, boolean bl2) {
        Pipeline.getPipeline().disableGlobalAlpha(context, this, this.vertexFormat, bl, bl2);
    }

    float[] updateAlphaInFloatRefColors(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            return this.mirrorFloatRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorFloatRefColors[0];
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        assert (this.lastAlpha != null);
        assert (this.mirrorFloatRefColors != null);
        assert (this.mirrorFloatRefColors.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            for (n2 = 0; n2 < this.lastAlpha.length; ++n2) {
                object[n2] = this.lastAlpha[n2];
            }
            this.lastAlpha = object;
        }
        if (this.mirrorFloatRefColors.length <= n) {
            object = new float[n + 1][];
            for (n2 = 0; n2 < this.mirrorFloatRefColors.length; ++n2) {
                object[n2] = (float)this.mirrorFloatRefColors[n2];
            }
            for (n2 = this.mirrorFloatRefColors.length; n2 < n + 1; ++n2) {
                object[n2] = (float)new float[4 * this.vertexCount];
                System.arraycopy(object[0], 0, object[n2], 0, 4 * this.vertexCount);
                this.lastAlpha[n2] = this.lastAlpha[0];
            }
            this.mirrorFloatRefColors = (float[][])object;
        }
        assert ((double)this.lastAlpha[n] >= 0.0);
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) <= 1.0E-6) {
                return this.mirrorFloatRefColors[n];
            }
            float f2 = f / this.lastAlpha[n];
            float[] fArray = this.mirrorFloatRefColors[n];
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.vertexCount) {
                fArray[n4 + 3] = fArray[n4 + 3] * f2;
                ++n3;
                n4 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorFloatRefColors[n];
            n2 = this.initialColorIndex * 4;
            int n5 = this.initialColorIndex;
            while (n5 < this.validVertexCount) {
                object[n2 + 3] = object[n2 + 3] * f;
                ++n5;
                n2 += 4;
            }
        } else {
            float f3 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mirrorFloatRefColors[0];
            float[] fArray2 = this.mirrorFloatRefColors[n];
            int n6 = this.initialColorIndex * 4;
            for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                fArray2[n6] = fArray[n6++];
                fArray2[n6] = fArray[n6++];
                fArray2[n6] = fArray[n6++];
                fArray2[n6] = fArray[n6++] * f3;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        return this.mirrorFloatRefColors[n];
    }

    byte[] updateAlphaInByteRefColors(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            return this.mirrorUnsignedByteRefColors[0];
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            return this.mirrorUnsignedByteRefColors[0];
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        assert (this.lastAlpha != null);
        assert (this.mirrorUnsignedByteRefColors != null);
        assert (this.mirrorUnsignedByteRefColors.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            for (n2 = 0; n2 < this.lastAlpha.length; ++n2) {
                object[n2] = this.lastAlpha[n2];
            }
            this.lastAlpha = object;
        }
        if (this.mirrorUnsignedByteRefColors.length <= n) {
            object = new byte[n + 1][];
            for (n2 = 0; n2 < this.mirrorUnsignedByteRefColors.length; ++n2) {
                object[n2] = (float)this.mirrorUnsignedByteRefColors[n2];
            }
            for (n2 = this.mirrorUnsignedByteRefColors.length; n2 < n + 1; ++n2) {
                object[n2] = (float)new byte[4 * this.vertexCount];
                System.arraycopy(object[0], 0, object[n2], 0, 4 * this.vertexCount);
                this.lastAlpha[n2] = this.lastAlpha[0];
            }
            this.mirrorUnsignedByteRefColors = (byte[][])object;
        }
        assert ((double)this.lastAlpha[n] >= 0.0);
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) <= 1.0E-6) {
                return this.mirrorUnsignedByteRefColors[n];
            }
            float f2 = f / this.lastAlpha[n];
            byte[] byArray = this.mirrorUnsignedByteRefColors[n];
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.vertexCount) {
                byArray[n4 + 3] = (byte)((float)(byArray[n4 + 3] & 0xFF) * f2);
                ++n3;
                n4 += 4;
            }
        } else if (n == 0) {
            object = this.mirrorUnsignedByteRefColors[n];
            n2 = this.initialColorIndex * 4;
            int n5 = this.initialColorIndex;
            while (n5 < this.validVertexCount) {
                object[n2 + 3] = (byte)((float)(object[n2 + 3] & 0xFF) * f);
                ++n5;
                n2 += 4;
            }
        } else {
            float f3 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            byte[] byArray = this.mirrorUnsignedByteRefColors[0];
            byte[] byArray2 = this.mirrorUnsignedByteRefColors[n];
            int n6 = this.initialColorIndex * 4;
            for (int i = this.initialColorIndex; i < this.validVertexCount; ++i) {
                byArray2[n6] = byArray[n6++];
                byArray2[n6] = byArray[n6++];
                byArray2[n6] = byArray[n6++];
                byArray2[n6] = (byte)((float)(byArray[n6++] & 0xFF) * f3);
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        return this.mirrorUnsignedByteRefColors[n];
    }

    Object[] updateAlphaInVertexData(Canvas3D canvas3D, int n, float f) {
        int n2;
        int n3;
        Object object;
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            objectArray[1] = this.vertexData;
            return objectArray;
        }
        if ((this.vertexFormat & 4) == 0) {
            objectArray[1] = this.vertexData;
            return objectArray;
        }
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        objectArray[0] = Boolean.TRUE;
        assert (this.lastAlpha != null);
        assert (this.mvertexData == null || this.mvertexData.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            for (n3 = 0; n3 < this.lastAlpha.length; ++n3) {
                object[n3] = this.lastAlpha[n3];
            }
            this.lastAlpha = object;
        }
        if (this.mvertexData == null || this.mvertexData.length <= n) {
            object = new float[n + 1][];
            n3 = 1;
            if (this.mvertexData != null) {
                n3 = this.mvertexData.length;
                for (n2 = 0; n2 < this.mvertexData.length; ++n2) {
                    object[n2] = (float)this.mvertexData[n2];
                }
            }
            if (object[0] == null) {
                object[0] = (float)this.vertexData;
            }
            if (n > 0) {
                for (n2 = n3; n2 < n + 1; ++n2) {
                    object[n2] = (float)new float[this.stride * this.vertexCount];
                    System.arraycopy(object[0], 0, object[n2], 0, this.stride * this.vertexCount);
                    this.lastAlpha[n2] = this.lastAlpha[0];
                }
            }
            this.mvertexData = (float[][])object;
        }
        assert ((double)this.lastAlpha[n] >= 0.0);
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) <= 1.0E-6) {
                objectArray[1] = this.mvertexData[n];
                return objectArray;
            }
            float f2 = f / this.lastAlpha[n];
            float[] fArray = this.mvertexData[n];
            n2 = 0;
            int n4 = this.colorOffset;
            while (n2 < this.vertexCount) {
                int n5 = n4 + 3;
                fArray[n5] = fArray[n5] * f2;
                ++n2;
                n4 += this.stride;
            }
        } else if (n == 0) {
            object = this.mvertexData[n];
            double d = f / this.lastAlpha[0];
            int n6 = 0;
            int n7 = this.colorOffset;
            while (n6 < this.vertexCount) {
                int n8 = n7 + 3;
                object[n8] = (float)((double)object[n8] * d);
                ++n6;
                n7 += this.stride;
            }
        } else {
            float f3 = f / this.lastAlpha[0];
            float[] fArray = this.mvertexData[0];
            float[] fArray2 = this.mvertexData[n];
            int n9 = 0;
            int n10 = this.colorOffset;
            while (n9 < this.vertexCount) {
                System.arraycopy(fArray, n10, fArray2, n10, 3);
                fArray2[n10 + 3] = fArray[n10 + 3] * f3;
                ++n9;
                n10 += this.stride;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        objectArray[1] = this.mvertexData[n];
        return objectArray;
    }

    Object[] updateAlphaInInterLeavedData(Canvas3D canvas3D, int n, float f) {
        int n2;
        Object object;
        Object[] objectArray = new Object[2];
        objectArray[0] = Boolean.FALSE;
        if (canvas3D.supportGlobalAlpha()) {
            canvas3D.setGlobalAlpha(canvas3D.ctx, f);
            objectArray[1] = null;
            return objectArray;
        }
        if (((this.vertexFormat | this.c4fAllocated) & 8) == 0) {
            objectArray[1] = this.mirrorInterleavedColorPointer[0];
            return objectArray;
        }
        int n3 = this.initialColorIndex << 2;
        if ((double)f <= 1.0E-6) {
            f = 1.0E-6f;
        }
        objectArray[0] = Boolean.TRUE;
        assert (this.lastAlpha != null);
        assert (this.mirrorInterleavedColorPointer != null);
        assert (this.mirrorInterleavedColorPointer.length == this.lastAlpha.length);
        if (this.lastAlpha.length <= n) {
            object = new float[n + 1];
            for (n2 = 0; n2 < this.lastAlpha.length; ++n2) {
                object[n2] = this.lastAlpha[n2];
            }
            this.lastAlpha = object;
        }
        if (this.mirrorInterleavedColorPointer.length <= n) {
            object = new float[n + 1][];
            for (n2 = 0; n2 < this.mirrorInterleavedColorPointer.length; ++n2) {
                object[n2] = (float)this.mirrorInterleavedColorPointer[n2];
            }
            for (n2 = this.mirrorInterleavedColorPointer.length; n2 < n + 1; ++n2) {
                object[n2] = (float)new float[4 * this.vertexCount];
                System.arraycopy(object[0], 0, object[n2], 0, 4 * this.vertexCount);
                this.lastAlpha[n2] = this.lastAlpha[0];
            }
            this.mirrorInterleavedColorPointer = (float[][])object;
        }
        assert ((double)this.lastAlpha[n] >= 0.0);
        if ((this.colorChanged & 1 << n) == 0) {
            if ((double)Math.abs(this.lastAlpha[n] - f) <= 1.0E-6) {
                objectArray[1] = this.mirrorInterleavedColorPointer[n];
                return objectArray;
            }
            float f2 = f / this.lastAlpha[n];
            float[] fArray = this.mirrorInterleavedColorPointer[n];
            for (int i = n3 = this.initialColorIndex << 2; i < n3 + (this.vertexCount << 2); i += 4) {
                fArray[i + 3] = fArray[i + 3] * f2;
            }
        } else if (n == 0) {
            object = this.mirrorInterleavedColorPointer[n];
            for (n2 = n3; n2 < n3 + (this.vertexCount << 2); n2 += 4) {
                object[n2 + 3] = object[n2 + 3] * f;
            }
        } else {
            float f3 = (this.colorChanged & 1) == 0 ? f / this.lastAlpha[0] : f;
            float[] fArray = this.mirrorInterleavedColorPointer[0];
            float[] fArray2 = this.mirrorInterleavedColorPointer[n];
            int n4 = n3;
            while (n4 < n3 + (this.vertexCount << 2)) {
                fArray2[n4] = fArray[n4++];
                fArray2[n4] = fArray[n4++];
                fArray2[n4] = fArray[n4++];
                fArray2[n4] = fArray[n4++] * f3;
            }
        }
        this.lastAlpha[n] = f;
        this.colorChanged &= ~(1 << n);
        this.dirtyFlag |= 4;
        objectArray[1] = this.mirrorInterleavedColorPointer[n];
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, int n, boolean bl3) {
        boolean bl4 = false;
        if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            int n2;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n2 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInVertexData(canvas3D, n, f);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n2 |= 4;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n2 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().execute(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialVertexIndex, this.validVertexCount, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.vertexAttrCount, this.vertexAttrSizes, fArray, null, n2);
        } else if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int n3;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] fArray = null;
                GeometryArrayRetained geometryArrayRetained = this;
                synchronized (geometryArrayRetained) {
                    n3 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                        bl4 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n3 |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n3 |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().execute(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.vertexAttrCount, this.vertexAttrSizes, this.interLeavedVertexData, fArray, n3);
            } else {
                int n4;
                GeometryArrayRetained geometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n4 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n4 |= 4;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n4 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    geometryArrayRetained = this;
                    synchronized (geometryArrayRetained) {
                        n4 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n4 |= 4;
                            }
                        } else {
                            byArray = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n4 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    n4 = this.dirtyFlag;
                }
                int n5 = 0;
                if ((this.vertexType & 5) != 0) {
                    n5 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n5 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n5 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n5 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n5 |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    n5 |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n5 |= 0x20;
                }
                Pipeline.getPipeline().executeVA(canvas3D.ctx, this, this.geoType, bl, bl3, this.validVertexCount, this.vertexFormat | this.c4fAllocated, n5, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, fArray, byArray, this.initialNormalIndex, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, n4);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n6;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] fArray = null;
            GeometryArrayRetained geometryArrayRetained = this;
            synchronized (geometryArrayRetained) {
                n6 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n6 |= 4;
                    }
                } else {
                    fArray = null;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n6 |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().executeInterleavedBuffer(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.interleavedFloatBufferImpl.getBufferAsObject(), fArray, n6);
        } else {
            int n7;
            Object object;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] byArray = null;
            float[] fArray = null;
            if ((this.vertexType & 0x10) != 0) {
                object = this;
                synchronized (object) {
                    n7 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n7 |= 4;
                        }
                    } else {
                        fArray = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n7 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                object = this;
                synchronized (object) {
                    n7 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n7 |= 4;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n7 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                n7 = this.dirtyFlag;
            }
            object = null;
            Object object2 = null;
            Object object3 = null;
            int n8 = 0;
            if ((this.vertexType & 1) != 0) {
                n8 |= 1;
                object = this.floatBufferRefCoords.getBufferAsObject();
            } else if ((this.vertexType & 2) != 0) {
                n8 |= 2;
                object = this.doubleBufferRefCoords.getBufferAsObject();
            }
            if ((this.vertexType & 0x10) != 0) {
                n8 |= 4;
                object2 = this.floatBufferRefColors.getBufferAsObject();
            } else if ((this.vertexType & 0x20) != 0) {
                n8 |= 8;
                object2 = this.byteBufferRefColors.getBufferAsObject();
            }
            if ((this.vertexType & 0xC00) != 0) {
                n8 |= 0x10;
                object3 = this.floatBufferRefNormals.getBufferAsObject();
            }
            if ((this.vertexType & 0x8000) != 0) {
                n8 |= 0x40;
            }
            if ((this.vertexType & 0x7000) != 0) {
                n8 |= 0x20;
            }
            Pipeline.getPipeline().executeVABuffer(canvas3D.ctx, this, this.geoType, bl, bl3, this.validVertexCount, this.vertexFormat | this.c4fAllocated, n8, this.initialCoordIndex, object, this.initialColorIndex, object2, fArray, byArray, this.initialNormalIndex, object3, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.nioFloatBufferRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.initialTexCoordIndex, this.texCoordStride, this.refTexCoords, n7);
        }
    }

    void buildGA(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        float[] fArray = null;
        assert ((this.vertexFormat & 0x800) == 0);
        if ((this.vertexFormat & 0x80) == 0) {
            fArray = this.vertexData;
        } else if ((this.vertexFormat & 0x100) != 0 && (this.vertexFormat & 0x800) == 0) {
            fArray = this.interLeavedVertexData;
        }
        if (fArray != null) {
            Pipeline.getPipeline().buildGA(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.initialVertexIndex, this.validVertexCount, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, this.vertexAttrCount, this.vertexAttrSizes, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, fArray);
        } else {
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                int n = 0;
                if ((this.vertexType & 5) != 0) {
                    n |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    n |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n |= 0x20;
                }
                Pipeline.getPipeline().buildGAForByRef(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.validVertexCount, this.vertexFormat, n, this.initialCoordIndex, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, this.initialColorIndex, this.mirrorFloatRefColors[0], this.mirrorUnsignedByteRefColors[0], this.initialNormalIndex, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.initialVertexAttrIndex, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, this.initialTexCoordIndex, this.texCoordStride, this.mirrorRefTexCoords, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat);
            }
        }
    }

    void unIndexify(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        if ((indexedGeometryArrayRetained.vertexFormat & 0x800) == 0) {
            this.unIndexifyJavaArray(indexedGeometryArrayRetained);
        } else {
            this.unIndexifyNIOBuffer(indexedGeometryArrayRetained);
        }
    }

    private void unIndexifyJavaArray(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float[] fArray = null;
        int n4 = indexedGeometryArrayRetained.initialIndexIndex;
        int n5 = indexedGeometryArrayRetained.initialIndexIndex + indexedGeometryArrayRetained.validIndexCount;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0 || (indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 0x80) == 0) {
                fArray = indexedGeometryArrayRetained.vertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n3 = 4;
                }
            } else if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                fArray = indexedGeometryArrayRetained.interLeavedVertexData;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n3 = 4;
                } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                    n3 = 3;
                }
            }
            for (int i = n4; i < n5; ++i) {
                int n6;
                int n7;
                if ((this.vertexFormat & 2) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexNormal[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset, this.vertexData, n + this.normalOffset, 3);
                }
                if (n3 == 4) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n3);
                } else if (n3 == 3) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexColor[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset, this.vertexData, n + this.colorOffset, n3);
                    this.vertexData[n + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    n7 = n + this.textureOffset;
                    int n8 = 0;
                    n6 = 0;
                    while (n6 < this.texCoordSetCount) {
                        if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
                            n8 = n6 * this.texCoordStride;
                        }
                        System.arraycopy(fArray, indexedGeometryArrayRetained.indexTexCoord[n6][i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset + n8, this.vertexData, n7, this.texCoordStride);
                        ++n6;
                        n7 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 0x1000) != 0) {
                    assert ((indexedGeometryArrayRetained.vertexFormat & 0x100) == 0);
                    for (n6 = 0; n6 < this.vertexAttrCount; ++n6) {
                        n7 = n + this.vertexAttrOffsets[n6];
                        System.arraycopy(fArray, indexedGeometryArrayRetained.indexVertexAttr[n6][i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.vertexAttrOffsets[n6], this.vertexData, n7, this.vertexAttrSizes[n6]);
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    System.arraycopy(fArray, indexedGeometryArrayRetained.indexCoord[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset, this.vertexData, n + this.coordinateOffset, 3);
                }
                n += this.stride;
            }
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            if ((this.vertexFormat & 2) != 0) {
                n = this.normalOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xC00) {
                    case 1024: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefNormals, indexedGeometryArrayRetained.indexNormal[n12] * 3, this.vertexData, n, 3);
                            n += this.stride;
                        }
                        break;
                    }
                    case 2048: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexNormal[n12];
                            this.vertexData[n] = indexedGeometryArrayRetained.v3fRefNormals[n11].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.v3fRefNormals[n11].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.v3fRefNormals[n11].z;
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n = this.colorOffset;
                n10 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n10 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n12] * n10, this.vertexData, n, 4);
                            } else {
                                System.arraycopy(indexedGeometryArrayRetained.floatRefColors, indexedGeometryArrayRetained.indexColor[n12] * n10, this.vertexData, n, 3);
                                this.vertexData[n + 3] = 1.0f;
                            }
                            n += this.stride;
                        }
                        break;
                    }
                    case 32: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexColor[n12] * n10;
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.byteRefColors[n11] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.byteRefColors[n11 + 1] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.byteRefColors[n11 + 2] & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteRefColors[n11 + 3] & 0xFF) * 0.003921569f : 1.0f;
                            n += this.stride;
                        }
                        break;
                    }
                    case 64: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexColor[n12];
                            this.vertexData[n] = indexedGeometryArrayRetained.c3fRefColors[n11].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.c3fRefColors[n11].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.c3fRefColors[n11].z;
                            this.vertexData[n + 3] = 1.0f;
                            n += this.stride;
                        }
                        break;
                    }
                    case 128: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexColor[n12];
                            this.vertexData[n] = indexedGeometryArrayRetained.c4fRefColors[n11].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.c4fRefColors[n11].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.c4fRefColors[n11].z;
                            this.vertexData[n + 3] = indexedGeometryArrayRetained.c4fRefColors[n11].w;
                            n += this.stride;
                        }
                        break;
                    }
                    case 256: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexColor[n12];
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.c3bRefColors[n11].x & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.c3bRefColors[n11].y & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.c3bRefColors[n11].z & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = 1.0f;
                            n += this.stride;
                        }
                        break;
                    }
                    case 512: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexColor[n12];
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.c4bRefColors[n11].x & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.c4bRefColors[n11].y & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.c4bRefColors[n11].z & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (float)(indexedGeometryArrayRetained.c4bRefColors[n11].w & 0xFF) * 0.003921569f;
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n = this.textureOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0x7000) {
                    case 4096: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n2 = n;
                            for (n9 = 0; n9 < this.texCoordSetCount; ++n9) {
                                System.arraycopy(indexedGeometryArrayRetained.refTexCoords[n9], indexedGeometryArrayRetained.indexTexCoord[n9][n12] * this.texCoordStride, this.vertexData, n2, this.texCoordStride);
                                n2 += this.texCoordStride;
                            }
                            n += this.stride;
                        }
                        break;
                    }
                    case 8192: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n2 = n;
                            for (n9 = 0; n9 < this.texCoordSetCount; ++n9) {
                                n11 = indexedGeometryArrayRetained.indexTexCoord[n9][n12];
                                this.vertexData[n2] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n9])[n11].x;
                                this.vertexData[n2 + 1] = ((TexCoord2f[])indexedGeometryArrayRetained.refTexCoords[n9])[n11].y;
                                n2 += this.texCoordStride;
                            }
                            n += this.stride;
                        }
                        break;
                    }
                    case 16384: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n2 = n;
                            for (n9 = 0; n9 < this.texCoordSetCount; ++n9) {
                                n11 = indexedGeometryArrayRetained.indexTexCoord[n9][n12];
                                this.vertexData[n2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n9])[n11].x;
                                this.vertexData[n2 + 1] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n9])[n11].y;
                                this.vertexData[n2 + 2] = ((TexCoord3f[])indexedGeometryArrayRetained.refTexCoords[n9])[n11].z;
                                n2 += this.texCoordStride;
                            }
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n = 0;
                switch (indexedGeometryArrayRetained.vertexType & 0x8000) {
                    case 32768: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            for (n9 = 0; n9 < this.vertexAttrCount; ++n9) {
                                n10 = n + this.vertexAttrOffsets[n9];
                                System.arraycopy(indexedGeometryArrayRetained.floatRefVertexAttrs[n9], indexedGeometryArrayRetained.indexVertexAttr[n9][n12] * this.vertexAttrSizes[n9], this.vertexData, n10, this.vertexAttrSizes[n9]);
                            }
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            System.arraycopy(indexedGeometryArrayRetained.floatRefCoords, indexedGeometryArrayRetained.indexCoord[n12] * 3, this.vertexData, n, 3);
                            n += this.stride;
                        }
                        break;
                    }
                    case 2: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexCoord[n12] * 3;
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.doubleRefCoords[n11];
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.doubleRefCoords[n11 + 1];
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.doubleRefCoords[n11 + 2];
                            n += this.stride;
                        }
                        break;
                    }
                    case 4: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexCoord[n12];
                            this.vertexData[n] = indexedGeometryArrayRetained.p3fRefCoords[n11].x;
                            this.vertexData[n + 1] = indexedGeometryArrayRetained.p3fRefCoords[n11].y;
                            this.vertexData[n + 2] = indexedGeometryArrayRetained.p3fRefCoords[n11].z;
                            n += this.stride;
                        }
                        break;
                    }
                    case 8: {
                        for (n12 = n4; n12 < n5; ++n12) {
                            n11 = indexedGeometryArrayRetained.indexCoord[n12];
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.p3dRefCoords[n11].x;
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.p3dRefCoords[n11].y;
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.p3dRefCoords[n11].z;
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
        }
    }

    private void unIndexifyNIOBuffer(IndexedGeometryArrayRetained indexedGeometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object var7_5 = null;
        int n4 = indexedGeometryArrayRetained.initialIndexIndex;
        int n5 = indexedGeometryArrayRetained.initialIndexIndex + indexedGeometryArrayRetained.validIndexCount;
        if ((indexedGeometryArrayRetained.vertexFormat & 0x100) != 0) {
            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                n3 = 4;
            } else if ((indexedGeometryArrayRetained.vertexFormat & 4) != 0) {
                n3 = 3;
            }
            for (int i = n4; i < n5; ++i) {
                if ((this.vertexFormat & 2) != 0) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexNormal[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.normalOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.normalOffset, 3);
                }
                if (n3 == 4) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexColor[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n3);
                } else if (n3 == 3) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexColor[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.colorOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.colorOffset, n3);
                    this.vertexData[n + this.colorOffset + 3] = 1.0f;
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    int n6 = n + this.textureOffset;
                    int n7 = 0;
                    while (n7 < this.texCoordSetCount) {
                        indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexTexCoord[n7][i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.textureOffset);
                        indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n6, this.texCoordStride);
                        ++n7;
                        n6 += this.texCoordStride;
                    }
                }
                if ((this.vertexFormat & 1) != 0) {
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.position(indexedGeometryArrayRetained.indexCoord[i] * indexedGeometryArrayRetained.stride + indexedGeometryArrayRetained.coordinateOffset);
                    indexedGeometryArrayRetained.interleavedFloatBufferImpl.get(this.vertexData, n + this.coordinateOffset, 3);
                }
                n += this.stride;
            }
        } else {
            int n8;
            int n9;
            int n10;
            if ((this.vertexFormat & 2) != 0) {
                n = this.normalOffset;
                if ((indexedGeometryArrayRetained.vertexType & 0xC00) != 0) {
                    for (n10 = n4; n10 < n5; ++n10) {
                        indexedGeometryArrayRetained.floatBufferRefNormals.position(indexedGeometryArrayRetained.indexNormal[n10] * 3);
                        indexedGeometryArrayRetained.floatBufferRefNormals.get(this.vertexData, n, 3);
                        n += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 4) != 0) {
                n = this.colorOffset;
                int n11 = 3;
                if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                    n11 = 4;
                }
                switch (indexedGeometryArrayRetained.vertexType & 0x3F0) {
                    case 16: {
                        for (n10 = n4; n10 < n5; ++n10) {
                            if ((indexedGeometryArrayRetained.vertexFormat & 8) != 0) {
                                indexedGeometryArrayRetained.floatBufferRefColors.position(indexedGeometryArrayRetained.indexColor[n10] * n11);
                                indexedGeometryArrayRetained.floatBufferRefColors.get(this.vertexData, n, 4);
                            } else {
                                indexedGeometryArrayRetained.floatBufferRefColors.position(indexedGeometryArrayRetained.indexColor[n10] * n11);
                                indexedGeometryArrayRetained.floatBufferRefColors.get(this.vertexData, n, 3);
                                this.vertexData[n + 3] = 1.0f;
                            }
                            n += this.stride;
                        }
                        break;
                    }
                    case 32: {
                        for (n10 = n4; n10 < n5; ++n10) {
                            n9 = indexedGeometryArrayRetained.indexColor[n10] * n11;
                            this.vertexData[n] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9) & 0xFF) * 0.003921569f;
                            this.vertexData[n + 1] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9 + 1) & 0xFF) * 0.003921569f;
                            this.vertexData[n + 2] = (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9 + 2) & 0xFF) * 0.003921569f;
                            this.vertexData[n + 3] = (indexedGeometryArrayRetained.vertexFormat & 8) != 0 ? (float)(indexedGeometryArrayRetained.byteBufferRefColors.get(n9 + 3) & 0xFF) * 0.003921569f : 1.0f;
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
            if ((this.vertexFormat & 0x460) != 0) {
                n = this.textureOffset;
                if ((indexedGeometryArrayRetained.vertexType & 0x7000) != 0) {
                    for (n10 = n4; n10 < n5; ++n10) {
                        n2 = n;
                        for (n8 = 0; n8 < this.texCoordSetCount; ++n8) {
                            FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)indexedGeometryArrayRetained.refTexCoordsBuffer[n8]).getBufferImpl();
                            floatBufferWrapper.position(indexedGeometryArrayRetained.indexTexCoord[n8][n10] * this.texCoordStride);
                            floatBufferWrapper.get(this.vertexData, n2, this.texCoordStride);
                            n2 += this.texCoordStride;
                        }
                        n += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                n = 0;
                if ((indexedGeometryArrayRetained.vertexType & 0x8000) == 32768) {
                    for (n10 = n4; n10 < n5; ++n10) {
                        for (n8 = 0; n8 < this.vertexAttrCount; ++n8) {
                            int n12 = n + this.vertexAttrOffsets[n8];
                            FloatBufferWrapper floatBufferWrapper = indexedGeometryArrayRetained.floatBufferRefVertexAttrs[n8];
                            floatBufferWrapper.position(indexedGeometryArrayRetained.indexVertexAttr[n8][n10] * this.vertexAttrSizes[n8]);
                            floatBufferWrapper.get(this.vertexData, n12, this.vertexAttrSizes[n8]);
                        }
                        n += this.stride;
                    }
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                n = this.coordinateOffset;
                switch (indexedGeometryArrayRetained.vertexType & 0xF) {
                    case 1: {
                        for (n10 = n4; n10 < n5; ++n10) {
                            indexedGeometryArrayRetained.floatBufferRefCoords.position(indexedGeometryArrayRetained.indexCoord[n10] * 3);
                            indexedGeometryArrayRetained.floatBufferRefCoords.get(this.vertexData, n, 3);
                            n += this.stride;
                        }
                        break;
                    }
                    case 2: {
                        for (n10 = n4; n10 < n5; ++n10) {
                            n9 = indexedGeometryArrayRetained.indexCoord[n10] * 3;
                            this.vertexData[n] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n9);
                            this.vertexData[n + 1] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n9 + 1);
                            this.vertexData[n + 2] = (float)indexedGeometryArrayRetained.doubleBufferRefCoords.get(n9 + 2);
                            n += this.stride;
                        }
                        break;
                    }
                }
            }
        }
    }

    int stride() {
        int n = 0;
        if ((this.vertexFormat & 1) != 0) {
            n += 3;
        }
        if ((this.vertexFormat & 2) != 0) {
            n += 3;
        }
        if ((this.vertexFormat & 4) != 0) {
            n = (this.vertexFormat & 0x80) == 0 ? (n += 4) : ((this.vertexFormat & 8) == 0 ? (n += 3) : (n += 4));
        }
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x20) != 0) {
                this.texCoordStride = 2;
            } else if ((this.vertexFormat & 0x40) != 0) {
                this.texCoordStride = 3;
            } else if ((this.vertexFormat & 0x400) != 0) {
                this.texCoordStride = 4;
            }
            n += this.texCoordStride * this.texCoordSetCount;
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            n += this.vertexAttrStride;
        }
        return n;
    }

    int[] texCoordSetMapOffset() {
        if (this.texCoordSetMap == null) {
            return null;
        }
        this.texCoordSetMapOffset = new int[this.texCoordSetMap.length];
        for (int i = 0; i < this.texCoordSetMap.length; ++i) {
            this.texCoordSetMapOffset[i] = this.texCoordSetMap[i] == -1 ? -1 : this.texCoordSetMap[i] * this.texCoordStride;
        }
        return this.texCoordSetMapOffset;
    }

    int vertexAttrStride() {
        int n = 0;
        for (int i = 0; i < this.vertexAttrCount; ++i) {
            n += this.vertexAttrSizes[i];
        }
        return n;
    }

    int[] vertexAttrOffsets() {
        int[] nArray = this.vertexAttrCount > 0 ? new int[this.vertexAttrCount] : new int[]{0};
        for (int i = 1; i < this.vertexAttrCount; ++i) {
            nArray[i] = nArray[i - 1] + this.vertexAttrSizes[i - 1];
        }
        return nArray;
    }

    int textureOffset() {
        int n = this.vertexAttrOffsets[0];
        if ((this.vertexFormat & 0x1000) != 0) {
            n += this.vertexAttrStride;
        }
        return n;
    }

    int colorOffset() {
        int n = this.textureOffset;
        if ((this.vertexFormat & 0x20) != 0) {
            n += 2 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x40) != 0) {
            n += 3 * this.texCoordSetCount;
        } else if ((this.vertexFormat & 0x400) != 0) {
            n += 4 * this.texCoordSetCount;
        }
        return n;
    }

    int normalOffset() {
        int n = this.colorOffset;
        if ((this.vertexFormat & 4) != 0) {
            n = (this.vertexFormat & 0x80) == 0 ? (n += 4) : ((this.vertexFormat & 8) == 0 ? (n += 3) : (n += 4));
        }
        return n;
    }

    int coordinateOffset() {
        int n = this.normalOffset;
        if ((this.vertexFormat & 2) != 0) {
            n += 3;
        }
        return n;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getVertexFormat() {
        return this.vertexFormat;
    }

    int getVertexAttrCount() {
        return this.vertexAttrCount;
    }

    void getVertexAttrSizes(int[] nArray) {
        for (int i = 0; i < this.vertexAttrCount; ++i) {
            nArray[i] = this.vertexAttrSizes[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDataChangedMessage(boolean bl) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source != null && this.source.isLive()) {
                Cloneable cloneable;
                int n;
                int n2;
                int n3;
                int n4 = 128;
                n4 |= 0x400;
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int n5 = this.universeList.size();
                    J3dMessage[] j3dMessageArray = new J3dMessage[n5];
                    n3 = 0;
                    n2 = 0;
                    while (n2 < n5) {
                        Shape3DRetained shape3DRetained;
                        this.gaList.clear();
                        ArrayList arrayList2 = (ArrayList)this.userLists.get(n2);
                        for (n = 0; n < arrayList2.size(); ++n) {
                            shape3DRetained = (Shape3DRetained)arrayList2.get(n);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (!bl || !((LeafRetained)cloneable).boundsAutoCompute) continue;
                            ((LeafRetained)cloneable).boundsDirty = true;
                        }
                        for (n = 0; n < arrayList2.size(); ++n) {
                            shape3DRetained = (Shape3DRetained)arrayList2.get(n);
                            cloneable = (LeafRetained)shape3DRetained.sourceNode;
                            if (((LeafRetained)cloneable).boundsDirty) {
                                ((LeafRetained)cloneable).updateBounds();
                                ((LeafRetained)cloneable).boundsDirty = false;
                            }
                            this.gaList.add(Shape3DRetained.getGeomAtom(shape3DRetained));
                        }
                        j3dMessageArray[n3] = new J3dMessage();
                        j3dMessageArray[n3].type = 17;
                        j3dMessageArray[n3].threads = n4;
                        j3dMessageArray[n3].args[0] = this.gaList.toArray();
                        j3dMessageArray[n3].args[1] = this;
                        j3dMessageArray[n3].args[2] = null;
                        j3dMessageArray[n3].args[3] = new Integer(this.changedFrequent);
                        j3dMessageArray[n3].universe = (VirtualUniverse)this.universeList.get(n2);
                        ++n2;
                        ++n3;
                    }
                    VirtualUniverse.mc.processMessage(j3dMessageArray);
                }
                if (this.morphUniverseList != null) {
                    arrayList = this.morphUniverseList;
                    synchronized (arrayList) {
                        int n6 = this.morphUniverseList.size();
                        if (n6 > 0) {
                            cloneable = this.morphUniverseList;
                            synchronized (cloneable) {
                                n2 = 0;
                                while (n2 < n6) {
                                    ArrayList arrayList3 = (ArrayList)this.morphUserLists.get(n2);
                                    for (n = 0; n < arrayList3.size(); ++n) {
                                        MorphRetained morphRetained = (MorphRetained)arrayList3.get(n);
                                        morphRetained.updateMorphedGeometryArray(this, bl);
                                    }
                                    ++n2;
                                    ++n3;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    void setCoordinate(int n, float[] fArray) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, double[] dArray) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[n2] = (float)dArray[0];
        this.vertexData[n2 + 1] = (float)dArray[1];
        this.vertexData[n2 + 2] = (float)dArray[2];
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, Point3f point3f) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[n2] = point3f.x;
        this.vertexData[n2 + 1] = point3f.y;
        this.vertexData[n2 + 2] = point3f.z;
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinate(int n, Point3d point3d) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.vertexData[n2] = (float)point3d.x;
        this.vertexData[n2 + 1] = (float)point3d.y;
        this.vertexData[n2 + 2] = (float)point3d.z;
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, float[] fArray) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = fArray[n4];
            this.vertexData[n5 + 1] = fArray[n4 + 1];
            this.vertexData[n5 + 2] = fArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, double[] dArray) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = dArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)dArray[n4];
            this.vertexData[n5 + 1] = (float)dArray[n4 + 1];
            this.vertexData[n5 + 2] = (float)dArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3f[] point3fArray) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = point3fArray[n4].x;
            this.vertexData[n5 + 1] = point3fArray[n4].y;
            this.vertexData[n5 + 2] = point3fArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3d[] point3dArray) {
        boolean bl;
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3dArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)point3dArray[n4].x;
            this.vertexData[n5 + 1] = (float)point3dArray[n4].y;
            this.vertexData[n5 + 2] = (float)point3dArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, float[] fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, double[] dArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = (float)dArray[n5];
            this.vertexData[n6 + 1] = (float)dArray[n5 + 1];
            this.vertexData[n6 + 2] = (float)dArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3f[] point3fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = point3fArray[n5].x;
            this.vertexData[n6 + 1] = point3fArray[n5].y;
            this.vertexData[n6 + 2] = point3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setCoordinates(int n, Point3d[] point3dArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.coordinateOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)point3dArray[n5].x;
            this.vertexData[n6 + 1] = (float)point3dArray[n5].y;
            this.vertexData[n6 + 2] = (float)point3dArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (this.inUpdater || this.source == null) {
            return;
        }
        if (!bl) {
            this.boundsDirty = true;
            return;
        }
        this.processCoordsChanged(false);
        this.sendDataChangedMessage(true);
    }

    void setColor(int n, float[] fArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        this.vertexData[n2 + 3] = (this.vertexFormat & 8) != 0 ? fArray[3] * this.lastAlpha[0] : this.lastAlpha[0];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int n, byte[] byArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(byArray[0] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(byArray[1] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(byArray[2] & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 3] = (this.vertexFormat & 8) != 0 ? (float)(byArray[3] & 0xFF) * 0.003921569f * this.lastAlpha[0] : this.lastAlpha[0];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int n, Color3f color3f) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = color3f.x;
        this.vertexData[n2 + 1] = color3f.y;
        this.vertexData[n2 + 2] = color3f.z;
        this.vertexData[n2 + 3] = this.lastAlpha[0];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int n, Color4f color4f) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = color4f.x;
        this.vertexData[n2 + 1] = color4f.y;
        this.vertexData[n2 + 2] = color4f.z;
        this.vertexData[n2 + 3] = color4f.w * this.lastAlpha[0];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int n, Color3b color3b) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(color3b.x & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(color3b.y & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(color3b.z & 0xFF) * 0.003921569f;
        this.vertexData[n2 + 3] = this.lastAlpha[0];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColor(int n, Color4b color4b) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.vertexData[n2] = (float)(color4b.x * 255) * 0.003921569f;
        this.vertexData[n2 + 1] = (float)(color4b.y * 255) * 0.003921569f;
        this.vertexData[n2 + 2] = (float)(color4b.z * 255) * 0.003921569f;
        this.vertexData[n2 + 3] = (float)(color4b.w & 0xFF) * 0.003921569f * this.lastAlpha[0];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, float[] fArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        int n3 = fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                this.vertexData[n5] = fArray[n4];
                this.vertexData[n5 + 1] = fArray[n4 + 1];
                this.vertexData[n5 + 2] = fArray[n4 + 2];
                this.vertexData[n5 + 3] = fArray[n4 + 3] * this.lastAlpha[0];
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                this.vertexData[n7] = fArray[n6];
                this.vertexData[n7 + 1] = fArray[n6 + 1];
                this.vertexData[n7 + 2] = fArray[n6 + 2];
                this.vertexData[n7 + 3] = this.lastAlpha[0];
                n6 += 3;
                n7 += this.stride;
            }
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, byte[] byArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        int n3 = byArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                this.vertexData[n5] = (float)(byArray[n4] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 1] = (float)(byArray[n4 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 2] = (float)(byArray[n4 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n5 + 3] = (float)(byArray[n4 + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                this.vertexData[n7] = (float)(byArray[n6] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 1] = (float)(byArray[n6 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 2] = (float)(byArray[n6 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n7 + 3] = this.lastAlpha[0];
                n6 += 3;
                n7 += this.stride;
            }
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color3f[] color3fArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = color3fArray[n4].x;
            this.vertexData[n5 + 1] = color3fArray[n4].y;
            this.vertexData[n5 + 2] = color3fArray[n4].z;
            this.vertexData[n5 + 3] = this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color4f[] color4fArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = color4fArray[n4].x;
            this.vertexData[n5 + 1] = color4fArray[n4].y;
            this.vertexData[n5 + 2] = color4fArray[n4].z;
            this.vertexData[n5 + 3] = color4fArray[n4].w * this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color3b[] color3bArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3bArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)(color3bArray[n4].x & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 1] = (float)(color3bArray[n4].y & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 2] = (float)(color3bArray[n4].z & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 3] = this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color4b[] color4bArray) {
        boolean bl;
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4bArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = (float)(color4bArray[n4].x & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 1] = (float)(color4bArray[n4].y & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 2] = (float)(color4bArray[n4].z & 0xFF) * 0.003921569f;
            this.vertexData[n5 + 3] = (float)(color4bArray[n4].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, float[] fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = n2 * 4;
            int n6 = n4;
            while (n5 < (n2 + n3) * 4) {
                this.vertexData[n6] = fArray[n5];
                this.vertexData[n6 + 1] = fArray[n5 + 1];
                this.vertexData[n6 + 2] = fArray[n5 + 2];
                this.vertexData[n6 + 3] = fArray[n5 + 3] * this.lastAlpha[0];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = n2 * 3;
            int n8 = n4;
            while (n7 < (n2 + n3) * 3) {
                this.vertexData[n8] = fArray[n7];
                this.vertexData[n8 + 1] = fArray[n7 + 1];
                this.vertexData[n8 + 2] = fArray[n7 + 2];
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, byte[] byArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        if ((this.vertexFormat & 8) != 0) {
            int n5 = n2 * 4;
            int n6 = n4;
            while (n5 < (n2 + n3) * 4) {
                this.vertexData[n6] = (float)(byArray[n5] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 1] = (float)(byArray[n5 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 2] = (float)(byArray[n5 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n6 + 3] = (float)(byArray[n5 + 3] & 0xFF) * 0.003921569f * this.lastAlpha[0];
                n5 += 4;
                n6 += this.stride;
            }
        } else {
            int n7 = n2 * 3;
            int n8 = n4;
            while (n7 < (n2 + n3) * 3) {
                this.vertexData[n8] = (float)(byArray[n7] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 1] = (float)(byArray[n7 + 1] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 2] = (float)(byArray[n7 + 2] & 0xFF) * 0.003921569f;
                this.vertexData[n8 + 3] = this.lastAlpha[0];
                n7 += 3;
                n8 += this.stride;
            }
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color3f[] color3fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = color3fArray[n5].x;
            this.vertexData[n6 + 1] = color3fArray[n5].y;
            this.vertexData[n6 + 2] = color3fArray[n5].z;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color4f[] color4fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = color4fArray[n5].x;
            this.vertexData[n6 + 1] = color4fArray[n5].y;
            this.vertexData[n6 + 2] = color4fArray[n5].z;
            this.vertexData[n6 + 3] = color4fArray[n5].w * this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color3b[] color3bArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)(color3bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color3bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color3bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setColors(int n, Color4b[] color4bArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.colorOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = (float)(color4bArray[n5].x & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 1] = (float)(color4bArray[n5].y & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 2] = (float)(color4bArray[n5].z & 0xFF) * 0.003921569f;
            this.vertexData[n6 + 3] = (float)(color4bArray[n5].w & 0xFF) * 0.003921569f * this.lastAlpha[0];
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormal(int n, float[] fArray) {
        boolean bl;
        int n2 = this.stride * n + this.normalOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.vertexData[n2] = fArray[0];
        this.vertexData[n2 + 1] = fArray[1];
        this.vertexData[n2 + 2] = fArray[2];
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormal(int n, Vector3f vector3f) {
        boolean bl;
        int n2 = this.stride * n + this.normalOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.vertexData[n2] = vector3f.x;
        this.vertexData[n2 + 1] = vector3f.y;
        this.vertexData[n2 + 2] = vector3f.z;
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int n, float[] fArray) {
        boolean bl;
        int n2 = this.stride * n + this.normalOffset;
        int n3 = fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = fArray[n4];
            this.vertexData[n5 + 1] = fArray[n4 + 1];
            this.vertexData[n5 + 2] = fArray[n4 + 2];
            n4 += 3;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int n, Vector3f[] vector3fArray) {
        boolean bl;
        int n2 = this.stride * n + this.normalOffset;
        int n3 = vector3fArray.length;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            this.vertexData[n5] = vector3fArray[n4].x;
            this.vertexData[n5 + 1] = vector3fArray[n4].y;
            this.vertexData[n5 + 2] = vector3fArray[n4].z;
            ++n4;
            n5 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int n, float[] fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.normalOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int n5 = n2 * 3;
        int n6 = n4;
        while (n5 < (n2 + n3) * 3) {
            this.vertexData[n6] = fArray[n5];
            this.vertexData[n6 + 1] = fArray[n5 + 1];
            this.vertexData[n6 + 2] = fArray[n5 + 2];
            n5 += 3;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setNormals(int n, Vector3f[] vector3fArray, int n2, int n3) {
        boolean bl;
        int n4 = this.stride * n + this.normalOffset;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        int n5 = n2;
        int n6 = n4;
        while (n5 < n2 + n3) {
            this.vertexData[n6] = vector3fArray[n5].x;
            this.vertexData[n6 + 1] = vector3fArray[n5].y;
            this.vertexData[n6 + 2] = vector3fArray[n5].z;
            ++n5;
            n6 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int n, int n2, float[] fArray, int n3, int n4) {
        boolean bl;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x400) != 0) {
            int n6 = n3 * 4;
            int n7 = n5;
            for (int i = 0; i < n4; ++i) {
                this.vertexData[n7] = fArray[n6++];
                this.vertexData[n7 + 1] = fArray[n6++];
                this.vertexData[n7 + 2] = fArray[n6++];
                this.vertexData[n7 + 3] = fArray[n6++];
                n7 += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int n8 = n3 * 3;
            int n9 = n5;
            for (int i = 0; i < n4; ++i) {
                this.vertexData[n9] = fArray[n8++];
                this.vertexData[n9 + 1] = fArray[n8++];
                this.vertexData[n9 + 2] = fArray[n8++];
                n9 += this.stride;
            }
        } else {
            int n10 = n3 * 2;
            int n11 = n5;
            for (int i = 0; i < n4; ++i) {
                this.vertexData[n11] = fArray[n10++];
                this.vertexData[n11 + 1] = fArray[n10++];
                n11 += this.stride;
            }
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int n, int n2, Point2f[] point2fArray, int n3, int n4) {
        boolean bl;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point2fArray[n6].x;
            this.vertexData[n7 + 1] = point2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int n, int n2, Point3f[] point3fArray, int n3, int n4) {
        boolean bl;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = point3fArray[n6].x;
            this.vertexData[n7 + 1] = point3fArray[n6].y;
            this.vertexData[n7 + 2] = point3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord2fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord3fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord3fArray[n6].y;
            this.vertexData[n7 + 2] = texCoord3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setTextureCoordinates(int n, int n2, TexCoord4f[] texCoord4fArray, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        if ((this.vertexFormat & 0x80) != 0) {
            throw new IllegalStateException(J3dI18N.getString("GeometryArray82"));
        }
        if ((this.vertexFormat & 0x460) == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray79"));
        }
        int n5 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n6 = n3;
        int n7 = n5;
        while (n6 < n3 + n4) {
            this.vertexData[n7] = texCoord4fArray[n6].x;
            this.vertexData[n7 + 1] = texCoord4fArray[n6].y;
            this.vertexData[n7 + 2] = texCoord4fArray[n6].z;
            this.vertexData[n7 + 3] = texCoord4fArray[n6].w;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttr(int n, int n2, Point2f point2f) {
        boolean bl;
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexData[n3] = point2f.x;
        this.vertexData[n3 + 1] = point2f.y;
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttr(int n, int n2, Point3f point3f) {
        boolean bl;
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexData[n3] = point3f.x;
        this.vertexData[n3 + 1] = point3f.y;
        this.vertexData[n3 + 2] = point3f.z;
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttr(int n, int n2, Point4f point4f) {
        boolean bl;
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexData[n3] = point4f.x;
        this.vertexData[n3 + 1] = point4f.y;
        this.vertexData[n3 + 2] = point4f.z;
        this.vertexData[n3 + 3] = point4f.w;
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int n, int n2, float[] fArray, int n3, int n4) {
        boolean bl;
        int n5 = this.stride * n2 + this.vertexAttrOffsets[n];
        int n6 = this.vertexAttrSizes[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int n7 = n3 * n6;
        int n8 = n5;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n6; ++j) {
                this.vertexData[n8 + j] = fArray[n7 + j];
            }
            n7 += n6;
            n8 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int n, int n2, Point2f[] point2fArray, int n3, int n4) {
        boolean bl;
        int n5 = this.stride * n2 + this.vertexAttrOffsets[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int n6 = n3;
        int n7 = n5;
        for (int i = 0; i < n4; ++i) {
            this.vertexData[n7] = point2fArray[n6].x;
            this.vertexData[n7 + 1] = point2fArray[n6].y;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int n, int n2, Point3f[] point3fArray, int n3, int n4) {
        boolean bl;
        int n5 = this.stride * n2 + this.vertexAttrOffsets[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int n6 = n3;
        int n7 = n5;
        for (int i = 0; i < n4; ++i) {
            this.vertexData[n7] = point3fArray[n6].x;
            this.vertexData[n7 + 1] = point3fArray[n6].y;
            this.vertexData[n7 + 2] = point3fArray[n6].z;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrs(int n, int n2, Point4f[] point4fArray, int n3, int n4) {
        boolean bl;
        int n5 = this.stride * n2 + this.vertexAttrOffsets[n];
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        int n6 = n3;
        int n7 = n5;
        for (int i = 0; i < n4; ++i) {
            this.vertexData[n7] = point4fArray[n6].x;
            this.vertexData[n7 + 1] = point4fArray[n6].y;
            this.vertexData[n7 + 2] = point4fArray[n6].z;
            this.vertexData[n7 + 3] = point4fArray[n6].w;
            ++n6;
            n7 += this.stride;
        }
        if (bl) {
            this.geomLock.unLock();
            this.sendDataChangedMessage(false);
        }
    }

    void getCoordinate(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        dArray[0] = this.vertexData[n2];
        dArray[1] = this.vertexData[n2 + 1];
        dArray[2] = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, Point3f point3f) {
        int n2 = this.stride * n + this.coordinateOffset;
        point3f.x = this.vertexData[n2];
        point3f.y = this.vertexData[n2 + 1];
        point3f.z = this.vertexData[n2 + 2];
    }

    void getCoordinate(int n, Point3d point3d) {
        int n2 = this.stride * n + this.coordinateOffset;
        point3d.x = this.vertexData[n2];
        point3d.y = this.vertexData[n2 + 1];
        point3d.z = this.vertexData[n2 + 2];
    }

    void getCoordinates(int n, float[] fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            fArray[n4] = this.vertexData[n5];
            fArray[n4 + 1] = this.vertexData[n5 + 1];
            fArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, double[] dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = dArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            dArray[n4] = this.vertexData[n5];
            dArray[n4 + 1] = this.vertexData[n5 + 1];
            dArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, Point3f[] point3fArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            point3fArray[n4].x = this.vertexData[n5];
            point3fArray[n4].y = this.vertexData[n5 + 1];
            point3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getCoordinates(int n, Point3d[] point3dArray) {
        int n2 = this.stride * n + this.coordinateOffset;
        int n3 = point3dArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            point3dArray[n4].x = this.vertexData[n5];
            point3dArray[n4].y = this.vertexData[n5 + 1];
            point3dArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getColor(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
        if ((this.vertexFormat & 8) != 0) {
            fArray[3] = this.vertexData[n2 + 3] / this.lastAlpha[0];
        }
    }

    void getColor(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        byArray[0] = (byte)(this.vertexData[n2] * 255.0f);
        byArray[1] = (byte)(this.vertexData[n2 + 1] * 255.0f);
        byArray[2] = (byte)(this.vertexData[n2 + 2] * 255.0f);
        if ((this.vertexFormat & 8) != 0) {
            byArray[3] = (byte)(this.vertexData[n2 + 3] / this.lastAlpha[0] * 255.0f);
        }
    }

    void getColor(int n, Color3f color3f) {
        int n2 = this.stride * n + this.colorOffset;
        color3f.x = this.vertexData[n2];
        color3f.y = this.vertexData[n2 + 1];
        color3f.z = this.vertexData[n2 + 2];
    }

    void getColor(int n, Color4f color4f) {
        int n2 = this.stride * n + this.colorOffset;
        color4f.x = this.vertexData[n2];
        color4f.y = this.vertexData[n2 + 1];
        color4f.z = this.vertexData[n2 + 2];
        color4f.w = this.vertexData[n2 + 3] / this.lastAlpha[0];
    }

    void getColor(int n, Color3b color3b) {
        int n2 = this.stride * n + this.colorOffset;
        color3b.x = (byte)(this.vertexData[n2] * 255.0f);
        color3b.y = (byte)(this.vertexData[n2 + 1] * 255.0f);
        color3b.z = (byte)(this.vertexData[n2 + 2] * 255.0f);
    }

    void getColor(int n, Color4b color4b) {
        int n2 = this.stride * n + this.colorOffset;
        color4b.x = (byte)(this.vertexData[n2] * 255.0f);
        color4b.y = (byte)(this.vertexData[n2 + 1] * 255.0f);
        color4b.z = (byte)(this.vertexData[n2 + 2] * 255.0f);
        color4b.w = (byte)(this.vertexData[n2 + 3] / this.lastAlpha[0] * 255.0f);
    }

    void getColors(int n, float[] fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = fArray.length;
        float f = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                fArray[n4] = this.vertexData[n5];
                fArray[n4 + 1] = this.vertexData[n5 + 1];
                fArray[n4 + 2] = this.vertexData[n5 + 2];
                fArray[n4 + 3] = this.vertexData[n5 + 3] * f;
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                fArray[n6] = this.vertexData[n7];
                fArray[n6 + 1] = this.vertexData[n7 + 1];
                fArray[n6 + 2] = this.vertexData[n7 + 2];
                n6 += 3;
                n7 += this.stride;
            }
        }
    }

    void getColors(int n, byte[] byArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = byArray.length;
        float f = 1.0f / this.lastAlpha[0];
        if ((this.vertexFormat & 8) != 0) {
            int n4 = 0;
            int n5 = n2;
            while (n4 < n3) {
                byArray[n4] = (byte)(this.vertexData[n5] * 255.0f);
                byArray[n4 + 1] = (byte)(this.vertexData[n5 + 1] * 255.0f);
                byArray[n4 + 2] = (byte)(this.vertexData[n5 + 2] * 255.0f);
                byArray[n4 + 3] = (byte)(this.vertexData[n5 + 3] * f * 255.0f);
                n4 += 4;
                n5 += this.stride;
            }
        } else {
            int n6 = 0;
            int n7 = n2;
            while (n6 < n3) {
                byArray[n6] = (byte)(this.vertexData[n7] * 255.0f);
                byArray[n6 + 1] = (byte)(this.vertexData[n7 + 1] * 255.0f);
                byArray[n6 + 2] = (byte)(this.vertexData[n7 + 2] * 255.0f);
                n6 += 3;
                n7 += this.stride;
            }
        }
    }

    void getColors(int n, Color3f[] color3fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color3fArray[n4].x = this.vertexData[n5];
            color3fArray[n4].y = this.vertexData[n5 + 1];
            color3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color4f[] color4fArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4fArray.length;
        float f = 1.0f / this.lastAlpha[0];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color4fArray[n4].x = this.vertexData[n5];
            color4fArray[n4].y = this.vertexData[n5 + 1];
            color4fArray[n4].z = this.vertexData[n5 + 2];
            color4fArray[n4].w = this.vertexData[n5 + 3] * f;
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color3b[] color3bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color3bArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color3bArray[n4].x = (byte)(this.vertexData[n5] * 255.0f);
            color3bArray[n4].y = (byte)(this.vertexData[n5 + 1] * 255.0f);
            color3bArray[n4].z = (byte)(this.vertexData[n5 + 2] * 255.0f);
            ++n4;
            n5 += this.stride;
        }
    }

    void getColors(int n, Color4b[] color4bArray) {
        int n2 = this.stride * n + this.colorOffset;
        int n3 = color4bArray.length;
        float f = 1.0f / this.lastAlpha[0];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            color4bArray[n4].x = (byte)(this.vertexData[n5] * 255.0f);
            color4bArray[n4].y = (byte)(this.vertexData[n5 + 1] * 255.0f);
            color4bArray[n4].z = (byte)(this.vertexData[n5 + 2] * 255.0f);
            color4bArray[n4].w = (byte)(this.vertexData[n5 + 3] * f * 255.0f);
            ++n4;
            n5 += this.stride;
        }
    }

    void getNormal(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        fArray[0] = this.vertexData[n2];
        fArray[1] = this.vertexData[n2 + 1];
        fArray[2] = this.vertexData[n2 + 2];
    }

    void getNormal(int n, Vector3f vector3f) {
        int n2 = this.stride * n + this.normalOffset;
        vector3f.x = this.vertexData[n2];
        vector3f.y = this.vertexData[n2 + 1];
        vector3f.z = this.vertexData[n2 + 2];
    }

    void getNormals(int n, float[] fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            fArray[n4] = this.vertexData[n5];
            fArray[n4 + 1] = this.vertexData[n5 + 1];
            fArray[n4 + 2] = this.vertexData[n5 + 2];
            n4 += 3;
            n5 += this.stride;
        }
    }

    void getNormals(int n, Vector3f[] vector3fArray) {
        int n2 = this.stride * n + this.normalOffset;
        int n3 = vector3fArray.length;
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            vector3fArray[n4].x = this.vertexData[n5];
            vector3fArray[n4].y = this.vertexData[n5 + 1];
            vector3fArray[n4].z = this.vertexData[n5 + 2];
            ++n4;
            n5 += this.stride;
        }
    }

    void getTextureCoordinate(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        fArray[0] = this.vertexData[n3];
        fArray[1] = this.vertexData[n3 + 1];
        if ((this.vertexFormat & 0x40) != 0) {
            fArray[2] = this.vertexData[n3 + 2];
        } else if ((this.vertexFormat & 0x400) != 0) {
            fArray[2] = this.vertexData[n3 + 2];
            fArray[3] = this.vertexData[n3 + 3];
        }
    }

    void getTextureCoordinate(int n, int n2, TexCoord2f texCoord2f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord2f.x = this.vertexData[n3];
        texCoord2f.y = this.vertexData[n3 + 1];
    }

    void getTextureCoordinate(int n, int n2, TexCoord3f texCoord3f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord3f.x = this.vertexData[n3];
        texCoord3f.y = this.vertexData[n3 + 1];
        texCoord3f.z = this.vertexData[n3 + 2];
    }

    void getTextureCoordinate(int n, int n2, TexCoord4f texCoord4f) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        texCoord4f.x = this.vertexData[n3];
        texCoord4f.y = this.vertexData[n3 + 1];
        texCoord4f.z = this.vertexData[n3 + 2];
        texCoord4f.w = this.vertexData[n3 + 3];
    }

    void getTextureCoordinates(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = fArray.length;
        if ((this.vertexFormat & 0x400) != 0) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < n4) {
                fArray[n5] = this.vertexData[n6];
                fArray[n5 + 1] = this.vertexData[n6 + 1];
                fArray[n5 + 2] = this.vertexData[n6 + 2];
                fArray[n5 + 3] = this.vertexData[n6 + 3];
                n5 += 4;
                n6 += this.stride;
            }
        } else if ((this.vertexFormat & 0x40) != 0) {
            int n7 = 0;
            int n8 = n3;
            while (n7 < n4) {
                fArray[n7] = this.vertexData[n8];
                fArray[n7 + 1] = this.vertexData[n8 + 1];
                fArray[n7 + 2] = this.vertexData[n8 + 2];
                n7 += 3;
                n8 += this.stride;
            }
        } else {
            int n9 = 0;
            int n10 = n3;
            while (n9 < n4) {
                fArray[n9] = this.vertexData[n10];
                fArray[n9 + 1] = this.vertexData[n10 + 1];
                n9 += 2;
                n10 += this.stride;
            }
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord2f[] texCoord2fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord2fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord2fArray[n5].x = this.vertexData[n6];
            texCoord2fArray[n5].y = this.vertexData[n6 + 1];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord3f[] texCoord3fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord3fArray[n5].x = this.vertexData[n6];
            texCoord3fArray[n5].y = this.vertexData[n6 + 1];
            texCoord3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, TexCoord4f[] texCoord4fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = texCoord4fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            texCoord4fArray[n5].x = this.vertexData[n6];
            texCoord4fArray[n5].y = this.vertexData[n6 + 1];
            texCoord4fArray[n5].z = this.vertexData[n6 + 2];
            texCoord4fArray[n5].w = this.vertexData[n6 + 3];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, Point2f[] point2fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = point2fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point2fArray[n5].x = this.vertexData[n6];
            point2fArray[n5].y = this.vertexData[n6 + 1];
            ++n5;
            n6 += this.stride;
        }
    }

    void getTextureCoordinates(int n, int n2, Point3f[] point3fArray) {
        int n3 = this.stride * n2 + this.textureOffset + n * this.texCoordStride;
        int n4 = point3fArray.length;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n4) {
            point3fArray[n5].x = this.vertexData[n6];
            point3fArray[n5].y = this.vertexData[n6 + 1];
            point3fArray[n5].z = this.vertexData[n6 + 2];
            ++n5;
            n6 += this.stride;
        }
    }

    public void getVertexAttr(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        int n4 = this.vertexAttrSizes[n];
        for (int i = 0; i < n4; ++i) {
            fArray[i] = this.vertexData[n3 + i];
        }
    }

    public void getVertexAttr(int n, int n2, Point2f point2f) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        point2f.x = this.vertexData[n3];
        point2f.y = this.vertexData[n3 + 1];
    }

    public void getVertexAttr(int n, int n2, Point3f point3f) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        point3f.x = this.vertexData[n3];
        point3f.y = this.vertexData[n3 + 1];
        point3f.z = this.vertexData[n3 + 2];
    }

    public void getVertexAttr(int n, int n2, Point4f point4f) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        point4f.x = this.vertexData[n3];
        point4f.y = this.vertexData[n3 + 1];
        point4f.z = this.vertexData[n3 + 2];
        point4f.w = this.vertexData[n3 + 3];
    }

    public void getVertexAttrs(int n, int n2, float[] fArray) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        int n4 = this.vertexAttrSizes[n];
        int n5 = 0;
        for (int i = n3; n5 < fArray.length && i < this.vertexData.length; n5 += n4, i += this.stride) {
            for (int j = 0; j < n4; ++j) {
                fArray[n5 + j] = this.vertexData[i + j];
            }
        }
    }

    public void getVertexAttrs(int n, int n2, Point2f[] point2fArray) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        int n4 = 0;
        for (int i = n3; n4 < point2fArray.length && i < this.vertexData.length; ++n4, i += this.stride) {
            point2fArray[n4].x = this.vertexData[i];
            point2fArray[n4].y = this.vertexData[i + 1];
        }
    }

    public void getVertexAttrs(int n, int n2, Point3f[] point3fArray) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        int n4 = 0;
        for (int i = n3; n4 < point3fArray.length && i < this.vertexData.length; ++n4, i += this.stride) {
            point3fArray[n4].x = this.vertexData[i];
            point3fArray[n4].y = this.vertexData[i + 1];
            point3fArray[n4].z = this.vertexData[i + 2];
        }
    }

    public void getVertexAttrs(int n, int n2, Point4f[] point4fArray) {
        int n3 = this.stride * n2 + this.vertexAttrOffsets[n];
        int n4 = 0;
        for (int i = n3; n4 < point4fArray.length && i < this.vertexData.length; ++n4, i += this.stride) {
            point4fArray[n4].x = this.vertexData[i];
            point4fArray[n4].y = this.vertexData[i + 1];
            point4fArray[n4].z = this.vertexData[i + 2];
            point4fArray[n4].w = this.vertexData[i + 3];
        }
    }

    void updateData(GeometryUpdater geometryUpdater) {
        boolean bl = false;
        this.geomLock.getLock();
        this.inUpdater = true;
        geometryUpdater.updateData((Geometry)this.source);
        this.inUpdater = false;
        if ((this.vertexFormat & 0x80) != 0) {
            if ((this.vertexFormat & 0x800) != 0) {
                if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                    if ((this.vertexFormat & 0x100) != 0) {
                        this.setupMirrorInterleavedColorPointer(false);
                        bl = this.interleavedFloatBufferImpl == null;
                    } else {
                        this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                        bl = (this.vertexType & 0xF) == 0;
                    }
                }
            } else if (!(this instanceof IndexedGeometryArrayRetained) || (this.vertexFormat & 0x200) != 0) {
                if ((this.vertexFormat & 0x100) != 0) {
                    this.setupMirrorInterleavedColorPointer(false);
                    bl = this.interLeavedVertexData == null;
                } else {
                    this.setupMirrorVertexPointer(this.vertexType & 0xF);
                    this.setupMirrorColorPointer(this.vertexType & 0x3F0, false);
                    this.setupMirrorNormalPointer(this.vertexType & 0xC00);
                    this.setupMirrorTexCoordPointer(this.texCoordType);
                    this.setupMirrorVertexAttrPointer(this.vertexAttrType);
                    boolean bl2 = bl = (this.vertexType & 0xF) == 0;
                }
            }
            if ((this.vertexFormat & 0x2000) != 0) {
                assert (this instanceof IndexedGeometryArrayRetained);
                if (((IndexedGeometryArrayRetained)this).getCoordIndicesRef() == null) {
                    bl = true;
                }
                ((IndexedGeometryArrayRetained)this).doPostUpdaterUpdate();
            }
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.geomLock.unLock();
        if (this.source != null && this.source.isLive()) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    boolean intersectBoundingBox(Point3d[] point3dArray, BoundingBox boundingBox, double[] dArray, Point3d point3d) {
        int n;
        int[] nArray = new int[6];
        for (n = 0; n < 6; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < point3dArray.length; ++n) {
            if (point3dArray[n].x >= boundingBox.lower.x && point3dArray[n].x <= boundingBox.upper.x && point3dArray[n].y >= boundingBox.lower.y && point3dArray[n].y <= boundingBox.upper.y && point3dArray[n].z >= boundingBox.lower.z && point3dArray[n].z <= boundingBox.upper.z) {
                return true;
            }
            if (point3dArray[n].x < boundingBox.lower.x) {
                nArray[0] = nArray[0] + 1;
            }
            if (point3dArray[n].y < boundingBox.lower.y) {
                nArray[1] = nArray[1] + 1;
            }
            if (point3dArray[n].z < boundingBox.lower.z) {
                nArray[2] = nArray[2] + 1;
            }
            if (point3dArray[n].x > boundingBox.upper.x) {
                nArray[3] = nArray[3] + 1;
            }
            if (point3dArray[n].y > boundingBox.upper.y) {
                nArray[4] = nArray[4] + 1;
            }
            if (!(point3dArray[n].z > boundingBox.upper.z)) continue;
            nArray[5] = nArray[5] + 1;
        }
        if (nArray[0] == point3dArray.length || nArray[1] == point3dArray.length || nArray[2] == point3dArray.length || nArray[3] == point3dArray.length || nArray[4] == point3dArray.length || nArray[5] == point3dArray.length) {
            return false;
        }
        Point3d[] point3dArray2 = new Point3d[4];
        for (n = 0; n < 4; ++n) {
            point3dArray2[n] = new Point3d();
        }
        point3dArray2[0].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[1].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.upper.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.upper.z);
        point3dArray2[3].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.upper.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        point3dArray2[0].set(boundingBox.upper.x, boundingBox.upper.y, boundingBox.lower.z);
        point3dArray2[1].set(boundingBox.upper.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[2].set(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
        point3dArray2[3].set(boundingBox.lower.x, boundingBox.upper.y, boundingBox.lower.z);
        if (this.intersectPolygon(point3dArray2, point3dArray)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray2, boundingBox.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        return false;
    }

    boolean intersectBoundingSphere(Point3d[] point3dArray, BoundingSphere boundingSphere, double[] dArray, Point3d point3d) {
        int n;
        int n2;
        Vector3d vector3d = new Vector3d();
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            vector3d.x = point3dArray[n2].x - boundingSphere.center.x;
            vector3d.y = point3dArray[n2].y - boundingSphere.center.y;
            vector3d.z = point3dArray[n2].z - boundingSphere.center.z;
            if (!(vector3d.length() <= boundingSphere.radius)) continue;
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            boolean bl = n2 < point3dArray.length - 1 ? this.edgeIntersectSphere(boundingSphere, point3dArray[n2], point3dArray[n2 + 1]) : this.edgeIntersectSphere(boundingSphere, point3dArray[n2], point3dArray[0]);
            if (!bl) continue;
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), null, dArray, point3d);
            }
            return true;
        }
        if (point3dArray.length < 3) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d2 = new Point3d();
        n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (!(vector3d2.length() > 0.0)) continue;
        }
        for (n = n2; n < point3dArray.length - 1; ++n) {
            vector3d3.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d3.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d3.z = point3dArray[n + 1].z - point3dArray[n].z;
            if (vector3d3.length() > 0.0) break;
        }
        if (n == point3dArray.length - 1) {
            return false;
        }
        vector3d4.cross(vector3d2, vector3d3);
        double d = vector3d4.lengthSquared();
        if (d == 0.0) {
            return false;
        }
        vector3d5.x = point3dArray[0].x - boundingSphere.center.x;
        vector3d5.y = point3dArray[0].y - boundingSphere.center.y;
        vector3d5.z = point3dArray[0].z - boundingSphere.center.z;
        double d2 = vector3d4.dot(vector3d5);
        double d3 = Math.sqrt(d2 * d2 / d);
        if (d3 > boundingSphere.radius) {
            return false;
        }
        double d4 = d2 / d;
        point3d2.x = boundingSphere.center.x + d4 * vector3d4.x;
        point3d2.y = boundingSphere.center.y + d4 * vector3d4.y;
        point3d2.z = boundingSphere.center.z + d4 * vector3d4.z;
        if (this.pointIntersectPolygon2D(vector3d4, point3dArray, point3d2)) {
            if (dArray != null) {
                this.computeMinDistance(point3dArray, boundingSphere.getCenter(), vector3d4, dArray, point3d);
            }
            return true;
        }
        return false;
    }

    boolean intersectBoundingPolytope(Point3d[] point3dArray, BoundingPolytope boundingPolytope, double[] dArray, Point3d point3d) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        Point4d point4d = new Point4d();
        double d = -1.0;
        if (point3dArray.length == 2) {
            if (boundingPolytope.intersect(point3dArray[0], point3dArray[1], point4d)) {
                if (dArray != null) {
                    point3d.x = point4d.x;
                    point3d.y = point4d.y;
                    point3d.z = point4d.z;
                    Point3d point3d2 = boundingPolytope.getCenter();
                    double d2 = point3d.x - point3d2.x;
                    double d3 = point3d.y - point3d2.y;
                    double d4 = point3d.z - point3d2.z;
                    dArray[0] = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                }
                return true;
            }
            return false;
        }
        if (bl) {
            int n5;
            System.err.println("The value of the input vertices are: ");
            for (n5 = 0; n5 < point3dArray.length; ++n5) {
                System.err.println("The " + n5 + " th vertex is: " + point3dArray[n5]);
            }
            System.err.println("The value of the input bounding Polytope's planes =");
            for (n5 = 0; n5 < boundingPolytope.planes.length; ++n5) {
                System.err.println("The " + n5 + " th plane is: " + boundingPolytope.planes[n5]);
            }
        }
        double[] dArray2 = new double[]{0.8, 0.9, 1.1, 1.2};
        boolean bl2 = true;
        boolean bl3 = false;
        if (bl3) {
            for (n4 = 0; n4 < point3dArray.length; ++n4) {
                for (n3 = 0; n3 < boundingPolytope.planes.length; ++n3) {
                    if (!(boundingPolytope.planes[n3].x * point3dArray[n4].x + boundingPolytope.planes[n3].y * point3dArray[n4].y + boundingPolytope.planes[n3].z * point3dArray[n4].z <= d * boundingPolytope.planes[n3].w)) {
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                }
                if (!bl2) continue;
                if (dArray != null) {
                    this.computeMinDistance(point3dArray, boundingPolytope.getCenter(), null, dArray, point3d);
                }
                return true;
            }
        }
        n4 = boundingPolytope.planes.length + 2 + point3dArray.length + 1;
        n3 = 1 + point3dArray.length;
        double[][] dArray3 = new double[n3][n4];
        for (n2 = 0; n2 < boundingPolytope.planes.length; ++n2) {
            for (n = 0; n < point3dArray.length; ++n) {
                dArray3[n][n2] = -1.0 * (boundingPolytope.planes[n2].x * point3dArray[n].x + boundingPolytope.planes[n2].y * point3dArray[n].y + boundingPolytope.planes[n2].z * point3dArray[n].z);
            }
        }
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            dArray3[n2][boundingPolytope.planes.length] = -1.0;
            dArray3[n2][boundingPolytope.planes.length + 1] = 1.0;
            for (n = 0; n < point3dArray.length; ++n) {
                dArray3[n2][n + boundingPolytope.planes.length + 2] = n2 == n ? 1.0 : 0.0;
                dArray3[n2][n4 - 1] = dArray2[n2];
            }
        }
        for (n2 = 0; n2 < boundingPolytope.planes.length; ++n2) {
            dArray3[n3 - 1][n2] = d * boundingPolytope.planes[n2].w;
        }
        dArray3[n3 - 1][boundingPolytope.planes.length] = 1.0;
        dArray3[n3 - 1][boundingPolytope.planes.length + 1] = -1.0;
        for (n2 = 0; n2 < point3dArray.length; ++n2) {
            dArray3[n3 - 1][boundingPolytope.planes.length + 2 + n2] = 0.0;
        }
        if (bl) {
            System.err.println("The value of the problem tableau is: ");
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                for (n = 0; n < dArray3[0].length; ++n) {
                    System.err.print(dArray3[n2][n] + "  ");
                }
                System.err.println();
            }
        }
        double d5 = this.generalStandardSimplexSolver(dArray3, Double.NEGATIVE_INFINITY);
        if (bl) {
            System.err.println("The value returned by the general standard simplex = " + d5);
        }
        if (d5 == Double.POSITIVE_INFINITY) {
            return false;
        }
        if (dArray != null) {
            this.computeMinDistance(point3dArray, boundingPolytope.getCenter(), null, dArray, point3d);
        }
        return true;
    }

    double generalStandardSimplexSolver(double[][] dArray, double d) {
        boolean bl = false;
        int n = dArray.length;
        int n2 = dArray[0].length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            System.err.println("The number of rows is : " + n);
            System.err.println("The number of columns is : " + n2);
        }
        while (!bl2) {
            double d2;
            int n3;
            if (bl) {
                System.err.println("input problem tableau is:");
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        System.err.println("kth, jth value is:" + i + " " + j + " : " + dArray[i][j]);
                    }
                }
            }
            double d3 = 0.0;
            int n4 = -1;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                d2 = dArray[n - 1][n3];
                if (!(d2 < d3)) continue;
                d3 = d2;
                n4 = n3;
            }
            if (n4 == -1) {
                bl2 = true;
            }
            if (bl2) continue;
            double d4 = Double.POSITIVE_INFINITY;
            double d5 = 0.0;
            int n5 = -1;
            for (n3 = 0; n3 < n - 1; ++n3) {
                d2 = dArray[n3][n4];
                double d6 = dArray[n3][n2 - 1];
                if (d2 == 0.0) {
                    if (!bl) continue;
                    System.err.println("Division by zero has occurred");
                    System.err.println("Within the linear program solver");
                    System.err.println("Ignoring the zero as a potential pivot");
                    continue;
                }
                if (d2 < 0.0 || d6 < 0.0) {
                    if (!bl) continue;
                    System.err.println("Ignoring cases where element is negative");
                    System.err.println("The value of element is: " + d2);
                    System.err.println("The value of end Element is: " + d6);
                    continue;
                }
                d5 = d6 / d2;
                if (bl) {
                    System.err.println("The value of element is: " + d2);
                    System.err.println("The value of endElement is: " + d6);
                    System.err.println("The value of ratio is: " + d5);
                    System.err.println("The value of prevRatio is: " + d4);
                    System.err.println("Value of ratio <= prevRatio is :" + (d5 <= d4));
                }
                if (!(d5 <= d4)) continue;
                if (bl) {
                    System.err.println("updating prevRatio with ratio");
                }
                d4 = d5;
                n5 = n3;
            }
            if (n5 == -1) {
                if (bl) {
                    System.err.println("UNABLE TO FIND SOLUTION");
                    System.err.println("The system is infeasable or unbounded");
                }
                return Double.POSITIVE_INFINITY;
            }
            double d7 = dArray[n5][n4];
            if (bl) {
                System.err.println("The value of row index is: " + n5);
                System.err.println("The value of col index is: " + n4);
                System.err.println("The value of pivotValue is: " + d7);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray[n5][n3] = dArray[n5][n3] / d7;
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (n3 == n5) continue;
                double d8 = dArray[n3][n4];
                for (int i = 0; i < n2; ++i) {
                    dArray[n3][i] = dArray[n3][i] - d8 * dArray[n5][i];
                }
            }
        }
        return dArray[n - 1][n2 - 1];
    }

    boolean edgeIntersectSphere(BoundingSphere boundingSphere, Point3d point3d, Point3d point3d2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = boundingSphere.center.x - point3d.x;
        vector3d2.y = boundingSphere.center.y - point3d.y;
        vector3d2.z = boundingSphere.center.z - point3d.z;
        double d = vector3d.dot(vector3d2);
        if (d < 0.0) {
            return false;
        }
        double d2 = vector3d.lengthSquared();
        double d3 = d * d / d2;
        if (d3 < d2) {
            return false;
        }
        double d4 = boundingSphere.radius * boundingSphere.radius;
        double d5 = vector3d2.lengthSquared();
        return d5 - d3 <= d4;
    }

    double det2D(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return (point2d3.x - point2d.x) * (point2d.y - point2d2.y) + (point2d.y - point2d3.y) * (point2d.x - point2d2.x);
    }

    boolean pointIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d point3d) {
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d point2d = new Point2d();
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n = d > d2 ? 0 : 1;
        if (n == 0) {
            if (d < d3) {
                n = 2;
            }
        } else if (n == 1 && d2 < d3) {
            n = 2;
        }
        block10: for (int i = 0; i < point3dArray.length; ++i) {
            point2dArray[i] = new Point2d();
            switch (n) {
                case 0: {
                    point2dArray[i].x = point3dArray[i].y;
                    point2dArray[i].y = point3dArray[i].z;
                    continue block10;
                }
                case 1: {
                    point2dArray[i].x = point3dArray[i].x;
                    point2dArray[i].y = point3dArray[i].z;
                    continue block10;
                }
                case 2: {
                    point2dArray[i].x = point3dArray[i].x;
                    point2dArray[i].y = point3dArray[i].y;
                }
            }
        }
        switch (n) {
            case 0: {
                point2d.x = point3d.y;
                point2d.y = point3d.z;
                break;
            }
            case 1: {
                point2d.x = point3d.x;
                point2d.y = point3d.z;
                break;
            }
            case 2: {
                point2d.x = point3d.x;
                point2d.y = point3d.y;
            }
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            if (i < point3dArray.length - 1) {
                if (this.det2D(point2dArray[i], point2dArray[i + 1], point2d) > 0.0) continue;
                return false;
            }
            if (this.det2D(point2dArray[i], point2dArray[0], point2d) > 0.0) continue;
            return false;
        }
        return true;
    }

    boolean edgeIntersectPlane(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.set((Tuple3d)point3d);
        double d = vector3d.dot(vector3d2);
        vector3d3.x = point3d3.x - point3d2.x;
        vector3d3.y = point3d3.y - point3d2.y;
        vector3d3.z = point3d3.z - point3d2.z;
        double d2 = vector3d.dot(vector3d3);
        if (d2 == 0.0) {
            return false;
        }
        vector3d2.set((Tuple3d)point3d2);
        double d3 = (d - vector3d.dot(vector3d2)) / d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return false;
        }
        point3d4.x = point3d2.x + d3 * vector3d3.x;
        point3d4.y = point3d2.y + d3 * vector3d3.y;
        point3d4.z = point3d2.z + d3 * vector3d3.z;
        return true;
    }

    boolean edgeIntersectPolygon2D(Vector3d vector3d, Point3d[] point3dArray, Point3d[] point3dArray2) {
        int n;
        Point2d[] point2dArray = new Point2d[point3dArray.length];
        Point2d[] point2dArray2 = new Point2d[2];
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        int n2 = d > d2 ? 0 : 1;
        if (n2 == 0) {
            if (d < d3) {
                n2 = 2;
            }
        } else if (n2 == 1 && d2 < d3) {
            n2 = 2;
        }
        block10: for (n = 0; n < point3dArray.length; ++n) {
            point2dArray[n] = new Point2d();
            switch (n2) {
                case 0: {
                    point2dArray[n].x = point3dArray[n].y;
                    point2dArray[n].y = point3dArray[n].z;
                    continue block10;
                }
                case 1: {
                    point2dArray[n].x = point3dArray[n].x;
                    point2dArray[n].y = point3dArray[n].z;
                    continue block10;
                }
                case 2: {
                    point2dArray[n].x = point3dArray[n].x;
                    point2dArray[n].y = point3dArray[n].y;
                }
            }
        }
        block11: for (n = 0; n < 2; ++n) {
            point2dArray2[n] = new Point2d();
            switch (n2) {
                case 0: {
                    point2dArray2[n].x = point3dArray2[n].y;
                    point2dArray2[n].y = point3dArray2[n].z;
                    continue block11;
                }
                case 1: {
                    point2dArray2[n].x = point3dArray2[n].x;
                    point2dArray2[n].y = point3dArray2[n].z;
                    continue block11;
                }
                case 2: {
                    point2dArray2[n].x = point3dArray2[n].x;
                    point2dArray2[n].y = point3dArray2[n].y;
                }
            }
        }
        boolean[][] blArray = new boolean[2][point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            for (n = 0; n < 2; ++n) {
                blArray[n][i] = i < point3dArray.length - 1 ? this.det2D(point2dArray[i], point2dArray[i + 1], point2dArray2[n]) < 0.0 : this.det2D(point2dArray[i], point2dArray[0], point2dArray2[n]) < 0.0;
            }
            if (blArray[0][i] || blArray[1][i]) continue;
            return false;
        }
        boolean bl = true;
        for (n = 0; n < point3dArray.length; ++n) {
            if (blArray[0][n]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        bl = true;
        for (n = 0; n < point3dArray.length; ++n) {
            if (blArray[1][n]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        int n3 = 0;
        for (n = 0; n < point3dArray.length; ++n) {
            if (!(this.det2D(point2dArray2[0], point2dArray2[1], point2dArray[n]) < 0.0)) continue;
            ++n3;
        }
        return n3 != 0 && n3 != point3dArray.length;
    }

    double getCompValue(Point3d point3d, int n) {
        switch (n) {
            case 0: {
                return point3d.x;
            }
            case 1: {
                return point3d.y;
            }
        }
        return point3d.z;
    }

    double getCompValue(Point3d point3d, Point3d point3d2, int n) {
        switch (n) {
            case 0: {
                return point3d.x - point3d2.x;
            }
            case 1: {
                return point3d.y - point3d2.y;
            }
        }
        return point3d.z - point3d2.z;
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Vector3d vector3d) {
        int n;
        int n2;
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        if (d > d2) {
            if (d > d3) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d3 > d2) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        return this.pointInTri(point3d, point3d2, point3d3, point3d4, n2, n);
    }

    boolean pointInTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, int n, int n2) {
        double d = this.getCompValue(point3d3, point3d2, n2);
        double d2 = -this.getCompValue(point3d3, point3d2, n);
        double d3 = -d * this.getCompValue(point3d2, n) - d2 * this.getCompValue(point3d2, n2);
        double d4 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        d = this.getCompValue(point3d4, point3d3, n2);
        d2 = -this.getCompValue(point3d4, point3d3, n);
        d3 = -d * this.getCompValue(point3d3, n) - d2 * this.getCompValue(point3d3, n2);
        double d5 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        d = this.getCompValue(point3d2, point3d4, n2);
        d2 = -this.getCompValue(point3d2, point3d4, n);
        d3 = -d * this.getCompValue(point3d4, n) - d2 * this.getCompValue(point3d4, n2);
        double d6 = d * this.getCompValue(point3d, n) + d2 * this.getCompValue(point3d, n2) + d3;
        return d4 * d5 > 0.0 && d4 * d6 > 0.0;
    }

    boolean edgeAgainstEdge(Point3d point3d, Point3d point3d2, Point3d point3d3, double d, double d2, int n, int n2) {
        double d3 = this.getCompValue(point3d2, point3d3, n);
        double d4 = this.getCompValue(point3d2, point3d3, n2);
        double d5 = this.getCompValue(point3d, point3d2, n);
        double d6 = this.getCompValue(point3d, point3d2, n2);
        double d7 = d2 * d3 - d * d4;
        double d8 = d4 * d5 - d3 * d6;
        if (d7 > 0.0 && d8 >= 0.0 && d8 <= d7 || d7 < 0.0 && d8 <= 0.0 && d8 >= d7) {
            double d9 = d * d6 - d2 * d5;
            if (d7 > 0.0 ? d9 >= 0.0 && d9 <= d7 : d9 <= 0.0 && d9 >= d7) {
                return true;
            }
        }
        return false;
    }

    boolean edgeAgainstTriEdges(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, int n, int n2) {
        double d;
        double d2 = this.getCompValue(point3d2, point3d, n);
        if (this.edgeAgainstEdge(point3d, point3d3, point3d4, d2, d = this.getCompValue(point3d2, point3d, n2), n, n2)) {
            return true;
        }
        if (this.edgeAgainstEdge(point3d, point3d4, point3d5, d2, d, n, n2)) {
            return true;
        }
        return this.edgeAgainstEdge(point3d, point3d5, point3d3, d2, d, n, n2);
    }

    boolean coplanarTriTri(Vector3d vector3d, Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        int n;
        int n2;
        double d = Math.abs(vector3d.x);
        double d2 = Math.abs(vector3d.y);
        double d3 = Math.abs(vector3d.z);
        if (d > d2) {
            if (d > d3) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d3 > d2) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        if (this.edgeAgainstTriEdges(point3d, point3d2, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d2, point3d3, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.edgeAgainstTriEdges(point3d3, point3d, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        if (this.pointInTri(point3d, point3d4, point3d5, point3d6, n2, n)) {
            return true;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n2, n);
    }

    boolean intersectTriPnt(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        int n;
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3d);
        double d = -vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)point3d4);
        double d2 = vector3d3.dot(vector3d4) + d;
        if (Math.abs(d2) < 1.0E-13) {
            d2 = 0.0;
        }
        if (d2 != 0.0) {
            return false;
        }
        double d3 = Math.abs(vector3d3.x);
        double d4 = Math.abs(vector3d3.y);
        double d5 = Math.abs(vector3d3.z);
        if (d3 > d4) {
            if (d3 > d5) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (d5 > d4) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        return this.pointInTri(point3d4, point3d, point3d2, point3d3, n2, n);
    }

    boolean intersectTriTri(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, Point3d point3d5, Point3d point3d6) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        vector3d2.x = point3d3.x - point3d.x;
        vector3d2.y = point3d3.y - point3d.y;
        vector3d2.z = point3d3.z - point3d.z;
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d5.set((Tuple3d)point3d);
        double d7 = -vector3d3.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d4);
        double d8 = vector3d3.dot(vector3d5) + d7;
        vector3d5.set((Tuple3d)point3d5);
        double d9 = vector3d3.dot(vector3d5) + d7;
        vector3d5.set((Tuple3d)point3d6);
        double d10 = vector3d3.dot(vector3d5) + d7;
        if (Math.abs(d8) < 1.0E-13) {
            d8 = 0.0;
        }
        if (Math.abs(d9) < 1.0E-13) {
            d9 = 0.0;
        }
        if (Math.abs(d10) < 1.0E-13) {
            d10 = 0.0;
        }
        double d11 = d8 * d9;
        double d12 = d8 * d10;
        if (d11 > 0.0 && d12 > 0.0) {
            return false;
        }
        vector3d.x = point3d5.x - point3d4.x;
        vector3d.y = point3d5.y - point3d4.y;
        vector3d.z = point3d5.z - point3d4.z;
        vector3d2.x = point3d6.x - point3d4.x;
        vector3d2.y = point3d6.y - point3d4.y;
        vector3d2.z = point3d6.z - point3d4.z;
        vector3d4.cross(vector3d, vector3d2);
        if (vector3d4.length() == 0.0) {
            return false;
        }
        vector3d5.set((Tuple3d)point3d4);
        double d13 = -vector3d4.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d);
        double d14 = vector3d4.dot(vector3d5) + d13;
        vector3d5.set((Tuple3d)point3d2);
        double d15 = vector3d4.dot(vector3d5) + d13;
        vector3d5.set((Tuple3d)point3d3);
        double d16 = vector3d4.dot(vector3d5) + d13;
        if (Math.abs(d14) < 1.0E-13) {
            d14 = 0.0;
        }
        if (Math.abs(d15) < 1.0E-13) {
            d15 = 0.0;
        }
        if (Math.abs(d16) < 1.0E-13) {
            d16 = 0.0;
        }
        double d17 = d14 * d15;
        double d18 = d14 * d16;
        if (d17 > 0.0 && d18 > 0.0) {
            return false;
        }
        vector3d5.cross(vector3d3, vector3d4);
        double d19 = Math.abs(vector3d5.x);
        int n = 0;
        double d20 = Math.abs(vector3d5.y);
        double d21 = Math.abs(vector3d5.z);
        if (d20 > d19) {
            d19 = d20;
            n = 1;
        }
        if (d21 > d19) {
            d19 = d21;
            n = 2;
        }
        switch (n) {
            case 0: {
                d = point3d.x;
                d2 = point3d2.x;
                d3 = point3d3.x;
                d4 = point3d4.x;
                d5 = point3d5.x;
                d6 = point3d6.x;
                break;
            }
            case 1: {
                d = point3d.y;
                d2 = point3d2.y;
                d3 = point3d3.y;
                d4 = point3d4.y;
                d5 = point3d5.y;
                d6 = point3d6.y;
                break;
            }
            case 2: {
                d = point3d.z;
                d2 = point3d2.z;
                d3 = point3d3.z;
                d4 = point3d4.z;
                d5 = point3d5.z;
                d6 = point3d6.z;
            }
        }
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        double d26 = 0.0;
        if (d17 > 0.0) {
            d22 = d3;
            d23 = (d - d3) * d16;
            d24 = (d2 - d3) * d16;
            d25 = d16 - d14;
            d26 = d16 - d15;
        } else if (d18 > 0.0) {
            d22 = d2;
            d23 = (d - d2) * d15;
            d24 = (d3 - d2) * d15;
            d25 = d15 - d14;
            d26 = d15 - d16;
        } else if (d15 * d16 > 0.0 || d14 != 0.0) {
            d22 = d;
            d23 = (d2 - d) * d14;
            d24 = (d3 - d) * d14;
            d25 = d14 - d15;
            d26 = d14 - d16;
        } else if (d15 != 0.0) {
            d22 = d2;
            d23 = (d - d2) * d15;
            d24 = (d3 - d2) * d15;
            d25 = d15 - d14;
            d26 = d15 - d16;
        } else if (d16 != 0.0) {
            d22 = d3;
            d23 = (d - d3) * d16;
            d24 = (d2 - d3) * d16;
            d25 = d16 - d14;
            d26 = d16 - d15;
        } else {
            boolean bl = this.coplanarTriTri(vector3d3, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
            return bl;
        }
        double d27 = 0.0;
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        double d31 = 0.0;
        if (d11 > 0.0) {
            d27 = d6;
            d28 = (d4 - d6) * d10;
            d29 = (d5 - d6) * d10;
            d30 = d10 - d8;
            d31 = d10 - d9;
        } else if (d12 > 0.0) {
            d27 = d5;
            d28 = (d4 - d5) * d9;
            d29 = (d6 - d5) * d9;
            d30 = d9 - d8;
            d31 = d9 - d10;
        } else if (d9 * d10 > 0.0 || d8 != 0.0) {
            d27 = d4;
            d28 = (d5 - d4) * d8;
            d29 = (d6 - d4) * d8;
            d30 = d8 - d9;
            d31 = d8 - d10;
        } else if (d9 != 0.0) {
            d27 = d5;
            d28 = (d4 - d5) * d9;
            d29 = (d6 - d5) * d9;
            d30 = d9 - d8;
            d31 = d9 - d10;
        } else if (d10 != 0.0) {
            d27 = d6;
            d28 = (d4 - d6) * d10;
            d29 = (d5 - d6) * d10;
            d30 = d10 - d8;
            d31 = d10 - d9;
        } else {
            boolean bl = this.coplanarTriTri(vector3d4, point3d, point3d2, point3d3, point3d4, point3d5, point3d6);
            return bl;
        }
        double d32 = d25 * d26;
        double d33 = d30 * d31;
        double d34 = d32 * d33;
        double d35 = d22 * d34;
        double d36 = d35 + d23 * d26 * d33;
        double d37 = d35 + d24 * d25 * d33;
        d35 = d27 * d34;
        double d38 = d35 + d28 * d31 * d32;
        double d39 = d35 + d29 * d30 * d32;
        if (d36 > d37) {
            d35 = d36;
            d36 = d37;
            d37 = d35;
        }
        if (d38 > d39) {
            d35 = d38;
            d38 = d39;
            d39 = d35;
        }
        return !(d37 < d38) && !(d39 < d36);
    }

    boolean intersectPolygon(Point3d[] point3dArray, Point3d[] point3dArray2) {
        boolean bl;
        int n;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        int n2 = 0;
        while (n2 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n = n2; n < point3dArray.length - 1; ++n) {
            vector3d2.x = point3dArray[n + 1].x - point3dArray[n].x;
            vector3d2.y = point3dArray[n + 1].y - point3dArray[n].y;
            vector3d2.z = point3dArray[n + 1].z - point3dArray[n].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        n = 0;
        Point3d[] point3dArray3 = new Point3d[]{new Point3d(), new Point3d()};
        for (n2 = 0; !(n2 >= point3dArray2.length || (bl = n2 < point3dArray2.length - 1 ? this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n2], point3dArray2[n2 + 1], point3dArray3[n]) : this.edgeIntersectPlane(vector3d3, point3dArray[0], point3dArray2[n2], point3dArray2[0], point3dArray3[n])) && ++n > 1); ++n2) {
        }
        if (n == 0) {
            return false;
        }
        if (point3dArray2.length < 3) {
            boolean bl2 = this.pointIntersectPolygon2D(vector3d3, point3dArray, point3dArray3[0]);
            return bl2;
        }
        boolean bl3 = this.edgeIntersectPolygon2D(vector3d3, point3dArray, point3dArray3);
        return bl3;
    }

    boolean intersectRay(Point3d[] point3dArray, PickRay pickRay, double[] dArray, Point3d point3d) {
        return this.intersectRayOrSegment(point3dArray, pickRay.direction, pickRay.origin, dArray, point3d, false);
    }

    boolean intersectSegment(Point3d[] point3dArray, Point3d point3d, Point3d point3d2, double[] dArray, Point3d point3d3) {
        Vector3d vector3d = new Vector3d();
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        boolean bl = this.intersectRayOrSegment(point3dArray, vector3d, point3d, dArray, point3d3, true);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean intersectRayOrSegment(Point3d[] point3dArray, Vector3d vector3d, Point3d point3d, double[] dArray, Point3d point3d2, boolean bl) {
        int n;
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < point3dArray.length; ++n) {
            n3 = n != point3dArray.length - 1 ? n + 1 : 0;
            vector3d2.x = point3dArray[n3].x - point3dArray[n].x;
            vector3d2.y = point3dArray[n3].y - point3dArray[n].y;
            vector3d2.z = point3dArray[n3].z - point3dArray[n].z;
            if (vector3d2.length() > 0.0) break;
        }
        for (int i = n3; i < point3dArray.length; ++i) {
            n2 = i != point3dArray.length - 1 ? i + 1 : 0;
            vector3d3.x = point3dArray[n2].x - point3dArray[i].x;
            vector3d3.y = point3dArray[n2].y - point3dArray[i].y;
            vector3d3.z = point3dArray[n2].z - point3dArray[i].z;
            if (vector3d3.length() > 0.0) break;
        }
        vector3d4.cross(vector3d2, vector3d3);
        if (vector3d3.length() == 0.0 || vector3d4.length() == 0.0) {
            n2 = n3 == 0 ? point3dArray.length - 1 : n3 - 1;
            return this.intersectLineAndRay(point3dArray[n3], point3dArray[n2], point3d, vector3d, dArray, point3d2);
        }
        d2 = vector3d4.dot(vector3d);
        if (d2 == 0.0) {
            n = 0;
            while (n < point3dArray.length) {
                n2 = n != point3dArray.length - 1 ? n + 1 : 0;
                if (this.intersectLineAndRay(point3dArray[n], point3dArray[n2], point3d, vector3d, dArray, point3d2)) {
                    return true;
                }
                ++n;
            }
            return bl2;
        }
        Vector3d vector3d5 = new Vector3d();
        vector3d5.set((Tuple3d)point3dArray[0]);
        d = vector3d4.dot(vector3d5);
        vector3d5.set((Tuple3d)point3d);
        dArray[0] = (d - vector3d4.dot(vector3d5)) / d2;
        if (dArray[0] < -1.0E-13) return false;
        if (bl && dArray[0] > 1.0000000000001) {
            return false;
        }
        if (point3d2 == null) {
            point3d2 = new Point3d();
        }
        point3d2.x = point3d.x + vector3d.x * dArray[0];
        point3d2.y = point3d.y + vector3d.y * dArray[0];
        point3d2.z = point3d.z + vector3d.z * dArray[0];
        double d3 = Math.abs(vector3d4.x);
        double d4 = Math.abs(vector3d4.y);
        double d5 = Math.abs(vector3d4.z);
        double d6 = 0.0;
        Point3d point3d3 = point3dArray[point3dArray.length - 1];
        Point3d point3d4 = point3dArray[0];
        bl2 = true;
        if (d3 > d4) {
            if (d3 < d5) {
                for (n = 0; n < point3dArray.length; ++n) {
                    point3d3 = point3dArray[n];
                    point3d4 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                    double d7 = (point3d2.y - point3d3.y) * (point3d4.x - point3d3.x) - (point3d2.x - point3d3.x) * (point3d4.y - point3d3.y);
                    if (GeometryArrayRetained.isNonZero(d7)) {
                        if (d7 * d6 < 0.0) {
                            return false;
                        }
                        d6 = d7;
                        continue;
                    }
                    double d8 = point3d4.y - point3d3.y;
                    if (GeometryArrayRetained.isNonZero(d8)) {
                        if (!((d8 = (point3d2.y - point3d3.y) / d8) > -1.0E-13)) return false;
                        if (!(d8 < 1.0000000000001)) return false;
                        boolean bl3 = true;
                        bl2 = bl3;
                    } else {
                        d8 = point3d4.x - point3d3.x;
                        if (!GeometryArrayRetained.isNonZero(d8)) continue;
                        if (!((d8 = (point3d2.x - point3d3.x) / d8) > -1.0E-13)) return false;
                        if (!(d8 < 1.0000000000001)) return false;
                        boolean bl4 = true;
                        bl2 = bl4;
                    }
                    break;
                }
            } else {
                for (n = 0; n < point3dArray.length; ++n) {
                    point3d3 = point3dArray[n];
                    point3d4 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                    double d9 = (point3d2.y - point3d3.y) * (point3d4.z - point3d3.z) - (point3d2.z - point3d3.z) * (point3d4.y - point3d3.y);
                    if (GeometryArrayRetained.isNonZero(d9)) {
                        if (d9 * d6 < 0.0) {
                            return false;
                        }
                        d6 = d9;
                        continue;
                    }
                    double d10 = point3d4.y - point3d3.y;
                    if (GeometryArrayRetained.isNonZero(d10)) {
                        if (!((d10 = (point3d2.y - point3d3.y) / d10) > -1.0E-13)) return false;
                        if (!(d10 < 1.0000000000001)) return false;
                        boolean bl5 = true;
                        bl2 = bl5;
                    } else {
                        d10 = point3d4.z - point3d3.z;
                        if (!GeometryArrayRetained.isNonZero(d10)) continue;
                        if (!((d10 = (point3d2.z - point3d3.z) / d10) > -1.0E-13)) return false;
                        if (!(d10 < 1.0000000000001)) return false;
                        boolean bl6 = true;
                        bl2 = bl6;
                    }
                    break;
                }
            }
        } else if (d4 < d5) {
            for (n = 0; n < point3dArray.length; ++n) {
                point3d3 = point3dArray[n];
                point3d4 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                double d11 = (point3d2.y - point3d3.y) * (point3d4.x - point3d3.x) - (point3d2.x - point3d3.x) * (point3d4.y - point3d3.y);
                if (GeometryArrayRetained.isNonZero(d11)) {
                    if (d11 * d6 < 0.0) {
                        return false;
                    }
                    d6 = d11;
                    continue;
                }
                double d12 = point3d4.y - point3d3.y;
                if (GeometryArrayRetained.isNonZero(d12)) {
                    if (!((d12 = (point3d2.y - point3d3.y) / d12) > -1.0E-13)) return false;
                    if (!(d12 < 1.0000000000001)) return false;
                    boolean bl7 = true;
                    bl2 = bl7;
                } else {
                    d12 = point3d4.x - point3d3.x;
                    if (!GeometryArrayRetained.isNonZero(d12)) continue;
                    if (!((d12 = (point3d2.x - point3d3.x) / d12) > -1.0E-13)) return false;
                    if (!(d12 < 1.0000000000001)) return false;
                    boolean bl8 = true;
                    bl2 = bl8;
                }
                break;
            }
        } else {
            for (n = 0; n < point3dArray.length; ++n) {
                point3d3 = point3dArray[n];
                point3d4 = n != point3dArray.length - 1 ? point3dArray[n + 1] : point3dArray[0];
                double d13 = (point3d2.x - point3d3.x) * (point3d4.z - point3d3.z) - (point3d2.z - point3d3.z) * (point3d4.x - point3d3.x);
                if (GeometryArrayRetained.isNonZero(d13)) {
                    if (d13 * d6 < 0.0) {
                        return false;
                    }
                    d6 = d13;
                    continue;
                }
                double d14 = point3d4.x - point3d3.x;
                if (GeometryArrayRetained.isNonZero(d14)) {
                    if (!((d14 = (point3d2.x - point3d3.x) / d14) > -1.0E-13)) return false;
                    if (!(d14 < 1.0000000000001)) return false;
                    boolean bl9 = true;
                    bl2 = bl9;
                } else {
                    d14 = point3d4.z - point3d3.z;
                    if (!GeometryArrayRetained.isNonZero(d14)) continue;
                    if (!((d14 = (point3d2.z - point3d3.z) / d14) > -1.0E-13)) return false;
                    if (!(d14 < 1.0000000000001)) return false;
                    boolean bl10 = true;
                    bl2 = bl10;
                }
                break;
            }
        }
        if (!bl2) return bl2;
        dArray[0] = dArray[0] * vector3d.length();
        return bl2;
    }

    static final boolean isNonZero(double d) {
        return d > 1.0E-13 || d < -1.0E-13;
    }

    boolean inside(Point3d[] point3dArray, PickPoint pickPoint, int n) {
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        if (n == 1) {
            vector3d3.cross(vector3d, vector3d2);
        } else {
            vector3d3.cross(vector3d2, vector3d);
        }
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set((Tuple3d)point3dArray[0]);
        d = vector3d3.dot(vector3d4);
        vector3d4.set((Tuple3d)pickPoint.location);
        return d - vector3d3.dot(vector3d4) <= 0.0;
    }

    boolean intersectPntAndPnt(Point3d point3d, Point3d point3d2) {
        return point3d.x == point3d2.x && point3d.y == point3d2.y && point3d.z == point3d2.z;
    }

    boolean intersectPntAndRay(Point3d point3d, Point3d point3d2, Vector3d vector3d, double[] dArray) {
        double d;
        int n = 0;
        if (vector3d.x != 0.0) {
            n = 0;
            dArray[0] = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n = 1;
            dArray[0] = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n = 2;
            dArray[0] = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (dArray[0] < 0.0) {
            return false;
        }
        if (n == 0 && (point3d.y < (d = point3d2.y + dArray[0] * vector3d.y) - 1.0E-13 || point3d.y > d + 1.0E-13)) {
            return false;
        }
        return n >= 2 || !(point3d.z < (d = point3d2.z + dArray[0] * vector3d.z) - 1.0E-13) && !(point3d.z > d + 1.0E-13);
    }

    boolean intersectLineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray, Point3d point3d4) {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.x = point3d2.x - point3d.x;
        vector3d2.y = point3d2.y - point3d.y;
        vector3d2.z = point3d2.z - point3d.z;
        double d = vector3d2.x;
        double d2 = -vector3d.y;
        double d3 = vector3d2.y;
        double d4 = -vector3d.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            boolean bl = false;
            if (vector3d2.x == 0.0 && vector3d2.y == 0.0 && vector3d2.z == 0.0 && (bl = this.intersectPntAndRay(point3d, point3d3, vector3d, dArray)) && point3d4 != null) {
                point3d4.set((Tuple3d)point3d);
            }
            return bl;
        }
        double d6 = 1.0 / d5;
        double d7 = d6 * d2;
        double d8 = d6 * -d4;
        double d9 = d6 * -d3;
        double d10 = d6 * d;
        d6 = point3d3.x - point3d.x;
        double d11 = point3d3.y - point3d.y;
        double d12 = d7 * d6 + d8 * d11;
        double d13 = d9 * d6 + d10 * d11;
        if (d13 < 0.0) {
            return false;
        }
        if (d12 < 0.0 || d12 > 1.0) {
            return false;
        }
        d6 = point3d3.z + d13 * vector3d.z;
        d11 = point3d.z + d12 * vector3d2.z;
        if (d6 < d11 - 1.0E-13 || d6 > d11 + 1.0E-13) {
            return false;
        }
        dArray[0] = d13;
        if (point3d4 != null) {
            point3d4.x = point3d3.x + vector3d.x * dArray[0];
            point3d4.y = point3d3.y + vector3d.y * dArray[0];
            point3d4.z = point3d3.z + vector3d.z * dArray[0];
        }
        return true;
    }

    boolean intersectCylinder(Point3d[] point3dArray, PickCylinder pickCylinder, double[] dArray, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        if (point3d == null) {
            point3d = new Point3d();
        }
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
        }
        if (point3dArray.length > 2 && (pickCylinder instanceof PickCylinderRay ? this.intersectRay(point3dArray, new PickRay(point3d2, vector3d), dArray, point3d) : this.intersectSegment(point3dArray, point3d2, point3d3, dArray, point3d))) {
            return true;
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            int n = i < point3dArray.length - 1 ? i + 1 : 0;
            double d2 = pickCylinder instanceof PickCylinderSegment ? Distance.segmentToSegment((Point3d)point3d2, (Point3d)point3d3, (Point3d)point3dArray[i], (Point3d)point3dArray[n], (Point3d)point3d4, (Point3d)point3d, null) : Distance.rayToSegment((Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3dArray[i], (Point3d)point3dArray[n], (Point3d)point3d4, (Point3d)point3d, null);
            if (!(d2 <= d * d)) continue;
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            dArray[0] = vector3d2.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d[] point3dArray, PickCone pickCone, double[] dArray, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d3 = new Vector3d();
        if (point3d == null) {
            point3d = new Point3d();
        }
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
        }
        if (point3dArray.length > 2 && (pickCone instanceof PickConeRay ? this.intersectRay(point3dArray, new PickRay(point3d2, vector3d), dArray, point3d) : this.intersectSegment(point3dArray, point3d2, point3d3, dArray, point3d))) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < point3dArray.length; ++i) {
            n = i < point3dArray.length - 1 ? i + 1 : 0;
            double d = pickCone instanceof PickConeSegment ? Distance.segmentToSegment((Point3d)point3d2, (Point3d)point3d3, (Point3d)point3dArray[i], (Point3d)point3dArray[n], (Point3d)point3d4, (Point3d)point3d, null) : Distance.rayToSegment((Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3dArray[i], (Point3d)point3dArray[n], (Point3d)point3d4, (Point3d)point3d, null);
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            double d2 = vector3d2.length();
            double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
            if (!(d <= d3 * d3)) continue;
            dArray[0] = d2;
            return true;
        }
        return false;
    }

    boolean intersectCylinder(Point3d point3d, PickCylinder pickCylinder, double[] dArray) {
        double d;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCylinder.getOrigin(point3d2);
        pickCylinder.getDirection(vector3d);
        double d2 = pickCylinder.getRadius();
        if (pickCylinder instanceof PickCylinderSegment) {
            ((PickCylinderSegment)pickCylinder).getEnd(point3d3);
            d = Distance.pointToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3d3, (Point3d)point3d4, null);
        } else {
            d = Distance.pointToRay((Point3d)point3d, (Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3d4, null);
        }
        if (d <= d2 * d2) {
            vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
            dArray[0] = vector3d2.length();
            return true;
        }
        return false;
    }

    boolean intersectCone(Point3d point3d, PickCone pickCone, double[] dArray) {
        double d;
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d2 = new Vector3d();
        pickCone.getOrigin(point3d2);
        pickCone.getDirection(vector3d);
        if (point3d4 == null) {
            point3d4 = new Point3d();
        }
        if (pickCone instanceof PickConeSegment) {
            ((PickConeSegment)pickCone).getEnd(point3d3);
            d = Distance.pointToSegment((Point3d)point3d, (Point3d)point3d2, (Point3d)point3d3, (Point3d)point3d4, null);
        } else {
            d = Distance.pointToRay((Point3d)point3d, (Point3d)point3d2, (Vector3d)vector3d, (Point3d)point3d4, null);
        }
        vector3d2.sub((Tuple3d)point3d4, (Tuple3d)point3d2);
        double d2 = vector3d2.length();
        double d3 = Math.tan(pickCone.getSpreadAngle()) * d2;
        if (d <= d3 * d3) {
            dArray[0] = d2;
            return true;
        }
        return false;
    }

    void setCoordRefBuffer(J3DBuffer j3DBuffer) {
        boolean bl;
        if (j3DBuffer != null) {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    assert (((FloatBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 8: {
                    assert (((DoubleBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= j3DBuffer.getBufferImpl().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (j3DBuffer.getBufferImpl().limit() < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.coordRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefCoords = null;
            this.doubleBufferRefCoords = null;
            this.vertexType &= 0xFFFFFFFD;
            this.vertexType &= 0xFFFFFFFE;
        } else {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    this.floatBufferRefCoords = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
                    this.doubleBufferRefCoords = null;
                    this.vertexType |= 1;
                    this.vertexType &= 0xFFFFFFFD;
                    break;
                }
                case 8: {
                    this.floatBufferRefCoords = null;
                    this.doubleBufferRefCoords = (DoubleBufferWrapper)j3DBuffer.getBufferImpl();
                    this.vertexType |= 2;
                    this.vertexType &= 0xFFFFFFFE;
                    break;
                }
            }
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (bl) {
                this.processCoordsChanged(j3DBuffer == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    J3DBuffer getCoordRefBuffer() {
        return this.coordRefBuffer;
    }

    void setCoordRefFloat(float[] fArray) {
        boolean bl;
        if (fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 1) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (fArray.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.floatRefCoords = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFFE) : (this.vertexType |= 1);
        } else {
            this.setupMirrorVertexPointer(1);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (bl) {
                this.processCoordsChanged(fArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    float[] getCoordRefFloat() {
        return this.floatRefCoords;
    }

    void setCoordRefDouble(double[] dArray) {
        boolean bl;
        if (dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 2) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (3 * indexedGeometryArrayRetained.maxCoordIndex >= dArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (dArray.length < 3 * (this.initialCoordIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.doubleRefCoords = dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = dArray == null ? (this.vertexType &= 0xFFFFFFFD) : (this.vertexType |= 2);
        } else {
            this.setupMirrorVertexPointer(2);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (bl) {
                this.processCoordsChanged(dArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    double[] getCoordRefDouble() {
        return this.doubleRefCoords;
    }

    void setCoordRef3f(Point3f[] point3fArray) {
        boolean bl;
        if (point3fArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 4) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxCoordIndex >= point3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (point3fArray.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.p3fRefCoords = point3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = point3fArray == null ? (this.vertexType &= 0xFFFFFFFB) : (this.vertexType |= 4);
        } else {
            this.setupMirrorVertexPointer(4);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (bl) {
                this.processCoordsChanged(point3fArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3f[] getCoordRef3f() {
        return this.p3fRefCoords;
    }

    void setCoordRef3d(Point3d[] point3dArray) {
        boolean bl;
        if (point3dArray != null) {
            if ((this.vertexType & 0xF) != 0 && (this.vertexType & 0xF) != 8) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxCoordIndex >= point3dArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (point3dArray.length < this.initialCoordIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.p3dRefCoords = point3dArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = point3dArray == null ? (this.vertexType &= 0xFFFFFFF7) : (this.vertexType |= 8);
        } else {
            this.setupMirrorVertexPointer(8);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && this.source != null) {
            if (bl) {
                this.processCoordsChanged(point3dArray == null);
                this.sendDataChangedMessage(true);
            } else {
                this.boundsDirty = true;
            }
        }
    }

    Point3d[] getCoordRef3d() {
        return this.p3dRefCoords;
    }

    void setColorRefFloat(float[] fArray) {
        boolean bl;
        if (fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 16) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (fArray.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.floatRefColors = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFFEF) : (this.vertexType |= 0x10);
        } else {
            this.setupMirrorColorPointer(16, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getColorRefFloat() {
        return this.floatRefColors;
    }

    void setColorRefBuffer(J3DBuffer j3DBuffer) {
        boolean bl;
        if (j3DBuffer != null) {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    assert (((FloatBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 2: {
                    assert (((ByteBufferWrapper)j3DBuffer.getBufferImpl()).isDirect());
                    break;
                }
                case 0: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray115"));
                }
                default: {
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
                }
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= j3DBuffer.getBufferImpl().limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (j3DBuffer.getBufferImpl().limit() < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.colorRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefColors = null;
            this.byteBufferRefColors = null;
        } else {
            switch (j3DBuffer.getBufferType()) {
                case 7: {
                    this.floatBufferRefColors = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
                    this.byteBufferRefColors = null;
                    break;
                }
                case 2: {
                    this.byteBufferRefColors = (ByteBufferWrapper)j3DBuffer.getBufferImpl();
                    this.floatBufferRefColors = null;
                    break;
                }
            }
        }
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            if (j3DBuffer == null) {
                this.vertexType &= 0xFFFFFFEF;
                this.vertexType &= 0xFFFFFFDF;
            } else {
                switch (j3DBuffer.getBufferType()) {
                    case 7: {
                        this.vertexType |= 0x10;
                        this.vertexType &= 0xFFFFFFDF;
                        break;
                    }
                    case 2: {
                        this.vertexType |= 0x20;
                        this.vertexType &= 0xFFFFFFEF;
                        break;
                    }
                }
            }
        } else {
            this.setupMirrorColorPointer(48, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getColorRefBuffer() {
        return this.colorRefBuffer;
    }

    void setColorRefByte(byte[] byArray) {
        boolean bl;
        if (byArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 32) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray123"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.getColorStride() * indexedGeometryArrayRetained.maxColorIndex >= byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (byArray.length < this.getColorStride() * (this.initialColorIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.byteRefColors = byArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = byArray == null ? (this.vertexType &= 0xFFFFFFDF) : (this.vertexType |= 0x20);
        } else {
            this.setupMirrorColorPointer(32, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    byte[] getColorRefByte() {
        return this.byteRefColors;
    }

    void setColorRef3f(Color3f[] color3fArray) {
        boolean bl;
        if (color3fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 64) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color3fArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3fRefColors = color3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color3fArray == null ? (this.vertexType &= 0xFFFFFFBF) : (this.vertexType |= 0x40);
        } else {
            this.setupMirrorColorPointer(64, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3f[] getColorRef3f() {
        return this.c3fRefColors;
    }

    void setColorRef4f(Color4f[] color4fArray) {
        boolean bl;
        if (color4fArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 128) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color4fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color4fArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4fRefColors = color4fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color4fArray == null ? (this.vertexType &= 0xFFFFFF7F) : (this.vertexType |= 0x80);
        } else {
            this.setupMirrorColorPointer(128, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4f[] getColorRef4f() {
        return this.c4fRefColors;
    }

    void setColorRef3b(Color3b[] color3bArray) {
        boolean bl;
        if (color3bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 256) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 4) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray92"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color3bArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color3bArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c3bRefColors = color3bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color3bArray == null ? (this.vertexType &= 0xFFFFFEFF) : (this.vertexType |= 0x100);
        } else {
            this.setupMirrorColorPointer(256, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    Color3b[] getColorRef3b() {
        return this.c3bRefColors;
    }

    void setColorRef4b(Color4b[] color4bArray) {
        boolean bl;
        if (color4bArray != null) {
            if ((this.vertexType & 0x3F0) != 0 && (this.vertexType & 0x3F0) != 512) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 0xC) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray93"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxColorIndex >= color4bArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
            } else if (color4bArray.length < this.initialColorIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.c4bRefColors = color4bArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = color4bArray == null ? (this.vertexType &= 0xFFFFFDFF) : (this.vertexType |= 0x200);
        } else {
            this.setupMirrorColorPointer(512, false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    Color4b[] getColorRef4b() {
        return this.c4bRefColors;
    }

    void setNormalRefFloat(float[] fArray) {
        boolean bl;
        if (fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 1024) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex * 3 >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (fArray.length < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.floatRefNormals = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = fArray == null ? (this.vertexType &= 0xFFFFFBFF) : (this.vertexType |= 0x400);
        } else {
            this.setupMirrorNormalPointer(1024);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getNormalRefFloat() {
        return this.floatRefNormals;
    }

    void setNormalRefBuffer(J3DBuffer j3DBuffer) {
        boolean bl;
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            assert (floatBufferWrapper.isDirect());
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex * 3 >= ((FloatBufferWrapper)j3DBuffer.getBufferImpl()).limit()) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (floatBufferWrapper.limit() < 3 * (this.initialNormalIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.normalRefBuffer = j3DBuffer;
        if (j3DBuffer == null) {
            this.vertexType &= 0xFFFFFBFF;
            this.floatBufferRefNormals = null;
        } else {
            this.vertexType |= 0x400;
            this.floatBufferRefNormals = floatBufferWrapper;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getNormalRefBuffer() {
        return this.normalRefBuffer;
    }

    void setNormalRef3f(Vector3f[] vector3fArray) {
        boolean bl;
        if (vector3fArray != null) {
            if ((this.vertexType & 0xC00) != 0 && (this.vertexType & 0xC00) != 2048) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            if ((this.vertexFormat & 2) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray122"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxNormalIndex >= vector3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (vector3fArray.length < this.initialNormalIndex + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.v3fRefNormals = vector3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexType = vector3fArray == null ? (this.vertexType &= 0xFFFFF7FF) : (this.vertexType |= 0x800);
        } else {
            this.setupMirrorNormalPointer(2048);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    Vector3f[] getNormalRef3f() {
        return this.v3fRefNormals;
    }

    final int getColorStride() {
        return (this.vertexFormat & 8) != 0 ? 4 : 3;
    }

    final int getTexStride() {
        if ((this.vertexFormat & 0x20) != 0) {
            return 2;
        }
        if ((this.vertexFormat & 0x40) != 0) {
            return 3;
        }
        if ((this.vertexFormat & 0x400) != 0) {
            return 4;
        }
        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray121"));
    }

    void setTexCoordRefFloat(int n, float[] fArray) {
        int n2;
        if (this.texCoordType != 0 && this.texCoordType != 4096) {
            if (fArray != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (fArray != null) {
            n2 = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] * n2 >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (fArray.length < n2 * (this.initialTexCoordIndex[n] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        int n3 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoords[n] = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 4096;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(n, 4096);
        }
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getTexCoordRefFloat(int n) {
        return (float[])this.refTexCoords[n];
    }

    void setTexCoordRefBuffer(int n, J3DBuffer j3DBuffer) {
        int n2;
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            n2 = floatBufferWrapper.limit();
            assert (floatBufferWrapper.isDirect());
            int n3 = this.getTexStride();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] * n3 >= n2) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (n2 < n3 * (this.initialTexCoordIndex[n] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        int n4 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoordsBuffer[n] = j3DBuffer;
        this.refTexCoords[n] = j3DBuffer == null ? null : floatBufferWrapper.getBufferAsObject();
        this.texCoordType = 4096;
        this.validateTexCoordPointerType();
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getTexCoordRefBuffer(int n) {
        return (J3DBuffer)this.refTexCoordsBuffer[n];
    }

    void setTexCoordRef2f(int n, TexCoord2f[] texCoord2fArray) {
        boolean bl;
        if (this.texCoordType != 0 && this.texCoordType != 8192) {
            if (texCoord2fArray != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoord2fArray != null) {
            if ((this.vertexFormat & 0x20) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray94"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] >= texCoord2fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoord2fArray.length < this.initialTexCoordIndex[n] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoords[n] = texCoord2fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 8192;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(n, 8192);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord2f[] getTexCoordRef2f(int n) {
        if (this.refTexCoords != null && this.refTexCoords[n] != null && this.refTexCoords[n] instanceof TexCoord2f[]) {
            return (TexCoord2f[])this.refTexCoords[n];
        }
        return null;
    }

    void setTexCoordRef3f(int n, TexCoord3f[] texCoord3fArray) {
        boolean bl;
        if (this.texCoordType != 0 && this.texCoordType != 16384) {
            if (texCoord3fArray != null) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray98"));
            }
            return;
        }
        if (texCoord3fArray != null) {
            if ((this.vertexFormat & 0x40) == 0) {
                throw new IllegalStateException(J3dI18N.getString("GeometryArray95"));
            }
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxTexCoordIndices[n] >= texCoord3fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                }
            } else if (texCoord3fArray.length < this.initialTexCoordIndex[n] + this.validVertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.refTexCoords[n] = texCoord3fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.texCoordType = 16384;
            this.validateTexCoordPointerType();
        } else {
            this.setupMirrorTexCoordPointer(n, 16384);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    TexCoord3f[] getTexCoordRef3f(int n) {
        if (this.refTexCoords != null && this.refTexCoords[n] != null && this.refTexCoords[n] instanceof TexCoord3f[]) {
            return (TexCoord3f[])this.refTexCoords[n];
        }
        return null;
    }

    void setVertexAttrRefFloat(int n, float[] fArray) {
        int n2;
        if (fArray != null) {
            n2 = this.vertexAttrSizes[n];
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (n2 * indexedGeometryArrayRetained.maxVertexAttrIndices[n] >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                }
            } else if (fArray.length < n2 * (this.initialVertexAttrIndex[n] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
            }
        }
        int n3 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.floatRefVertexAttrs[n] = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.vertexAttrType = 32768;
            this.validateVertexAttrPointerType();
        } else {
            this.setupMirrorVertexAttrPointer(n, 32768);
        }
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.sendDataChangedMessage(false);
        }
    }

    float[] getVertexAttrRefFloat(int n) {
        return this.floatRefVertexAttrs[n];
    }

    void setVertexAttrRefBuffer(int n, J3DBuffer j3DBuffer) {
        int n2;
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            n2 = floatBufferWrapper.limit();
            assert (floatBufferWrapper.isDirect());
            int n3 = this.vertexAttrSizes[n];
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (indexedGeometryArrayRetained.maxVertexAttrIndices[n] * n3 >= n2) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                }
            } else if (n2 < n3 * (this.initialVertexAttrIndex[n] + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
            }
        }
        int n4 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.vertexAttrsRefBuffer[n] = j3DBuffer;
        if (j3DBuffer == null) {
            this.floatBufferRefVertexAttrs[n] = null;
            this.nioFloatBufferRefVertexAttrs[n] = null;
        } else {
            this.floatBufferRefVertexAttrs[n] = floatBufferWrapper;
            this.nioFloatBufferRefVertexAttrs[n] = floatBufferWrapper.getBufferAsObject();
        }
        this.vertexAttrType = 32768;
        this.validateVertexAttrPointerType();
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.sendDataChangedMessage(false);
        }
    }

    J3DBuffer getVertexAttrRefBuffer(int n) {
        return this.vertexAttrsRefBuffer[n];
    }

    void setInterleavedVertices(float[] fArray) {
        boolean bl;
        if (fArray != null) {
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.stride * indexedGeometryArrayRetained.maxCoordIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    for (int i = 0; i < this.texCoordSetCount; ++i) {
                        if (this.stride * indexedGeometryArrayRetained.maxTexCoordIndices[i] < fArray.length) continue;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * indexedGeometryArrayRetained.maxColorIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * indexedGeometryArrayRetained.maxNormalIndex >= fArray.length) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                }
            } else if (fArray.length < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.interLeavedVertexData = fArray;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.processCoordsChanged(fArray == null);
            this.sendDataChangedMessage(true);
        }
    }

    void setInterleavedVertexBuffer(J3DBuffer j3DBuffer) {
        int n;
        FloatBufferWrapper floatBufferWrapper = null;
        if (j3DBuffer != null) {
            if (j3DBuffer.getBufferType() != 7) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray116"));
            }
            floatBufferWrapper = (FloatBufferWrapper)j3DBuffer.getBufferImpl();
            assert (floatBufferWrapper.isDirect());
            n = floatBufferWrapper.limit();
            if (this instanceof IndexedGeometryArrayRetained) {
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)this;
                if (this.stride * indexedGeometryArrayRetained.maxCoordIndex >= n) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
                if ((this.vertexFormat & 0x460) != 0) {
                    for (int i = 0; i < this.texCoordSetCount; ++i) {
                        if (this.stride * indexedGeometryArrayRetained.maxTexCoordIndices[i] < n) continue;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                }
                if ((this.vertexFormat & 4) != 0 && this.stride * indexedGeometryArrayRetained.maxColorIndex >= n) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                }
                if ((this.vertexFormat & 2) != 0 && this.stride * indexedGeometryArrayRetained.maxNormalIndex >= n) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                }
            } else if (n < this.stride * (this.initialVertexIndex + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        }
        int n2 = n = this.source != null && this.source.isLive() ? 1 : 0;
        if (n != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.colorChanged = 65535;
        this.interleavedVertexBuffer = j3DBuffer;
        this.interleavedFloatBufferImpl = j3DBuffer == null ? null : floatBufferWrapper;
        if (this.inUpdater || this instanceof IndexedGeometryArrayRetained && (this.vertexFormat & 0x200) == 0) {
            this.setupMirrorInterleavedColorPointer(false);
        }
        if (n != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n != 0) {
            this.processCoordsChanged(j3DBuffer == null);
            this.sendDataChangedMessage(true);
        }
    }

    float[] getInterleavedVertices() {
        return this.interLeavedVertexData;
    }

    J3DBuffer getInterleavedVertexBuffer() {
        return this.interleavedVertexBuffer;
    }

    void setValidVertexCount(int n) {
        int n2;
        boolean bl = false;
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray110"));
        }
        if (this.initialVertexIndex + n > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x100) != 0) {
            if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
                if (this.interleavedFloatBufferImpl.limit() < this.stride * (this.initialVertexIndex + n)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else if (this.interLeavedVertexData != null) {
                if (this.interLeavedVertexData.length < this.stride * (this.initialVertexIndex + n)) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
                }
            } else {
                bl = true;
            }
        } else if ((this.vertexFormat & 0x80) != 0) {
            if (this.initialCoordIndex + n > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
            }
            if (this.initialColorIndex + n > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
            }
            if (this.initialNormalIndex + n > this.vertexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    if (this.initialTexCoordIndex[n2] + n <= this.vertexCount) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    if (this.initialVertexAttrIndex[n2] + n <= this.vertexCount) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("GeometryArray130"));
                }
            }
            if ((this.vertexType & 0xF) == 0) {
                bl = true;
            }
            if ((this.vertexFormat & 0x800) != 0) {
                int n3;
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleBufferRefCoords.limit() >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                            FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n3]).getBufferImpl();
                            if (!((this.vertexFormat & 0x20) != 0 ? floatBufferWrapper.limit() < 2 * (this.initialTexCoordIndex[n3] + n) : ((this.vertexFormat & 0x40) != 0 ? floatBufferWrapper.limit() < 3 * (this.initialTexCoordIndex[n3] + n) : (this.vertexFormat & 0x400) != 0 && floatBufferWrapper.limit() < 4 * (this.initialTexCoordIndex[n3] + n)))) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatBufferRefNormals.limit() >= 3 * (this.initialNormalIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                            n3 = this.vertexAttrSizes[n2];
                            if (this.floatBufferRefVertexAttrs[n2].limit() >= n3 * (this.initialVertexAttrIndex[n2] + n)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
                        }
                        break;
                    }
                }
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords.length >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 2: {
                        if (this.doubleRefCoords.length >= 3 * (this.initialCoordIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 4: {
                        if (this.p3fRefCoords.length >= this.initialCoordIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                    case 8: {
                        if (this.p3dRefCoords.length >= this.initialCoordIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                    }
                }
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 32: {
                        if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (this.initialColorIndex + n) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (this.initialColorIndex + n))) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 64: {
                        if (this.c3fRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 128: {
                        if (this.c4fRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 256: {
                        if (this.c3bRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                    case 512: {
                        if (this.c4bRefColors.length >= this.initialColorIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                    }
                }
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                            if ((this.vertexFormat & 0x20) != 0) {
                                if (((float[])this.refTexCoords[n2]).length >= 2 * (this.initialTexCoordIndex[n2] + n)) continue;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            if ((this.vertexFormat & 0x40) == 0) continue;
                            if (((float[])this.refTexCoords[n2]).length < 3 * (this.initialTexCoordIndex[n2] + n)) {
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                            }
                            if ((this.vertexFormat & 0x400) == 0 || ((float[])this.refTexCoords[n2]).length >= 4 * (this.initialTexCoordIndex[n2] + n)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                    case 8192: {
                        for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                            if (((TexCoord2f[])this.refTexCoords[n2]).length >= this.initialTexCoordIndex[n2] + n) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                    case 16384: {
                        for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                            if (((TexCoord3f[])this.refTexCoords[n2]).length >= this.initialTexCoordIndex[n2] + n) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                        }
                        break;
                    }
                }
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals.length >= 3 * (this.initialNormalIndex + n)) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                    case 2048: {
                        if (this.v3fRefNormals.length >= this.initialNormalIndex + n) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                    }
                }
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                            int n4 = this.vertexAttrSizes[n2];
                            if (this.floatRefVertexAttrs[n2].length >= n4 * (this.initialVertexAttrIndex[n2] + n)) continue;
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
                        }
                        break;
                    }
                }
            }
        }
        int n5 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.validVertexCount = n;
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.processCoordsChanged(bl);
            this.sendDataChangedMessage(true);
        }
    }

    int getValidVertexCount() {
        return this.validVertexCount;
    }

    void setInitialVertexIndex(int n) {
        boolean bl;
        boolean bl2 = false;
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray100"));
        }
        if ((this.vertexFormat & 0x800) != 0 && this.interleavedFloatBufferImpl != null) {
            if (this.interleavedFloatBufferImpl.limit() < this.stride * (n + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else if (this.interLeavedVertexData != null) {
            if (this.interLeavedVertexData.length < this.stride * (n + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray114"));
            }
        } else {
            bl2 = (this.vertexFormat & 0x100) != 0;
        }
        boolean bl3 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x8F;
        this.initialVertexIndex = n;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.processCoordsChanged(bl2);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialVertexIndex() {
        return this.initialVertexIndex;
    }

    void setInitialCoordIndex(int n) {
        boolean bl;
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray104"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatBufferRefCoords.limit() >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleBufferRefCoords.limit() >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    if (this.floatRefCoords.length >= 3 * (n + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 2: {
                    if (this.doubleRefCoords.length >= 3 * (n + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 4: {
                    if (this.p3fRefCoords.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
                case 8: {
                    if (this.p3dRefCoords.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray99"));
                }
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 1;
        this.initialCoordIndex = n;
        this.dirtyFlag |= 1;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.processCoordsChanged((this.vertexType & 0xF) == 0);
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialCoordIndex() {
        return this.initialCoordIndex;
    }

    void setInitialColorIndex(int n) {
        boolean bl;
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray101"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatBufferRefColors.limit() < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatBufferRefColors.limit() < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteBufferRefColors.limit() < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteBufferRefColors.limit() < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        } else {
            switch (this.vertexType & 0x3F0) {
                case 16: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.floatRefColors.length < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.floatRefColors.length < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 32: {
                    if (!((this.vertexFormat & 0xC) == 4 ? this.byteRefColors.length < 3 * (n + this.validVertexCount) : (this.vertexFormat & 0xC) == 12 && this.byteRefColors.length < 4 * (n + this.validVertexCount))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 64: {
                    if (this.c3fRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 128: {
                    if (this.c4fRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 256: {
                    if (this.c3bRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
                case 512: {
                    if (this.c4bRefColors.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray112"));
                }
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 4;
        this.colorChanged = 65535;
        this.initialColorIndex = n;
        if (bl) {
            this.geomLock.unLock();
        }
    }

    int getInitialColorIndex() {
        return this.initialColorIndex;
    }

    void setInitialNormalIndex(int n) {
        boolean bl;
        if (n + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray102"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0xC00) == 1024 && this.floatBufferRefNormals.limit() < 3 * (n + this.validVertexCount)) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
            }
        } else {
            switch (this.vertexType & 0xC00) {
                case 1024: {
                    if (this.floatRefNormals.length >= 3 * (n + this.validVertexCount)) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
                case 2048: {
                    if (this.v3fRefNormals.length >= n + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray111"));
                }
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 2;
        this.initialNormalIndex = n;
        if (bl) {
            this.geomLock.unLock();
        }
    }

    int getInitialNormalIndex() {
        return this.initialNormalIndex;
    }

    void setInitialVertexAttrIndex(int n, int n2) {
        boolean bl;
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray130"));
        }
        int n3 = this.vertexAttrSizes[n];
        int n4 = n3 * (n2 + this.validVertexCount);
        if ((this.vertexType & 0x8000) == 32768 && ((this.vertexFormat & 0x800) != 0 ? this.floatBufferRefVertexAttrs[n].limit() < n4 : this.floatRefVertexAttrs[n].length < n4)) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray129"));
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x80;
        this.initialVertexAttrIndex[n] = n2;
        if (bl) {
            this.geomLock.unLock();
        }
    }

    int getInitialVertexAttrIndex(int n) {
        return this.initialVertexAttrIndex[n];
    }

    void setInitialTexCoordIndex(int n, int n2) {
        boolean bl;
        if (n2 + this.validVertexCount > this.vertexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("GeometryArray103"));
        }
        if ((this.vertexFormat & 0x800) != 0) {
            if ((this.vertexType & 0x7000) == 4096) {
                FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n]).getBufferImpl();
                if ((this.vertexFormat & 0x20) != 0 ? floatBufferWrapper.limit() < 2 * (n2 + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? floatBufferWrapper.limit() < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && floatBufferWrapper.limit() < 4 * (n2 + this.validVertexCount))) {
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        } else {
            switch (this.vertexType & 0x7000) {
                case 4096: {
                    if (!((this.vertexFormat & 0x20) != 0 ? ((float[])this.refTexCoords[n]).length < 2 * (n2 + this.validVertexCount) : ((this.vertexFormat & 0x40) != 0 ? ((float[])this.refTexCoords[n]).length < 3 * (n2 + this.validVertexCount) : (this.vertexFormat & 0x400) != 0 && ((float[])this.refTexCoords[n]).length < 4 * (n2 + this.validVertexCount)))) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 8192: {
                    if (((TexCoord2f[])this.refTexCoords[n]).length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
                case 16384: {
                    if (((TexCoord3f[])this.refTexCoords[n]).length >= n2 + this.validVertexCount) break;
                    throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("GeometryArray113"));
                }
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 8;
        this.initialTexCoordIndex[n] = n2;
        if (bl) {
            this.geomLock.unLock();
        }
    }

    int getInitialTexCoordIndex(int n) {
        return this.initialTexCoordIndex[n];
    }

    int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    int getTexCoordSetMapLength() {
        if (this.texCoordSetMap != null) {
            return this.texCoordSetMap.length;
        }
        return 0;
    }

    void getTexCoordSetMap(int[] nArray) {
        if (this.texCoordSetMap != null) {
            for (int i = 0; i < this.texCoordSetMap.length; ++i) {
                nArray[i] = this.texCoordSetMap[i];
            }
        }
    }

    void freeDlistId() {
        if (this.dlistId != -1) {
            VirtualUniverse.mc.freeDisplayListId(this.dlistObj);
            this.dlistId = -1;
        }
    }

    void assignDlistId() {
        if (this.dlistId == -1) {
            this.dlistObj = VirtualUniverse.mc.getDisplayListId();
            this.dlistId = this.dlistObj;
        }
    }

    void addDlistUser(RenderBin renderBin, RenderAtomListInfo renderAtomListInfo) {
        HashSet<RenderAtomListInfo> hashSet;
        if (this.dlistUsers == null) {
            this.dlistUsers = new HashMap(2, 1.0f);
        }
        if ((hashSet = (HashSet<RenderAtomListInfo>)this.dlistUsers.get(renderBin)) == null) {
            hashSet = new HashSet<RenderAtomListInfo>();
            this.dlistUsers.put(renderBin, hashSet);
        }
        hashSet.add(renderAtomListInfo);
    }

    void removeDlistUser(RenderBin renderBin, RenderAtomListInfo renderAtomListInfo) {
        if (this.dlistUsers == null) {
            return;
        }
        Set set = (Set)this.dlistUsers.get(renderBin);
        if (set == null) {
            return;
        }
        set.remove(renderAtomListInfo);
    }

    boolean isDlistUserSetEmpty(RenderBin renderBin) {
        if (this.dlistUsers == null) {
            return true;
        }
        Set set = (Set)this.dlistUsers.get(renderBin);
        if (set == null) {
            return true;
        }
        return set.isEmpty();
    }

    int numDlistUsers(RenderBin renderBin) {
        if (this.isDlistUserSetEmpty(renderBin)) {
            return 0;
        }
        Set set = (Set)this.dlistUsers.get(renderBin);
        return set.size();
    }

    void setDlistTimeStamp(int n, long l) {
        int n2 = this.getIndex(n);
        if (n2 >= this.timeStampPerDlist.length) {
            long[] lArray = new long[n2 * 2];
            for (int i = 0; i < this.timeStampPerDlist.length; ++i) {
                lArray[i] = this.timeStampPerDlist[i];
            }
            this.timeStampPerDlist = lArray;
        }
        this.timeStampPerDlist[n2] = l;
    }

    long getDlistTimeStamp(int n) {
        int n2 = this.getIndex(n);
        if (n2 >= this.timeStampPerDlist.length) {
            this.setDlistTimeStamp(n, 0L);
        }
        return this.timeStampPerDlist[n2];
    }

    int getIndex(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    boolean isWriteStatic() {
        return !this.source.getCapability(1) && !this.source.getCapability(3) && !this.source.getCapability(5) && !this.source.getCapability(7) && !this.source.getCapability(23) && !this.source.getCapability(20) && !this.source.getCapability(19);
    }

    void setCompiled(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        this.geoOffset = new int[n];
        this.compileVcount = new int[n];
        int n3 = 0;
        int n4 = 0;
        n3 = 0;
        this.isCompiled = true;
        if (n > 0) {
            this.source = ((SceneGraphObjectRetained)arrayList.get((int)0)).source;
        }
        for (int i = 0; i < n; ++i) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(i);
            ((GeometryArray)geometryArrayRetained.source).retained = this;
            this.compileVcount[i] = geometryArrayRetained.getValidVertexCount();
            n3 += geometryArrayRetained.getValidVertexCount();
            this.geoOffset[i] = n2;
            n2 += geometryArrayRetained.stride() * this.compileVcount[i];
            n4 = geometryArrayRetained.getVertexFormat();
        }
        this.createGeometryArrayData(n3, n4);
        this.validVertexCount = n3;
        this.initialVertexIndex = 0;
        this.mergeGeometryArrays(arrayList);
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 1;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)arrayList.get(i);
            float[] fArray = geometryArrayRetained.vertexData;
            int n2 = geometryArrayRetained.validVertexCount * this.stride;
            int n3 = geometryArrayRetained.initialVertexIndex * this.stride;
            System.arraycopy(fArray, n3, this.vertexData, n, n2);
            n += n2;
            this.geoBounds.combine(geometryArrayRetained.geoBounds);
        }
        this.centroid.set((Tuple3d)this.geoBounds.getCenter());
    }

    boolean isMergeable() {
        if ((this.vertexFormat & 0x80) != 0) {
            return false;
        }
        if (!this.isStatic()) {
            return false;
        }
        if ((this.vertexFormat & 0x460) != 0 && (this.texCoordSetCount > 1 || this.texCoordSetMap != null && this.texCoordSetMap.length > 1)) {
            return false;
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            return false;
        }
        return !this.source.getCapability(18);
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        if ((this.vertexFormat & 2) != 0) {
            compileState.needNormalsTransform = true;
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        if (this.geoBounds != null) {
            this.geoBounds.transform(transformGroupRetained.transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMorphUser(MorphRetained morphRetained) {
        if (this.morphUniverseList == null) {
            this.morphUniverseList = new ArrayList(1);
            this.morphUserLists = new ArrayList(1);
        }
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            if (this.morphUniverseList.contains(morphRetained.universe)) {
                int n = this.morphUniverseList.indexOf(morphRetained.universe);
                ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n);
                arrayList2.add(morphRetained);
            } else {
                this.morphUniverseList.add(morphRetained.universe);
                ArrayList<MorphRetained> arrayList3 = new ArrayList<MorphRetained>(5);
                arrayList3.add(morphRetained);
                this.morphUserLists.add(arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMorphUser(MorphRetained morphRetained) {
        if (this.morphUniverseList == null) {
            return;
        }
        ArrayList arrayList = this.morphUniverseList;
        synchronized (arrayList) {
            int n = this.morphUniverseList.indexOf(morphRetained.universe);
            ArrayList arrayList2 = (ArrayList)this.morphUserLists.get(n);
            arrayList2.remove(arrayList2.indexOf(morphRetained));
            if (arrayList2.size() == 0) {
                this.morphUserLists.remove(n);
                this.morphUniverseList.remove(n);
            }
        }
    }

    void initMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained) {
            this.mirrorGeometry = (this.vertexFormat & 0x200) == 0 ? ((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry() : null;
        }
        this.geomLock.unLock();
    }

    void updateMirrorGeometry() {
        this.geomLock.getLock();
        if (this instanceof IndexedGeometryArrayRetained && this.mirrorGeometry != null) {
            this.mirrorGeometry = ((IndexedGeometryArrayRetained)this).cloneNonIndexedGeometry();
        }
        this.geomLock.unLock();
    }

    void getVertexData(int n, Point3d point3d) {
        if ((this.vertexFormat & 0x80) == 0) {
            int n2 = this.stride * n + this.coordinateOffset;
            point3d.x = this.vertexData[n2];
            point3d.y = this.vertexData[n2 + 1];
            point3d.z = this.vertexData[n2 + 2];
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x100) != 0) {
                int n3 = this.stride * n + this.coordinateOffset;
                point3d.x = this.interLeavedVertexData[n3];
                point3d.y = this.interLeavedVertexData[n3 + 1];
                point3d.z = this.interLeavedVertexData[n3 + 2];
            } else {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        int n4 = n * 3;
                        point3d.x = this.floatRefCoords[n4];
                        point3d.y = this.floatRefCoords[n4 + 1];
                        point3d.z = this.floatRefCoords[n4 + 2];
                        break;
                    }
                    case 2: {
                        int n5 = n * 3;
                        point3d.x = this.doubleRefCoords[n5];
                        point3d.y = this.doubleRefCoords[n5 + 1];
                        point3d.z = this.doubleRefCoords[n5 + 2];
                        break;
                    }
                    case 4: {
                        point3d.x = this.p3fRefCoords[n].x;
                        point3d.y = this.p3fRefCoords[n].y;
                        point3d.z = this.p3fRefCoords[n].z;
                        break;
                    }
                    case 8: {
                        point3d.x = this.p3dRefCoords[n].x;
                        point3d.y = this.p3dRefCoords[n].y;
                        point3d.z = this.p3dRefCoords[n].z;
                    }
                }
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n6 = this.stride * n + this.coordinateOffset;
            point3d.x = this.interleavedFloatBufferImpl.get(n6);
            point3d.y = this.interleavedFloatBufferImpl.get(n6 + 1);
            point3d.z = this.interleavedFloatBufferImpl.get(n6 + 2);
        } else {
            switch (this.vertexType & 0xF) {
                case 1: {
                    int n7 = n * 3;
                    point3d.x = this.floatBufferRefCoords.get(n7);
                    point3d.y = this.floatBufferRefCoords.get(n7 + 1);
                    point3d.z = this.floatBufferRefCoords.get(n7 + 2);
                    break;
                }
                case 2: {
                    int n8 = n * 3;
                    point3d.x = this.doubleBufferRefCoords.get(n8);
                    point3d.y = this.doubleBufferRefCoords.get(n8 + 1);
                    point3d.z = this.doubleBufferRefCoords.get(n8 + 2);
                }
            }
        }
    }

    void getCrossValue(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        vector3d.x += point3d.y * point3d2.z - point3d.z * point3d2.y;
        vector3d.y += point3d2.x * point3d.z - point3d2.z * point3d.x;
        vector3d.z += point3d.x * point3d2.y - point3d.y * point3d2.x;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Transform3D transform3D3 = new Transform3D();
        boolean bl = false;
        if (geometryRetained instanceof GeometryArrayRetained) {
            GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)geometryRetained;
            if (geometryArrayRetained.validVertexCount >= this.validVertexCount) {
                transform3D3.invert(transform3D2);
                transform3D3.mul(transform3D);
                bl = this.intersect(transform3D3, geometryRetained);
            } else {
                transform3D3.invert(transform3D);
                transform3D3.mul(transform3D2);
                bl = geometryArrayRetained.intersect(transform3D3, this);
            }
        } else {
            transform3D3.invert(transform3D);
            transform3D3.mul(transform3D2);
            bl = geometryRetained.intersect(transform3D3, this);
        }
        return bl;
    }

    int getNumCoordCount() {
        int n = 0;
        if ((this.vertexFormat & 1) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n = this.vertexCount;
                return n;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xF) {
                        case 1: {
                            n = this.floatRefCoords.length / 3;
                            break;
                        }
                        case 2: {
                            n = this.doubleRefCoords.length / 3;
                            break;
                        }
                        case 4: {
                            n = this.p3fRefCoords.length;
                            break;
                        }
                        case 8: {
                            n = this.p3dRefCoords.length;
                        }
                    }
                } else {
                    n = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0xF) {
                    case 1: {
                        n = this.floatBufferRefCoords.limit() / 3;
                        break;
                    }
                    case 2: {
                        n = this.doubleBufferRefCoords.limit() / 3;
                    }
                }
            } else {
                n = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n;
    }

    int getNumColorCount() {
        int n = 0;
        if ((this.vertexFormat & 4) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n = this.vertexCount;
                return n;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x3F0) {
                        case 16: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                n = this.floatRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            n = this.floatRefColors.length / 4;
                            break;
                        }
                        case 32: {
                            if ((this.vertexFormat & 0xC) == 4) {
                                n = this.byteRefColors.length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0xC) != 12) break;
                            n = this.byteRefColors.length / 4;
                            break;
                        }
                        case 64: {
                            n = this.c3fRefColors.length;
                            break;
                        }
                        case 128: {
                            n = this.c4fRefColors.length;
                            break;
                        }
                        case 256: {
                            n = this.c3bRefColors.length;
                            break;
                        }
                        case 512: {
                            n = this.c4bRefColors.length;
                        }
                    }
                } else {
                    n = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            n = this.floatBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        n = this.floatBufferRefColors.limit() / 4;
                        break;
                    }
                    case 32: {
                        if ((this.vertexFormat & 0xC) == 4) {
                            n = this.byteBufferRefColors.limit() / 3;
                            break;
                        }
                        if ((this.vertexFormat & 0xC) != 12) break;
                        n = this.byteBufferRefColors.limit() / 4;
                    }
                }
            } else {
                n = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n;
    }

    int getNumNormalCount() {
        int n = 0;
        if ((this.vertexFormat & 2) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n = this.vertexCount;
                return n;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0xC00) {
                        case 1024: {
                            n = this.floatRefNormals.length / 3;
                            break;
                        }
                        case 2048: {
                            n = this.v3fRefNormals.length;
                        }
                    }
                } else {
                    n = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0xC00) == 1024) {
                    n = this.floatBufferRefNormals.limit() / 3;
                }
            } else {
                n = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n;
    }

    int getNumTexCoordCount(int n) {
        int n2 = 0;
        if ((this.vertexFormat & 0x460) != 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                n2 = this.vertexCount;
                return n2;
            }
            if ((this.vertexFormat & 0x800) == 0) {
                if ((this.vertexFormat & 0x100) == 0) {
                    switch (this.vertexType & 0x7000) {
                        case 4096: {
                            if ((this.vertexFormat & 0x20) != 0) {
                                n2 = ((float[])this.refTexCoords[n]).length / 2;
                                break;
                            }
                            if ((this.vertexFormat & 0x40) != 0) {
                                n2 = ((float[])this.refTexCoords[n]).length / 3;
                                break;
                            }
                            if ((this.vertexFormat & 0x400) == 0) break;
                            n2 = ((float[])this.refTexCoords[n]).length / 4;
                            break;
                        }
                        case 8192: {
                            n2 = ((TexCoord2f[])this.refTexCoords[n]).length;
                            break;
                        }
                        case 16384: {
                            n2 = ((TexCoord3f[])this.refTexCoords[n]).length;
                        }
                    }
                } else {
                    n2 = this.interLeavedVertexData.length / this.stride;
                }
            } else if ((this.vertexFormat & 0x100) == 0) {
                if ((this.vertexType & 0x7000) == 4096) {
                    FloatBufferWrapper floatBufferWrapper = (FloatBufferWrapper)((J3DBuffer)this.refTexCoordsBuffer[n]).getBufferImpl();
                    if ((this.vertexFormat & 0x20) != 0) {
                        n2 = floatBufferWrapper.limit() / 2;
                    } else if ((this.vertexFormat & 0x40) != 0) {
                        n2 = floatBufferWrapper.limit() / 3;
                    } else if ((this.vertexFormat & 0x400) != 0) {
                        n2 = floatBufferWrapper.limit() / 4;
                    }
                }
            } else {
                n2 = this.interleavedFloatBufferImpl.limit() / this.stride;
            }
        }
        return n2;
    }

    void computeMinDistance(Point3d[] point3dArray, Point3d point3d, Vector3d vector3d, double[] dArray, Point3d point3d2) {
        if (point3dArray.length == 1) {
            point3d2.x = point3dArray[0].x;
            point3d2.y = point3dArray[0].y;
            point3d2.z = point3dArray[0].z;
            double d = point3d2.x - point3d.x;
            double d2 = point3d2.y - point3d.y;
            double d3 = point3d2.z - point3d.z;
            dArray[0] = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            return;
        }
        if (point3dArray.length == 2) {
            dArray[0] = Math.sqrt(Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[0], (Point3d)point3dArray[1], (Point3d)point3d2, null));
            return;
        }
        double d = 0.0;
        if (vector3d == null) {
            int n;
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            vector3d = new Vector3d();
            int n2 = 0;
            while (n2 < point3dArray.length - 1) {
                vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
                vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
                vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2++].z;
                if (!(vector3d2.length() > 0.0)) continue;
            }
            for (n = n2; n < point3dArray.length - 1; ++n) {
                vector3d3.x = point3dArray[n + 1].x - point3dArray[n].x;
                vector3d3.y = point3dArray[n + 1].y - point3dArray[n].y;
                vector3d3.z = point3dArray[n + 1].z - point3dArray[n].z;
                if (vector3d3.length() > 0.0) break;
            }
            if (n == point3dArray.length - 1) {
                vector3d = null;
            } else {
                vector3d.cross(vector3d2, vector3d3);
            }
        }
        if (vector3d != null && (d = vector3d.length()) == 0.0) {
            vector3d = null;
        }
        if (point3dArray.length == 3) {
            if (vector3d != null) {
                double d4 = -(vector3d.x * point3dArray[0].x + vector3d.y * point3dArray[0].y + vector3d.z * point3dArray[0].z);
                dArray[0] = (vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d4) / d;
                point3d2.x = point3d.x - dArray[0] * vector3d.x / d;
                point3d2.y = point3d.y - dArray[0] * vector3d.y / d;
                point3d2.z = point3d.z - dArray[0] * vector3d.z / d;
                if (this.pointInTri(point3d2, point3dArray[0], point3dArray[1], point3dArray[2], vector3d)) {
                    return;
                }
            }
            Point3d point3d3 = new Point3d();
            dArray[0] = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[0], (Point3d)point3dArray[1], (Point3d)point3d2, null);
            double d5 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[1], (Point3d)point3dArray[2], (Point3d)point3d3, null);
            if (d5 < dArray[0]) {
                dArray[0] = d5;
                point3d2.x = point3d3.x;
                point3d2.y = point3d3.y;
                point3d2.z = point3d3.z;
            }
            if ((d5 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[2], (Point3d)point3dArray[0], (Point3d)point3d3, null)) < dArray[0]) {
                dArray[0] = d5;
                point3d2.x = point3d3.x;
                point3d2.y = point3d3.y;
                point3d2.z = point3d3.z;
            }
            dArray[0] = Math.sqrt(dArray[0]);
            return;
        }
        if (vector3d != null) {
            double d6 = -(vector3d.x * point3dArray[0].x + vector3d.y * point3dArray[0].y + vector3d.z * point3dArray[0].z);
            dArray[0] = (vector3d.x * point3d.x + vector3d.y * point3d.y + vector3d.z * point3d.z + d6) / d;
            point3d2.x = point3d.x - dArray[0] * vector3d.x / d;
            point3d2.y = point3d.y - dArray[0] * vector3d.y / d;
            point3d2.z = point3d.z - dArray[0] * vector3d.z / d;
            if (this.pointInTri(point3d2, point3dArray[0], point3dArray[1], point3dArray[2], vector3d) || this.pointInTri(point3d2, point3dArray[1], point3dArray[2], point3dArray[3], vector3d)) {
                return;
            }
        }
        Point3d point3d4 = new Point3d();
        dArray[0] = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[0], (Point3d)point3dArray[1], (Point3d)point3d2, null);
        double d7 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[1], (Point3d)point3dArray[2], (Point3d)point3d4, null);
        if (d7 < dArray[0]) {
            dArray[0] = d7;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        if ((d7 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[2], (Point3d)point3dArray[3], (Point3d)point3d4, null)) < dArray[0]) {
            dArray[0] = d7;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        if ((d7 = Distance.pointToSegment((Point3d)point3d, (Point3d)point3dArray[3], (Point3d)point3dArray[0], (Point3d)point3d4, null)) < dArray[0]) {
            dArray[0] = d7;
            point3d2.x = point3d4.x;
            point3d2.y = point3d4.y;
            point3d2.z = point3d4.z;
        }
        dArray[0] = Math.sqrt(dArray[0]);
    }

    void handleFrequencyChange(int n) {
        int n2 = 0;
        if ((this.vertexFormat & 0x80) == 0) {
            if (n == 1 || (this.vertexFormat & 4) != 0 && n == 3 || (this.vertexFormat & 2) != 0 && n == 5 || (this.vertexFormat & 0x460) != 0 && n == 7 || (this.vertexFormat & 0x1000) != 0 && n == 23 || n == 20) {
                n2 = 1;
            }
        } else if (n == 19) {
            n2 = 1;
        }
        if (n2 != 0) {
            this.setFrequencyChangeMask(n, n2);
        }
    }

    int getTexCoordType() {
        return this.texCoordType;
    }

    int getVertexAttrType() {
        return this.vertexAttrType;
    }
}

