# frozen_string_literal: true

# Released under the MIT License.
# Copyright, 2016-2024, by Samuel Williams.

module XRB
	# We only support a small subset of markup entities.
	module Entities
		HTML5 = {
			"Aacute" => "\u00C1", # "Á"
			"aacute" => "\u00E1", # "á"
			"Abreve" => "\u0102", # "Ă"
			"abreve" => "\u0103", # "ă"
			"ac" => "\u223E", # "∾"
			"acd" => "\u223F", # "∿"
			"acE" => "\u223E\u0333", # "∾̳"
			"Acirc" => "\u00C2", # "Â"
			"acirc" => "\u00E2", # "â"
			"acute" => "\u00B4", # "´"
			"Acy" => "\u0410", # "А"
			"acy" => "\u0430", # "а"
			"AElig" => "\u00C6", # "Æ"
			"aelig" => "\u00E6", # "æ"
			"af" => "\u2061", # "⁡"
			"Afr" => "\u{1D504}", # "𝔄"
			"afr" => "\u{1D51E}", # "𝔞"
			"Agrave" => "\u00C0", # "À"
			"agrave" => "\u00E0", # "à"
			"alefsym" => "\u2135", # "ℵ"
			"aleph" => "\u2135", # "ℵ"
			"Alpha" => "\u0391", # "Α"
			"alpha" => "\u03B1", # "α"
			"Amacr" => "\u0100", # "Ā"
			"amacr" => "\u0101", # "ā"
			"amalg" => "\u2A3F", # "⨿"
			"AMP" => "&", # "&"
			"amp" => "&", # "&"
			"And" => "\u2A53", # "⩓"
			"and" => "\u2227", # "∧"
			"andand" => "\u2A55", # "⩕"
			"andd" => "\u2A5C", # "⩜"
			"andslope" => "\u2A58", # "⩘"
			"andv" => "\u2A5A", # "⩚"
			"ang" => "\u2220", # "∠"
			"ange" => "\u29A4", # "⦤"
			"angle" => "\u2220", # "∠"
			"angmsd" => "\u2221", # "∡"
			"angmsdaa" => "\u29A8", # "⦨"
			"angmsdab" => "\u29A9", # "⦩"
			"angmsdac" => "\u29AA", # "⦪"
			"angmsdad" => "\u29AB", # "⦫"
			"angmsdae" => "\u29AC", # "⦬"
			"angmsdaf" => "\u29AD", # "⦭"
			"angmsdag" => "\u29AE", # "⦮"
			"angmsdah" => "\u29AF", # "⦯"
			"angrt" => "\u221F", # "∟"
			"angrtvb" => "\u22BE", # "⊾"
			"angrtvbd" => "\u299D", # "⦝"
			"angsph" => "\u2222", # "∢"
			"angst" => "\u00C5", # "Å"
			"angzarr" => "\u237C", # "⍼"
			"Aogon" => "\u0104", # "Ą"
			"aogon" => "\u0105", # "ą"
			"Aopf" => "\u{1D538}", # "𝔸"
			"aopf" => "\u{1D552}", # "𝕒"
			"ap" => "\u2248", # "≈"
			"apacir" => "\u2A6F", # "⩯"
			"apE" => "\u2A70", # "⩰"
			"ape" => "\u224A", # "≊"
			"apid" => "\u224B", # "≋"
			"apos" => "'", # "'"
			"ApplyFunction" => "\u2061", # "⁡"
			"approx" => "\u2248", # "≈"
			"approxeq" => "\u224A", # "≊"
			"Aring" => "\u00C5", # "Å"
			"aring" => "\u00E5", # "å"
			"Ascr" => "\u{1D49C}", # "𝒜"
			"ascr" => "\u{1D4B6}", # "𝒶"
			"Assign" => "\u2254", # "≔"
			"ast" => "*", # "*"
			"asymp" => "\u2248", # "≈"
			"asympeq" => "\u224D", # "≍"
			"Atilde" => "\u00C3", # "Ã"
			"atilde" => "\u00E3", # "ã"
			"Auml" => "\u00C4", # "Ä"
			"auml" => "\u00E4", # "ä"
			"awconint" => "\u2233", # "∳"
			"awint" => "\u2A11", # "⨑"
			"backcong" => "\u224C", # "≌"
			"backepsilon" => "\u03F6", # "϶"
			"backprime" => "\u2035", # "‵"
			"backsim" => "\u223D", # "∽"
			"backsimeq" => "\u22CD", # "⋍"
			"Backslash" => "\u2216", # "∖"
			"Barv" => "\u2AE7", # "⫧"
			"barvee" => "\u22BD", # "⊽"
			"Barwed" => "\u2306", # "⌆"
			"barwed" => "\u2305", # "⌅"
			"barwedge" => "\u2305", # "⌅"
			"bbrk" => "\u23B5", # "⎵"
			"bbrktbrk" => "\u23B6", # "⎶"
			"bcong" => "\u224C", # "≌"
			"Bcy" => "\u0411", # "Б"
			"bcy" => "\u0431", # "б"
			"bdquo" => "\u201E", # "„"
			"becaus" => "\u2235", # "∵"
			"Because" => "\u2235", # "∵"
			"because" => "\u2235", # "∵"
			"bemptyv" => "\u29B0", # "⦰"
			"bepsi" => "\u03F6", # "϶"
			"bernou" => "\u212C", # "ℬ"
			"Bernoullis" => "\u212C", # "ℬ"
			"Beta" => "\u0392", # "Β"
			"beta" => "\u03B2", # "β"
			"beth" => "\u2136", # "ℶ"
			"between" => "\u226C", # "≬"
			"Bfr" => "\u{1D505}", # "𝔅"
			"bfr" => "\u{1D51F}", # "𝔟"
			"bigcap" => "\u22C2", # "⋂"
			"bigcirc" => "\u25EF", # "◯"
			"bigcup" => "\u22C3", # "⋃"
			"bigodot" => "\u2A00", # "⨀"
			"bigoplus" => "\u2A01", # "⨁"
			"bigotimes" => "\u2A02", # "⨂"
			"bigsqcup" => "\u2A06", # "⨆"
			"bigstar" => "\u2605", # "★"
			"bigtriangledown" => "\u25BD", # "▽"
			"bigtriangleup" => "\u25B3", # "△"
			"biguplus" => "\u2A04", # "⨄"
			"bigvee" => "\u22C1", # "⋁"
			"bigwedge" => "\u22C0", # "⋀"
			"bkarow" => "\u290D", # "⤍"
			"blacklozenge" => "\u29EB", # "⧫"
			"blacksquare" => "\u25AA", # "▪"
			"blacktriangle" => "\u25B4", # "▴"
			"blacktriangledown" => "\u25BE", # "▾"
			"blacktriangleleft" => "\u25C2", # "◂"
			"blacktriangleright" => "\u25B8", # "▸"
			"blank" => "\u2423", # "␣"
			"blk12" => "\u2592", # "▒"
			"blk14" => "\u2591", # "░"
			"blk34" => "\u2593", # "▓"
			"block" => "\u2588", # "█"
			"bne" => "=\u20E5", # "=⃥"
			"bnequiv" => "\u2261\u20E5", # "≡⃥"
			"bNot" => "\u2AED", # "⫭"
			"bnot" => "\u2310", # "⌐"
			"Bopf" => "\u{1D539}", # "𝔹"
			"bopf" => "\u{1D553}", # "𝕓"
			"bot" => "\u22A5", # "⊥"
			"bottom" => "\u22A5", # "⊥"
			"bowtie" => "\u22C8", # "⋈"
			"boxbox" => "\u29C9", # "⧉"
			"boxDL" => "\u2557", # "╗"
			"boxDl" => "\u2556", # "╖"
			"boxdL" => "\u2555", # "╕"
			"boxdl" => "\u2510", # "┐"
			"boxDR" => "\u2554", # "╔"
			"boxDr" => "\u2553", # "╓"
			"boxdR" => "\u2552", # "╒"
			"boxdr" => "\u250C", # "┌"
			"boxH" => "\u2550", # "═"
			"boxh" => "\u2500", # "─"
			"boxHD" => "\u2566", # "╦"
			"boxHd" => "\u2564", # "╤"
			"boxhD" => "\u2565", # "╥"
			"boxhd" => "\u252C", # "┬"
			"boxHU" => "\u2569", # "╩"
			"boxHu" => "\u2567", # "╧"
			"boxhU" => "\u2568", # "╨"
			"boxhu" => "\u2534", # "┴"
			"boxminus" => "\u229F", # "⊟"
			"boxplus" => "\u229E", # "⊞"
			"boxtimes" => "\u22A0", # "⊠"
			"boxUL" => "\u255D", # "╝"
			"boxUl" => "\u255C", # "╜"
			"boxuL" => "\u255B", # "╛"
			"boxul" => "\u2518", # "┘"
			"boxUR" => "\u255A", # "╚"
			"boxUr" => "\u2559", # "╙"
			"boxuR" => "\u2558", # "╘"
			"boxur" => "\u2514", # "└"
			"boxV" => "\u2551", # "║"
			"boxv" => "\u2502", # "│"
			"boxVH" => "\u256C", # "╬"
			"boxVh" => "\u256B", # "╫"
			"boxvH" => "\u256A", # "╪"
			"boxvh" => "\u253C", # "┼"
			"boxVL" => "\u2563", # "╣"
			"boxVl" => "\u2562", # "╢"
			"boxvL" => "\u2561", # "╡"
			"boxvl" => "\u2524", # "┤"
			"boxVR" => "\u2560", # "╠"
			"boxVr" => "\u255F", # "╟"
			"boxvR" => "\u255E", # "╞"
			"boxvr" => "\u251C", # "├"
			"bprime" => "\u2035", # "‵"
			"Breve" => "\u02D8", # "˘"
			"breve" => "\u02D8", # "˘"
			"brvbar" => "\u00A6", # "¦"
			"Bscr" => "\u212C", # "ℬ"
			"bscr" => "\u{1D4B7}", # "𝒷"
			"bsemi" => "\u204F", # "⁏"
			"bsim" => "\u223D", # "∽"
			"bsime" => "\u22CD", # "⋍"
			"bsol" => "\\", # "\\"
			"bsolb" => "\u29C5", # "⧅"
			"bsolhsub" => "\u27C8", # "⟈"
			"bull" => "\u2022", # "•"
			"bullet" => "\u2022", # "•"
			"bump" => "\u224E", # "≎"
			"bumpE" => "\u2AAE", # "⪮"
			"bumpe" => "\u224F", # "≏"
			"Bumpeq" => "\u224E", # "≎"
			"bumpeq" => "\u224F", # "≏"
			"Cacute" => "\u0106", # "Ć"
			"cacute" => "\u0107", # "ć"
			"Cap" => "\u22D2", # "⋒"
			"cap" => "\u2229", # "∩"
			"capand" => "\u2A44", # "⩄"
			"capbrcup" => "\u2A49", # "⩉"
			"capcap" => "\u2A4B", # "⩋"
			"capcup" => "\u2A47", # "⩇"
			"capdot" => "\u2A40", # "⩀"
			"CapitalDifferentialD" => "\u2145", # "ⅅ"
			"caps" => "\u2229\uFE00", # "∩︀"
			"caret" => "\u2041", # "⁁"
			"caron" => "\u02C7", # "ˇ"
			"Cayleys" => "\u212D", # "ℭ"
			"ccaps" => "\u2A4D", # "⩍"
			"Ccaron" => "\u010C", # "Č"
			"ccaron" => "\u010D", # "č"
			"Ccedil" => "\u00C7", # "Ç"
			"ccedil" => "\u00E7", # "ç"
			"Ccirc" => "\u0108", # "Ĉ"
			"ccirc" => "\u0109", # "ĉ"
			"Cconint" => "\u2230", # "∰"
			"ccups" => "\u2A4C", # "⩌"
			"ccupssm" => "\u2A50", # "⩐"
			"Cdot" => "\u010A", # "Ċ"
			"cdot" => "\u010B", # "ċ"
			"cedil" => "\u00B8", # "¸"
			"Cedilla" => "\u00B8", # "¸"
			"cemptyv" => "\u29B2", # "⦲"
			"cent" => "\u00A2", # "¢"
			"CenterDot" => "\u00B7", # "·"
			"centerdot" => "\u00B7", # "·"
			"Cfr" => "\u212D", # "ℭ"
			"cfr" => "\u{1D520}", # "𝔠"
			"CHcy" => "\u0427", # "Ч"
			"chcy" => "\u0447", # "ч"
			"check" => "\u2713", # "✓"
			"checkmark" => "\u2713", # "✓"
			"Chi" => "\u03A7", # "Χ"
			"chi" => "\u03C7", # "χ"
			"cir" => "\u25CB", # "○"
			"circ" => "\u02C6", # "ˆ"
			"circeq" => "\u2257", # "≗"
			"circlearrowleft" => "\u21BA", # "↺"
			"circlearrowright" => "\u21BB", # "↻"
			"circledast" => "\u229B", # "⊛"
			"circledcirc" => "\u229A", # "⊚"
			"circleddash" => "\u229D", # "⊝"
			"CircleDot" => "\u2299", # "⊙"
			"circledR" => "\u00AE", # "®"
			"circledS" => "\u24C8", # "Ⓢ"
			"CircleMinus" => "\u2296", # "⊖"
			"CirclePlus" => "\u2295", # "⊕"
			"CircleTimes" => "\u2297", # "⊗"
			"cirE" => "\u29C3", # "⧃"
			"cire" => "\u2257", # "≗"
			"cirfnint" => "\u2A10", # "⨐"
			"cirmid" => "\u2AEF", # "⫯"
			"cirscir" => "\u29C2", # "⧂"
			"ClockwiseContourIntegral" => "\u2232", # "∲"
			"CloseCurlyDoubleQuote" => "\u201D", # "”"
			"CloseCurlyQuote" => "\u2019", # "’"
			"clubs" => "\u2663", # "♣"
			"clubsuit" => "\u2663", # "♣"
			"Colon" => "\u2237", # "∷"
			"colon" => ":", # ":"
			"Colone" => "\u2A74", # "⩴"
			"colone" => "\u2254", # "≔"
			"coloneq" => "\u2254", # "≔"
			"comma" => ",", # ","
			"commat" => "@", # "@"
			"comp" => "\u2201", # "∁"
			"compfn" => "\u2218", # "∘"
			"complement" => "\u2201", # "∁"
			"complexes" => "\u2102", # "ℂ"
			"cong" => "\u2245", # "≅"
			"congdot" => "\u2A6D", # "⩭"
			"Congruent" => "\u2261", # "≡"
			"Conint" => "\u222F", # "∯"
			"conint" => "\u222E", # "∮"
			"ContourIntegral" => "\u222E", # "∮"
			"Copf" => "\u2102", # "ℂ"
			"copf" => "\u{1D554}", # "𝕔"
			"coprod" => "\u2210", # "∐"
			"Coproduct" => "\u2210", # "∐"
			"COPY" => "\u00A9", # "©"
			"copy" => "\u00A9", # "©"
			"copysr" => "\u2117", # "℗"
			"CounterClockwiseContourIntegral" => "\u2233", # "∳"
			"crarr" => "\u21B5", # "↵"
			"Cross" => "\u2A2F", # "⨯"
			"cross" => "\u2717", # "✗"
			"Cscr" => "\u{1D49E}", # "𝒞"
			"cscr" => "\u{1D4B8}", # "𝒸"
			"csub" => "\u2ACF", # "⫏"
			"csube" => "\u2AD1", # "⫑"
			"csup" => "\u2AD0", # "⫐"
			"csupe" => "\u2AD2", # "⫒"
			"ctdot" => "\u22EF", # "⋯"
			"cudarrl" => "\u2938", # "⤸"
			"cudarrr" => "\u2935", # "⤵"
			"cuepr" => "\u22DE", # "⋞"
			"cuesc" => "\u22DF", # "⋟"
			"cularr" => "\u21B6", # "↶"
			"cularrp" => "\u293D", # "⤽"
			"Cup" => "\u22D3", # "⋓"
			"cup" => "\u222A", # "∪"
			"cupbrcap" => "\u2A48", # "⩈"
			"CupCap" => "\u224D", # "≍"
			"cupcap" => "\u2A46", # "⩆"
			"cupcup" => "\u2A4A", # "⩊"
			"cupdot" => "\u228D", # "⊍"
			"cupor" => "\u2A45", # "⩅"
			"cups" => "\u222A\uFE00", # "∪︀"
			"curarr" => "\u21B7", # "↷"
			"curarrm" => "\u293C", # "⤼"
			"curlyeqprec" => "\u22DE", # "⋞"
			"curlyeqsucc" => "\u22DF", # "⋟"
			"curlyvee" => "\u22CE", # "⋎"
			"curlywedge" => "\u22CF", # "⋏"
			"curren" => "\u00A4", # "¤"
			"curvearrowleft" => "\u21B6", # "↶"
			"curvearrowright" => "\u21B7", # "↷"
			"cuvee" => "\u22CE", # "⋎"
			"cuwed" => "\u22CF", # "⋏"
			"cwconint" => "\u2232", # "∲"
			"cwint" => "\u2231", # "∱"
			"cylcty" => "\u232D", # "⌭"
			"Dagger" => "\u2021", # "‡"
			"dagger" => "\u2020", # "†"
			"daleth" => "\u2138", # "ℸ"
			"Darr" => "\u21A1", # "↡"
			"dArr" => "\u21D3", # "⇓"
			"darr" => "\u2193", # "↓"
			"dash" => "\u2010", # "‐"
			"Dashv" => "\u2AE4", # "⫤"
			"dashv" => "\u22A3", # "⊣"
			"dbkarow" => "\u290F", # "⤏"
			"dblac" => "\u02DD", # "˝"
			"Dcaron" => "\u010E", # "Ď"
			"dcaron" => "\u010F", # "ď"
			"Dcy" => "\u0414", # "Д"
			"dcy" => "\u0434", # "д"
			"DD" => "\u2145", # "ⅅ"
			"dd" => "\u2146", # "ⅆ"
			"ddagger" => "\u2021", # "‡"
			"ddarr" => "\u21CA", # "⇊"
			"DDotrahd" => "\u2911", # "⤑"
			"ddotseq" => "\u2A77", # "⩷"
			"deg" => "\u00B0", # "°"
			"Del" => "\u2207", # "∇"
			"Delta" => "\u0394", # "Δ"
			"delta" => "\u03B4", # "δ"
			"demptyv" => "\u29B1", # "⦱"
			"dfisht" => "\u297F", # "⥿"
			"Dfr" => "\u{1D507}", # "𝔇"
			"dfr" => "\u{1D521}", # "𝔡"
			"dHar" => "\u2965", # "⥥"
			"dharl" => "\u21C3", # "⇃"
			"dharr" => "\u21C2", # "⇂"
			"DiacriticalAcute" => "\u00B4", # "´"
			"DiacriticalDot" => "\u02D9", # "˙"
			"DiacriticalDoubleAcute" => "\u02DD", # "˝"
			"DiacriticalGrave" => "`", # "`"
			"DiacriticalTilde" => "\u02DC", # "˜"
			"diam" => "\u22C4", # "⋄"
			"Diamond" => "\u22C4", # "⋄"
			"diamond" => "\u22C4", # "⋄"
			"diamondsuit" => "\u2666", # "♦"
			"diams" => "\u2666", # "♦"
			"die" => "\u00A8", # "¨"
			"DifferentialD" => "\u2146", # "ⅆ"
			"digamma" => "\u03DD", # "ϝ"
			"disin" => "\u22F2", # "⋲"
			"div" => "\u00F7", # "÷"
			"divide" => "\u00F7", # "÷"
			"divideontimes" => "\u22C7", # "⋇"
			"divonx" => "\u22C7", # "⋇"
			"DJcy" => "\u0402", # "Ђ"
			"djcy" => "\u0452", # "ђ"
			"dlcorn" => "\u231E", # "⌞"
			"dlcrop" => "\u230D", # "⌍"
			"dollar" => "$", # "$"
			"Dopf" => "\u{1D53B}", # "𝔻"
			"dopf" => "\u{1D555}", # "𝕕"
			"Dot" => "\u00A8", # "¨"
			"dot" => "\u02D9", # "˙"
			"DotDot" => "\u20DC", # "⃜"
			"doteq" => "\u2250", # "≐"
			"doteqdot" => "\u2251", # "≑"
			"DotEqual" => "\u2250", # "≐"
			"dotminus" => "\u2238", # "∸"
			"dotplus" => "\u2214", # "∔"
			"dotsquare" => "\u22A1", # "⊡"
			"doublebarwedge" => "\u2306", # "⌆"
			"DoubleContourIntegral" => "\u222F", # "∯"
			"DoubleDot" => "\u00A8", # "¨"
			"DoubleDownArrow" => "\u21D3", # "⇓"
			"DoubleLeftArrow" => "\u21D0", # "⇐"
			"DoubleLeftRightArrow" => "\u21D4", # "⇔"
			"DoubleLeftTee" => "\u2AE4", # "⫤"
			"DoubleLongLeftArrow" => "\u27F8", # "⟸"
			"DoubleLongLeftRightArrow" => "\u27FA", # "⟺"
			"DoubleLongRightArrow" => "\u27F9", # "⟹"
			"DoubleRightArrow" => "\u21D2", # "⇒"
			"DoubleRightTee" => "\u22A8", # "⊨"
			"DoubleUpArrow" => "\u21D1", # "⇑"
			"DoubleUpDownArrow" => "\u21D5", # "⇕"
			"DoubleVerticalBar" => "\u2225", # "∥"
			"DownArrow" => "\u2193", # "↓"
			"Downarrow" => "\u21D3", # "⇓"
			"downarrow" => "\u2193", # "↓"
			"DownArrowBar" => "\u2913", # "⤓"
			"DownArrowUpArrow" => "\u21F5", # "⇵"
			"DownBreve" => "\u0311", # "̑"
			"downdownarrows" => "\u21CA", # "⇊"
			"downharpoonleft" => "\u21C3", # "⇃"
			"downharpoonright" => "\u21C2", # "⇂"
			"DownLeftRightVector" => "\u2950", # "⥐"
			"DownLeftTeeVector" => "\u295E", # "⥞"
			"DownLeftVector" => "\u21BD", # "↽"
			"DownLeftVectorBar" => "\u2956", # "⥖"
			"DownRightTeeVector" => "\u295F", # "⥟"
			"DownRightVector" => "\u21C1", # "⇁"
			"DownRightVectorBar" => "\u2957", # "⥗"
			"DownTee" => "\u22A4", # "⊤"
			"DownTeeArrow" => "\u21A7", # "↧"
			"drbkarow" => "\u2910", # "⤐"
			"drcorn" => "\u231F", # "⌟"
			"drcrop" => "\u230C", # "⌌"
			"Dscr" => "\u{1D49F}", # "𝒟"
			"dscr" => "\u{1D4B9}", # "𝒹"
			"DScy" => "\u0405", # "Ѕ"
			"dscy" => "\u0455", # "ѕ"
			"dsol" => "\u29F6", # "⧶"
			"Dstrok" => "\u0110", # "Đ"
			"dstrok" => "\u0111", # "đ"
			"dtdot" => "\u22F1", # "⋱"
			"dtri" => "\u25BF", # "▿"
			"dtrif" => "\u25BE", # "▾"
			"duarr" => "\u21F5", # "⇵"
			"duhar" => "\u296F", # "⥯"
			"dwangle" => "\u29A6", # "⦦"
			"DZcy" => "\u040F", # "Џ"
			"dzcy" => "\u045F", # "џ"
			"dzigrarr" => "\u27FF", # "⟿"
			"Eacute" => "\u00C9", # "É"
			"eacute" => "\u00E9", # "é"
			"easter" => "\u2A6E", # "⩮"
			"Ecaron" => "\u011A", # "Ě"
			"ecaron" => "\u011B", # "ě"
			"ecir" => "\u2256", # "≖"
			"Ecirc" => "\u00CA", # "Ê"
			"ecirc" => "\u00EA", # "ê"
			"ecolon" => "\u2255", # "≕"
			"Ecy" => "\u042D", # "Э"
			"ecy" => "\u044D", # "э"
			"eDDot" => "\u2A77", # "⩷"
			"Edot" => "\u0116", # "Ė"
			"eDot" => "\u2251", # "≑"
			"edot" => "\u0117", # "ė"
			"ee" => "\u2147", # "ⅇ"
			"efDot" => "\u2252", # "≒"
			"Efr" => "\u{1D508}", # "𝔈"
			"efr" => "\u{1D522}", # "𝔢"
			"eg" => "\u2A9A", # "⪚"
			"Egrave" => "\u00C8", # "È"
			"egrave" => "\u00E8", # "è"
			"egs" => "\u2A96", # "⪖"
			"egsdot" => "\u2A98", # "⪘"
			"el" => "\u2A99", # "⪙"
			"Element" => "\u2208", # "∈"
			"elinters" => "\u23E7", # "⏧"
			"ell" => "\u2113", # "ℓ"
			"els" => "\u2A95", # "⪕"
			"elsdot" => "\u2A97", # "⪗"
			"Emacr" => "\u0112", # "Ē"
			"emacr" => "\u0113", # "ē"
			"empty" => "\u2205", # "∅"
			"emptyset" => "\u2205", # "∅"
			"EmptySmallSquare" => "\u25FB", # "◻"
			"emptyv" => "\u2205", # "∅"
			"EmptyVerySmallSquare" => "\u25AB", # "▫"
			"emsp" => "\u2003", # " "
			"emsp13" => "\u2004", # " "
			"emsp14" => "\u2005", # " "
			"ENG" => "\u014A", # "Ŋ"
			"eng" => "\u014B", # "ŋ"
			"ensp" => "\u2002", # " "
			"Eogon" => "\u0118", # "Ę"
			"eogon" => "\u0119", # "ę"
			"Eopf" => "\u{1D53C}", # "𝔼"
			"eopf" => "\u{1D556}", # "𝕖"
			"epar" => "\u22D5", # "⋕"
			"eparsl" => "\u29E3", # "⧣"
			"eplus" => "\u2A71", # "⩱"
			"epsi" => "\u03B5", # "ε"
			"Epsilon" => "\u0395", # "Ε"
			"epsilon" => "\u03B5", # "ε"
			"epsiv" => "\u03F5", # "ϵ"
			"eqcirc" => "\u2256", # "≖"
			"eqcolon" => "\u2255", # "≕"
			"eqsim" => "\u2242", # "≂"
			"eqslantgtr" => "\u2A96", # "⪖"
			"eqslantless" => "\u2A95", # "⪕"
			"Equal" => "\u2A75", # "⩵"
			"equals" => "=", # "="
			"EqualTilde" => "\u2242", # "≂"
			"equest" => "\u225F", # "≟"
			"Equilibrium" => "\u21CC", # "⇌"
			"equiv" => "\u2261", # "≡"
			"equivDD" => "\u2A78", # "⩸"
			"eqvparsl" => "\u29E5", # "⧥"
			"erarr" => "\u2971", # "⥱"
			"erDot" => "\u2253", # "≓"
			"Escr" => "\u2130", # "ℰ"
			"escr" => "\u212F", # "ℯ"
			"esdot" => "\u2250", # "≐"
			"Esim" => "\u2A73", # "⩳"
			"esim" => "\u2242", # "≂"
			"Eta" => "\u0397", # "Η"
			"eta" => "\u03B7", # "η"
			"ETH" => "\u00D0", # "Ð"
			"eth" => "\u00F0", # "ð"
			"Euml" => "\u00CB", # "Ë"
			"euml" => "\u00EB", # "ë"
			"euro" => "\u20AC", # "€"
			"excl" => "!", # "!"
			"exist" => "\u2203", # "∃"
			"Exists" => "\u2203", # "∃"
			"expectation" => "\u2130", # "ℰ"
			"ExponentialE" => "\u2147", # "ⅇ"
			"exponentiale" => "\u2147", # "ⅇ"
			"fallingdotseq" => "\u2252", # "≒"
			"Fcy" => "\u0424", # "Ф"
			"fcy" => "\u0444", # "ф"
			"female" => "\u2640", # "♀"
			"ffilig" => "\uFB03", # "ﬃ"
			"fflig" => "\uFB00", # "ﬀ"
			"ffllig" => "\uFB04", # "ﬄ"
			"Ffr" => "\u{1D509}", # "𝔉"
			"ffr" => "\u{1D523}", # "𝔣"
			"filig" => "\uFB01", # "ﬁ"
			"FilledSmallSquare" => "\u25FC", # "◼"
			"FilledVerySmallSquare" => "\u25AA", # "▪"
			"fjlig" => "fj", # "fj"
			"flat" => "\u266D", # "♭"
			"fllig" => "\uFB02", # "ﬂ"
			"fltns" => "\u25B1", # "▱"
			"fnof" => "\u0192", # "ƒ"
			"Fopf" => "\u{1D53D}", # "𝔽"
			"fopf" => "\u{1D557}", # "𝕗"
			"ForAll" => "\u2200", # "∀"
			"forall" => "\u2200", # "∀"
			"fork" => "\u22D4", # "⋔"
			"forkv" => "\u2AD9", # "⫙"
			"Fouriertrf" => "\u2131", # "ℱ"
			"fpartint" => "\u2A0D", # "⨍"
			"frac12" => "\u00BD", # "½"
			"frac13" => "\u2153", # "⅓"
			"frac14" => "\u00BC", # "¼"
			"frac15" => "\u2155", # "⅕"
			"frac16" => "\u2159", # "⅙"
			"frac18" => "\u215B", # "⅛"
			"frac23" => "\u2154", # "⅔"
			"frac25" => "\u2156", # "⅖"
			"frac34" => "\u00BE", # "¾"
			"frac35" => "\u2157", # "⅗"
			"frac38" => "\u215C", # "⅜"
			"frac45" => "\u2158", # "⅘"
			"frac56" => "\u215A", # "⅚"
			"frac58" => "\u215D", # "⅝"
			"frac78" => "\u215E", # "⅞"
			"frasl" => "\u2044", # "⁄"
			"frown" => "\u2322", # "⌢"
			"Fscr" => "\u2131", # "ℱ"
			"fscr" => "\u{1D4BB}", # "𝒻"
			"gacute" => "\u01F5", # "ǵ"
			"Gamma" => "\u0393", # "Γ"
			"gamma" => "\u03B3", # "γ"
			"Gammad" => "\u03DC", # "Ϝ"
			"gammad" => "\u03DD", # "ϝ"
			"gap" => "\u2A86", # "⪆"
			"Gbreve" => "\u011E", # "Ğ"
			"gbreve" => "\u011F", # "ğ"
			"Gcedil" => "\u0122", # "Ģ"
			"Gcirc" => "\u011C", # "Ĝ"
			"gcirc" => "\u011D", # "ĝ"
			"Gcy" => "\u0413", # "Г"
			"gcy" => "\u0433", # "г"
			"Gdot" => "\u0120", # "Ġ"
			"gdot" => "\u0121", # "ġ"
			"gE" => "\u2267", # "≧"
			"ge" => "\u2265", # "≥"
			"gEl" => "\u2A8C", # "⪌"
			"gel" => "\u22DB", # "⋛"
			"geq" => "\u2265", # "≥"
			"geqq" => "\u2267", # "≧"
			"geqslant" => "\u2A7E", # "⩾"
			"ges" => "\u2A7E", # "⩾"
			"gescc" => "\u2AA9", # "⪩"
			"gesdot" => "\u2A80", # "⪀"
			"gesdoto" => "\u2A82", # "⪂"
			"gesdotol" => "\u2A84", # "⪄"
			"gesl" => "\u22DB\uFE00", # "⋛︀"
			"gesles" => "\u2A94", # "⪔"
			"Gfr" => "\u{1D50A}", # "𝔊"
			"gfr" => "\u{1D524}", # "𝔤"
			"Gg" => "\u22D9", # "⋙"
			"gg" => "\u226B", # "≫"
			"ggg" => "\u22D9", # "⋙"
			"gimel" => "\u2137", # "ℷ"
			"GJcy" => "\u0403", # "Ѓ"
			"gjcy" => "\u0453", # "ѓ"
			"gl" => "\u2277", # "≷"
			"gla" => "\u2AA5", # "⪥"
			"glE" => "\u2A92", # "⪒"
			"glj" => "\u2AA4", # "⪤"
			"gnap" => "\u2A8A", # "⪊"
			"gnapprox" => "\u2A8A", # "⪊"
			"gnE" => "\u2269", # "≩"
			"gne" => "\u2A88", # "⪈"
			"gneq" => "\u2A88", # "⪈"
			"gneqq" => "\u2269", # "≩"
			"gnsim" => "\u22E7", # "⋧"
			"Gopf" => "\u{1D53E}", # "𝔾"
			"gopf" => "\u{1D558}", # "𝕘"
			"grave" => "`", # "`"
			"GreaterEqual" => "\u2265", # "≥"
			"GreaterEqualLess" => "\u22DB", # "⋛"
			"GreaterFullEqual" => "\u2267", # "≧"
			"GreaterGreater" => "\u2AA2", # "⪢"
			"GreaterLess" => "\u2277", # "≷"
			"GreaterSlantEqual" => "\u2A7E", # "⩾"
			"GreaterTilde" => "\u2273", # "≳"
			"Gscr" => "\u{1D4A2}", # "𝒢"
			"gscr" => "\u210A", # "ℊ"
			"gsim" => "\u2273", # "≳"
			"gsime" => "\u2A8E", # "⪎"
			"gsiml" => "\u2A90", # "⪐"
			"GT" => ">", # ">"
			"Gt" => "\u226B", # "≫"
			"gt" => ">", # ">"
			"gtcc" => "\u2AA7", # "⪧"
			"gtcir" => "\u2A7A", # "⩺"
			"gtdot" => "\u22D7", # "⋗"
			"gtlPar" => "\u2995", # "⦕"
			"gtquest" => "\u2A7C", # "⩼"
			"gtrapprox" => "\u2A86", # "⪆"
			"gtrarr" => "\u2978", # "⥸"
			"gtrdot" => "\u22D7", # "⋗"
			"gtreqless" => "\u22DB", # "⋛"
			"gtreqqless" => "\u2A8C", # "⪌"
			"gtrless" => "\u2277", # "≷"
			"gtrsim" => "\u2273", # "≳"
			"gvertneqq" => "\u2269\uFE00", # "≩︀"
			"gvnE" => "\u2269\uFE00", # "≩︀"
			"Hacek" => "\u02C7", # "ˇ"
			"hairsp" => "\u200A", # " "
			"half" => "\u00BD", # "½"
			"hamilt" => "\u210B", # "ℋ"
			"HARDcy" => "\u042A", # "Ъ"
			"hardcy" => "\u044A", # "ъ"
			"hArr" => "\u21D4", # "⇔"
			"harr" => "\u2194", # "↔"
			"harrcir" => "\u2948", # "⥈"
			"harrw" => "\u21AD", # "↭"
			"Hat" => "^", # "^"
			"hbar" => "\u210F", # "ℏ"
			"Hcirc" => "\u0124", # "Ĥ"
			"hcirc" => "\u0125", # "ĥ"
			"hearts" => "\u2665", # "♥"
			"heartsuit" => "\u2665", # "♥"
			"hellip" => "\u2026", # "…"
			"hercon" => "\u22B9", # "⊹"
			"Hfr" => "\u210C", # "ℌ"
			"hfr" => "\u{1D525}", # "𝔥"
			"HilbertSpace" => "\u210B", # "ℋ"
			"hksearow" => "\u2925", # "⤥"
			"hkswarow" => "\u2926", # "⤦"
			"hoarr" => "\u21FF", # "⇿"
			"homtht" => "\u223B", # "∻"
			"hookleftarrow" => "\u21A9", # "↩"
			"hookrightarrow" => "\u21AA", # "↪"
			"Hopf" => "\u210D", # "ℍ"
			"hopf" => "\u{1D559}", # "𝕙"
			"horbar" => "\u2015", # "―"
			"HorizontalLine" => "\u2500", # "─"
			"Hscr" => "\u210B", # "ℋ"
			"hscr" => "\u{1D4BD}", # "𝒽"
			"hslash" => "\u210F", # "ℏ"
			"Hstrok" => "\u0126", # "Ħ"
			"hstrok" => "\u0127", # "ħ"
			"HumpDownHump" => "\u224E", # "≎"
			"HumpEqual" => "\u224F", # "≏"
			"hybull" => "\u2043", # "⁃"
			"hyphen" => "\u2010", # "‐"
			"Iacute" => "\u00CD", # "Í"
			"iacute" => "\u00ED", # "í"
			"ic" => "\u2063", # "⁣"
			"Icirc" => "\u00CE", # "Î"
			"icirc" => "\u00EE", # "î"
			"Icy" => "\u0418", # "И"
			"icy" => "\u0438", # "и"
			"Idot" => "\u0130", # "İ"
			"IEcy" => "\u0415", # "Е"
			"iecy" => "\u0435", # "е"
			"iexcl" => "\u00A1", # "¡"
			"iff" => "\u21D4", # "⇔"
			"Ifr" => "\u2111", # "ℑ"
			"ifr" => "\u{1D526}", # "𝔦"
			"Igrave" => "\u00CC", # "Ì"
			"igrave" => "\u00EC", # "ì"
			"ii" => "\u2148", # "ⅈ"
			"iiiint" => "\u2A0C", # "⨌"
			"iiint" => "\u222D", # "∭"
			"iinfin" => "\u29DC", # "⧜"
			"iiota" => "\u2129", # "℩"
			"IJlig" => "\u0132", # "Ĳ"
			"ijlig" => "\u0133", # "ĳ"
			"Im" => "\u2111", # "ℑ"
			"Imacr" => "\u012A", # "Ī"
			"imacr" => "\u012B", # "ī"
			"image" => "\u2111", # "ℑ"
			"ImaginaryI" => "\u2148", # "ⅈ"
			"imagline" => "\u2110", # "ℐ"
			"imagpart" => "\u2111", # "ℑ"
			"imath" => "\u0131", # "ı"
			"imof" => "\u22B7", # "⊷"
			"imped" => "\u01B5", # "Ƶ"
			"Implies" => "\u21D2", # "⇒"
			"in" => "\u2208", # "∈"
			"incare" => "\u2105", # "℅"
			"infin" => "\u221E", # "∞"
			"infintie" => "\u29DD", # "⧝"
			"inodot" => "\u0131", # "ı"
			"Int" => "\u222C", # "∬"
			"int" => "\u222B", # "∫"
			"intcal" => "\u22BA", # "⊺"
			"integers" => "\u2124", # "ℤ"
			"Integral" => "\u222B", # "∫"
			"intercal" => "\u22BA", # "⊺"
			"Intersection" => "\u22C2", # "⋂"
			"intlarhk" => "\u2A17", # "⨗"
			"intprod" => "\u2A3C", # "⨼"
			"InvisibleComma" => "\u2063", # "⁣"
			"InvisibleTimes" => "\u2062", # "⁢"
			"IOcy" => "\u0401", # "Ё"
			"iocy" => "\u0451", # "ё"
			"Iogon" => "\u012E", # "Į"
			"iogon" => "\u012F", # "į"
			"Iopf" => "\u{1D540}", # "𝕀"
			"iopf" => "\u{1D55A}", # "𝕚"
			"Iota" => "\u0399", # "Ι"
			"iota" => "\u03B9", # "ι"
			"iprod" => "\u2A3C", # "⨼"
			"iquest" => "\u00BF", # "¿"
			"Iscr" => "\u2110", # "ℐ"
			"iscr" => "\u{1D4BE}", # "𝒾"
			"isin" => "\u2208", # "∈"
			"isindot" => "\u22F5", # "⋵"
			"isinE" => "\u22F9", # "⋹"
			"isins" => "\u22F4", # "⋴"
			"isinsv" => "\u22F3", # "⋳"
			"isinv" => "\u2208", # "∈"
			"it" => "\u2062", # "⁢"
			"Itilde" => "\u0128", # "Ĩ"
			"itilde" => "\u0129", # "ĩ"
			"Iukcy" => "\u0406", # "І"
			"iukcy" => "\u0456", # "і"
			"Iuml" => "\u00CF", # "Ï"
			"iuml" => "\u00EF", # "ï"
			"Jcirc" => "\u0134", # "Ĵ"
			"jcirc" => "\u0135", # "ĵ"
			"Jcy" => "\u0419", # "Й"
			"jcy" => "\u0439", # "й"
			"Jfr" => "\u{1D50D}", # "𝔍"
			"jfr" => "\u{1D527}", # "𝔧"
			"jmath" => "\u0237", # "ȷ"
			"Jopf" => "\u{1D541}", # "𝕁"
			"jopf" => "\u{1D55B}", # "𝕛"
			"Jscr" => "\u{1D4A5}", # "𝒥"
			"jscr" => "\u{1D4BF}", # "𝒿"
			"Jsercy" => "\u0408", # "Ј"
			"jsercy" => "\u0458", # "ј"
			"Jukcy" => "\u0404", # "Є"
			"jukcy" => "\u0454", # "є"
			"Kappa" => "\u039A", # "Κ"
			"kappa" => "\u03BA", # "κ"
			"kappav" => "\u03F0", # "ϰ"
			"Kcedil" => "\u0136", # "Ķ"
			"kcedil" => "\u0137", # "ķ"
			"Kcy" => "\u041A", # "К"
			"kcy" => "\u043A", # "к"
			"Kfr" => "\u{1D50E}", # "𝔎"
			"kfr" => "\u{1D528}", # "𝔨"
			"kgreen" => "\u0138", # "ĸ"
			"KHcy" => "\u0425", # "Х"
			"khcy" => "\u0445", # "х"
			"KJcy" => "\u040C", # "Ќ"
			"kjcy" => "\u045C", # "ќ"
			"Kopf" => "\u{1D542}", # "𝕂"
			"kopf" => "\u{1D55C}", # "𝕜"
			"Kscr" => "\u{1D4A6}", # "𝒦"
			"kscr" => "\u{1D4C0}", # "𝓀"
			"lAarr" => "\u21DA", # "⇚"
			"Lacute" => "\u0139", # "Ĺ"
			"lacute" => "\u013A", # "ĺ"
			"laemptyv" => "\u29B4", # "⦴"
			"lagran" => "\u2112", # "ℒ"
			"Lambda" => "\u039B", # "Λ"
			"lambda" => "\u03BB", # "λ"
			"Lang" => "\u27EA", # "⟪"
			"lang" => "\u27E8", # "⟨"
			"langd" => "\u2991", # "⦑"
			"langle" => "\u27E8", # "⟨"
			"lap" => "\u2A85", # "⪅"
			"Laplacetrf" => "\u2112", # "ℒ"
			"laquo" => "\u00AB", # "«"
			"Larr" => "\u219E", # "↞"
			"lArr" => "\u21D0", # "⇐"
			"larr" => "\u2190", # "←"
			"larrb" => "\u21E4", # "⇤"
			"larrbfs" => "\u291F", # "⤟"
			"larrfs" => "\u291D", # "⤝"
			"larrhk" => "\u21A9", # "↩"
			"larrlp" => "\u21AB", # "↫"
			"larrpl" => "\u2939", # "⤹"
			"larrsim" => "\u2973", # "⥳"
			"larrtl" => "\u21A2", # "↢"
			"lat" => "\u2AAB", # "⪫"
			"lAtail" => "\u291B", # "⤛"
			"latail" => "\u2919", # "⤙"
			"late" => "\u2AAD", # "⪭"
			"lates" => "\u2AAD\uFE00", # "⪭︀"
			"lBarr" => "\u290E", # "⤎"
			"lbarr" => "\u290C", # "⤌"
			"lbbrk" => "\u2772", # "❲"
			"lbrace" => "{", # "{"
			"lbrack" => "[", # "["
			"lbrke" => "\u298B", # "⦋"
			"lbrksld" => "\u298F", # "⦏"
			"lbrkslu" => "\u298D", # "⦍"
			"Lcaron" => "\u013D", # "Ľ"
			"lcaron" => "\u013E", # "ľ"
			"Lcedil" => "\u013B", # "Ļ"
			"lcedil" => "\u013C", # "ļ"
			"lceil" => "\u2308", # "⌈"
			"lcub" => "{", # "{"
			"Lcy" => "\u041B", # "Л"
			"lcy" => "\u043B", # "л"
			"ldca" => "\u2936", # "⤶"
			"ldquo" => "\u201C", # "“"
			"ldquor" => "\u201E", # "„"
			"ldrdhar" => "\u2967", # "⥧"
			"ldrushar" => "\u294B", # "⥋"
			"ldsh" => "\u21B2", # "↲"
			"lE" => "\u2266", # "≦"
			"le" => "\u2264", # "≤"
			"LeftAngleBracket" => "\u27E8", # "⟨"
			"LeftArrow" => "\u2190", # "←"
			"Leftarrow" => "\u21D0", # "⇐"
			"leftarrow" => "\u2190", # "←"
			"LeftArrowBar" => "\u21E4", # "⇤"
			"LeftArrowRightArrow" => "\u21C6", # "⇆"
			"leftarrowtail" => "\u21A2", # "↢"
			"LeftCeiling" => "\u2308", # "⌈"
			"LeftDoubleBracket" => "\u27E6", # "⟦"
			"LeftDownTeeVector" => "\u2961", # "⥡"
			"LeftDownVector" => "\u21C3", # "⇃"
			"LeftDownVectorBar" => "\u2959", # "⥙"
			"LeftFloor" => "\u230A", # "⌊"
			"leftharpoondown" => "\u21BD", # "↽"
			"leftharpoonup" => "\u21BC", # "↼"
			"leftleftarrows" => "\u21C7", # "⇇"
			"LeftRightArrow" => "\u2194", # "↔"
			"Leftrightarrow" => "\u21D4", # "⇔"
			"leftrightarrow" => "\u2194", # "↔"
			"leftrightarrows" => "\u21C6", # "⇆"
			"leftrightharpoons" => "\u21CB", # "⇋"
			"leftrightsquigarrow" => "\u21AD", # "↭"
			"LeftRightVector" => "\u294E", # "⥎"
			"LeftTee" => "\u22A3", # "⊣"
			"LeftTeeArrow" => "\u21A4", # "↤"
			"LeftTeeVector" => "\u295A", # "⥚"
			"leftthreetimes" => "\u22CB", # "⋋"
			"LeftTriangle" => "\u22B2", # "⊲"
			"LeftTriangleBar" => "\u29CF", # "⧏"
			"LeftTriangleEqual" => "\u22B4", # "⊴"
			"LeftUpDownVector" => "\u2951", # "⥑"
			"LeftUpTeeVector" => "\u2960", # "⥠"
			"LeftUpVector" => "\u21BF", # "↿"
			"LeftUpVectorBar" => "\u2958", # "⥘"
			"LeftVector" => "\u21BC", # "↼"
			"LeftVectorBar" => "\u2952", # "⥒"
			"lEg" => "\u2A8B", # "⪋"
			"leg" => "\u22DA", # "⋚"
			"leq" => "\u2264", # "≤"
			"leqq" => "\u2266", # "≦"
			"leqslant" => "\u2A7D", # "⩽"
			"les" => "\u2A7D", # "⩽"
			"lescc" => "\u2AA8", # "⪨"
			"lesdot" => "\u2A7F", # "⩿"
			"lesdoto" => "\u2A81", # "⪁"
			"lesdotor" => "\u2A83", # "⪃"
			"lesg" => "\u22DA\uFE00", # "⋚︀"
			"lesges" => "\u2A93", # "⪓"
			"lessapprox" => "\u2A85", # "⪅"
			"lessdot" => "\u22D6", # "⋖"
			"lesseqgtr" => "\u22DA", # "⋚"
			"lesseqqgtr" => "\u2A8B", # "⪋"
			"LessEqualGreater" => "\u22DA", # "⋚"
			"LessFullEqual" => "\u2266", # "≦"
			"LessGreater" => "\u2276", # "≶"
			"lessgtr" => "\u2276", # "≶"
			"LessLess" => "\u2AA1", # "⪡"
			"lesssim" => "\u2272", # "≲"
			"LessSlantEqual" => "\u2A7D", # "⩽"
			"LessTilde" => "\u2272", # "≲"
			"lfisht" => "\u297C", # "⥼"
			"lfloor" => "\u230A", # "⌊"
			"Lfr" => "\u{1D50F}", # "𝔏"
			"lfr" => "\u{1D529}", # "𝔩"
			"lg" => "\u2276", # "≶"
			"lgE" => "\u2A91", # "⪑"
			"lHar" => "\u2962", # "⥢"
			"lhard" => "\u21BD", # "↽"
			"lharu" => "\u21BC", # "↼"
			"lharul" => "\u296A", # "⥪"
			"lhblk" => "\u2584", # "▄"
			"LJcy" => "\u0409", # "Љ"
			"ljcy" => "\u0459", # "љ"
			"Ll" => "\u22D8", # "⋘"
			"ll" => "\u226A", # "≪"
			"llarr" => "\u21C7", # "⇇"
			"llcorner" => "\u231E", # "⌞"
			"Lleftarrow" => "\u21DA", # "⇚"
			"llhard" => "\u296B", # "⥫"
			"lltri" => "\u25FA", # "◺"
			"Lmidot" => "\u013F", # "Ŀ"
			"lmidot" => "\u0140", # "ŀ"
			"lmoust" => "\u23B0", # "⎰"
			"lmoustache" => "\u23B0", # "⎰"
			"lnap" => "\u2A89", # "⪉"
			"lnapprox" => "\u2A89", # "⪉"
			"lnE" => "\u2268", # "≨"
			"lne" => "\u2A87", # "⪇"
			"lneq" => "\u2A87", # "⪇"
			"lneqq" => "\u2268", # "≨"
			"lnsim" => "\u22E6", # "⋦"
			"loang" => "\u27EC", # "⟬"
			"loarr" => "\u21FD", # "⇽"
			"lobrk" => "\u27E6", # "⟦"
			"LongLeftArrow" => "\u27F5", # "⟵"
			"Longleftarrow" => "\u27F8", # "⟸"
			"longleftarrow" => "\u27F5", # "⟵"
			"LongLeftRightArrow" => "\u27F7", # "⟷"
			"Longleftrightarrow" => "\u27FA", # "⟺"
			"longleftrightarrow" => "\u27F7", # "⟷"
			"longmapsto" => "\u27FC", # "⟼"
			"LongRightArrow" => "\u27F6", # "⟶"
			"Longrightarrow" => "\u27F9", # "⟹"
			"longrightarrow" => "\u27F6", # "⟶"
			"looparrowleft" => "\u21AB", # "↫"
			"looparrowright" => "\u21AC", # "↬"
			"lopar" => "\u2985", # "⦅"
			"Lopf" => "\u{1D543}", # "𝕃"
			"lopf" => "\u{1D55D}", # "𝕝"
			"loplus" => "\u2A2D", # "⨭"
			"lotimes" => "\u2A34", # "⨴"
			"lowast" => "\u2217", # "∗"
			"lowbar" => "_", # "_"
			"LowerLeftArrow" => "\u2199", # "↙"
			"LowerRightArrow" => "\u2198", # "↘"
			"loz" => "\u25CA", # "◊"
			"lozenge" => "\u25CA", # "◊"
			"lozf" => "\u29EB", # "⧫"
			"lpar" => "(", # "("
			"lparlt" => "\u2993", # "⦓"
			"lrarr" => "\u21C6", # "⇆"
			"lrcorner" => "\u231F", # "⌟"
			"lrhar" => "\u21CB", # "⇋"
			"lrhard" => "\u296D", # "⥭"
			"lrm" => "\u200E", # "‎"
			"lrtri" => "\u22BF", # "⊿"
			"lsaquo" => "\u2039", # "‹"
			"Lscr" => "\u2112", # "ℒ"
			"lscr" => "\u{1D4C1}", # "𝓁"
			"Lsh" => "\u21B0", # "↰"
			"lsh" => "\u21B0", # "↰"
			"lsim" => "\u2272", # "≲"
			"lsime" => "\u2A8D", # "⪍"
			"lsimg" => "\u2A8F", # "⪏"
			"lsqb" => "[", # "["
			"lsquo" => "\u2018", # "‘"
			"lsquor" => "\u201A", # "‚"
			"Lstrok" => "\u0141", # "Ł"
			"lstrok" => "\u0142", # "ł"
			"LT" => "<", # "<"
			"Lt" => "\u226A", # "≪"
			"lt" => "<", # "<"
			"ltcc" => "\u2AA6", # "⪦"
			"ltcir" => "\u2A79", # "⩹"
			"ltdot" => "\u22D6", # "⋖"
			"lthree" => "\u22CB", # "⋋"
			"ltimes" => "\u22C9", # "⋉"
			"ltlarr" => "\u2976", # "⥶"
			"ltquest" => "\u2A7B", # "⩻"
			"ltri" => "\u25C3", # "◃"
			"ltrie" => "\u22B4", # "⊴"
			"ltrif" => "\u25C2", # "◂"
			"ltrPar" => "\u2996", # "⦖"
			"lurdshar" => "\u294A", # "⥊"
			"luruhar" => "\u2966", # "⥦"
			"lvertneqq" => "\u2268\uFE00", # "≨︀"
			"lvnE" => "\u2268\uFE00", # "≨︀"
			"macr" => "\u00AF", # "¯"
			"male" => "\u2642", # "♂"
			"malt" => "\u2720", # "✠"
			"maltese" => "\u2720", # "✠"
			"Map" => "\u2905", # "⤅"
			"map" => "\u21A6", # "↦"
			"mapsto" => "\u21A6", # "↦"
			"mapstodown" => "\u21A7", # "↧"
			"mapstoleft" => "\u21A4", # "↤"
			"mapstoup" => "\u21A5", # "↥"
			"marker" => "\u25AE", # "▮"
			"mcomma" => "\u2A29", # "⨩"
			"Mcy" => "\u041C", # "М"
			"mcy" => "\u043C", # "м"
			"mdash" => "\u2014", # "—"
			"mDDot" => "\u223A", # "∺"
			"measuredangle" => "\u2221", # "∡"
			"MediumSpace" => "\u205F", # " "
			"Mellintrf" => "\u2133", # "ℳ"
			"Mfr" => "\u{1D510}", # "𝔐"
			"mfr" => "\u{1D52A}", # "𝔪"
			"mho" => "\u2127", # "℧"
			"micro" => "\u00B5", # "µ"
			"mid" => "\u2223", # "∣"
			"midast" => "*", # "*"
			"midcir" => "\u2AF0", # "⫰"
			"middot" => "\u00B7", # "·"
			"minus" => "\u2212", # "−"
			"minusb" => "\u229F", # "⊟"
			"minusd" => "\u2238", # "∸"
			"minusdu" => "\u2A2A", # "⨪"
			"MinusPlus" => "\u2213", # "∓"
			"mlcp" => "\u2ADB", # "⫛"
			"mldr" => "\u2026", # "…"
			"mnplus" => "\u2213", # "∓"
			"models" => "\u22A7", # "⊧"
			"Mopf" => "\u{1D544}", # "𝕄"
			"mopf" => "\u{1D55E}", # "𝕞"
			"mp" => "\u2213", # "∓"
			"Mscr" => "\u2133", # "ℳ"
			"mscr" => "\u{1D4C2}", # "𝓂"
			"mstpos" => "\u223E", # "∾"
			"Mu" => "\u039C", # "Μ"
			"mu" => "\u03BC", # "μ"
			"multimap" => "\u22B8", # "⊸"
			"mumap" => "\u22B8", # "⊸"
			"nabla" => "\u2207", # "∇"
			"Nacute" => "\u0143", # "Ń"
			"nacute" => "\u0144", # "ń"
			"nang" => "\u2220\u20D2", # "∠⃒"
			"nap" => "\u2249", # "≉"
			"napE" => "\u2A70\u0338", # "⩰̸"
			"napid" => "\u224B\u0338", # "≋̸"
			"napos" => "\u0149", # "ŉ"
			"napprox" => "\u2249", # "≉"
			"natur" => "\u266E", # "♮"
			"natural" => "\u266E", # "♮"
			"naturals" => "\u2115", # "ℕ"
			"nbsp" => "\u00A0", # " "
			"nbump" => "\u224E\u0338", # "≎̸"
			"nbumpe" => "\u224F\u0338", # "≏̸"
			"ncap" => "\u2A43", # "⩃"
			"Ncaron" => "\u0147", # "Ň"
			"ncaron" => "\u0148", # "ň"
			"Ncedil" => "\u0145", # "Ņ"
			"ncedil" => "\u0146", # "ņ"
			"ncong" => "\u2247", # "≇"
			"ncongdot" => "\u2A6D\u0338", # "⩭̸"
			"ncup" => "\u2A42", # "⩂"
			"Ncy" => "\u041D", # "Н"
			"ncy" => "\u043D", # "н"
			"ndash" => "\u2013", # "–"
			"ne" => "\u2260", # "≠"
			"nearhk" => "\u2924", # "⤤"
			"neArr" => "\u21D7", # "⇗"
			"nearr" => "\u2197", # "↗"
			"nearrow" => "\u2197", # "↗"
			"nedot" => "\u2250\u0338", # "≐̸"
			"NegativeMediumSpace" => "\u200B", # "​"
			"NegativeThickSpace" => "\u200B", # "​"
			"NegativeThinSpace" => "\u200B", # "​"
			"NegativeVeryThinSpace" => "\u200B", # "​"
			"nequiv" => "\u2262", # "≢"
			"nesear" => "\u2928", # "⤨"
			"nesim" => "\u2242\u0338", # "≂̸"
			"NestedGreaterGreater" => "\u226B", # "≫"
			"NestedLessLess" => "\u226A", # "≪"
			"NewLine" => "\n", # "\n"
			"nexist" => "\u2204", # "∄"
			"nexists" => "\u2204", # "∄"
			"Nfr" => "\u{1D511}", # "𝔑"
			"nfr" => "\u{1D52B}", # "𝔫"
			"ngE" => "\u2267\u0338", # "≧̸"
			"nge" => "\u2271", # "≱"
			"ngeq" => "\u2271", # "≱"
			"ngeqq" => "\u2267\u0338", # "≧̸"
			"ngeqslant" => "\u2A7E\u0338", # "⩾̸"
			"nges" => "\u2A7E\u0338", # "⩾̸"
			"nGg" => "\u22D9\u0338", # "⋙̸"
			"ngsim" => "\u2275", # "≵"
			"nGt" => "\u226B\u20D2", # "≫⃒"
			"ngt" => "\u226F", # "≯"
			"ngtr" => "\u226F", # "≯"
			"nGtv" => "\u226B\u0338", # "≫̸"
			"nhArr" => "\u21CE", # "⇎"
			"nharr" => "\u21AE", # "↮"
			"nhpar" => "\u2AF2", # "⫲"
			"ni" => "\u220B", # "∋"
			"nis" => "\u22FC", # "⋼"
			"nisd" => "\u22FA", # "⋺"
			"niv" => "\u220B", # "∋"
			"NJcy" => "\u040A", # "Њ"
			"njcy" => "\u045A", # "њ"
			"nlArr" => "\u21CD", # "⇍"
			"nlarr" => "\u219A", # "↚"
			"nldr" => "\u2025", # "‥"
			"nlE" => "\u2266\u0338", # "≦̸"
			"nle" => "\u2270", # "≰"
			"nLeftarrow" => "\u21CD", # "⇍"
			"nleftarrow" => "\u219A", # "↚"
			"nLeftrightarrow" => "\u21CE", # "⇎"
			"nleftrightarrow" => "\u21AE", # "↮"
			"nleq" => "\u2270", # "≰"
			"nleqq" => "\u2266\u0338", # "≦̸"
			"nleqslant" => "\u2A7D\u0338", # "⩽̸"
			"nles" => "\u2A7D\u0338", # "⩽̸"
			"nless" => "\u226E", # "≮"
			"nLl" => "\u22D8\u0338", # "⋘̸"
			"nlsim" => "\u2274", # "≴"
			"nLt" => "\u226A\u20D2", # "≪⃒"
			"nlt" => "\u226E", # "≮"
			"nltri" => "\u22EA", # "⋪"
			"nltrie" => "\u22EC", # "⋬"
			"nLtv" => "\u226A\u0338", # "≪̸"
			"nmid" => "\u2224", # "∤"
			"NoBreak" => "\u2060", # "⁠"
			"NonBreakingSpace" => "\u00A0", # " "
			"Nopf" => "\u2115", # "ℕ"
			"nopf" => "\u{1D55F}", # "𝕟"
			"Not" => "\u2AEC", # "⫬"
			"not" => "\u00AC", # "¬"
			"NotCongruent" => "\u2262", # "≢"
			"NotCupCap" => "\u226D", # "≭"
			"NotDoubleVerticalBar" => "\u2226", # "∦"
			"NotElement" => "\u2209", # "∉"
			"NotEqual" => "\u2260", # "≠"
			"NotEqualTilde" => "\u2242\u0338", # "≂̸"
			"NotExists" => "\u2204", # "∄"
			"NotGreater" => "\u226F", # "≯"
			"NotGreaterEqual" => "\u2271", # "≱"
			"NotGreaterFullEqual" => "\u2267\u0338", # "≧̸"
			"NotGreaterGreater" => "\u226B\u0338", # "≫̸"
			"NotGreaterLess" => "\u2279", # "≹"
			"NotGreaterSlantEqual" => "\u2A7E\u0338", # "⩾̸"
			"NotGreaterTilde" => "\u2275", # "≵"
			"NotHumpDownHump" => "\u224E\u0338", # "≎̸"
			"NotHumpEqual" => "\u224F\u0338", # "≏̸"
			"notin" => "\u2209", # "∉"
			"notindot" => "\u22F5\u0338", # "⋵̸"
			"notinE" => "\u22F9\u0338", # "⋹̸"
			"notinva" => "\u2209", # "∉"
			"notinvb" => "\u22F7", # "⋷"
			"notinvc" => "\u22F6", # "⋶"
			"NotLeftTriangle" => "\u22EA", # "⋪"
			"NotLeftTriangleBar" => "\u29CF\u0338", # "⧏̸"
			"NotLeftTriangleEqual" => "\u22EC", # "⋬"
			"NotLess" => "\u226E", # "≮"
			"NotLessEqual" => "\u2270", # "≰"
			"NotLessGreater" => "\u2278", # "≸"
			"NotLessLess" => "\u226A\u0338", # "≪̸"
			"NotLessSlantEqual" => "\u2A7D\u0338", # "⩽̸"
			"NotLessTilde" => "\u2274", # "≴"
			"NotNestedGreaterGreater" => "\u2AA2\u0338", # "⪢̸"
			"NotNestedLessLess" => "\u2AA1\u0338", # "⪡̸"
			"notni" => "\u220C", # "∌"
			"notniva" => "\u220C", # "∌"
			"notnivb" => "\u22FE", # "⋾"
			"notnivc" => "\u22FD", # "⋽"
			"NotPrecedes" => "\u2280", # "⊀"
			"NotPrecedesEqual" => "\u2AAF\u0338", # "⪯̸"
			"NotPrecedesSlantEqual" => "\u22E0", # "⋠"
			"NotReverseElement" => "\u220C", # "∌"
			"NotRightTriangle" => "\u22EB", # "⋫"
			"NotRightTriangleBar" => "\u29D0\u0338", # "⧐̸"
			"NotRightTriangleEqual" => "\u22ED", # "⋭"
			"NotSquareSubset" => "\u228F\u0338", # "⊏̸"
			"NotSquareSubsetEqual" => "\u22E2", # "⋢"
			"NotSquareSuperset" => "\u2290\u0338", # "⊐̸"
			"NotSquareSupersetEqual" => "\u22E3", # "⋣"
			"NotSubset" => "\u2282\u20D2", # "⊂⃒"
			"NotSubsetEqual" => "\u2288", # "⊈"
			"NotSucceeds" => "\u2281", # "⊁"
			"NotSucceedsEqual" => "\u2AB0\u0338", # "⪰̸"
			"NotSucceedsSlantEqual" => "\u22E1", # "⋡"
			"NotSucceedsTilde" => "\u227F\u0338", # "≿̸"
			"NotSuperset" => "\u2283\u20D2", # "⊃⃒"
			"NotSupersetEqual" => "\u2289", # "⊉"
			"NotTilde" => "\u2241", # "≁"
			"NotTildeEqual" => "\u2244", # "≄"
			"NotTildeFullEqual" => "\u2247", # "≇"
			"NotTildeTilde" => "\u2249", # "≉"
			"NotVerticalBar" => "\u2224", # "∤"
			"npar" => "\u2226", # "∦"
			"nparallel" => "\u2226", # "∦"
			"nparsl" => "\u2AFD\u20E5", # "⫽⃥"
			"npart" => "\u2202\u0338", # "∂̸"
			"npolint" => "\u2A14", # "⨔"
			"npr" => "\u2280", # "⊀"
			"nprcue" => "\u22E0", # "⋠"
			"npre" => "\u2AAF\u0338", # "⪯̸"
			"nprec" => "\u2280", # "⊀"
			"npreceq" => "\u2AAF\u0338", # "⪯̸"
			"nrArr" => "\u21CF", # "⇏"
			"nrarr" => "\u219B", # "↛"
			"nrarrc" => "\u2933\u0338", # "⤳̸"
			"nrarrw" => "\u219D\u0338", # "↝̸"
			"nRightarrow" => "\u21CF", # "⇏"
			"nrightarrow" => "\u219B", # "↛"
			"nrtri" => "\u22EB", # "⋫"
			"nrtrie" => "\u22ED", # "⋭"
			"nsc" => "\u2281", # "⊁"
			"nsccue" => "\u22E1", # "⋡"
			"nsce" => "\u2AB0\u0338", # "⪰̸"
			"Nscr" => "\u{1D4A9}", # "𝒩"
			"nscr" => "\u{1D4C3}", # "𝓃"
			"nshortmid" => "\u2224", # "∤"
			"nshortparallel" => "\u2226", # "∦"
			"nsim" => "\u2241", # "≁"
			"nsime" => "\u2244", # "≄"
			"nsimeq" => "\u2244", # "≄"
			"nsmid" => "\u2224", # "∤"
			"nspar" => "\u2226", # "∦"
			"nsqsube" => "\u22E2", # "⋢"
			"nsqsupe" => "\u22E3", # "⋣"
			"nsub" => "\u2284", # "⊄"
			"nsubE" => "\u2AC5\u0338", # "⫅̸"
			"nsube" => "\u2288", # "⊈"
			"nsubset" => "\u2282\u20D2", # "⊂⃒"
			"nsubseteq" => "\u2288", # "⊈"
			"nsubseteqq" => "\u2AC5\u0338", # "⫅̸"
			"nsucc" => "\u2281", # "⊁"
			"nsucceq" => "\u2AB0\u0338", # "⪰̸"
			"nsup" => "\u2285", # "⊅"
			"nsupE" => "\u2AC6\u0338", # "⫆̸"
			"nsupe" => "\u2289", # "⊉"
			"nsupset" => "\u2283\u20D2", # "⊃⃒"
			"nsupseteq" => "\u2289", # "⊉"
			"nsupseteqq" => "\u2AC6\u0338", # "⫆̸"
			"ntgl" => "\u2279", # "≹"
			"Ntilde" => "\u00D1", # "Ñ"
			"ntilde" => "\u00F1", # "ñ"
			"ntlg" => "\u2278", # "≸"
			"ntriangleleft" => "\u22EA", # "⋪"
			"ntrianglelefteq" => "\u22EC", # "⋬"
			"ntriangleright" => "\u22EB", # "⋫"
			"ntrianglerighteq" => "\u22ED", # "⋭"
			"Nu" => "\u039D", # "Ν"
			"nu" => "\u03BD", # "ν"
			"num" => "#", # "#"
			"numero" => "\u2116", # "№"
			"numsp" => "\u2007", # " "
			"nvap" => "\u224D\u20D2", # "≍⃒"
			"nVDash" => "\u22AF", # "⊯"
			"nVdash" => "\u22AE", # "⊮"
			"nvDash" => "\u22AD", # "⊭"
			"nvdash" => "\u22AC", # "⊬"
			"nvge" => "\u2265\u20D2", # "≥⃒"
			"nvgt" => ">\u20D2", # ">⃒"
			"nvHarr" => "\u2904", # "⤄"
			"nvinfin" => "\u29DE", # "⧞"
			"nvlArr" => "\u2902", # "⤂"
			"nvle" => "\u2264\u20D2", # "≤⃒"
			"nvlt" => "<\u20D2", # "<⃒"
			"nvltrie" => "\u22B4\u20D2", # "⊴⃒"
			"nvrArr" => "\u2903", # "⤃"
			"nvrtrie" => "\u22B5\u20D2", # "⊵⃒"
			"nvsim" => "\u223C\u20D2", # "∼⃒"
			"nwarhk" => "\u2923", # "⤣"
			"nwArr" => "\u21D6", # "⇖"
			"nwarr" => "\u2196", # "↖"
			"nwarrow" => "\u2196", # "↖"
			"nwnear" => "\u2927", # "⤧"
			"Oacute" => "\u00D3", # "Ó"
			"oacute" => "\u00F3", # "ó"
			"oast" => "\u229B", # "⊛"
			"ocir" => "\u229A", # "⊚"
			"Ocirc" => "\u00D4", # "Ô"
			"ocirc" => "\u00F4", # "ô"
			"Ocy" => "\u041E", # "О"
			"ocy" => "\u043E", # "о"
			"odash" => "\u229D", # "⊝"
			"Odblac" => "\u0150", # "Ő"
			"odblac" => "\u0151", # "ő"
			"odiv" => "\u2A38", # "⨸"
			"odot" => "\u2299", # "⊙"
			"odsold" => "\u29BC", # "⦼"
			"OElig" => "\u0152", # "Œ"
			"oelig" => "\u0153", # "œ"
			"ofcir" => "\u29BF", # "⦿"
			"Ofr" => "\u{1D512}", # "𝔒"
			"ofr" => "\u{1D52C}", # "𝔬"
			"ogon" => "\u02DB", # "˛"
			"Ograve" => "\u00D2", # "Ò"
			"ograve" => "\u00F2", # "ò"
			"ogt" => "\u29C1", # "⧁"
			"ohbar" => "\u29B5", # "⦵"
			"ohm" => "\u03A9", # "Ω"
			"oint" => "\u222E", # "∮"
			"olarr" => "\u21BA", # "↺"
			"olcir" => "\u29BE", # "⦾"
			"olcross" => "\u29BB", # "⦻"
			"oline" => "\u203E", # "‾"
			"olt" => "\u29C0", # "⧀"
			"Omacr" => "\u014C", # "Ō"
			"omacr" => "\u014D", # "ō"
			"Omega" => "\u03A9", # "Ω"
			"omega" => "\u03C9", # "ω"
			"Omicron" => "\u039F", # "Ο"
			"omicron" => "\u03BF", # "ο"
			"omid" => "\u29B6", # "⦶"
			"ominus" => "\u2296", # "⊖"
			"Oopf" => "\u{1D546}", # "𝕆"
			"oopf" => "\u{1D560}", # "𝕠"
			"opar" => "\u29B7", # "⦷"
			"OpenCurlyDoubleQuote" => "\u201C", # "“"
			"OpenCurlyQuote" => "\u2018", # "‘"
			"operp" => "\u29B9", # "⦹"
			"oplus" => "\u2295", # "⊕"
			"Or" => "\u2A54", # "⩔"
			"or" => "\u2228", # "∨"
			"orarr" => "\u21BB", # "↻"
			"ord" => "\u2A5D", # "⩝"
			"order" => "\u2134", # "ℴ"
			"orderof" => "\u2134", # "ℴ"
			"ordf" => "\u00AA", # "ª"
			"ordm" => "\u00BA", # "º"
			"origof" => "\u22B6", # "⊶"
			"oror" => "\u2A56", # "⩖"
			"orslope" => "\u2A57", # "⩗"
			"orv" => "\u2A5B", # "⩛"
			"oS" => "\u24C8", # "Ⓢ"
			"Oscr" => "\u{1D4AA}", # "𝒪"
			"oscr" => "\u2134", # "ℴ"
			"Oslash" => "\u00D8", # "Ø"
			"oslash" => "\u00F8", # "ø"
			"osol" => "\u2298", # "⊘"
			"Otilde" => "\u00D5", # "Õ"
			"otilde" => "\u00F5", # "õ"
			"Otimes" => "\u2A37", # "⨷"
			"otimes" => "\u2297", # "⊗"
			"otimesas" => "\u2A36", # "⨶"
			"Ouml" => "\u00D6", # "Ö"
			"ouml" => "\u00F6", # "ö"
			"ovbar" => "\u233D", # "⌽"
			"OverBar" => "\u203E", # "‾"
			"OverBrace" => "\u23DE", # "⏞"
			"OverBracket" => "\u23B4", # "⎴"
			"OverParenthesis" => "\u23DC", # "⏜"
			"par" => "\u2225", # "∥"
			"para" => "\u00B6", # "¶"
			"parallel" => "\u2225", # "∥"
			"parsim" => "\u2AF3", # "⫳"
			"parsl" => "\u2AFD", # "⫽"
			"part" => "\u2202", # "∂"
			"PartialD" => "\u2202", # "∂"
			"Pcy" => "\u041F", # "П"
			"pcy" => "\u043F", # "п"
			"percnt" => "%", # "%"
			"period" => ".", # "."
			"permil" => "\u2030", # "‰"
			"perp" => "\u22A5", # "⊥"
			"pertenk" => "\u2031", # "‱"
			"Pfr" => "\u{1D513}", # "𝔓"
			"pfr" => "\u{1D52D}", # "𝔭"
			"Phi" => "\u03A6", # "Φ"
			"phi" => "\u03C6", # "φ"
			"phiv" => "\u03D5", # "ϕ"
			"phmmat" => "\u2133", # "ℳ"
			"phone" => "\u260E", # "☎"
			"Pi" => "\u03A0", # "Π"
			"pi" => "\u03C0", # "π"
			"pitchfork" => "\u22D4", # "⋔"
			"piv" => "\u03D6", # "ϖ"
			"planck" => "\u210F", # "ℏ"
			"planckh" => "\u210E", # "ℎ"
			"plankv" => "\u210F", # "ℏ"
			"plus" => "+", # "+"
			"plusacir" => "\u2A23", # "⨣"
			"plusb" => "\u229E", # "⊞"
			"pluscir" => "\u2A22", # "⨢"
			"plusdo" => "\u2214", # "∔"
			"plusdu" => "\u2A25", # "⨥"
			"pluse" => "\u2A72", # "⩲"
			"PlusMinus" => "\u00B1", # "±"
			"plusmn" => "\u00B1", # "±"
			"plussim" => "\u2A26", # "⨦"
			"plustwo" => "\u2A27", # "⨧"
			"pm" => "\u00B1", # "±"
			"Poincareplane" => "\u210C", # "ℌ"
			"pointint" => "\u2A15", # "⨕"
			"Popf" => "\u2119", # "ℙ"
			"popf" => "\u{1D561}", # "𝕡"
			"pound" => "\u00A3", # "£"
			"Pr" => "\u2ABB", # "⪻"
			"pr" => "\u227A", # "≺"
			"prap" => "\u2AB7", # "⪷"
			"prcue" => "\u227C", # "≼"
			"prE" => "\u2AB3", # "⪳"
			"pre" => "\u2AAF", # "⪯"
			"prec" => "\u227A", # "≺"
			"precapprox" => "\u2AB7", # "⪷"
			"preccurlyeq" => "\u227C", # "≼"
			"Precedes" => "\u227A", # "≺"
			"PrecedesEqual" => "\u2AAF", # "⪯"
			"PrecedesSlantEqual" => "\u227C", # "≼"
			"PrecedesTilde" => "\u227E", # "≾"
			"preceq" => "\u2AAF", # "⪯"
			"precnapprox" => "\u2AB9", # "⪹"
			"precneqq" => "\u2AB5", # "⪵"
			"precnsim" => "\u22E8", # "⋨"
			"precsim" => "\u227E", # "≾"
			"Prime" => "\u2033", # "″"
			"prime" => "\u2032", # "′"
			"primes" => "\u2119", # "ℙ"
			"prnap" => "\u2AB9", # "⪹"
			"prnE" => "\u2AB5", # "⪵"
			"prnsim" => "\u22E8", # "⋨"
			"prod" => "\u220F", # "∏"
			"Product" => "\u220F", # "∏"
			"profalar" => "\u232E", # "⌮"
			"profline" => "\u2312", # "⌒"
			"profsurf" => "\u2313", # "⌓"
			"prop" => "\u221D", # "∝"
			"Proportion" => "\u2237", # "∷"
			"Proportional" => "\u221D", # "∝"
			"propto" => "\u221D", # "∝"
			"prsim" => "\u227E", # "≾"
			"prurel" => "\u22B0", # "⊰"
			"Pscr" => "\u{1D4AB}", # "𝒫"
			"pscr" => "\u{1D4C5}", # "𝓅"
			"Psi" => "\u03A8", # "Ψ"
			"psi" => "\u03C8", # "ψ"
			"puncsp" => "\u2008", # " "
			"Qfr" => "\u{1D514}", # "𝔔"
			"qfr" => "\u{1D52E}", # "𝔮"
			"qint" => "\u2A0C", # "⨌"
			"Qopf" => "\u211A", # "ℚ"
			"qopf" => "\u{1D562}", # "𝕢"
			"qprime" => "\u2057", # "⁗"
			"Qscr" => "\u{1D4AC}", # "𝒬"
			"qscr" => "\u{1D4C6}", # "𝓆"
			"quaternions" => "\u210D", # "ℍ"
			"quatint" => "\u2A16", # "⨖"
			"quest" => "?", # "?"
			"questeq" => "\u225F", # "≟"
			"QUOT" => "\"", # "\""
			"quot" => "\"", # "\""
			"rAarr" => "\u21DB", # "⇛"
			"race" => "\u223D\u0331", # "∽̱"
			"Racute" => "\u0154", # "Ŕ"
			"racute" => "\u0155", # "ŕ"
			"radic" => "\u221A", # "√"
			"raemptyv" => "\u29B3", # "⦳"
			"Rang" => "\u27EB", # "⟫"
			"rang" => "\u27E9", # "⟩"
			"rangd" => "\u2992", # "⦒"
			"range" => "\u29A5", # "⦥"
			"rangle" => "\u27E9", # "⟩"
			"raquo" => "\u00BB", # "»"
			"Rarr" => "\u21A0", # "↠"
			"rArr" => "\u21D2", # "⇒"
			"rarr" => "\u2192", # "→"
			"rarrap" => "\u2975", # "⥵"
			"rarrb" => "\u21E5", # "⇥"
			"rarrbfs" => "\u2920", # "⤠"
			"rarrc" => "\u2933", # "⤳"
			"rarrfs" => "\u291E", # "⤞"
			"rarrhk" => "\u21AA", # "↪"
			"rarrlp" => "\u21AC", # "↬"
			"rarrpl" => "\u2945", # "⥅"
			"rarrsim" => "\u2974", # "⥴"
			"Rarrtl" => "\u2916", # "⤖"
			"rarrtl" => "\u21A3", # "↣"
			"rarrw" => "\u219D", # "↝"
			"rAtail" => "\u291C", # "⤜"
			"ratail" => "\u291A", # "⤚"
			"ratio" => "\u2236", # "∶"
			"rationals" => "\u211A", # "ℚ"
			"RBarr" => "\u2910", # "⤐"
			"rBarr" => "\u290F", # "⤏"
			"rbarr" => "\u290D", # "⤍"
			"rbbrk" => "\u2773", # "❳"
			"rbrace" => "}", # "}"
			"rbrack" => "]", # "]"
			"rbrke" => "\u298C", # "⦌"
			"rbrksld" => "\u298E", # "⦎"
			"rbrkslu" => "\u2990", # "⦐"
			"Rcaron" => "\u0158", # "Ř"
			"rcaron" => "\u0159", # "ř"
			"Rcedil" => "\u0156", # "Ŗ"
			"rcedil" => "\u0157", # "ŗ"
			"rceil" => "\u2309", # "⌉"
			"rcub" => "}", # "}"
			"Rcy" => "\u0420", # "Р"
			"rcy" => "\u0440", # "р"
			"rdca" => "\u2937", # "⤷"
			"rdldhar" => "\u2969", # "⥩"
			"rdquo" => "\u201D", # "”"
			"rdquor" => "\u201D", # "”"
			"rdsh" => "\u21B3", # "↳"
			"Re" => "\u211C", # "ℜ"
			"real" => "\u211C", # "ℜ"
			"realine" => "\u211B", # "ℛ"
			"realpart" => "\u211C", # "ℜ"
			"reals" => "\u211D", # "ℝ"
			"rect" => "\u25AD", # "▭"
			"REG" => "\u00AE", # "®"
			"reg" => "\u00AE", # "®"
			"ReverseElement" => "\u220B", # "∋"
			"ReverseEquilibrium" => "\u21CB", # "⇋"
			"ReverseUpEquilibrium" => "\u296F", # "⥯"
			"rfisht" => "\u297D", # "⥽"
			"rfloor" => "\u230B", # "⌋"
			"Rfr" => "\u211C", # "ℜ"
			"rfr" => "\u{1D52F}", # "𝔯"
			"rHar" => "\u2964", # "⥤"
			"rhard" => "\u21C1", # "⇁"
			"rharu" => "\u21C0", # "⇀"
			"rharul" => "\u296C", # "⥬"
			"Rho" => "\u03A1", # "Ρ"
			"rho" => "\u03C1", # "ρ"
			"rhov" => "\u03F1", # "ϱ"
			"RightAngleBracket" => "\u27E9", # "⟩"
			"RightArrow" => "\u2192", # "→"
			"Rightarrow" => "\u21D2", # "⇒"
			"rightarrow" => "\u2192", # "→"
			"RightArrowBar" => "\u21E5", # "⇥"
			"RightArrowLeftArrow" => "\u21C4", # "⇄"
			"rightarrowtail" => "\u21A3", # "↣"
			"RightCeiling" => "\u2309", # "⌉"
			"RightDoubleBracket" => "\u27E7", # "⟧"
			"RightDownTeeVector" => "\u295D", # "⥝"
			"RightDownVector" => "\u21C2", # "⇂"
			"RightDownVectorBar" => "\u2955", # "⥕"
			"RightFloor" => "\u230B", # "⌋"
			"rightharpoondown" => "\u21C1", # "⇁"
			"rightharpoonup" => "\u21C0", # "⇀"
			"rightleftarrows" => "\u21C4", # "⇄"
			"rightleftharpoons" => "\u21CC", # "⇌"
			"rightrightarrows" => "\u21C9", # "⇉"
			"rightsquigarrow" => "\u219D", # "↝"
			"RightTee" => "\u22A2", # "⊢"
			"RightTeeArrow" => "\u21A6", # "↦"
			"RightTeeVector" => "\u295B", # "⥛"
			"rightthreetimes" => "\u22CC", # "⋌"
			"RightTriangle" => "\u22B3", # "⊳"
			"RightTriangleBar" => "\u29D0", # "⧐"
			"RightTriangleEqual" => "\u22B5", # "⊵"
			"RightUpDownVector" => "\u294F", # "⥏"
			"RightUpTeeVector" => "\u295C", # "⥜"
			"RightUpVector" => "\u21BE", # "↾"
			"RightUpVectorBar" => "\u2954", # "⥔"
			"RightVector" => "\u21C0", # "⇀"
			"RightVectorBar" => "\u2953", # "⥓"
			"ring" => "\u02DA", # "˚"
			"risingdotseq" => "\u2253", # "≓"
			"rlarr" => "\u21C4", # "⇄"
			"rlhar" => "\u21CC", # "⇌"
			"rlm" => "\u200F", # "‏"
			"rmoust" => "\u23B1", # "⎱"
			"rmoustache" => "\u23B1", # "⎱"
			"rnmid" => "\u2AEE", # "⫮"
			"roang" => "\u27ED", # "⟭"
			"roarr" => "\u21FE", # "⇾"
			"robrk" => "\u27E7", # "⟧"
			"ropar" => "\u2986", # "⦆"
			"Ropf" => "\u211D", # "ℝ"
			"ropf" => "\u{1D563}", # "𝕣"
			"roplus" => "\u2A2E", # "⨮"
			"rotimes" => "\u2A35", # "⨵"
			"RoundImplies" => "\u2970", # "⥰"
			"rpar" => ")", # ")"
			"rpargt" => "\u2994", # "⦔"
			"rppolint" => "\u2A12", # "⨒"
			"rrarr" => "\u21C9", # "⇉"
			"Rrightarrow" => "\u21DB", # "⇛"
			"rsaquo" => "\u203A", # "›"
			"Rscr" => "\u211B", # "ℛ"
			"rscr" => "\u{1D4C7}", # "𝓇"
			"Rsh" => "\u21B1", # "↱"
			"rsh" => "\u21B1", # "↱"
			"rsqb" => "]", # "]"
			"rsquo" => "\u2019", # "’"
			"rsquor" => "\u2019", # "’"
			"rthree" => "\u22CC", # "⋌"
			"rtimes" => "\u22CA", # "⋊"
			"rtri" => "\u25B9", # "▹"
			"rtrie" => "\u22B5", # "⊵"
			"rtrif" => "\u25B8", # "▸"
			"rtriltri" => "\u29CE", # "⧎"
			"RuleDelayed" => "\u29F4", # "⧴"
			"ruluhar" => "\u2968", # "⥨"
			"rx" => "\u211E", # "℞"
			"Sacute" => "\u015A", # "Ś"
			"sacute" => "\u015B", # "ś"
			"sbquo" => "\u201A", # "‚"
			"Sc" => "\u2ABC", # "⪼"
			"sc" => "\u227B", # "≻"
			"scap" => "\u2AB8", # "⪸"
			"Scaron" => "\u0160", # "Š"
			"scaron" => "\u0161", # "š"
			"sccue" => "\u227D", # "≽"
			"scE" => "\u2AB4", # "⪴"
			"sce" => "\u2AB0", # "⪰"
			"Scedil" => "\u015E", # "Ş"
			"scedil" => "\u015F", # "ş"
			"Scirc" => "\u015C", # "Ŝ"
			"scirc" => "\u015D", # "ŝ"
			"scnap" => "\u2ABA", # "⪺"
			"scnE" => "\u2AB6", # "⪶"
			"scnsim" => "\u22E9", # "⋩"
			"scpolint" => "\u2A13", # "⨓"
			"scsim" => "\u227F", # "≿"
			"Scy" => "\u0421", # "С"
			"scy" => "\u0441", # "с"
			"sdot" => "\u22C5", # "⋅"
			"sdotb" => "\u22A1", # "⊡"
			"sdote" => "\u2A66", # "⩦"
			"searhk" => "\u2925", # "⤥"
			"seArr" => "\u21D8", # "⇘"
			"searr" => "\u2198", # "↘"
			"searrow" => "\u2198", # "↘"
			"sect" => "\u00A7", # "§"
			"semi" => ";", # ";"
			"seswar" => "\u2929", # "⤩"
			"setminus" => "\u2216", # "∖"
			"setmn" => "\u2216", # "∖"
			"sext" => "\u2736", # "✶"
			"Sfr" => "\u{1D516}", # "𝔖"
			"sfr" => "\u{1D530}", # "𝔰"
			"sfrown" => "\u2322", # "⌢"
			"sharp" => "\u266F", # "♯"
			"SHCHcy" => "\u0429", # "Щ"
			"shchcy" => "\u0449", # "щ"
			"SHcy" => "\u0428", # "Ш"
			"shcy" => "\u0448", # "ш"
			"ShortDownArrow" => "\u2193", # "↓"
			"ShortLeftArrow" => "\u2190", # "←"
			"shortmid" => "\u2223", # "∣"
			"shortparallel" => "\u2225", # "∥"
			"ShortRightArrow" => "\u2192", # "→"
			"ShortUpArrow" => "\u2191", # "↑"
			"shy" => "\u00AD", # "­"
			"Sigma" => "\u03A3", # "Σ"
			"sigma" => "\u03C3", # "σ"
			"sigmaf" => "\u03C2", # "ς"
			"sigmav" => "\u03C2", # "ς"
			"sim" => "\u223C", # "∼"
			"simdot" => "\u2A6A", # "⩪"
			"sime" => "\u2243", # "≃"
			"simeq" => "\u2243", # "≃"
			"simg" => "\u2A9E", # "⪞"
			"simgE" => "\u2AA0", # "⪠"
			"siml" => "\u2A9D", # "⪝"
			"simlE" => "\u2A9F", # "⪟"
			"simne" => "\u2246", # "≆"
			"simplus" => "\u2A24", # "⨤"
			"simrarr" => "\u2972", # "⥲"
			"slarr" => "\u2190", # "←"
			"SmallCircle" => "\u2218", # "∘"
			"smallsetminus" => "\u2216", # "∖"
			"smashp" => "\u2A33", # "⨳"
			"smeparsl" => "\u29E4", # "⧤"
			"smid" => "\u2223", # "∣"
			"smile" => "\u2323", # "⌣"
			"smt" => "\u2AAA", # "⪪"
			"smte" => "\u2AAC", # "⪬"
			"smtes" => "\u2AAC\uFE00", # "⪬︀"
			"SOFTcy" => "\u042C", # "Ь"
			"softcy" => "\u044C", # "ь"
			"sol" => "/", # "/"
			"solb" => "\u29C4", # "⧄"
			"solbar" => "\u233F", # "⌿"
			"Sopf" => "\u{1D54A}", # "𝕊"
			"sopf" => "\u{1D564}", # "𝕤"
			"spades" => "\u2660", # "♠"
			"spadesuit" => "\u2660", # "♠"
			"spar" => "\u2225", # "∥"
			"sqcap" => "\u2293", # "⊓"
			"sqcaps" => "\u2293\uFE00", # "⊓︀"
			"sqcup" => "\u2294", # "⊔"
			"sqcups" => "\u2294\uFE00", # "⊔︀"
			"Sqrt" => "\u221A", # "√"
			"sqsub" => "\u228F", # "⊏"
			"sqsube" => "\u2291", # "⊑"
			"sqsubset" => "\u228F", # "⊏"
			"sqsubseteq" => "\u2291", # "⊑"
			"sqsup" => "\u2290", # "⊐"
			"sqsupe" => "\u2292", # "⊒"
			"sqsupset" => "\u2290", # "⊐"
			"sqsupseteq" => "\u2292", # "⊒"
			"squ" => "\u25A1", # "□"
			"Square" => "\u25A1", # "□"
			"square" => "\u25A1", # "□"
			"SquareIntersection" => "\u2293", # "⊓"
			"SquareSubset" => "\u228F", # "⊏"
			"SquareSubsetEqual" => "\u2291", # "⊑"
			"SquareSuperset" => "\u2290", # "⊐"
			"SquareSupersetEqual" => "\u2292", # "⊒"
			"SquareUnion" => "\u2294", # "⊔"
			"squarf" => "\u25AA", # "▪"
			"squf" => "\u25AA", # "▪"
			"srarr" => "\u2192", # "→"
			"Sscr" => "\u{1D4AE}", # "𝒮"
			"sscr" => "\u{1D4C8}", # "𝓈"
			"ssetmn" => "\u2216", # "∖"
			"ssmile" => "\u2323", # "⌣"
			"sstarf" => "\u22C6", # "⋆"
			"Star" => "\u22C6", # "⋆"
			"star" => "\u2606", # "☆"
			"starf" => "\u2605", # "★"
			"straightepsilon" => "\u03F5", # "ϵ"
			"straightphi" => "\u03D5", # "ϕ"
			"strns" => "\u00AF", # "¯"
			"Sub" => "\u22D0", # "⋐"
			"sub" => "\u2282", # "⊂"
			"subdot" => "\u2ABD", # "⪽"
			"subE" => "\u2AC5", # "⫅"
			"sube" => "\u2286", # "⊆"
			"subedot" => "\u2AC3", # "⫃"
			"submult" => "\u2AC1", # "⫁"
			"subnE" => "\u2ACB", # "⫋"
			"subne" => "\u228A", # "⊊"
			"subplus" => "\u2ABF", # "⪿"
			"subrarr" => "\u2979", # "⥹"
			"Subset" => "\u22D0", # "⋐"
			"subset" => "\u2282", # "⊂"
			"subseteq" => "\u2286", # "⊆"
			"subseteqq" => "\u2AC5", # "⫅"
			"SubsetEqual" => "\u2286", # "⊆"
			"subsetneq" => "\u228A", # "⊊"
			"subsetneqq" => "\u2ACB", # "⫋"
			"subsim" => "\u2AC7", # "⫇"
			"subsub" => "\u2AD5", # "⫕"
			"subsup" => "\u2AD3", # "⫓"
			"succ" => "\u227B", # "≻"
			"succapprox" => "\u2AB8", # "⪸"
			"succcurlyeq" => "\u227D", # "≽"
			"Succeeds" => "\u227B", # "≻"
			"SucceedsEqual" => "\u2AB0", # "⪰"
			"SucceedsSlantEqual" => "\u227D", # "≽"
			"SucceedsTilde" => "\u227F", # "≿"
			"succeq" => "\u2AB0", # "⪰"
			"succnapprox" => "\u2ABA", # "⪺"
			"succneqq" => "\u2AB6", # "⪶"
			"succnsim" => "\u22E9", # "⋩"
			"succsim" => "\u227F", # "≿"
			"SuchThat" => "\u220B", # "∋"
			"Sum" => "\u2211", # "∑"
			"sum" => "\u2211", # "∑"
			"sung" => "\u266A", # "♪"
			"Sup" => "\u22D1", # "⋑"
			"sup" => "\u2283", # "⊃"
			"sup1" => "\u00B9", # "¹"
			"sup2" => "\u00B2", # "²"
			"sup3" => "\u00B3", # "³"
			"supdot" => "\u2ABE", # "⪾"
			"supdsub" => "\u2AD8", # "⫘"
			"supE" => "\u2AC6", # "⫆"
			"supe" => "\u2287", # "⊇"
			"supedot" => "\u2AC4", # "⫄"
			"Superset" => "\u2283", # "⊃"
			"SupersetEqual" => "\u2287", # "⊇"
			"suphsol" => "\u27C9", # "⟉"
			"suphsub" => "\u2AD7", # "⫗"
			"suplarr" => "\u297B", # "⥻"
			"supmult" => "\u2AC2", # "⫂"
			"supnE" => "\u2ACC", # "⫌"
			"supne" => "\u228B", # "⊋"
			"supplus" => "\u2AC0", # "⫀"
			"Supset" => "\u22D1", # "⋑"
			"supset" => "\u2283", # "⊃"
			"supseteq" => "\u2287", # "⊇"
			"supseteqq" => "\u2AC6", # "⫆"
			"supsetneq" => "\u228B", # "⊋"
			"supsetneqq" => "\u2ACC", # "⫌"
			"supsim" => "\u2AC8", # "⫈"
			"supsub" => "\u2AD4", # "⫔"
			"supsup" => "\u2AD6", # "⫖"
			"swarhk" => "\u2926", # "⤦"
			"swArr" => "\u21D9", # "⇙"
			"swarr" => "\u2199", # "↙"
			"swarrow" => "\u2199", # "↙"
			"swnwar" => "\u292A", # "⤪"
			"szlig" => "\u00DF", # "ß"
			"Tab" => "\t", # "\t"
			"target" => "\u2316", # "⌖"
			"Tau" => "\u03A4", # "Τ"
			"tau" => "\u03C4", # "τ"
			"tbrk" => "\u23B4", # "⎴"
			"Tcaron" => "\u0164", # "Ť"
			"tcaron" => "\u0165", # "ť"
			"Tcedil" => "\u0162", # "Ţ"
			"tcedil" => "\u0163", # "ţ"
			"Tcy" => "\u0422", # "Т"
			"tcy" => "\u0442", # "т"
			"tdot" => "\u20DB", # "⃛"
			"telrec" => "\u2315", # "⌕"
			"Tfr" => "\u{1D517}", # "𝔗"
			"tfr" => "\u{1D531}", # "𝔱"
			"there4" => "\u2234", # "∴"
			"Therefore" => "\u2234", # "∴"
			"therefore" => "\u2234", # "∴"
			"Theta" => "\u0398", # "Θ"
			"theta" => "\u03B8", # "θ"
			"thetasym" => "\u03D1", # "ϑ"
			"thetav" => "\u03D1", # "ϑ"
			"thickapprox" => "\u2248", # "≈"
			"thicksim" => "\u223C", # "∼"
			"ThickSpace" => "\u205F\u200A", # "  "
			"thinsp" => "\u2009", # " "
			"ThinSpace" => "\u2009", # " "
			"thkap" => "\u2248", # "≈"
			"thksim" => "\u223C", # "∼"
			"THORN" => "\u00DE", # "Þ"
			"thorn" => "\u00FE", # "þ"
			"Tilde" => "\u223C", # "∼"
			"tilde" => "\u02DC", # "˜"
			"TildeEqual" => "\u2243", # "≃"
			"TildeFullEqual" => "\u2245", # "≅"
			"TildeTilde" => "\u2248", # "≈"
			"times" => "\u00D7", # "×"
			"timesb" => "\u22A0", # "⊠"
			"timesbar" => "\u2A31", # "⨱"
			"timesd" => "\u2A30", # "⨰"
			"tint" => "\u222D", # "∭"
			"toea" => "\u2928", # "⤨"
			"top" => "\u22A4", # "⊤"
			"topbot" => "\u2336", # "⌶"
			"topcir" => "\u2AF1", # "⫱"
			"Topf" => "\u{1D54B}", # "𝕋"
			"topf" => "\u{1D565}", # "𝕥"
			"topfork" => "\u2ADA", # "⫚"
			"tosa" => "\u2929", # "⤩"
			"tprime" => "\u2034", # "‴"
			"TRADE" => "\u2122", # "™"
			"trade" => "\u2122", # "™"
			"triangle" => "\u25B5", # "▵"
			"triangledown" => "\u25BF", # "▿"
			"triangleleft" => "\u25C3", # "◃"
			"trianglelefteq" => "\u22B4", # "⊴"
			"triangleq" => "\u225C", # "≜"
			"triangleright" => "\u25B9", # "▹"
			"trianglerighteq" => "\u22B5", # "⊵"
			"tridot" => "\u25EC", # "◬"
			"trie" => "\u225C", # "≜"
			"triminus" => "\u2A3A", # "⨺"
			"TripleDot" => "\u20DB", # "⃛"
			"triplus" => "\u2A39", # "⨹"
			"trisb" => "\u29CD", # "⧍"
			"tritime" => "\u2A3B", # "⨻"
			"trpezium" => "\u23E2", # "⏢"
			"Tscr" => "\u{1D4AF}", # "𝒯"
			"tscr" => "\u{1D4C9}", # "𝓉"
			"TScy" => "\u0426", # "Ц"
			"tscy" => "\u0446", # "ц"
			"TSHcy" => "\u040B", # "Ћ"
			"tshcy" => "\u045B", # "ћ"
			"Tstrok" => "\u0166", # "Ŧ"
			"tstrok" => "\u0167", # "ŧ"
			"twixt" => "\u226C", # "≬"
			"twoheadleftarrow" => "\u219E", # "↞"
			"twoheadrightarrow" => "\u21A0", # "↠"
			"Uacute" => "\u00DA", # "Ú"
			"uacute" => "\u00FA", # "ú"
			"Uarr" => "\u219F", # "↟"
			"uArr" => "\u21D1", # "⇑"
			"uarr" => "\u2191", # "↑"
			"Uarrocir" => "\u2949", # "⥉"
			"Ubrcy" => "\u040E", # "Ў"
			"ubrcy" => "\u045E", # "ў"
			"Ubreve" => "\u016C", # "Ŭ"
			"ubreve" => "\u016D", # "ŭ"
			"Ucirc" => "\u00DB", # "Û"
			"ucirc" => "\u00FB", # "û"
			"Ucy" => "\u0423", # "У"
			"ucy" => "\u0443", # "у"
			"udarr" => "\u21C5", # "⇅"
			"Udblac" => "\u0170", # "Ű"
			"udblac" => "\u0171", # "ű"
			"udhar" => "\u296E", # "⥮"
			"ufisht" => "\u297E", # "⥾"
			"Ufr" => "\u{1D518}", # "𝔘"
			"ufr" => "\u{1D532}", # "𝔲"
			"Ugrave" => "\u00D9", # "Ù"
			"ugrave" => "\u00F9", # "ù"
			"uHar" => "\u2963", # "⥣"
			"uharl" => "\u21BF", # "↿"
			"uharr" => "\u21BE", # "↾"
			"uhblk" => "\u2580", # "▀"
			"ulcorn" => "\u231C", # "⌜"
			"ulcorner" => "\u231C", # "⌜"
			"ulcrop" => "\u230F", # "⌏"
			"ultri" => "\u25F8", # "◸"
			"Umacr" => "\u016A", # "Ū"
			"umacr" => "\u016B", # "ū"
			"uml" => "\u00A8", # "¨"
			"UnderBar" => "_", # "_"
			"UnderBrace" => "\u23DF", # "⏟"
			"UnderBracket" => "\u23B5", # "⎵"
			"UnderParenthesis" => "\u23DD", # "⏝"
			"Union" => "\u22C3", # "⋃"
			"UnionPlus" => "\u228E", # "⊎"
			"Uogon" => "\u0172", # "Ų"
			"uogon" => "\u0173", # "ų"
			"Uopf" => "\u{1D54C}", # "𝕌"
			"uopf" => "\u{1D566}", # "𝕦"
			"UpArrow" => "\u2191", # "↑"
			"Uparrow" => "\u21D1", # "⇑"
			"uparrow" => "\u2191", # "↑"
			"UpArrowBar" => "\u2912", # "⤒"
			"UpArrowDownArrow" => "\u21C5", # "⇅"
			"UpDownArrow" => "\u2195", # "↕"
			"Updownarrow" => "\u21D5", # "⇕"
			"updownarrow" => "\u2195", # "↕"
			"UpEquilibrium" => "\u296E", # "⥮"
			"upharpoonleft" => "\u21BF", # "↿"
			"upharpoonright" => "\u21BE", # "↾"
			"uplus" => "\u228E", # "⊎"
			"UpperLeftArrow" => "\u2196", # "↖"
			"UpperRightArrow" => "\u2197", # "↗"
			"Upsi" => "\u03D2", # "ϒ"
			"upsi" => "\u03C5", # "υ"
			"upsih" => "\u03D2", # "ϒ"
			"Upsilon" => "\u03A5", # "Υ"
			"upsilon" => "\u03C5", # "υ"
			"UpTee" => "\u22A5", # "⊥"
			"UpTeeArrow" => "\u21A5", # "↥"
			"upuparrows" => "\u21C8", # "⇈"
			"urcorn" => "\u231D", # "⌝"
			"urcorner" => "\u231D", # "⌝"
			"urcrop" => "\u230E", # "⌎"
			"Uring" => "\u016E", # "Ů"
			"uring" => "\u016F", # "ů"
			"urtri" => "\u25F9", # "◹"
			"Uscr" => "\u{1D4B0}", # "𝒰"
			"uscr" => "\u{1D4CA}", # "𝓊"
			"utdot" => "\u22F0", # "⋰"
			"Utilde" => "\u0168", # "Ũ"
			"utilde" => "\u0169", # "ũ"
			"utri" => "\u25B5", # "▵"
			"utrif" => "\u25B4", # "▴"
			"uuarr" => "\u21C8", # "⇈"
			"Uuml" => "\u00DC", # "Ü"
			"uuml" => "\u00FC", # "ü"
			"uwangle" => "\u29A7", # "⦧"
			"vangrt" => "\u299C", # "⦜"
			"varepsilon" => "\u03F5", # "ϵ"
			"varkappa" => "\u03F0", # "ϰ"
			"varnothing" => "\u2205", # "∅"
			"varphi" => "\u03D5", # "ϕ"
			"varpi" => "\u03D6", # "ϖ"
			"varpropto" => "\u221D", # "∝"
			"vArr" => "\u21D5", # "⇕"
			"varr" => "\u2195", # "↕"
			"varrho" => "\u03F1", # "ϱ"
			"varsigma" => "\u03C2", # "ς"
			"varsubsetneq" => "\u228A\uFE00", # "⊊︀"
			"varsubsetneqq" => "\u2ACB\uFE00", # "⫋︀"
			"varsupsetneq" => "\u228B\uFE00", # "⊋︀"
			"varsupsetneqq" => "\u2ACC\uFE00", # "⫌︀"
			"vartheta" => "\u03D1", # "ϑ"
			"vartriangleleft" => "\u22B2", # "⊲"
			"vartriangleright" => "\u22B3", # "⊳"
			"Vbar" => "\u2AEB", # "⫫"
			"vBar" => "\u2AE8", # "⫨"
			"vBarv" => "\u2AE9", # "⫩"
			"Vcy" => "\u0412", # "В"
			"vcy" => "\u0432", # "в"
			"VDash" => "\u22AB", # "⊫"
			"Vdash" => "\u22A9", # "⊩"
			"vDash" => "\u22A8", # "⊨"
			"vdash" => "\u22A2", # "⊢"
			"Vdashl" => "\u2AE6", # "⫦"
			"Vee" => "\u22C1", # "⋁"
			"vee" => "\u2228", # "∨"
			"veebar" => "\u22BB", # "⊻"
			"veeeq" => "\u225A", # "≚"
			"vellip" => "\u22EE", # "⋮"
			"Verbar" => "\u2016", # "‖"
			"verbar" => "|", # "|"
			"Vert" => "\u2016", # "‖"
			"vert" => "|", # "|"
			"VerticalBar" => "\u2223", # "∣"
			"VerticalLine" => "|", # "|"
			"VerticalSeparator" => "\u2758", # "❘"
			"VerticalTilde" => "\u2240", # "≀"
			"VeryThinSpace" => "\u200A", # " "
			"Vfr" => "\u{1D519}", # "𝔙"
			"vfr" => "\u{1D533}", # "𝔳"
			"vltri" => "\u22B2", # "⊲"
			"vnsub" => "\u2282\u20D2", # "⊂⃒"
			"vnsup" => "\u2283\u20D2", # "⊃⃒"
			"Vopf" => "\u{1D54D}", # "𝕍"
			"vopf" => "\u{1D567}", # "𝕧"
			"vprop" => "\u221D", # "∝"
			"vrtri" => "\u22B3", # "⊳"
			"Vscr" => "\u{1D4B1}", # "𝒱"
			"vscr" => "\u{1D4CB}", # "𝓋"
			"vsubnE" => "\u2ACB\uFE00", # "⫋︀"
			"vsubne" => "\u228A\uFE00", # "⊊︀"
			"vsupnE" => "\u2ACC\uFE00", # "⫌︀"
			"vsupne" => "\u228B\uFE00", # "⊋︀"
			"Vvdash" => "\u22AA", # "⊪"
			"vzigzag" => "\u299A", # "⦚"
			"Wcirc" => "\u0174", # "Ŵ"
			"wcirc" => "\u0175", # "ŵ"
			"wedbar" => "\u2A5F", # "⩟"
			"Wedge" => "\u22C0", # "⋀"
			"wedge" => "\u2227", # "∧"
			"wedgeq" => "\u2259", # "≙"
			"weierp" => "\u2118", # "℘"
			"Wfr" => "\u{1D51A}", # "𝔚"
			"wfr" => "\u{1D534}", # "𝔴"
			"Wopf" => "\u{1D54E}", # "𝕎"
			"wopf" => "\u{1D568}", # "𝕨"
			"wp" => "\u2118", # "℘"
			"wr" => "\u2240", # "≀"
			"wreath" => "\u2240", # "≀"
			"Wscr" => "\u{1D4B2}", # "𝒲"
			"wscr" => "\u{1D4CC}", # "𝓌"
			"xcap" => "\u22C2", # "⋂"
			"xcirc" => "\u25EF", # "◯"
			"xcup" => "\u22C3", # "⋃"
			"xdtri" => "\u25BD", # "▽"
			"Xfr" => "\u{1D51B}", # "𝔛"
			"xfr" => "\u{1D535}", # "𝔵"
			"xhArr" => "\u27FA", # "⟺"
			"xharr" => "\u27F7", # "⟷"
			"Xi" => "\u039E", # "Ξ"
			"xi" => "\u03BE", # "ξ"
			"xlArr" => "\u27F8", # "⟸"
			"xlarr" => "\u27F5", # "⟵"
			"xmap" => "\u27FC", # "⟼"
			"xnis" => "\u22FB", # "⋻"
			"xodot" => "\u2A00", # "⨀"
			"Xopf" => "\u{1D54F}", # "𝕏"
			"xopf" => "\u{1D569}", # "𝕩"
			"xoplus" => "\u2A01", # "⨁"
			"xotime" => "\u2A02", # "⨂"
			"xrArr" => "\u27F9", # "⟹"
			"xrarr" => "\u27F6", # "⟶"
			"Xscr" => "\u{1D4B3}", # "𝒳"
			"xscr" => "\u{1D4CD}", # "𝓍"
			"xsqcup" => "\u2A06", # "⨆"
			"xuplus" => "\u2A04", # "⨄"
			"xutri" => "\u25B3", # "△"
			"xvee" => "\u22C1", # "⋁"
			"xwedge" => "\u22C0", # "⋀"
			"Yacute" => "\u00DD", # "Ý"
			"yacute" => "\u00FD", # "ý"
			"YAcy" => "\u042F", # "Я"
			"yacy" => "\u044F", # "я"
			"Ycirc" => "\u0176", # "Ŷ"
			"ycirc" => "\u0177", # "ŷ"
			"Ycy" => "\u042B", # "Ы"
			"ycy" => "\u044B", # "ы"
			"yen" => "\u00A5", # "¥"
			"Yfr" => "\u{1D51C}", # "𝔜"
			"yfr" => "\u{1D536}", # "𝔶"
			"YIcy" => "\u0407", # "Ї"
			"yicy" => "\u0457", # "ї"
			"Yopf" => "\u{1D550}", # "𝕐"
			"yopf" => "\u{1D56A}", # "𝕪"
			"Yscr" => "\u{1D4B4}", # "𝒴"
			"yscr" => "\u{1D4CE}", # "𝓎"
			"YUcy" => "\u042E", # "Ю"
			"yucy" => "\u044E", # "ю"
			"Yuml" => "\u0178", # "Ÿ"
			"yuml" => "\u00FF", # "ÿ"
			"Zacute" => "\u0179", # "Ź"
			"zacute" => "\u017A", # "ź"
			"Zcaron" => "\u017D", # "Ž"
			"zcaron" => "\u017E", # "ž"
			"Zcy" => "\u0417", # "З"
			"zcy" => "\u0437", # "з"
			"Zdot" => "\u017B", # "Ż"
			"zdot" => "\u017C", # "ż"
			"zeetrf" => "\u2128", # "ℨ"
			"ZeroWidthSpace" => "\u200B", # "​"
			"Zeta" => "\u0396", # "Ζ"
			"zeta" => "\u03B6", # "ζ"
			"Zfr" => "\u2128", # "ℨ"
			"zfr" => "\u{1D537}", # "𝔷"
			"ZHcy" => "\u0416", # "Ж"
			"zhcy" => "\u0436", # "ж"
			"zigrarr" => "\u21DD", # "⇝"
			"Zopf" => "\u2124", # "ℤ"
			"zopf" => "\u{1D56B}", # "𝕫"
			"Zscr" => "\u{1D4B5}", # "𝒵"
			"zscr" => "\u{1D4CF}", # "𝓏"
			"zwj" => "\u200D", # "‍"
			"zwnj" => "\u200C", # "‌"
		}
	end
end
