/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.MatchSequence;
import com.nulabinc.zxcvbn.Matching;
import com.nulabinc.zxcvbn.Scoring;
import com.nulabinc.zxcvbn.StandardContext;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.matchers.Match;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Zxcvbn {
    private final Context context;

    public Zxcvbn() {
        try {
            this.context = StandardContext.build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    Zxcvbn(Context context) {
        this.context = context;
    }

    public Strength measure(CharSequence password) {
        return this.measure(password, null);
    }

    public Strength measure(CharSequence password, List<String> sanitizedInputs) {
        List<String> lowerSanitizedInputs;
        if (password == null) {
            throw new IllegalArgumentException("Password is null.");
        }
        if (sanitizedInputs != null && !sanitizedInputs.isEmpty()) {
            lowerSanitizedInputs = new ArrayList(sanitizedInputs.size());
            for (String sanitizedInput : sanitizedInputs) {
                lowerSanitizedInputs.add(sanitizedInput.toLowerCase(Locale.getDefault()));
            }
        } else {
            lowerSanitizedInputs = Collections.emptyList();
        }
        long start = this.time();
        Matching matching = new Matching(this.context, lowerSanitizedInputs);
        List<Match> matches = matching.omnimatch(password);
        Scoring scoring = new Scoring(this.context);
        MatchSequence matchSequence = scoring.calculateMostGuessableMatchSequence(password, matches);
        long end = this.time() - start;
        return new Strength(password, matchSequence.getGuesses(), matchSequence.getSequence(), end);
    }

    private long time() {
        return System.nanoTime();
    }
}

