/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class ProcessorBase
implements PlainJsonSerializable {
    @Nullable
    private final String description;
    @Nullable
    private final String if_;
    @Nullable
    private final Boolean ignoreFailure;
    @Nonnull
    private final List<Processor> onFailure;
    @Nullable
    private final String tag;

    protected ProcessorBase(AbstractBuilder<?> builder) {
        this.description = ((AbstractBuilder)builder).description;
        this.if_ = ((AbstractBuilder)builder).if_;
        this.ignoreFailure = ((AbstractBuilder)builder).ignoreFailure;
        this.onFailure = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).onFailure);
        this.tag = ((AbstractBuilder)builder).tag;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String if_() {
        return this.if_;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Nonnull
    public final List<Processor> onFailure() {
        return this.onFailure;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.if_ != null) {
            generator.writeKey("if");
            generator.write(this.if_);
        }
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.onFailure)) {
            generator.writeKey("on_failure");
            generator.writeStartArray();
            for (Processor item0 : this.onFailure) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupProcessorBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::if_, JsonpDeserializer.stringDeserializer(), "if");
        op.add(AbstractBuilder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
        op.add(AbstractBuilder::onFailure, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "on_failure");
        op.add(AbstractBuilder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.if_);
        result = 31 * result + Objects.hashCode(this.ignoreFailure);
        result = 31 * result + Objects.hashCode(this.onFailure);
        result = 31 * result + Objects.hashCode(this.tag);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorBase other = (ProcessorBase)o;
        return Objects.equals(this.description, other.description) && Objects.equals(this.if_, other.if_) && Objects.equals(this.ignoreFailure, other.ignoreFailure) && Objects.equals(this.onFailure, other.onFailure) && Objects.equals(this.tag, other.tag);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String description;
        @Nullable
        private String if_;
        @Nullable
        private Boolean ignoreFailure;
        @Nullable
        private List<Processor> onFailure;
        @Nullable
        private String tag;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(ProcessorBase o) {
            this.description = o.description;
            this.if_ = o.if_;
            this.ignoreFailure = o.ignoreFailure;
            this.onFailure = AbstractBuilder._listCopy(o.onFailure);
            this.tag = o.tag;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.description = o.description;
            this.if_ = o.if_;
            this.ignoreFailure = o.ignoreFailure;
            this.onFailure = AbstractBuilder._listCopy(o.onFailure);
            this.tag = o.tag;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT if_(@Nullable String value) {
            this.if_ = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT onFailure(List<Processor> list) {
            this.onFailure = AbstractBuilder._listAddAll(this.onFailure, list);
            return this.self();
        }

        @Nonnull
        public final BuilderT onFailure(Processor value, Processor ... values) {
            this.onFailure = AbstractBuilder._listAdd(this.onFailure, value, values);
            return this.self();
        }

        @Nonnull
        public final BuilderT onFailure(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.onFailure(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        @Nonnull
        public final BuilderT tag(@Nullable String value) {
            this.tag = value;
            return this.self();
        }
    }
}

