/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainDeserializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SourceField
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SourceField> {
    @Nullable
    private final Boolean compress;
    @Nullable
    private final String compressThreshold;
    @Nullable
    private final Boolean enabled;
    @Nonnull
    private final List<String> excludes;
    @Nonnull
    private final List<String> includes;
    public static final JsonpDeserializer<SourceField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceField::setupSourceFieldDeserializer);

    private SourceField(Builder builder) {
        this.compress = builder.compress;
        this.compressThreshold = builder.compressThreshold;
        this.enabled = builder.enabled;
        this.excludes = ApiTypeHelper.unmodifiable(builder.excludes);
        this.includes = ApiTypeHelper.unmodifiable(builder.includes);
    }

    public static SourceField of(Function<Builder, ObjectBuilder<SourceField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean compress() {
        return this.compress;
    }

    @Nullable
    public final String compressThreshold() {
        return this.compressThreshold;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nonnull
    public final List<String> excludes() {
        return this.excludes;
    }

    @Nonnull
    public final List<String> includes() {
        return this.includes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress.booleanValue());
        }
        if (this.compressThreshold != null) {
            generator.writeKey("compress_threshold");
            generator.write(this.compressThreshold);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.excludes)) {
            generator.writeKey("excludes");
            generator.writeStartArray();
            for (String item0 : this.excludes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.includes)) {
            generator.writeKey("includes");
            generator.writeStartArray();
            for (String item0 : this.includes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSourceFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compress, JsonpDeserializer.booleanDeserializer(), "compress");
        op.add(Builder::compressThreshold, JsonpDeserializer.stringDeserializer(), "compress_threshold");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::excludes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "excludes");
        op.add(Builder::includes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "includes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.compress);
        result = 31 * result + Objects.hashCode(this.compressThreshold);
        result = 31 * result + Objects.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.excludes);
        result = 31 * result + Objects.hashCode(this.includes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceField other = (SourceField)o;
        return Objects.equals(this.compress, other.compress) && Objects.equals(this.compressThreshold, other.compressThreshold) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.excludes, other.excludes) && Objects.equals(this.includes, other.includes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SourceField>,
    PlainDeserializable<Builder> {
        @Nullable
        private Boolean compress;
        @Nullable
        private String compressThreshold;
        @Nullable
        private Boolean enabled;
        @Nullable
        private List<String> excludes;
        @Nullable
        private List<String> includes;

        public Builder() {
        }

        private Builder(SourceField o) {
            this.compress = o.compress;
            this.compressThreshold = o.compressThreshold;
            this.enabled = o.enabled;
            this.excludes = Builder._listCopy(o.excludes);
            this.includes = Builder._listCopy(o.includes);
        }

        private Builder(Builder o) {
            this.compress = o.compress;
            this.compressThreshold = o.compressThreshold;
            this.enabled = o.enabled;
            this.excludes = Builder._listCopy(o.excludes);
            this.includes = Builder._listCopy(o.includes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }

        @Nonnull
        public final Builder compress(@Nullable Boolean value) {
            this.compress = value;
            return this;
        }

        @Nonnull
        public final Builder compressThreshold(@Nullable String value) {
            this.compressThreshold = value;
            return this;
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public final Builder excludes(List<String> list) {
            this.excludes = Builder._listAddAll(this.excludes, list);
            return this;
        }

        @Nonnull
        public final Builder excludes(String value, String ... values) {
            this.excludes = Builder._listAdd(this.excludes, value, values);
            return this;
        }

        @Nonnull
        public final Builder includes(List<String> list) {
            this.includes = Builder._listAddAll(this.includes, list);
            return this;
        }

        @Nonnull
        public final Builder includes(String value, String ... values) {
            this.includes = Builder._listAdd(this.includes, value, values);
            return this;
        }

        @Override
        @Nonnull
        public SourceField build() {
            this._checkSingleUse();
            return new SourceField(this);
        }
    }
}

