/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.credentials.oss;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.notifications.core.credentials.CredentialsProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\t"}, d2={"Lorg/opensearch/notifications/core/credentials/oss/CredentialsProviderFactory;", "Lorg/opensearch/notifications/core/credentials/CredentialsProvider;", "()V", "getCredentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "region", "", "roleArn", "getCredentialsProviderByIAMRole", "opensearch-notifications-core"})
public final class CredentialsProviderFactory
implements CredentialsProvider {
    @Override
    @NotNull
    public AWSCredentialsProvider getCredentialsProvider(@NotNull String region, @Nullable String roleArn) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return roleArn != null ? this.getCredentialsProviderByIAMRole(region, roleArn) : (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain();
    }

    private final AWSCredentialsProvider getCredentialsProviderByIAMRole(String region, String roleArn) {
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance())).withRegion(region)).build();
        AssumeRoleRequest roleRequest = new AssumeRoleRequest().withRoleArn(roleArn).withRoleSessionName("opensearch-notifications");
        AssumeRoleResult roleResponse = stsClient.assumeRole(roleRequest);
        Credentials sessionCredentials = roleResponse.getCredentials();
        BasicSessionCredentials awsCredentials = new BasicSessionCredentials(sessionCredentials.getAccessKeyId(), sessionCredentials.getSecretAccessKey(), sessionCredentials.getSessionToken());
        return (AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
    }
}

