/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class QueryBase
implements PlainJsonSerializable {
    @Nullable
    private final Float boost;
    @Nullable
    private final String queryName;

    protected QueryBase(AbstractBuilder<?> builder) {
        this.boost = ((AbstractBuilder)builder).boost;
        this.queryName = ((AbstractBuilder)builder).queryName;
    }

    @Nullable
    public final Float boost() {
        return this.boost;
    }

    @Nullable
    public final String queryName() {
        return this.queryName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write((double)this.boost.floatValue());
        }
        if (this.queryName != null) {
            generator.writeKey("_name");
            generator.write(this.queryName);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupQueryBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::boost, JsonpDeserializer.floatDeserializer(), "boost");
        op.add(AbstractBuilder::queryName, JsonpDeserializer.stringDeserializer(), "_name");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.boost);
        result = 31 * result + Objects.hashCode(this.queryName);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryBase other = (QueryBase)o;
        return Objects.equals(this.boost, other.boost) && Objects.equals(this.queryName, other.queryName);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private Float boost;
        @Nullable
        private String queryName;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(QueryBase o) {
            this.boost = o.boost;
            this.queryName = o.queryName;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.boost = o.boost;
            this.queryName = o.queryName;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT boost(@Nullable Float value) {
            this.boost = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT queryName(@Nullable String value) {
            this.queryName = value;
            return this.self();
        }
    }
}

