/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss.cagra;

import java.io.IOException;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.opensearch.knn.memoryoptsearch.faiss.AbstractFaissHNSWIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndex;
import org.opensearch.knn.memoryoptsearch.faiss.cagra.FaissCagraHNSW;

public class FaissHNSWCagraIndex
extends AbstractFaissHNSWIndex {
    public static final String IHNC = "IHNc";
    public static final String IHNC2 = "IHc2";
    private boolean keepMaxSizeLevel0;
    private boolean baseLevelOnly;
    private int numBaseLevelSearchEntryPoint;

    public FaissHNSWCagraIndex(String indexType) {
        super(indexType, new FaissCagraHNSW());
    }

    @Override
    protected void doLoad(IndexInput input) throws IOException {
        this.readCommonHeader(input);
        this.keepMaxSizeLevel0 = input.readByte() == 1;
        this.baseLevelOnly = input.readByte() == 1;
        this.numBaseLevelSearchEntryPoint = input.readInt();
        if (this.indexType.equals(IHNC2)) {
            input.readInt();
        }
        this.faissHnsw.load(input, this.getTotalNumberOfVectors());
        ((FaissCagraHNSW)this.faissHnsw).setNumBaseLevelSearchEntryPoints(this.numBaseLevelSearchEntryPoint);
        this.flatVectors = FaissIndex.load(input);
    }

    @Override
    public VectorEncoding getVectorEncoding() {
        return this.flatVectors.getVectorEncoding();
    }

    @Override
    public FloatVectorValues getFloatValues(IndexInput indexInput) throws IOException {
        return this.flatVectors.getFloatValues(indexInput);
    }

    @Override
    public ByteVectorValues getByteValues(IndexInput indexInput) throws IOException {
        return this.flatVectors.getByteValues(indexInput);
    }
}

