/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior;
import software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.SpotInstanceType;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestSpotInstancesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RequestSpotInstancesRequest> {
    private static final SdkField<RequestSpotLaunchSpecification> LAUNCH_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchSpecification").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::launchSpecification)).setter(RequestSpotInstancesRequest.setter(Builder::launchSpecification)).constructor(RequestSpotLaunchSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecification").unmarshallLocationName("LaunchSpecification").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::tagSpecifications)).setter(RequestSpotInstancesRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInterruptionBehavior").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::instanceInterruptionBehaviorAsString)).setter(RequestSpotInstancesRequest.setter(Builder::instanceInterruptionBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior").unmarshallLocationName("InstanceInterruptionBehavior").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::dryRun)).setter(RequestSpotInstancesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpotPrice").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::spotPrice)).setter(RequestSpotInstancesRequest.setter(Builder::spotPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice").unmarshallLocationName("spotPrice").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::clientToken)).setter(RequestSpotInstancesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::instanceCount)).setter(RequestSpotInstancesRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::typeAsString)).setter(RequestSpotInstancesRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidFrom").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::validFrom)).setter(RequestSpotInstancesRequest.setter(Builder::validFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom").unmarshallLocationName("validFrom").build()}).build();
    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidUntil").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::validUntil)).setter(RequestSpotInstancesRequest.setter(Builder::validUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").unmarshallLocationName("validUntil").build()}).build();
    private static final SdkField<String> LAUNCH_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchGroup").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::launchGroup)).setter(RequestSpotInstancesRequest.setter(Builder::launchGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchGroup").unmarshallLocationName("launchGroup").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneGroup").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::availabilityZoneGroup)).setter(RequestSpotInstancesRequest.setter(Builder::availabilityZoneGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneGroup").unmarshallLocationName("availabilityZoneGroup").build()}).build();
    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockDurationMinutes").getter(RequestSpotInstancesRequest.getter(RequestSpotInstancesRequest::blockDurationMinutes)).setter(RequestSpotInstancesRequest.setter(Builder::blockDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes").unmarshallLocationName("blockDurationMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_SPECIFICATION_FIELD, TAG_SPECIFICATIONS_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, DRY_RUN_FIELD, SPOT_PRICE_FIELD, CLIENT_TOKEN_FIELD, INSTANCE_COUNT_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD, LAUNCH_GROUP_FIELD, AVAILABILITY_ZONE_GROUP_FIELD, BLOCK_DURATION_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestSpotInstancesRequest.memberNameToFieldInitializer();
    private final RequestSpotLaunchSpecification launchSpecification;
    private final List<TagSpecification> tagSpecifications;
    private final String instanceInterruptionBehavior;
    private final Boolean dryRun;
    private final String spotPrice;
    private final String clientToken;
    private final Integer instanceCount;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final String launchGroup;
    private final String availabilityZoneGroup;
    private final Integer blockDurationMinutes;

    private RequestSpotInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.launchSpecification = builder.launchSpecification;
        this.tagSpecifications = builder.tagSpecifications;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.dryRun = builder.dryRun;
        this.spotPrice = builder.spotPrice;
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.launchGroup = builder.launchGroup;
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.blockDurationMinutes = builder.blockDurationMinutes;
    }

    public final RequestSpotLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(this.instanceInterruptionBehavior);
    }

    public final String instanceInterruptionBehaviorAsString() {
        return this.instanceInterruptionBehavior;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String spotPrice() {
        return this.spotPrice;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final SpotInstanceType type() {
        return SpotInstanceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant validFrom() {
        return this.validFrom;
    }

    public final Instant validUntil() {
        return this.validUntil;
    }

    public final String launchGroup() {
        return this.launchGroup;
    }

    public final String availabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public final Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDurationMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesRequest)) {
            return false;
        }
        RequestSpotInstancesRequest other = (RequestSpotInstancesRequest)((Object)obj);
        return Objects.equals(this.launchSpecification(), other.launchSpecification()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.spotPrice(), other.spotPrice()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.validFrom(), other.validFrom()) && Objects.equals(this.validUntil(), other.validUntil()) && Objects.equals(this.launchGroup(), other.launchGroup()) && Objects.equals(this.availabilityZoneGroup(), other.availabilityZoneGroup()) && Objects.equals(this.blockDurationMinutes(), other.blockDurationMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"RequestSpotInstancesRequest").add("LaunchSpecification", (Object)this.launchSpecification()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("InstanceInterruptionBehavior", (Object)this.instanceInterruptionBehaviorAsString()).add("DryRun", (Object)this.dryRun()).add("SpotPrice", (Object)this.spotPrice()).add("ClientToken", (Object)this.clientToken()).add("InstanceCount", (Object)this.instanceCount()).add("Type", (Object)this.typeAsString()).add("ValidFrom", (Object)this.validFrom()).add("ValidUntil", (Object)this.validUntil()).add("LaunchGroup", (Object)this.launchGroup()).add("AvailabilityZoneGroup", (Object)this.availabilityZoneGroup()).add("BlockDurationMinutes", (Object)this.blockDurationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchSpecification()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "InstanceInterruptionBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInterruptionBehaviorAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SpotPrice": {
                return Optional.ofNullable(clazz.cast(this.spotPrice()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ValidFrom": {
                return Optional.ofNullable(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.ofNullable(clazz.cast(this.validUntil()));
            }
            case "LaunchGroup": {
                return Optional.ofNullable(clazz.cast(this.launchGroup()));
            }
            case "AvailabilityZoneGroup": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneGroup()));
            }
            case "BlockDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.blockDurationMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LaunchSpecification", LAUNCH_SPECIFICATION_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("InstanceInterruptionBehavior", INSTANCE_INTERRUPTION_BEHAVIOR_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SpotPrice", SPOT_PRICE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ValidFrom", VALID_FROM_FIELD);
        map.put("ValidUntil", VALID_UNTIL_FIELD);
        map.put("LaunchGroup", LAUNCH_GROUP_FIELD);
        map.put("AvailabilityZoneGroup", AVAILABILITY_ZONE_GROUP_FIELD);
        map.put("BlockDurationMinutes", BLOCK_DURATION_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotInstancesRequest, T> g) {
        return obj -> g.apply((RequestSpotInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private RequestSpotLaunchSpecification launchSpecification;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String instanceInterruptionBehavior;
        private Boolean dryRun;
        private String spotPrice;
        private String clientToken;
        private Integer instanceCount;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private String launchGroup;
        private String availabilityZoneGroup;
        private Integer blockDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesRequest model) {
            super(model);
            this.launchSpecification(model.launchSpecification);
            this.tagSpecifications(model.tagSpecifications);
            this.instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            this.dryRun(model.dryRun);
            this.spotPrice(model.spotPrice);
            this.clientToken(model.clientToken);
            this.instanceCount(model.instanceCount);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.launchGroup(model.launchGroup);
            this.availabilityZoneGroup(model.availabilityZoneGroup);
            this.blockDurationMinutes(model.blockDurationMinutes);
        }

        public final RequestSpotLaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        public final void setLaunchSpecification(RequestSpotLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        @Override
        public final Builder launchSpecification(RequestSpotLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return this.instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SpotInstanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final String getLaunchGroup() {
            return this.launchGroup;
        }

        public final void setLaunchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
        }

        @Override
        public final Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public final String getAvailabilityZoneGroup() {
            return this.availabilityZoneGroup;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestSpotInstancesRequest build() {
            return new RequestSpotInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestSpotInstancesRequest> {
        public Builder launchSpecification(RequestSpotLaunchSpecification var1);

        default public Builder launchSpecification(Consumer<RequestSpotLaunchSpecification.Builder> launchSpecification) {
            return this.launchSpecification((RequestSpotLaunchSpecification)((RequestSpotLaunchSpecification.Builder)RequestSpotLaunchSpecification.builder().applyMutation(launchSpecification)).build());
        }

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder instanceInterruptionBehavior(String var1);

        public Builder instanceInterruptionBehavior(InstanceInterruptionBehavior var1);

        public Builder dryRun(Boolean var1);

        public Builder spotPrice(String var1);

        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder type(String var1);

        public Builder type(SpotInstanceType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder launchGroup(String var1);

        public Builder availabilityZoneGroup(String var1);

        public Builder blockDurationMinutes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

