/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.common.hash.MessageDigests;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.core.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class CommunityIdProcessor
extends AbstractProcessor {
    public static final String TYPE = "community_id";
    private static final String COMMUNITY_ID_HASH_VERSION = "1";
    private static final byte PADDING_BYTE = 0;
    private static final int IANA_COMMON_MAX_NUMBER = 255;
    private static final int IANA_COMMON_MIN_NUMBER = 0;
    private static final int MIN_SEED = 0;
    private static final int MAX_SEED = 65535;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 63335;
    private static final String ICMP_MESSAGE_TYPE = "type";
    private static final String ICMP_MESSAGE_CODE = "code";
    private final String sourceIPField;
    private final String sourcePortField;
    private final String destinationIPField;
    private final String destinationPortField;
    private final String ianaProtocolNumberField;
    private final String protocolField;
    private final String icmpTypeField;
    private final String icmpCodeField;
    private final int seed;
    private final String targetField;
    private final boolean ignoreMissing;

    CommunityIdProcessor(String tag, String description, String sourceIPField, String sourcePortField, String destinationIPField, String destinationPortField, String ianaProtocolNumberField, String protocolField, String icmpTypeField, String icmpCodeField, int seed, String targetField, boolean ignoreMissing) {
        super(tag, description);
        this.sourceIPField = sourceIPField;
        this.sourcePortField = sourcePortField;
        this.destinationIPField = destinationIPField;
        this.destinationPortField = destinationPortField;
        this.ianaProtocolNumberField = ianaProtocolNumberField;
        this.protocolField = protocolField;
        this.icmpTypeField = icmpTypeField;
        this.icmpCodeField = icmpCodeField;
        this.seed = seed;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getSourceIPField() {
        return this.sourceIPField;
    }

    public String getSourcePortField() {
        return this.sourcePortField;
    }

    public String getDestinationIPField() {
        return this.destinationIPField;
    }

    public String getDestinationPortField() {
        return this.destinationPortField;
    }

    public String getIANAProtocolNumberField() {
        return this.ianaProtocolNumberField;
    }

    public String getProtocolField() {
        return this.protocolField;
    }

    public String getIcmpTypeField() {
        return this.icmpTypeField;
    }

    public String getIcmpCodeField() {
        return this.icmpCodeField;
    }

    public int getSeed() {
        return this.seed;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument document) {
        boolean isICMPProtocol;
        Protocol protocol = this.resolveProtocol(document);
        if (protocol == null) {
            return document;
        }
        byte[] sourceIPByteArray = this.resolveIP(document, this.sourceIPField);
        if (sourceIPByteArray == null) {
            return document;
        }
        byte[] destIPByteArray = this.resolveIP(document, this.destinationIPField);
        if (destIPByteArray == null) {
            return document;
        }
        if (sourceIPByteArray.length != destIPByteArray.length) {
            throw new IllegalArgumentException("source ip and destination ip must have same format");
        }
        Integer sourcePort = null;
        Integer destinationPort = null;
        if (protocol.isTransportProtocol()) {
            sourcePort = this.resolvePort(document, this.sourcePortField);
            if (sourcePort == null) {
                return document;
            }
            destinationPort = this.resolvePort(document, this.destinationPortField);
            if (destinationPort == null) {
                return document;
            }
        }
        boolean isOneway = true;
        boolean bl = isICMPProtocol = Protocol.ICMP == protocol || Protocol.ICMP_V6 == protocol;
        if (isICMPProtocol) {
            Byte equivalentCode;
            Integer icmpType = this.resolveICMP(document, this.icmpTypeField, ICMP_MESSAGE_TYPE);
            if (icmpType == null) {
                return document;
            }
            sourcePort = icmpType;
            Byte by = equivalentCode = Protocol.ICMP.getProtocolCode() == protocol.getProtocolCode() ? ICMPType.getEquivalentCode(icmpType.byteValue()) : ICMPv6Type.getEquivalentCode(icmpType.byteValue());
            if (equivalentCode != null) {
                isOneway = false;
                destinationPort = Protocol.ICMP.getProtocolCode() == protocol.getProtocolCode() ? Integer.valueOf(equivalentCode.byteValue()) : Byte.toUnsignedInt(equivalentCode);
            } else {
                Integer icmpCode = this.resolveICMP(document, this.icmpCodeField, ICMP_MESSAGE_CODE);
                if (icmpCode == null) {
                    return document;
                }
                destinationPort = icmpCode;
            }
        }
        assert (sourcePort != null && destinationPort != null);
        boolean isLess = this.compareIPAndPort(sourceIPByteArray, sourcePort, destIPByteArray, destinationPort);
        if (!(isLess || isICMPProtocol && isOneway)) {
            byte[] byteArray = sourceIPByteArray;
            sourceIPByteArray = destIPByteArray;
            destIPByteArray = byteArray;
            int tempPort = sourcePort;
            sourcePort = destinationPort;
            destinationPort = tempPort;
        }
        String digest = this.generateCommunityIDHash(protocol.getProtocolCode(), sourceIPByteArray, destIPByteArray, sourcePort, destinationPort, this.seed);
        document.setFieldValue(this.targetField, (Object)digest);
        return document;
    }

    public String getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Protocol resolveProtocol(IngestDocument document) {
        Protocol protocol = null;
        Integer ianaProtocolNumber = null;
        String protocolName = null;
        if (!Strings.isNullOrEmpty((String)this.ianaProtocolNumberField)) {
            ianaProtocolNumber = (Integer)document.getFieldValue(this.ianaProtocolNumberField, Integer.class, true);
        }
        if (!Strings.isNullOrEmpty((String)this.protocolField)) {
            protocolName = (String)document.getFieldValue(this.protocolField, String.class, true);
        }
        if (ianaProtocolNumber != null) {
            if (ianaProtocolNumber < 0 || ianaProtocolNumber > 255 || !Protocol.protocolCodeMap.containsKey(ianaProtocolNumber.byteValue())) throw new IllegalArgumentException("unsupported iana protocol number [" + ianaProtocolNumber + "]");
            protocol = Protocol.protocolCodeMap.get(ianaProtocolNumber.byteValue());
        } else if (protocolName != null) {
            Protocol protocolFromName = Protocol.fromProtocolName(protocolName);
            if (protocolFromName == null) throw new IllegalArgumentException("unsupported protocol [" + protocolName + "]");
            protocol = protocolFromName;
        }
        if (protocol != null) return protocol;
        if (!this.ignoreMissing) throw new IllegalArgumentException("cannot resolve protocol by neither iana protocol number field [" + this.ianaProtocolNumberField + "] nor protocol name field [" + this.protocolField + "]");
        return null;
    }

    private byte[] resolveIP(IngestDocument document, String fieldName) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("both source ip field path and destination ip field path cannot be null nor empty");
        }
        String ipAddress = (String)document.getFieldValue(fieldName, String.class, true);
        if (Strings.isNullOrEmpty((String)ipAddress)) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("ip address in the field [" + fieldName + "] is null or empty");
        }
        byte[] byteArray = InetAddresses.ipStringToBytes((String)ipAddress);
        if (byteArray == null) {
            throw new IllegalArgumentException("ip address [" + ipAddress + "] in the field [" + fieldName + "] is not a valid ipv4/ipv6 address");
        }
        return byteArray;
    }

    private Integer resolvePort(IngestDocument document, String fieldName) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("both source port and destination port field path cannot be null nor empty");
        }
        Integer port = (Integer)document.getFieldValue(fieldName, Integer.class, true);
        if (port == null) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("both source port and destination port cannot be null, but port in the field path [" + fieldName + "] is null");
        }
        if (port < 0 || port > 63335) {
            throw new IllegalArgumentException("both source port and destination port must be between 0 and 65535, but port in the field path [" + fieldName + "] is [" + port + "]");
        }
        return port;
    }

    private Integer resolveICMP(IngestDocument document, String fieldName, String fieldType) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("icmp message " + fieldType + " field path cannot be null nor empty");
        }
        Integer fieldValue = (Integer)document.getFieldValue(fieldName, Integer.class, true);
        if (fieldValue == null) {
            if (this.ignoreMissing) {
                return null;
            }
            throw new IllegalArgumentException("icmp message " + fieldType + " cannot be null");
        }
        if (fieldValue < 0 || fieldValue > 255) {
            throw new IllegalArgumentException("invalid icmp message " + fieldType + " [" + fieldValue + "]");
        }
        return fieldValue;
    }

    private String generateCommunityIDHash(byte protocolCode, byte[] sourceIPByteArray, byte[] destIPByteArray, Integer sourcePort, Integer destinationPort, int seed) {
        MessageDigest messageDigest = MessageDigests.sha1();
        messageDigest.update(this.intToTwoByteArray(seed));
        messageDigest.update(sourceIPByteArray);
        messageDigest.update(destIPByteArray);
        messageDigest.update(protocolCode);
        messageDigest.update((byte)0);
        messageDigest.update(this.intToTwoByteArray(sourcePort));
        messageDigest.update(this.intToTwoByteArray(destinationPort));
        return "1:" + Base64.getEncoder().encodeToString(messageDigest.digest());
    }

    private byte[] intToTwoByteArray(Integer val) {
        byte[] byteArray = new byte[]{Integer.valueOf(val >>> 8).byteValue(), val.byteValue()};
        return byteArray;
    }

    private boolean compareIPAndPort(byte[] sourceIPByteArray, int sourcePort, byte[] destIPByteArray, int destinationPort) {
        int compareResult = this.compareByteArray(sourceIPByteArray, destIPByteArray);
        return compareResult < 0 || compareResult == 0 && sourcePort < destinationPort;
    }

    private int compareByteArray(byte[] byteArray1, byte[] byteArray2) {
        assert (byteArray1.length == byteArray2.length);
        int i = 0;
        for (int j = 0; i < byteArray1.length && j < byteArray2.length; ++i, ++j) {
            int isLess = Byte.compareUnsigned(byteArray1[i], byteArray2[j]);
            if (isLess == 0) {
                continue;
            }
            return isLess;
        }
        return 0;
    }

    static enum Protocol {
        ICMP(1, false),
        TCP(6, true),
        UDP(17, true),
        ICMP_V6(58, false),
        SCTP(-124, true);

        private final byte protocolCode;
        private final boolean isTransportProtocol;
        public static final Map<Byte, Protocol> protocolCodeMap;

        private Protocol(int ianaNumber, boolean isTransportProtocol) {
            this.protocolCode = Integer.valueOf(ianaNumber).byteValue();
            this.isTransportProtocol = isTransportProtocol;
        }

        public static Protocol fromProtocolName(String protocolName) {
            String name = protocolName.toUpperCase(Locale.ROOT);
            if (name.equals("IPV6-ICMP")) {
                return ICMP_V6;
            }
            try {
                return Protocol.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public byte getProtocolCode() {
            return this.protocolCode;
        }

        public boolean isTransportProtocol() {
            return this.isTransportProtocol;
        }

        static {
            protocolCodeMap = Arrays.stream(Protocol.values()).collect(Collectors.toMap(Protocol::getProtocolCode, p -> p));
        }
    }

    static enum ICMPType {
        ECHO_REPLY(0, 8),
        ECHO(8, 0),
        RTR_ADVERT(9, 10),
        RTR_SOLICIT(10, 9),
        TSTAMP(13, 14),
        TSTAMP_REPLY(14, 13),
        INFO(15, 16),
        INFO_REPLY(16, 15),
        MASK(17, 18),
        MASK_REPLY(18, 17);

        private final byte type;
        private final byte code;
        private static final Map<Byte, Byte> ICMPTypeMapper;

        private ICMPType(byte type, byte code) {
            this.type = type;
            this.code = code;
        }

        public static Byte getEquivalentCode(int type) {
            return ICMPTypeMapper.get(Integer.valueOf(type).byteValue());
        }

        static {
            ICMPTypeMapper = Arrays.stream(ICMPType.values()).collect(Collectors.toMap(t -> t.type, t -> t.code));
        }
    }

    static enum ICMPv6Type {
        ECHO_REQUEST(-128, -127),
        ECHO_REPLY(-127, -128),
        MLD_LISTENER_QUERY(-126, -125),
        MLD_LISTENER_REPORT(-125, -126),
        ND_ROUTER_SOLICIT(-123, -122),
        ND_ROUTER_ADVERT(-122, -123),
        ND_NEIGHBOR_SOLICIT(-121, -120),
        ND_NEIGHBOR_ADVERT(-120, -121),
        WRU_REQUEST(-117, -116),
        WRU_REPLY(-116, -117),
        HAAD_REQUEST(-112, -111),
        HAAD_REPLY(-111, -112);

        private final byte type;
        private final byte code;
        private static final Map<Byte, Byte> ICMPTypeMapper;

        private ICMPv6Type(byte type, byte code) {
            this.type = type;
            this.code = code;
        }

        public static Byte getEquivalentCode(int type) {
            return ICMPTypeMapper.get(Integer.valueOf(type).byteValue());
        }

        static {
            ICMPTypeMapper = Arrays.stream(ICMPv6Type.values()).collect(Collectors.toMap(t -> t.type, t -> t.code));
        }
    }

    public static class Factory
    implements Processor.Factory {
        public CommunityIdProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String sourceIPField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"source_ip_field");
            String sourcePortField = ConfigurationUtils.readOptionalStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"source_port_field");
            String destinationIPField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"destination_ip_field");
            String destinationPortField = ConfigurationUtils.readOptionalStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"destination_port_field");
            String ianaProtocolNumberField = ConfigurationUtils.readOptionalStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"iana_protocol_number_field");
            String protocolField = ConfigurationUtils.readOptionalStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"protocol_field");
            String icmpTypeField = ConfigurationUtils.readOptionalStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"icmp_type_field");
            String icmpCodeField = ConfigurationUtils.readOptionalStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"icmp_code_field");
            int seed = ConfigurationUtils.readIntProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"seed", (Integer)0);
            if (seed < 0 || seed > 65535) {
                throw ConfigurationUtils.newConfigurationException((String)CommunityIdProcessor.TYPE, (String)processorTag, (String)"seed", (String)"seed must be between 0 and 65535");
            }
            String targetField = ConfigurationUtils.readStringProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)CommunityIdProcessor.TYPE);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)CommunityIdProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            return new CommunityIdProcessor(processorTag, description, sourceIPField, sourcePortField, destinationIPField, destinationPortField, ianaProtocolNumberField, protocolField, icmpTypeField, icmpCodeField, seed, targetField, ignoreMissing);
        }
    }
}

