/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.util.UCPErrorHandler;

public class DataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    static final String CLASS_NAME = DataSourceConnectionFactoryAdapter.class.getName();
    protected DataSource m_dataSource;

    public DataSourceConnectionFactoryAdapter(DataSource dataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(diagnosticsCollector);
        if (null == dataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(256);
        }
        this.m_dataSource = dataSource;
    }

    public DataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        this(dataSource, DiagnosticsCollectorImpl.getCommon());
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        if (!(connectionRequestInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo JDBCConnectionRequestInfo = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
        Connection connection = null;
        try {
            connection = this.m_dataSource.getConnection(JDBCConnectionRequestInfo.getUser(), JDBCConnectionRequestInfo.getPassword().get());
            if (null != connection) {
                this.onSuccessfulConnectionCreation(connection);
            }
        }
        catch (Throwable e) {
            this.onFailedConnectionCreation(e);
            this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
            if (null != connection) {
                this.closeConnection(connection);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
        }
        return connection;
    }

    @Override
    public void closeConnection(Object connection) throws UniversalConnectionPoolException {
        if (!(connection instanceof Connection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(258);
        }
        Connection javaSQLConnection = (Connection)connection;
        try {
            javaSQLConnection.close();
        }
        catch (SQLException sqlException) {
            this.trace(Level.WARNING, CLASS_NAME, "closeConnection", "", null, sqlException, new Object[0]);
            UCPErrorHandler.throwUniversalConnectionPoolException(255, sqlException);
        }
    }
}

