/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.EntityInfo;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.IOsmStorageFilter;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OsmBaseStorage {
    protected static final String ELEM_OSM = "osm";
    protected static final String ELEM_OSMCHANGE = "osmChange";
    protected static final String ELEM_NODE = "node";
    protected static final String ELEM_TAG = "tag";
    protected static final String ELEM_WAY = "way";
    protected static final String ELEM_ND = "nd";
    protected static final String ELEM_RELATION = "relation";
    protected static final String ELEM_MEMBER = "member";
    protected static final String ELEM_MODIFY = "modify";
    protected static final String ELEM_CREATE = "create";
    protected static final String ELEM_DELETE = "delete";
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_LAT = "lat";
    protected static final String ATTR_LON = "lon";
    protected static final String ATTR_TIMESTAMP = "timestamp";
    protected static final String ATTR_UID = "uid";
    protected static final String ATTR_USER = "user";
    protected static final String ATTR_VISIBLE = "visible";
    protected static final String ATTR_CHANGESET = "changeset";
    protected static final String ATTR_K = "k";
    protected static final String ATTR_V = "v";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_REF = "ref";
    protected static final String ATTR_ROLE = "role";
    protected Entity currentParsedEntity = null;
    protected int currentModify = 0;
    protected EntityInfo currentParsedEntityInfo = null;
    protected boolean parseStarted;
    protected Map<Entity.EntityId, Entity> entities = new LinkedHashMap<Entity.EntityId, Entity>();
    protected Map<Entity.EntityId, EntityInfo> entityInfo = new LinkedHashMap<Entity.EntityId, EntityInfo>();
    protected int progressEntity = 0;
    protected IProgress progress;
    protected InputStream inputStream;
    protected InputStream streamForProgress;
    protected List<IOsmStorageFilter> filters = new ArrayList<IOsmStorageFilter>();
    protected boolean supressWarnings = true;
    protected boolean parseEntityInfo;
    private boolean osmChange;
    protected static final Set<String> supportedVersions = new HashSet<String>();
    protected static final int moduleProgress = 1024;

    public static void main(String[] args) throws IOException, SAXException, XmlPullParserException {
        GZIPInputStream is = new GZIPInputStream(new FileInputStream("/Users/victorshcherb/osmand/temp/m.m001508233.osc.gz"));
        new OsmBaseStorage().parseOSM(is, IProgress.EMPTY_PROGRESS);
    }

    public synchronized void parseOSM(InputStream stream, IProgress progress, InputStream streamForProgress, boolean entityInfo) throws IOException, XmlPullParserException {
        int tok;
        this.inputStream = stream;
        this.progress = progress;
        this.parseEntityInfo = entityInfo;
        if (streamForProgress == null) {
            streamForProgress = this.inputStream;
        }
        this.streamForProgress = streamForProgress;
        this.parseStarted = false;
        this.entities.clear();
        this.entityInfo.clear();
        if (progress != null) {
            progress.startWork(streamForProgress.available());
        }
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        parser.setInput(stream, "UTF-8");
        while ((tok = parser.next()) != 1) {
            if (tok == 2) {
                this.startElement(parser, parser.getName());
                continue;
            }
            if (tok != 3) continue;
            this.endElement(parser, parser.getName());
        }
        if (progress != null) {
            progress.finishTask();
        }
        this.completeReading();
    }

    public synchronized void parseOSM(InputStream stream, IProgress progress) throws IOException, XmlPullParserException {
        this.parseOSM(stream, progress, null, true);
    }

    public boolean isSupressWarnings() {
        return this.supressWarnings;
    }

    public void setSupressWarnings(boolean supressWarnings) {
        this.supressWarnings = supressWarnings;
    }

    public boolean isOsmChange() {
        return this.osmChange;
    }

    protected Long parseId(XmlPullParser parser, String name, long defId) {
        long id2 = defId;
        String value = parser.getAttributeValue("", name);
        try {
            id2 = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id2;
    }

    protected double parseDouble(XmlPullParser parser, String name, double defVal) {
        double ret = defVal;
        String value = parser.getAttributeValue("", name);
        if (value == null) {
            return defVal;
        }
        try {
            ret = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    protected void initRootElement(XmlPullParser parser, String name) throws OsmVersionNotSupported {
        if (!ELEM_OSM.equals(name) && !ELEM_OSMCHANGE.equals(name) || !supportedVersions.contains(parser.getAttributeValue("", ATTR_VERSION))) {
            throw new OsmVersionNotSupported();
        }
        this.osmChange = ELEM_OSMCHANGE.equals(name);
        this.parseStarted = true;
    }

    public void startElement(XmlPullParser parser, String name) {
        if (!this.parseStarted) {
            this.initRootElement(parser, name);
        }
        if (ELEM_MODIFY.equals(name)) {
            this.currentModify = 1;
        } else if (ELEM_CREATE.equals(name)) {
            this.currentModify = 2;
        } else if (ELEM_DELETE.equals(name)) {
            this.currentModify = -1;
        } else if (this.currentParsedEntity == null) {
            ++this.progressEntity;
            if (this.progress != null && this.progressEntity % 1024 == 0 && !this.progress.isIndeterminate() && this.streamForProgress != null) {
                try {
                    this.progress.remaining(this.streamForProgress.available());
                }
                catch (IOException e) {
                    this.progress.startWork(-1);
                }
            }
            if (ELEM_NODE.equals(name)) {
                this.currentParsedEntity = new Node(this.parseDouble(parser, ATTR_LAT, 0.0), this.parseDouble(parser, ATTR_LON, 0.0), this.parseId(parser, ATTR_ID, -1L));
            } else if (ELEM_WAY.equals(name)) {
                this.currentParsedEntity = new Way(this.parseId(parser, ATTR_ID, -1L));
            } else if (ELEM_RELATION.equals(name)) {
                this.currentParsedEntity = new Relation(this.parseId(parser, ATTR_ID, -1L));
            }
            if (this.currentParsedEntity != null) {
                this.currentParsedEntity.setModify(this.currentModify);
                if (this.parseEntityInfo) {
                    this.currentParsedEntityInfo = new EntityInfo();
                    this.currentParsedEntityInfo.setChangeset(parser.getAttributeValue("", ATTR_CHANGESET));
                    this.currentParsedEntityInfo.setTimestamp(parser.getAttributeValue("", ATTR_TIMESTAMP));
                    this.currentParsedEntityInfo.setUser(parser.getAttributeValue("", ATTR_USER));
                    this.currentParsedEntityInfo.setVersion(parser.getAttributeValue("", ATTR_VERSION));
                    this.currentParsedEntityInfo.setVisible(parser.getAttributeValue("", ATTR_VISIBLE));
                    this.currentParsedEntityInfo.setUid(parser.getAttributeValue("", ATTR_UID));
                }
            }
        } else if (ELEM_TAG.equals(name)) {
            String key = parser.getAttributeValue("", ATTR_K);
            if (key != null) {
                this.currentParsedEntity.putTag(key, parser.getAttributeValue("", ATTR_V));
            }
        } else if (ELEM_ND.equals(name)) {
            Long id2 = this.parseId(parser, ATTR_REF, -1L);
            if (id2 != -1L && this.currentParsedEntity instanceof Way) {
                ((Way)this.currentParsedEntity).addNode(id2);
            }
        } else if (ELEM_MEMBER.equals(name)) {
            try {
                Long id3 = this.parseId(parser, ATTR_REF, -1L);
                if (id3 != -1L && this.currentParsedEntity instanceof Relation) {
                    Entity.EntityType type = Entity.EntityType.valueOf(parser.getAttributeValue("", ATTR_TYPE).toUpperCase());
                    ((Relation)this.currentParsedEntity).addMember(id3, type, parser.getAttributeValue("", ATTR_ROLE));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void endElement(XmlPullParser parser, String name) {
        Entity.EntityType type = null;
        if (ELEM_NODE.equals(name)) {
            type = Entity.EntityType.NODE;
        } else if (ELEM_WAY.equals(name)) {
            type = Entity.EntityType.WAY;
        } else if (ELEM_RELATION.equals(name)) {
            type = Entity.EntityType.RELATION;
        } else if (ELEM_MODIFY.equals(name)) {
            this.currentModify = 0;
        } else if (ELEM_CREATE.equals(name)) {
            this.currentModify = 0;
        } else if (ELEM_DELETE.equals(name)) {
            this.currentModify = 0;
        }
        if (type != null && this.currentParsedEntity != null) {
            Entity.EntityId entityId = new Entity.EntityId(type, this.currentParsedEntity.getId());
            if (this.acceptEntityToLoad(entityId, this.currentParsedEntity)) {
                Entity oldEntity = this.entities.put(entityId, this.currentParsedEntity);
                if (this.parseEntityInfo && this.currentParsedEntityInfo != null) {
                    this.entityInfo.put(entityId, this.currentParsedEntityInfo);
                }
                if (!this.supressWarnings && oldEntity != null) {
                    throw new UnsupportedOperationException("Entity with id=" + oldEntity.getId() + " is duplicated in osm map");
                }
            }
            this.currentParsedEntity = null;
        }
    }

    public void registerEntity(Entity entity, EntityInfo info) {
        this.entities.put(Entity.EntityId.valueOf(entity), entity);
        if (info != null) {
            this.entityInfo.put(Entity.EntityId.valueOf(entity), info);
        }
    }

    protected boolean acceptEntityToLoad(Entity.EntityId entityId, Entity entity) {
        for (IOsmStorageFilter f : this.filters) {
            if (f.acceptEntityToLoad(this, entityId, entity)) continue;
            return false;
        }
        return true;
    }

    public void completeReading() {
        for (Entity e : this.entities.values()) {
            e.initializeLinks(this.entities);
        }
    }

    public Map<Entity.EntityId, EntityInfo> getRegisteredEntityInfo() {
        return this.entityInfo;
    }

    public Map<Entity.EntityId, Entity> getRegisteredEntities() {
        return this.entities;
    }

    public List<IOsmStorageFilter> getFilters() {
        return this.filters;
    }

    static {
        supportedVersions.add("0.6");
        supportedVersions.add("0.5");
    }

    public static class OsmVersionNotSupported
    extends RuntimeException {
        private static final long serialVersionUID = -127558215143984838L;
    }
}

