/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.CompilerVariableHelper;
import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class UnixJVMLocator {
    private static final String[] UNIX_DIR_KEYWORDS = new String[]{"java", "jre", "jdk", "j2sdk", "j2re", "j2jre"};
    public static final String[] JDK_FILES = new String[]{"bin/javac"};
    public static final String JAVA_EXECUTABLE = "bin/java";
    public static final String FIND_COMMON_SHARED_JRES_VARIABLE_NAME = "findCommonSharedJres";

    public static Collection<JVMLocator.JVMLocation> getJVMLocations() {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        ArrayList<String> unixRootLocations = new ArrayList<String>();
        unixRootLocations.addAll(UnixJVMLocator.getSharedLocations("/opt/i4j_jres", "/usr/local/i4j_jres", new File(Util.getUserHome(), ".i4j_jres").getAbsolutePath()));
        unixRootLocations.addAll(Arrays.asList("/usr/bin", "/usr", "/usr/java", "/usr/lib/java", "/usr/lib/jvm", "/usr/local", "/usr/lib", "/usr/jdk", "/opt"));
        for (String unixRootLocation : unixRootLocations) {
            ret.addAll(UnixJVMLocator.searchRootLocation(unixRootLocation));
        }
        return ret;
    }

    public static List<String> getSharedLocations(String ... baseLocations) {
        String sharingKey;
        ArrayList<String> ret = new ArrayList<String>();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig != null && !(sharingKey = installerConfig.getJreSharingKey()).isEmpty()) {
            for (String baseLocation : baseLocations) {
                ret.add(new File(baseLocation, sharingKey).getAbsolutePath());
            }
        }
        if (UnixJVMLocator.isFindCommonShared()) {
            ret.addAll(Arrays.asList(baseLocations));
        }
        return ret;
    }

    private static boolean isFindCommonShared() {
        return CompilerVariableHelper.getCompilerExtensionVariable((Context)ContextImpl.getSingleContextInt(), FIND_COMMON_SHARED_JRES_VARIABLE_NAME, false);
    }

    private static Collection<JVMLocator.JVMLocation> searchRootLocation(String rootLocation) {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        File[] files = new File(rootLocation).listFiles();
        if (files != null) {
            block2: for (File file : files) {
                if (!file.isDirectory()) continue;
                for (String keyword : UNIX_DIR_KEYWORDS) {
                    if (!file.getName().contains(keyword)) continue;
                    try {
                        JVMLocator.JVMLocation jvmLocation = JVMLocator.checkJVMLocation(file, JAVA_EXECUTABLE, JDK_FILES);
                        if (jvmLocation == null) {
                            jvmLocation = JVMLocator.checkJVMLocation(new File(file, "jre"), JAVA_EXECUTABLE, JDK_FILES);
                        }
                        if (jvmLocation == null) continue block2;
                        ret.add(jvmLocation);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block2;
                }
            }
        }
        return ret;
    }
}

