/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperTypeRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.AdminPermissionManagement;
import org.keycloak.services.resources.admin.fgap.AdminPermissions;
import org.keycloak.utils.ProfileHelper;

@Extension(name="x-smallrye-profile-admin", value="")
public class IdentityProviderResource {
    protected static final Logger logger = Logger.getLogger(IdentityProviderResource.class);
    private final AdminPermissionEvaluator auth;
    private final RealmModel realm;
    private final KeycloakSession session;
    private final IdentityProviderModel identityProviderModel;
    private final AdminEventBuilder adminEvent;

    public IdentityProviderResource(AdminPermissionEvaluator auth, RealmModel realm, KeycloakSession session, IdentityProviderModel identityProviderModel, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.identityProviderModel = identityProviderModel;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.IDENTITY_PROVIDER);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Get the identity provider")
    public IdentityProviderRepresentation getIdentityProvider() {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        return (IdentityProviderRepresentation)StripSecretsUtils.stripSecrets((KeycloakSession)this.session, (Object)ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)this.identityProviderModel));
    }

    @DELETE
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Delete the identity provider")
    public Response delete() {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        String alias = this.identityProviderModel.getAlias();
        this.session.users().preRemove(this.realm, this.identityProviderModel);
        this.session.identityProviders().remove(alias);
        this.realm.getIdentityProviderMappersByAliasStream(alias).collect(Collectors.toList()).forEach(arg_0 -> ((RealmModel)this.realm).removeIdentityProviderMapper(arg_0));
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Update the identity provider")
    public Response update(IdentityProviderRepresentation providerRep) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        try {
            this.updateIdpFromRep(providerRep, this.realm, this.session);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(providerRep).success();
            return Response.noContent().build();
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Invalid request";
            }
            throw ErrorResponse.error(message, Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Identity Provider " + providerRep.getAlias() + " already exists");
        }
    }

    private void updateIdpFromRep(IdentityProviderRepresentation providerRep, RealmModel realm, KeycloakSession session) {
        IdentityProviderModel updated;
        if (!this.identityProviderModel.getInternalId().equals(providerRep.getInternalId())) {
            providerRep.setInternalId(this.identityProviderModel.getInternalId());
        }
        if ((updated = RepresentationToModel.toModel((RealmModel)realm, (IdentityProviderRepresentation)providerRep, (KeycloakSession)session)).getConfig() != null && "**********".equals(updated.getConfig().get("clientSecret"))) {
            updated.getConfig().put("clientSecret", this.identityProviderModel.getConfig() != null ? (String)this.identityProviderModel.getConfig().get("clientSecret") : null);
        }
        session.identityProviders().update(updated);
        providerRep.setHideOnLogin(updated.isHideOnLogin());
        String newProviderAlias = providerRep.getAlias();
        String oldProviderAlias = this.identityProviderModel.getAlias();
        if (!oldProviderAlias.equals(newProviderAlias)) {
            logger.debugf("Changing providerId in all clients and linked users. oldProviderId=%s, newProviderId=%s", (Object)oldProviderAlias, (Object)newProviderAlias);
            IdentityProviderResource.updateUsersAfterProviderAliasChange(session.users().searchForUserStream(realm, Collections.singletonMap("keycloak.session.realm.users.query.include_service_account", Boolean.FALSE.toString())), oldProviderAlias, newProviderAlias, realm, session);
        }
    }

    private static void updateUsersAfterProviderAliasChange(Stream<UserModel> users, String oldProviderId, String newProviderId, RealmModel realm, KeycloakSession session) {
        users.forEach(user -> {
            FederatedIdentityModel federatedIdentity = session.users().getFederatedIdentity(realm, user, oldProviderId);
            if (federatedIdentity != null) {
                session.users().removeFederatedIdentity(realm, user, oldProviderId);
                FederatedIdentityModel newFederatedIdentity = new FederatedIdentityModel(newProviderId, federatedIdentity.getUserId(), federatedIdentity.getUserName(), federatedIdentity.getToken());
                session.users().addFederatedIdentity(realm, user, newFederatedIdentity);
            }
        });
    }

    private IdentityProviderFactory<?> getIdentityProviderFactory() {
        String providerId = this.identityProviderModel.getProviderId();
        return Stream.concat(this.session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class), this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class)).filter(providerFactory -> Objects.equals(providerFactory.getId(), providerId)).map(IdentityProviderFactory.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("IDP not found by Provider ID: " + providerId));
    }

    @GET
    @Path(value="export")
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Export public broker configuration for identity provider")
    public Response export(@Parameter(description="Format to use") @QueryParam(value="format") String format) {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        try {
            return this.createIdentityProviderInstance().export((UriInfo)this.session.getContext().getUri(), this.realm, format);
        }
        catch (Exception e) {
            throw ErrorResponse.error("Could not export public broker configuration for identity provider [" + this.identityProviderModel.getProviderId() + "].", Response.Status.NOT_FOUND);
        }
    }

    private IdentityProvider<?> createIdentityProviderInstance() {
        IdentityProviderFactory<?> factory = this.getIdentityProviderFactory();
        return factory.create(this.session, this.identityProviderModel);
    }

    @GET
    @Path(value="mapper-types")
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Get mapper types for identity provider")
    public Map<String, IdentityProviderMapperTypeRepresentation> getMapperTypes() {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProvider<?> identityProviderInstance = this.createIdentityProviderInstance();
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        return sessionFactory.getProviderFactoriesStream(IdentityProviderMapper.class).map(IdentityProviderMapper.class::cast).filter(arg_0 -> identityProviderInstance.isMapperSupported(arg_0)).map(mapper -> {
            IdentityProviderMapperTypeRepresentation rep = new IdentityProviderMapperTypeRepresentation();
            rep.setId(mapper.getId());
            rep.setCategory(mapper.getDisplayCategory());
            rep.setName(mapper.getDisplayType());
            rep.setHelpText(mapper.getHelpText());
            rep.setProperties(mapper.getConfigProperties().stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList()));
            return rep;
        }).collect(Collectors.toMap(IdentityProviderMapperTypeRepresentation::getId, Function.identity()));
    }

    @GET
    @Path(value="mappers")
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Get mappers for identity provider")
    public Stream<IdentityProviderMapperRepresentation> getMappers() {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        return this.session.identityProviders().getMappersByAliasStream(this.identityProviderModel.getAlias()).map(ModelToRepresentation::toRepresentation);
    }

    @POST
    @Path(value="mappers")
    @Consumes(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Add a mapper to identity provider")
    public Response addMapper(IdentityProviderMapperRepresentation mapper) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)mapper);
        try {
            model = this.session.identityProviders().createMapper(model);
        }
        catch (Exception e) {
            throw ErrorResponse.error("Failed to add mapper '" + model.getName() + "' to identity provider [" + this.identityProviderModel.getProviderId() + "].", Response.Status.BAD_REQUEST);
        }
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.IDENTITY_PROVIDER_MAPPER).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(mapper).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @NoCache
    @Path(value="mappers/{id}")
    @Produces(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Get mapper by id for the identity provider")
    public IdentityProviderMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = this.session.identityProviders().getMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return ModelToRepresentation.toRepresentation((IdentityProviderMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="mappers/{id}")
    @Consumes(value={"application/json"})
    @Tag(name="Identity Providers")
    @Operation(summary="Update a mapper for the identity provider")
    public void update(@Parameter(description="Mapper id") @PathParam(value="id") String id, IdentityProviderMapperRepresentation rep) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = this.session.identityProviders().getMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)rep);
        this.session.identityProviders().updateMapper(model);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.IDENTITY_PROVIDER_MAPPER).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @DELETE
    @NoCache
    @Path(value="mappers/{id}")
    @Tag(name="Identity Providers")
    @Operation(summary="Delete a mapper for the identity provider")
    public void delete(@Parameter(description="Mapper id") @PathParam(value="id") String id) {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProviderMapperModel model = this.session.identityProviders().getMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.session.identityProviders().removeMapper(model);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.IDENTITY_PROVIDER_MAPPER).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Return object stating whether client Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference getManagementPermissions() {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        this.auth.realm().requireViewIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.idps().isPermissionsEnabled(this.identityProviderModel)) {
            return new ManagementPermissionReference();
        }
        return this.toMgmtRef(this.identityProviderModel, permissions);
    }

    private ManagementPermissionReference toMgmtRef(IdentityProviderModel model, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.idps().resource(model).getId());
        ref.setScopePermissions(permissions.idps().getPermissions(model));
        return ref;
    }

    @Path(value="management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Return object stating whether client Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference setManagementPermissionsEnabled(ManagementPermissionReference ref) {
        ProfileHelper.requireFeature(Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ);
        this.auth.realm().requireManageIdentityProviders();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        permissions.idps().setPermissionsEnabled(this.identityProviderModel, ref.isEnabled());
        if (ref.isEnabled()) {
            return this.toMgmtRef(this.identityProviderModel, permissions);
        }
        return new ManagementPermissionReference();
    }

    @GET
    @Path(value="reload-keys")
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Identity Providers")
    @Operation(summary="Reaload keys for the identity provider if the provider supports it, \"true\" is returned if reload was performed, \"false\" if not.")
    public boolean reloadKeys() {
        this.auth.realm().requireManageIdentityProviders();
        if (this.identityProviderModel == null) {
            throw new NotFoundException();
        }
        IdentityProvider<?> provider = IdentityBrokerService.getIdentityProvider(this.session, this.identityProviderModel.getAlias());
        return provider.reloadKeys();
    }
}

