/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Permute axes and flip images as needed to obtain an approximation to
the desired orientation.


The physical location of all pixels in the image remains the same, but
the meta-data and the ordering of the stored pixels may change.

DICOMOrientImageFilter depends on a set of constants that describe all possible labels.
Directions are labeled in terms of following pairs:


Left and Right (Subject's left and right)

Anterior and Posterior (Subject's front and back)

Inferior and Superior (Subject's bottom and top, i.e. feet and head)
 The initials of these directions are used in a 3 letter code in the
enumerated type OrientationEnum. The initials are given fastest moving
index first, second fastest second, third fastest third, where the
label's direction indicates increasing values.

An ITK image with an identity direction cosine matrix is in LPS (Left,
Posterior, Superior) orientation as defined by the DICOM standard.

\\[ LPS = \\begin{Bmatrix} from\\ right\\ to\\
\\textbf{L}eft \\\\ from\\ anterior\\ towards\\
\\textbf{P}osterior \\\\ from\\ inferior\\ towards\\
\\textbf{S}uperior \\end{Bmatrix} \\]

The output orientation is specified with
SetDesiredCoordinateOrientation. The input coordinate orientation is
computed from the input image's direction cosine matrix.
See:
 itk::simple::DICOMOrient for the procedural interface

 itk::DICOMOrientImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDICOMOrientImageFilter.h
*/
public class DICOMOrientImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DICOMOrientImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DICOMOrientImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DICOMOrientImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DICOMOrientImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DICOMOrientImageFilter::~DICOMOrientImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DICOMOrientImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DICOMOrientImageFilter::DICOMOrientImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DICOMOrientImageFilter() {
    this(SimpleITKJNI.new_DICOMOrientImageFilter(), true);
  }

  public static String getOrientationFromDirectionCosines(VectorDouble direction) {
    return SimpleITKJNI.DICOMOrientImageFilter_getOrientationFromDirectionCosines(VectorDouble.getCPtr(direction), direction);
  }

  public static VectorDouble getDirectionCosinesFromOrientation(String str) {
    return new VectorDouble(SimpleITKJNI.DICOMOrientImageFilter_getDirectionCosinesFromOrientation(str), true);
  }

  /**
Self&amp; itk::simple::DICOMOrientImageFilter::SetDesiredCoordinateOrientation(std::string DesiredCoordinateOrientation)

Set/Get the desired coordinate orientation for the output image

*/
public  void setDesiredCoordinateOrientation(String DesiredCoordinateOrientation) {
    SimpleITKJNI.DICOMOrientImageFilter_setDesiredCoordinateOrientation(swigCPtr, this, DesiredCoordinateOrientation);
  }

  /**
std::string itk::simple::DICOMOrientImageFilter::GetDesiredCoordinateOrientation() const

Set/Get the desired coordinate orientation for the output image

*/
public  String getDesiredCoordinateOrientation() {
    return SimpleITKJNI.DICOMOrientImageFilter_getDesiredCoordinateOrientation(swigCPtr, this);
  }

  /**
std::vector&lt;bool&gt; itk::simple::DICOMOrientImageFilter::GetFlipAxes() const

    Get flip axes.

This value is computed during Update.    This is a measurement. Its value is updated in the Execute
methods, so the value will only be valid after an execution.

*/
public  VectorBool getFlipAxes() {
    return new VectorBool(SimpleITKJNI.DICOMOrientImageFilter_getFlipAxes(swigCPtr, this), true);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::DICOMOrientImageFilter::GetPermuteOrder() const

    Get axes permute order.

This value is computed during Update.    This is a measurement. Its value is updated in the Execute
methods, so the value will only be valid after an execution.

*/
public  VectorUInt32 getPermuteOrder() {
    return new VectorUInt32(SimpleITKJNI.DICOMOrientImageFilter_getPermuteOrder(swigCPtr, this), true);
  }

  /**
std::string itk::simple::DICOMOrientImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DICOMOrientImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DICOMOrientImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DICOMOrientImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DICOMOrientImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DICOMOrientImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
