/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module glib.MemChunk;

private import glib.ConstructionException;
private import glib.Str;
private import glib.c.functions;
public  import glib.c.types;


/** */
public class MemChunk
{
	/** the main Gtk struct */
	protected GMemChunk* gMemChunk;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GMemChunk* getMemChunkStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gMemChunk;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gMemChunk;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GMemChunk* gMemChunk, bool ownedRef = false)
	{
		this.gMemChunk = gMemChunk;
		this.ownedRef = ownedRef;
	}


	/** */
	public void* alloc()
	{
		return g_mem_chunk_alloc(gMemChunk);
	}

	/** */
	public void* alloc0()
	{
		return g_mem_chunk_alloc0(gMemChunk);
	}

	/** */
	public void clean()
	{
		g_mem_chunk_clean(gMemChunk);
	}

	/** */
	public void destroy()
	{
		g_mem_chunk_destroy(gMemChunk);
	}

	/** */
	public void free(void* mem)
	{
		g_mem_chunk_free(gMemChunk, mem);
	}

	/** */
	public void print()
	{
		g_mem_chunk_print(gMemChunk);
	}

	/** */
	public void reset()
	{
		g_mem_chunk_reset(gMemChunk);
	}

	/** */
	public static void info()
	{
		g_mem_chunk_info();
	}

	/** */
	public this(string name, int atomSize, size_t areaSize, int type)
	{
		auto __p = g_mem_chunk_new(Str.toStringz(name), atomSize, areaSize, type);

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(GMemChunk*) __p);
	}
}
