/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.font;

import io.sf.carte.echosvg.gvt.font.AWTGVTGlyphVector;
import io.sf.carte.echosvg.gvt.font.AWTGlyphGeometryCache;
import io.sf.carte.echosvg.gvt.font.GVTFont;
import io.sf.carte.echosvg.gvt.font.GVTGlyphVector;
import io.sf.carte.echosvg.gvt.font.GVTLineMetrics;
import io.sf.carte.echosvg.gvt.text.ArabicTextHandler;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class AWTGVTFont
implements GVTFont {
    protected Font awtFont;
    protected double size;
    protected double scale;
    public static final float FONT_SIZE = 48.0f;
    static Map<Font, Object> fontCache = new HashMap<Font, Object>(11);

    public AWTGVTFont(Font font) {
        this.size = font.getSize2D();
        this.awtFont = font.deriveFont(48.0f);
        this.scale = this.size / (double)this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public AWTGVTFont(Font font, double d) {
        this.size = (double)font.getSize2D() * d;
        this.awtFont = font.deriveFont(48.0f);
        this.scale = this.size / (double)this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public AWTGVTFont(Map<AttributedCharacterIterator.Attribute, Object> map) {
        Float f = (Float)map.get(TextAttribute.SIZE);
        if (f != null) {
            this.size = f.floatValue();
            map.put(TextAttribute.SIZE, Float.valueOf(48.0f));
            this.awtFont = new Font(map);
        } else {
            this.awtFont = new Font(map);
            this.size = this.awtFont.getSize2D();
        }
        this.scale = this.size / (double)this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public AWTGVTFont(String string, int n, int n2) {
        this.awtFont = new Font(string, n, 48);
        this.size = n2;
        this.scale = (float)n2 / this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    @Override
    public boolean canDisplay(char c) {
        return this.awtFont.canDisplay(c);
    }

    @Override
    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        return this.awtFont.canDisplayUpTo(cArray, n, n2);
    }

    @Override
    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        return this.awtFont.canDisplayUpTo(characterIterator, n, n2);
    }

    @Override
    public int canDisplayUpTo(String string) {
        return this.awtFont.canDisplayUpTo(string);
    }

    @Override
    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        GlyphVector glyphVector = this.awtFont.createGlyphVector(fontRenderContext, cArray);
        return new AWTGVTGlyphVector(glyphVector, this, this.scale, stringCharacterIterator);
    }

    @Override
    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        Cloneable cloneable;
        if (characterIterator instanceof AttributedCharacterIterator && ArabicTextHandler.containsArabic(cloneable = (AttributedCharacterIterator)characterIterator)) {
            String string = ArabicTextHandler.createSubstituteString(cloneable);
            return this.createGlyphVector(fontRenderContext, string);
        }
        cloneable = this.awtFont.createGlyphVector(fontRenderContext, characterIterator);
        return new AWTGVTGlyphVector((GlyphVector)cloneable, this, this.scale, characterIterator);
    }

    @Override
    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray, CharacterIterator characterIterator) {
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, nArray), this, this.scale, characterIterator);
    }

    @Override
    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, string), this, this.scale, stringCharacterIterator);
    }

    @Override
    public GVTFont deriveFont(float f) {
        return new AWTGVTFont(this.awtFont, (double)f / this.size);
    }

    @Override
    public String getFamilyName() {
        return this.awtFont.getFamily();
    }

    @Override
    public GVTLineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(cArray, n, n2, fontRenderContext), (float)this.scale);
    }

    @Override
    public GVTLineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(characterIterator, n, n2, fontRenderContext), (float)this.scale);
    }

    @Override
    public GVTLineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, fontRenderContext), (float)this.scale);
    }

    @Override
    public GVTLineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, n, n2, fontRenderContext), (float)this.scale);
    }

    @Override
    public float getSize() {
        return (float)this.size;
    }

    @Override
    public float getHKern(int n, int n2) {
        return 0.0f;
    }

    @Override
    public float getVKern(int n, int n2) {
        return 0.0f;
    }

    public static AWTGlyphGeometryCache.Value getGlyphGeometry(AWTGVTFont aWTGVTFont, char c, GlyphVector glyphVector, int n, Point2D point2D) {
        AWTGlyphGeometryCache aWTGlyphGeometryCache = (AWTGlyphGeometryCache)fontCache.get(aWTGVTFont.awtFont);
        AWTGlyphGeometryCache.Value value = aWTGlyphGeometryCache.get(c);
        if (value == null) {
            Shape shape = glyphVector.getGlyphOutline(n);
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(n);
            Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
            if (AWTGVTGlyphVector.outlinesPositioned()) {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-point2D.getX(), -point2D.getY());
                shape = affineTransform.createTransformedShape(shape);
            }
            value = new AWTGlyphGeometryCache.Value(shape, rectangle2D);
            aWTGlyphGeometryCache.put(c, value);
        }
        return value;
    }

    static void initializeFontCache(Font font) {
        if (!fontCache.containsKey(font)) {
            fontCache.put(font, new AWTGlyphGeometryCache());
        }
    }

    static void putAWTGVTFont(AWTGVTFont aWTGVTFont) {
        fontCache.put(aWTGVTFont.awtFont, aWTGVTFont);
    }

    static AWTGVTFont getAWTGVTFont(Font font) {
        return (AWTGVTFont)fontCache.get(font);
    }
}

