# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoDetailsAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'description_path': 'str',
        'support': 'str',
        'channel': 'VideoChannel',
        'account': 'Account',
        'tags': 'list[str]',
        'files': 'list[VideoFile]',
        'comments_enabled': 'bool',
        'download_enabled': 'bool',
        'tracker_urls': 'list[str]',
        'streaming_playlists': 'list[VideoStreamingPlaylists]'
    }

    attribute_map = {
        'description_path': 'descriptionPath',
        'support': 'support',
        'channel': 'channel',
        'account': 'account',
        'tags': 'tags',
        'files': 'files',
        'comments_enabled': 'commentsEnabled',
        'download_enabled': 'downloadEnabled',
        'tracker_urls': 'trackerUrls',
        'streaming_playlists': 'streamingPlaylists'
    }

    def __init__(self, description_path=None, support=None, channel=None, account=None, tags=None, files=None, comments_enabled=None, download_enabled=None, tracker_urls=None, streaming_playlists=None, local_vars_configuration=None):  # noqa: E501
        """VideoDetailsAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._description_path = None
        self._support = None
        self._channel = None
        self._account = None
        self._tags = None
        self._files = None
        self._comments_enabled = None
        self._download_enabled = None
        self._tracker_urls = None
        self._streaming_playlists = None
        self.discriminator = None

        if description_path is not None:
            self.description_path = description_path
        if support is not None:
            self.support = support
        if channel is not None:
            self.channel = channel
        if account is not None:
            self.account = account
        if tags is not None:
            self.tags = tags
        if files is not None:
            self.files = files
        if comments_enabled is not None:
            self.comments_enabled = comments_enabled
        if download_enabled is not None:
            self.download_enabled = download_enabled
        if tracker_urls is not None:
            self.tracker_urls = tracker_urls
        if streaming_playlists is not None:
            self.streaming_playlists = streaming_playlists

    @property
    def description_path(self):
        """Gets the description_path of this VideoDetailsAllOf.  # noqa: E501


        :return: The description_path of this VideoDetailsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._description_path

    @description_path.setter
    def description_path(self, description_path):
        """Sets the description_path of this VideoDetailsAllOf.


        :param description_path: The description_path of this VideoDetailsAllOf.  # noqa: E501
        :type description_path: str
        """

        self._description_path = description_path

    @property
    def support(self):
        """Gets the support of this VideoDetailsAllOf.  # noqa: E501

        A text tell the audience how to support the video creator  # noqa: E501

        :return: The support of this VideoDetailsAllOf.  # noqa: E501
        :rtype: str
        """
        return self._support

    @support.setter
    def support(self, support):
        """Sets the support of this VideoDetailsAllOf.

        A text tell the audience how to support the video creator  # noqa: E501

        :param support: The support of this VideoDetailsAllOf.  # noqa: E501
        :type support: str
        """

        self._support = support

    @property
    def channel(self):
        """Gets the channel of this VideoDetailsAllOf.  # noqa: E501


        :return: The channel of this VideoDetailsAllOf.  # noqa: E501
        :rtype: VideoChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel):
        """Sets the channel of this VideoDetailsAllOf.


        :param channel: The channel of this VideoDetailsAllOf.  # noqa: E501
        :type channel: VideoChannel
        """

        self._channel = channel

    @property
    def account(self):
        """Gets the account of this VideoDetailsAllOf.  # noqa: E501


        :return: The account of this VideoDetailsAllOf.  # noqa: E501
        :rtype: Account
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this VideoDetailsAllOf.


        :param account: The account of this VideoDetailsAllOf.  # noqa: E501
        :type account: Account
        """

        self._account = account

    @property
    def tags(self):
        """Gets the tags of this VideoDetailsAllOf.  # noqa: E501


        :return: The tags of this VideoDetailsAllOf.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this VideoDetailsAllOf.


        :param tags: The tags of this VideoDetailsAllOf.  # noqa: E501
        :type tags: list[str]
        """

        self._tags = tags

    @property
    def files(self):
        """Gets the files of this VideoDetailsAllOf.  # noqa: E501

        WebTorrent/raw video files. Can be empty if WebTorrent is disabled on the server. In this case, video files will be in the \"streamingPlaylists[].files\" property  # noqa: E501

        :return: The files of this VideoDetailsAllOf.  # noqa: E501
        :rtype: list[VideoFile]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this VideoDetailsAllOf.

        WebTorrent/raw video files. Can be empty if WebTorrent is disabled on the server. In this case, video files will be in the \"streamingPlaylists[].files\" property  # noqa: E501

        :param files: The files of this VideoDetailsAllOf.  # noqa: E501
        :type files: list[VideoFile]
        """

        self._files = files

    @property
    def comments_enabled(self):
        """Gets the comments_enabled of this VideoDetailsAllOf.  # noqa: E501


        :return: The comments_enabled of this VideoDetailsAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._comments_enabled

    @comments_enabled.setter
    def comments_enabled(self, comments_enabled):
        """Sets the comments_enabled of this VideoDetailsAllOf.


        :param comments_enabled: The comments_enabled of this VideoDetailsAllOf.  # noqa: E501
        :type comments_enabled: bool
        """

        self._comments_enabled = comments_enabled

    @property
    def download_enabled(self):
        """Gets the download_enabled of this VideoDetailsAllOf.  # noqa: E501


        :return: The download_enabled of this VideoDetailsAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._download_enabled

    @download_enabled.setter
    def download_enabled(self, download_enabled):
        """Sets the download_enabled of this VideoDetailsAllOf.


        :param download_enabled: The download_enabled of this VideoDetailsAllOf.  # noqa: E501
        :type download_enabled: bool
        """

        self._download_enabled = download_enabled

    @property
    def tracker_urls(self):
        """Gets the tracker_urls of this VideoDetailsAllOf.  # noqa: E501


        :return: The tracker_urls of this VideoDetailsAllOf.  # noqa: E501
        :rtype: list[str]
        """
        return self._tracker_urls

    @tracker_urls.setter
    def tracker_urls(self, tracker_urls):
        """Sets the tracker_urls of this VideoDetailsAllOf.


        :param tracker_urls: The tracker_urls of this VideoDetailsAllOf.  # noqa: E501
        :type tracker_urls: list[str]
        """

        self._tracker_urls = tracker_urls

    @property
    def streaming_playlists(self):
        """Gets the streaming_playlists of this VideoDetailsAllOf.  # noqa: E501


        :return: The streaming_playlists of this VideoDetailsAllOf.  # noqa: E501
        :rtype: list[VideoStreamingPlaylists]
        """
        return self._streaming_playlists

    @streaming_playlists.setter
    def streaming_playlists(self, streaming_playlists):
        """Sets the streaming_playlists of this VideoDetailsAllOf.


        :param streaming_playlists: The streaming_playlists of this VideoDetailsAllOf.  # noqa: E501
        :type streaming_playlists: list[VideoStreamingPlaylists]
        """

        self._streaming_playlists = streaming_playlists

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoDetailsAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoDetailsAllOf):
            return True

        return self.to_dict() != other.to_dict()
