# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class MRSSGroupContent(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'url': 'str',
        'file_size': 'int',
        'type': 'str',
        'framerate': 'int',
        'duration': 'int',
        'height': 'int',
        'lang': 'str'
    }

    attribute_map = {
        'url': 'url',
        'file_size': 'fileSize',
        'type': 'type',
        'framerate': 'framerate',
        'duration': 'duration',
        'height': 'height',
        'lang': 'lang'
    }

    def __init__(self, url=None, file_size=None, type=None, framerate=None, duration=None, height=None, lang=None, local_vars_configuration=None):  # noqa: E501
        """MRSSGroupContent - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._url = None
        self._file_size = None
        self._type = None
        self._framerate = None
        self._duration = None
        self._height = None
        self._lang = None
        self.discriminator = None

        if url is not None:
            self.url = url
        if file_size is not None:
            self.file_size = file_size
        if type is not None:
            self.type = type
        if framerate is not None:
            self.framerate = framerate
        if duration is not None:
            self.duration = duration
        if height is not None:
            self.height = height
        if lang is not None:
            self.lang = lang

    @property
    def url(self):
        """Gets the url of this MRSSGroupContent.  # noqa: E501


        :return: The url of this MRSSGroupContent.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this MRSSGroupContent.


        :param url: The url of this MRSSGroupContent.  # noqa: E501
        :type url: str
        """

        self._url = url

    @property
    def file_size(self):
        """Gets the file_size of this MRSSGroupContent.  # noqa: E501


        :return: The file_size of this MRSSGroupContent.  # noqa: E501
        :rtype: int
        """
        return self._file_size

    @file_size.setter
    def file_size(self, file_size):
        """Sets the file_size of this MRSSGroupContent.


        :param file_size: The file_size of this MRSSGroupContent.  # noqa: E501
        :type file_size: int
        """

        self._file_size = file_size

    @property
    def type(self):
        """Gets the type of this MRSSGroupContent.  # noqa: E501


        :return: The type of this MRSSGroupContent.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this MRSSGroupContent.


        :param type: The type of this MRSSGroupContent.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def framerate(self):
        """Gets the framerate of this MRSSGroupContent.  # noqa: E501


        :return: The framerate of this MRSSGroupContent.  # noqa: E501
        :rtype: int
        """
        return self._framerate

    @framerate.setter
    def framerate(self, framerate):
        """Sets the framerate of this MRSSGroupContent.


        :param framerate: The framerate of this MRSSGroupContent.  # noqa: E501
        :type framerate: int
        """

        self._framerate = framerate

    @property
    def duration(self):
        """Gets the duration of this MRSSGroupContent.  # noqa: E501


        :return: The duration of this MRSSGroupContent.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this MRSSGroupContent.


        :param duration: The duration of this MRSSGroupContent.  # noqa: E501
        :type duration: int
        """

        self._duration = duration

    @property
    def height(self):
        """Gets the height of this MRSSGroupContent.  # noqa: E501


        :return: The height of this MRSSGroupContent.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this MRSSGroupContent.


        :param height: The height of this MRSSGroupContent.  # noqa: E501
        :type height: int
        """

        self._height = height

    @property
    def lang(self):
        """Gets the lang of this MRSSGroupContent.  # noqa: E501


        :return: The lang of this MRSSGroupContent.  # noqa: E501
        :rtype: str
        """
        return self._lang

    @lang.setter
    def lang(self, lang):
        """Sets the lang of this MRSSGroupContent.


        :param lang: The lang of this MRSSGroupContent.  # noqa: E501
        :type lang: str
        """

        self._lang = lang

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MRSSGroupContent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MRSSGroupContent):
            return True

        return self.to_dict() != other.to_dict()
