/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle.stagent;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.graalvm.visualvm.sampler.truffle.stagent.AgentClassLoader;
import org.graalvm.visualvm.sampler.truffle.stagent.Truffle;
import org.graalvm.visualvm.sampler.truffle.stagent.TruffleClassLoader;
import sun.misc.Unsafe;

public class TruffleJMX {
    static boolean DEBUG = false;

    public static void agentmain(String agentArgs, Instrumentation inst) throws MalformedObjectNameException, InstantiationException, IllegalAccessException, InterruptedException {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            if (DEBUG) {
                System.out.println("Unsafe " + unsafe);
            }
            Object context = TruffleJMX.getContext();
            Object impl = TruffleJMX.getContextImpl(context);
            URL jarURL = TruffleJMX.getJarURL();
            if (impl == null) {
                impl = context;
            }
            URLClassLoader ur = TruffleJMX.getSamplerClassLoader(impl, unsafe, jarURL);
            Object truffle = TruffleJMX.getTruffleInstance(ur, unsafe);
            TruffleJMX.registerMXBean(truffle);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static Object getContext() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, SecurityException, IllegalAccessException, IllegalArgumentException {
        ClassLoader systemCl = ClassLoader.getSystemClassLoader();
        Class<?> contextClass = systemCl.loadClass("org.graalvm.polyglot.Context");
        Method builderMethod = contextClass.getMethod("newBuilder", String[].class);
        Object builder = builderMethod.invoke(null, new Object[]{new String[0]});
        Method allowExpMethod = builder.getClass().getMethod("allowExperimentalOptions", Boolean.TYPE);
        builder = allowExpMethod.invoke(builder, Boolean.TRUE);
        Method buildMethod = builder.getClass().getMethod("build", new Class[0]);
        Object context = buildMethod.invoke(builder, new Object[0]);
        if (DEBUG) {
            System.out.println("Context: " + context.getClass());
        }
        if (DEBUG) {
            System.out.println("Context ClassLoader: " + context.getClass().getClassLoader());
        }
        return context;
    }

    private static Object getContextImpl(Object context) throws IllegalArgumentException, SecurityException, NoSuchFieldException, IllegalAccessException {
        Field implField = TruffleJMX.getDeclaredField(context, "impl", "receiver", "dispatch");
        try {
            implField.setAccessible(true);
            Object impl = implField.get(context);
            if (DEBUG) {
                System.out.println("Context Impl: " + impl);
            }
            if (DEBUG && impl != null) {
                System.out.println("Context Impl ClassLoader: " + impl.getClass().getClassLoader());
            }
            return impl;
        }
        catch (RuntimeException ex) {
            if (ex.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                return null;
            }
            throw ex;
        }
    }

    static Field getDeclaredField(Object obj, String ... names) throws NoSuchFieldException {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field f : obj.getClass().getDeclaredFields()) {
            fields.put(f.getName(), f);
        }
        for (String name : names) {
            Field f = (Field)fields.get(name);
            if (f == null) continue;
            return f;
        }
        throw new NoSuchFieldException(Arrays.toString(names));
    }

    private static URL getJarURL() throws IOException {
        URL classUrl = ClassLoader.getSystemResource("org/graalvm/visualvm/sampler/truffle/stagent/Truffle.class");
        JarURLConnection connection = (JarURLConnection)classUrl.openConnection();
        if (DEBUG) {
            System.out.println("URL " + classUrl);
        }
        if (DEBUG) {
            System.out.println("URL " + connection.getJarFileURL());
        }
        return connection.getJarFileURL();
    }

    private static URLClassLoader getSamplerClassLoader(Object impl, Unsafe unsafe, URL jarURL) throws IllegalAccessException, NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalArgumentException {
        TruffleClassLoader truffleLoader = new TruffleClassLoader(impl.getClass().getClassLoader(), unsafe);
        AgentClassLoader ur = new AgentClassLoader(new URL[]{jarURL}, (ClassLoader)truffleLoader);
        if (DEBUG) {
            System.out.println("Class " + ur.loadClass("com.oracle.truffle.api.TruffleStackTraceElement"));
        }
        if (DEBUG) {
            System.out.println("Class " + ur.loadClass("com.oracle.truffle.api.impl.TruffleLocator"));
        }
        if (DEBUG) {
            System.out.println("Class " + ur.loadClass("com.oracle.truffle.polyglot.PolyglotEngineImpl"));
        }
        if (DEBUG) {
            System.out.println("Class " + ur.loadClass("com.oracle.truffle.tools.profiler.CPUSampler"));
        }
        return ur;
    }

    private static Object getTruffleInstance(URLClassLoader ur, Unsafe unsafe) throws IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        Class<?> TruffleClass = ur.loadClass(Truffle.class.getName());
        if (DEBUG) {
            System.out.println("Class " + TruffleClass + " ClassLoader " + TruffleClass.getClassLoader());
        }
        Constructor<?> TruffleClassConstructor = TruffleClass.getConstructor(Unsafe.class);
        return TruffleClassConstructor.newInstance(unsafe);
    }

    private static void registerMXBean(Object truffle) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("com.truffle:type=Threading");
            mbs.registerMBean(truffle, mxbeanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MBeanRegistrationException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NotCompliantMBeanException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedObjectNameException ex) {
            Logger.getLogger(TruffleJMX.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

