/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.LimitOptions;

public class TableTypesFilter
implements Predicate<Table> {
    private final TableTypes tableTypes;

    public TableTypesFilter() {
        this.tableTypes = TableTypes.includeAll();
    }

    public TableTypesFilter(LimitOptions options) {
        Objects.requireNonNull(options, "No limit options provided");
        this.tableTypes = options.getTableTypes();
    }

    public TableTypesFilter(String ... tableTypesFiltered) {
        this.tableTypes = TableTypes.from(tableTypesFiltered);
    }

    @Override
    public boolean test(Table table) {
        return this.tableTypes.lookupTableType(table.getTableType().getTableType()).isPresent();
    }
}

