/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import schemacrawler.schema.JdbcDriverProperty;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.AbstractProperty;
import us.fatehi.utility.property.PropertyName;

final class ImmutableJdbcDriverProperty
extends AbstractProperty
implements JdbcDriverProperty {
    private static final long serialVersionUID = 8030156654422512161L;
    private final List<String> choices;
    private final boolean required;

    ImmutableJdbcDriverProperty(DriverPropertyInfo driverPropertyInfo) {
        super(new PropertyName(driverPropertyInfo.name, driverPropertyInfo.description), (Serializable)((Object)driverPropertyInfo.value));
        this.required = driverPropertyInfo.required;
        if (driverPropertyInfo.choices == null) {
            this.choices = Collections.emptyList();
        } else {
            this.choices = Arrays.asList(driverPropertyInfo.choices);
            this.choices.sort(Comparator.naturalOrder());
        }
    }

    @Override
    public Collection<String> getChoices() {
        return new ArrayList<String>(this.choices);
    }

    @Override
    public String getValue() {
        return (String)((Object)super.getValue());
    }

    public boolean hasDescription() {
        return !Utility.isBlank((CharSequence)this.getDescription());
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("%s = %s%n", this.getName(), this.getValue()));
        if (this.hasDescription()) {
            buffer.append(this.getDescription()).append(String.format("%n", new Object[0]));
        }
        buffer.append(String.format("  is required? %b%n  choices: %s", this.isRequired(), this.getChoices()));
        return buffer.toString();
    }
}

