/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import schemacrawler.schema.IdentifiedEnum;
import us.fatehi.utility.Utility;

public class EnumUtility {
    public static <E extends Enum<E>> E enumValue(String value, E defaultValue) {
        Object enumValue;
        Objects.requireNonNull(defaultValue, "No default value provided");
        if (Utility.isBlank(value)) {
            enumValue = defaultValue;
        } else {
            try {
                Class<?> enumClass = defaultValue.getClass();
                if (enumClass.getEnclosingClass() != null) {
                    enumClass = enumClass.getEnclosingClass();
                }
                enumValue = Enum.valueOf(enumClass, value.trim());
            }
            catch (Exception e) {
                enumValue = defaultValue;
            }
        }
        return enumValue;
    }

    public static <E extends Enum<E>> E enumValueFromId(int value, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        try {
            Class<?> enumClass = defaultValue.getClass();
            for (Enum enumValue : EnumSet.allOf(enumClass)) {
                if (((IdentifiedEnum)((Object)enumValue)).id() != value) continue;
                return (E)enumValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> Set<E> enumValues(String values, String splitBy, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        EnumSet<E> enumValues = EnumSet.of(defaultValue);
        if (Utility.isBlank(values)) {
            return enumValues;
        }
        String[] valueStrings = Utility.isBlank(splitBy) ? new String[]{values} : values.split(splitBy);
        for (String valueString : valueStrings) {
            E enumValue = EnumUtility.enumValue(valueString, defaultValue);
            enumValues.add(enumValue);
        }
        if (enumValues.size() > 1) {
            enumValues.remove(defaultValue);
        }
        return enumValues;
    }

    private EnumUtility() {
    }
}

