/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;

public class DateFormat {
    private static final char[][] dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'D'}, {'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F', '1'}, {'F', 'F', '2'}, {'F', 'F', '3'}, {'F', 'F', '4'}, {'F', 'F', '5'}, {'F', 'F', '6'}, {'F', 'F', '7'}, {'F', 'F', '8'}, {'F', 'F', '9'}, {'F', 'F'}, {'T', 'Z'}};
    private static final String[] javaDateTokens = new String[]{"uuuu", "YYYY", "uuuu", "YY", "uu", "G", "G", "G", "G", "MMM", "MMMM", "MM", "EEEE", "EE", "F", "W", "ww", "dd", "D", "HH", "KK", "HH", "mm", "ss", "a", "a", "a", "a", "[S]", "[SS]", "[SSS]", "[SSSS]", "[SSSSS]", "[SSSSSS]", "[SSSSSSS]", "[SSSSSSSS]", "[SSSSSSSSS]", "SSSSSS", "xxxxx"};
    private static final char[] fixedFraction = new char[]{'F', 'F'};
    private static final String variableFraction = "[[SSSSSSSSS][SSSSSSSS][SSSSSSS][SSSSSS][SSSSS][SSSS][SSS][SS][S]]";
    private static final char e = '\uffff';
    private static final String javaPrefix = "JAVA:";

    public static DateTimeFormatter toFormatter(String string, boolean bl) {
        try {
            String string2 = "MMM";
            Locale locale = Locale.UK;
            String string3 = DateFormat.toJavaDatePattern(string, bl);
            int n = string3.indexOf(string2);
            if (n >= 0 && (n + string2.length() == string3.length() || string3.charAt(n + string2.length()) != 'M')) {
                locale = Locale.US;
            }
            DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
            dateTimeFormatterBuilder.parseCaseInsensitive();
            dateTimeFormatterBuilder.parseLenient();
            dateTimeFormatterBuilder.appendPattern(string3);
            DateTimeFormatter dateTimeFormatter = dateTimeFormatterBuilder.toFormatter(locale);
            return dateTimeFormatter;
        }
        catch (Exception exception) {
            throw Error.error(exception, 3407, exception.toString());
        }
    }

    public static TimestampData toDate(DateTimeType dateTimeType, String string, DateTimeFormatter dateTimeFormatter) {
        int n = 0;
        int n2 = 0;
        try {
            long l;
            ParsePosition parsePosition = new ParsePosition(0);
            TemporalAccessor temporalAccessor = dateTimeFormatter.parse((CharSequence)string, parsePosition);
            switch (dateTimeType.typeCode) {
                case 95: {
                    if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                        OffsetDateTime offsetDateTime = OffsetDateTime.from(temporalAccessor);
                        l = offsetDateTime.toEpochSecond();
                        n = offsetDateTime.getNano();
                        n2 = offsetDateTime.getOffset().getTotalSeconds();
                        break;
                    }
                }
                case 93: {
                    if (temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE)) {
                        LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
                        l = localDateTime.toEpochSecond(ZoneOffset.UTC);
                        n = localDateTime.getNano();
                        break;
                    }
                }
                case 91: {
                    LocalDate localDate = LocalDate.from(temporalAccessor);
                    l = localDate.toEpochDay() * 86400L;
                    break;
                }
                default: {
                    throw Error.error(5561);
                }
            }
            n = DTIType.normaliseFraction(n, dateTimeType.scale);
            return new TimestampData(l, n, n2);
        }
        catch (Exception exception) {
            throw Error.error(exception, 3407, exception.toString());
        }
    }

    public static TimestampData toDate(DateTimeType dateTimeType, String string, String string2) {
        DateTimeFormatter dateTimeFormatter = DateFormat.toFormatter(string2, true);
        return DateFormat.toDate(dateTimeType, string, dateTimeFormatter);
    }

    public static String toFormattedDate(DateTimeType dateTimeType, Object object, DateTimeFormatter dateTimeFormatter) {
        try {
            Comparable<ChronoLocalDateTime<?>> comparable;
            Object object2;
            switch (dateTimeType.typeCode) {
                case 91: 
                case 93: 
                case 95: {
                    object2 = (TimestampData)object;
                    LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(((TimestampData)object2).seconds + (long)((TimestampData)object2).zone, ((TimestampData)object2).nanos, ZoneOffset.UTC);
                    if (dateTimeType.typeCode == 95) {
                        comparable = OffsetDateTime.of(localDateTime, ZoneOffset.ofTotalSeconds(((TimestampData)object2).zone));
                        break;
                    }
                    comparable = localDateTime;
                    break;
                }
                case 92: 
                case 94: {
                    TimeData timeData = (TimeData)object;
                    LocalTime localTime = LocalTime.ofNanoOfDay((long)(timeData.seconds + timeData.zone) * 1000000000L + (long)timeData.nanos);
                    if (dateTimeType.typeCode == 94) {
                        comparable = OffsetTime.of(localTime, ZoneOffset.ofTotalSeconds(timeData.zone));
                        break;
                    }
                    comparable = localTime;
                    break;
                }
                default: {
                    throw Error.error(5561);
                }
            }
            object2 = dateTimeFormatter.format((TemporalAccessor)((Object)comparable));
            return object2;
        }
        catch (Exception exception) {
            throw Error.error(exception, 3407, exception.toString());
        }
    }

    public static String toFormattedDate(DateTimeType dateTimeType, Object object, String string) {
        DateTimeFormatter dateTimeFormatter = DateFormat.toFormatter(string, false);
        return DateFormat.toFormattedDate(dateTimeType, object, dateTimeFormatter);
    }

    public static String toJavaDatePattern(String string, boolean bl) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        Tokenizer tokenizer = new Tokenizer();
        if (string.startsWith(javaPrefix)) {
            return string.substring(javaPrefix.length());
        }
        for (int i = 0; i <= n; ++i) {
            char c;
            char c2 = c = i == n ? (char)'\uffff' : (char)string.charAt(i);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(c)) {
                    c = '\'';
                } else if (c == '\'') {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c);
                continue;
            }
            if (tokenizer.next(c, i)) continue;
            if (tokenizer.consumed) {
                int n2 = tokenizer.getLastMatch();
                String string2 = javaDateTokens[n2];
                if (Arrays.equals(dateTokens[n2], fixedFraction) && bl) {
                    string2 = variableFraction;
                }
                stringBuilder.append(string2);
                i = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(c)) {
                c = '\'';
                stringBuilder.append(c);
            } else if (tokenizer.isLiteral(c)) {
                stringBuilder.append(c);
            } else if (c != '\uffff') {
                throw Error.error(3407, string.substring(i));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        String string3 = stringBuilder.toString();
        return string3;
    }

    static /* synthetic */ char[][] access$200() {
        return dateTokens;
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        private final char[][] tokens = DateFormat.access$200();

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char c) {
            if (this.quoteChar == c) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char c) {
            return ArrayUtil.isInSortedArray(c, this.literalChars);
        }

        private boolean isZeroBit(int n) {
            return (this.state & 1L << n) == 0L;
        }

        private void setBit(int n) {
            this.state |= 1L << n;
        }

        public boolean next(char c, int n) {
            int n2 = ++this.offset;
            int n3 = this.offset + 1;
            int n4 = 0;
            this.matched = false;
            int n5 = this.tokens.length;
            while (--n5 >= 0) {
                if (!this.isZeroBit(n5)) continue;
                if (this.tokens[n5][n2] == Character.toUpperCase(c)) {
                    if (this.tokens[n5].length == n3) {
                        this.setBit(n5);
                        this.lastMatched = n5;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = n;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                this.setBit(n5);
            }
            return n4 > 0;
        }
    }
}

