/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.propagation.ExtendedContextPropagators;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.ExtendedSpanBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.ExtendedTracer;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.SpanCallable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.trace.SpanRunnable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.ApiUsageLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Span;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanKind;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Tracer;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.context.propagation.ContextPropagators;

@ThreadSafe
final class ExtendedDefaultTracer
implements ExtendedTracer {
    private static final Tracer INSTANCE = new ExtendedDefaultTracer();

    static Tracer getNoop() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private ExtendedDefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements ExtendedSpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            if (context == null) {
                ApiUsageLogger.log("context is null");
                return this;
            }
            this.spanContext = Span.fromContext(context).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setParentFrom(ContextPropagators propagators, Map<String, String> carrier) {
            this.setParent(ExtendedContextPropagators.extractTextMapPropagationContext(carrier, propagators));
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAllAttributes(Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(SpanKind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            return this;
        }

        @Override
        public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable) throws E {
            return spanCallable.callInSpan();
        }

        @Override
        public <T, E extends Throwable> T startAndCall(SpanCallable<T, E> spanCallable, BiConsumer<Span, Throwable> handleException) throws E {
            return spanCallable.callInSpan();
        }

        @Override
        public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable) throws E {
            runnable.runInSpan();
        }

        @Override
        public <E extends Throwable> void startAndRun(SpanRunnable<E> runnable, BiConsumer<Span, Throwable> handleException) throws E {
            runnable.runInSpan();
        }

        private NoopSpanBuilder() {
        }
    }
}

