/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpHeaders;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequestFactory;
import net.snowflake.client.jdbc.internal.google.api.client.json.JsonObjectParser;
import net.snowflake.client.jdbc.internal.google.api.client.util.ObjectParser;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;
import net.snowflake.client.jdbc.internal.opencensus.trace.Span;
import net.snowflake.client.jdbc.internal.opencensus.trace.Tracer;
import net.snowflake.client.jdbc.internal.opencensus.trace.Tracing;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

final class HttpClientContext {
    private final HttpRequestFactory requestFactory;
    private final ObjectParser objectParser;
    private final Tracer tracer;

    private HttpClientContext(HttpRequestFactory requestFactory, ObjectParser objectParser, Tracer tracer) {
        this.requestFactory = requestFactory;
        this.objectParser = objectParser;
        this.tracer = tracer;
    }

    static @Nullable String firstHeaderValue(@NonNull HttpHeaders headers, @NonNull String headerName) {
        Object v = headers.get(headerName);
        if (v instanceof List) {
            List list = (List)v;
            return (String)list.get(0);
        }
        return null;
    }

    public HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public ObjectParser getObjectParser() {
        return this.objectParser;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Span startSpan(String name) {
        return this.tracer.spanBuilder(name).setRecordEvents(true).startSpan();
    }

    static HttpClientContext from(StorageRpc storageRpc) {
        return new HttpClientContext(storageRpc.getStorage().getRequestFactory(), storageRpc.getStorage().getObjectParser(), Tracing.getTracer());
    }

    public static HttpClientContext of(HttpRequestFactory requestFactory, JsonObjectParser jsonObjectParser) {
        return new HttpClientContext(requestFactory, jsonObjectParser, Tracing.getTracer());
    }
}

