/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.DetectedPlatform;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.EnvironmentVariables;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.detection.GCPPlatformDetector;

final class GoogleCloudRunJob
implements DetectedPlatform {
    private final GCPMetadataConfig metadataConfig;
    private final EnvironmentVariables environmentVariables;
    private final Map<String, String> availableAttributes;

    GoogleCloudRunJob(EnvironmentVariables environmentVariables, GCPMetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
        this.environmentVariables = environmentVariables;
        this.availableAttributes = this.prepareAttributes();
    }

    private Map<String, String> prepareAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("serverless_compute_name", this.environmentVariables.get("CLOUD_RUN_JOB"));
        map.put("gcr_job_execution_key", this.environmentVariables.get("CLOUD_RUN_EXECUTION"));
        map.put("gcr_job_task_index", this.environmentVariables.get("CLOUD_RUN_TASK_INDEX"));
        map.put("instance_id", this.metadataConfig.getInstanceId());
        map.put("cloud_region", this.metadataConfig.getRegionFromZone());
        return map;
    }

    @Override
    public GCPPlatformDetector.SupportedPlatform getSupportedPlatform() {
        return GCPPlatformDetector.SupportedPlatform.GOOGLE_CLOUD_RUN_JOB;
    }

    @Override
    public String getProjectId() {
        return this.metadataConfig.getProjectId();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.availableAttributes;
    }
}

