/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWK;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.cnf.AbstractConfirmation;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public final class JWKThumbprintConfirmation
extends AbstractConfirmation {
    private final Base64URL jkt;

    public JWKThumbprintConfirmation(Base64URL jkt) {
        this.jkt = Objects.requireNonNull(jkt);
    }

    public Base64URL getValue() {
        return this.jkt;
    }

    @Override
    public Map.Entry<String, JSONObject> toJWTClaim() {
        JSONObject cnf = new JSONObject();
        cnf.put("jkt", this.jkt.toString());
        return new AbstractMap.SimpleImmutableEntry<String, JSONObject>("cnf", cnf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWKThumbprintConfirmation)) {
            return false;
        }
        JWKThumbprintConfirmation that = (JWKThumbprintConfirmation)o;
        return this.jkt.equals(that.jkt);
    }

    public int hashCode() {
        return Objects.hash(this.jkt);
    }

    public static JWKThumbprintConfirmation parse(JWTClaimsSet jwtClaimsSet) {
        JSONObject cnf = JWKThumbprintConfirmation.parseConfirmationJSONObject(jwtClaimsSet);
        if (cnf == null) {
            return null;
        }
        return JWKThumbprintConfirmation.parseFromConfirmationJSONObject(cnf);
    }

    public static JWKThumbprintConfirmation parse(JSONObject jsonObject) {
        if (!jsonObject.containsKey("cnf")) {
            return null;
        }
        try {
            return JWKThumbprintConfirmation.parseFromConfirmationJSONObject(JSONObjectUtils.getJSONObject(jsonObject, "cnf"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static JWKThumbprintConfirmation parseFromConfirmationJSONObject(JSONObject cnf) {
        if (cnf == null) {
            return null;
        }
        try {
            String jktString = JSONObjectUtils.getNonBlankString(cnf, "jkt");
            return new JWKThumbprintConfirmation(new Base64URL(jktString));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static JWKThumbprintConfirmation of(JWK jwk) throws JOSEException {
        return new JWKThumbprintConfirmation(jwk.computeThumbprint());
    }
}

