/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema.options;

import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputFormatState;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public enum TextOutputFormat implements OutputFormat
{
    text("Plain text format", "txt"),
    html("HyperText Markup Language (HTML) format"),
    tsv("Tab-separated values (TSV) format");

    private static final Logger LOGGER;
    private final OutputFormatState outputFormatState;

    public static TextOutputFormat fromFormat(String format) {
        TextOutputFormat outputFormat = TextOutputFormat.fromFormatOrNull(format);
        if (outputFormat == null) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Unknown format <%s>, using default", new Object[]{format}));
            return text;
        }
        return outputFormat;
    }

    public static boolean isSupportedFormat(String format) {
        return TextOutputFormat.fromFormatOrNull(format) != null;
    }

    private static TextOutputFormat fromFormatOrNull(String format) {
        if (Utility.isBlank((CharSequence)format)) {
            return null;
        }
        for (TextOutputFormat outputFormat : TextOutputFormat.values()) {
            if (!outputFormat.outputFormatState.isSupportedFormat(format)) continue;
            return outputFormat;
        }
        return null;
    }

    private TextOutputFormat(String description) {
        this.outputFormatState = new OutputFormatState(this.name(), description, new String[0]);
    }

    private TextOutputFormat(String description, String formatSpecifier) {
        this.outputFormatState = new OutputFormatState(formatSpecifier, description, new String[]{this.name()});
    }

    public String getDescription() {
        return this.outputFormatState.getDescription();
    }

    public String getFormat() {
        return this.outputFormatState.getFormat();
    }

    public List<String> getFormats() {
        return this.outputFormatState.getFormats();
    }

    public String toString() {
        return this.outputFormatState.toString();
    }

    static {
        LOGGER = Logger.getLogger(TextOutputFormat.class.getName());
    }
}

