/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyTabbedSetEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.objectproperty.OWLDisjointObjectPropertiesAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLDisjointObjectPropertiesFrameSection
extends AbstractOWLFrameSection<OWLObjectProperty, OWLDisjointObjectPropertiesAxiom, Set<OWLObjectPropertyExpression>> {
    public static final String LABEL = "Disjoint With";

    public OWLDisjointObjectPropertiesFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLObjectProperty> frame) {
        super(editorKit, LABEL, "Disjoint properties", frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLDisjointObjectPropertiesAxiom ax : ontology.getDisjointObjectPropertiesAxioms((OWLObjectPropertyExpression)this.getRootObject())) {
            this.addRow(new OWLDisjointObjectPropertiesAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLObjectProperty)this.getRootObject(), ax));
        }
    }

    @Override
    protected OWLDisjointObjectPropertiesAxiom createAxiom(Set<OWLObjectPropertyExpression> object) {
        HashSet<OWLObjectPropertyExpression> disjoints = new HashSet<OWLObjectPropertyExpression>(object);
        disjoints.add((OWLObjectPropertyExpression)this.getRootObject());
        return this.getOWLDataFactory().getOWLDisjointObjectPropertiesAxiom(disjoints);
    }

    @Override
    public OWLObjectEditor<Set<OWLObjectPropertyExpression>> getObjectEditor() {
        return new OWLObjectPropertyTabbedSetEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<Set<OWLObjectPropertyExpression>> editor) {
        Set<OWLObjectPropertyExpression> equivalents = editor.getEditedObject();
        return !equivalents.contains(this.getRootObject());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLObjectProperty, OWLDisjointObjectPropertiesAxiom, Set<OWLObjectPropertyExpression>>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLDisjointObjectPropertiesAxiom && ((OWLDisjointObjectPropertiesAxiom)change.getAxiom()).getProperties().contains(this.getRootObject());
    }
}

