/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.wnameless.json.base.JacksonJsonArray;
import com.github.wnameless.json.base.JacksonJsonValue;
import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonSource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class JacksonJsonObject
implements JsonObjectCore<JacksonJsonValue> {
    private final ObjectNode jsonObject;

    public JacksonJsonObject(ObjectNode jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jsonObject = jsonObject;
    }

    @Override
    public JacksonJsonValue get(String name) {
        JsonNode node = this.jsonObject.get(name);
        return node == null ? null : new JacksonJsonValue(node);
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonJsonObject)) {
            return false;
        }
        return Objects.equals(this.jsonObject, ((JacksonJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, JacksonJsonValue>> iterator() {
        return new JacksonJsonEntryIterator(this.jsonObject.fields());
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public void set(String name, JsonSource jsonValue) {
        this.jsonObject.set(name, (JsonNode)jsonValue.getSource());
    }

    @Override
    public boolean remove(String name) {
        return this.jsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.jsonObject.has(name);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public JacksonJsonObject asObject() {
        return this;
    }

    @Override
    public JacksonJsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JacksonJsonValue asValue() {
        return new JacksonJsonValue((JsonNode)this.jsonObject);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getSource() {
        return this.jsonObject;
    }

    @Override
    public Iterator<String> names() {
        return this.jsonObject.fieldNames();
    }

    private final class JacksonJsonEntryIterator
    implements Iterator<Map.Entry<String, JacksonJsonValue>> {
        private final Iterator<Map.Entry<String, JsonNode>> jsonNodeIterator;

        private JacksonJsonEntryIterator(Iterator<Map.Entry<String, JsonNode>> jsonNodeIterator) {
            this.jsonNodeIterator = jsonNodeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonNodeIterator.hasNext();
        }

        @Override
        public Map.Entry<String, JacksonJsonValue> next() {
            Map.Entry<String, JsonNode> member = this.jsonNodeIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, JacksonJsonValue>(member.getKey(), new JacksonJsonValue(member.getValue()));
        }
    }
}

