/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.agent.MLAgentUpdateInput;
import org.opensearch.ml.common.transport.agent.MLAgentUpdateRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateAgentTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateAgentTransportAction.class);
    Client client;
    SdkClient sdkClient;
    NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public UpdateAgentTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/agents/update", transportService, actionFilters, MLAgentUpdateRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        MLAgentUpdateRequest mlAgentUpdateRequest = MLAgentUpdateRequest.fromActionRequest((ActionRequest)request);
        MLAgentUpdateInput mlAgentUpdateInput = mlAgentUpdateRequest.getMlAgentUpdateInput();
        String agentId = mlAgentUpdateInput.getAgentId();
        String tenantId = mlAgentUpdateInput.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                log.debug("Completed Get Agent request for Agent ID {}", (Object)agentId);
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to get ML Agent {}", (Object)agentId, (Object)cause);
                    wrappedListener.onFailure(cause);
                } else {
                    try {
                        GetResponse getResponse = r.getResponse();
                        if (getResponse == null || !getResponse.isExists()) {
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to get agent with ID " + agentId, RestStatus.NOT_FOUND, new Object[0]));
                        }
                        XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLAgent retrievedAgent = MLAgent.parse((XContentParser)parser);
                        if (TenantAwareHelper.validateTenantResource(this.mlFeatureEnabledSetting, tenantId, retrievedAgent.getTenantId(), wrappedListener)) {
                            if (retrievedAgent.getIsHidden().booleanValue() && !isSuperAdmin) {
                                wrappedListener.onFailure((Exception)new OpenSearchStatusException("User does not have privilege to perform this operation on this agent", RestStatus.FORBIDDEN, new Object[0]));
                            } else {
                                this.updateAgent(agentId, mlAgentUpdateInput, retrievedAgent, (ActionListener<UpdateResponse>)wrappedListener);
                            }
                        } else {
                            log.error("Failed to validate tenant for Agent ID {}", (Object)agentId);
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to get ML agent {}", (Object)agentId);
                        wrappedListener.onFailure(e);
                    }
                }
            });
        }
    }

    private void updateAgent(String agentId, MLAgentUpdateInput updateInput, MLAgent originalAgent, ActionListener<UpdateResponse> wrappedListener) {
        Instant now = Instant.now();
        updateInput.setLastUpdateTime(now);
        MLAgent updatedAgent = updateInput.toMLAgent(originalAgent);
        UpdateDataObjectRequest updateDataObjectRequest = ((UpdateDataObjectRequest.Builder)((UpdateDataObjectRequest.Builder)UpdateDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).dataObject((ToXContentObject)updatedAgent).build();
        this.sdkClient.updateDataObjectAsync(updateDataObjectRequest).whenComplete((r, throwable) -> {
            log.debug("Completed Update Agent request for Agent ID {}", (Object)agentId);
            if (throwable != null) {
                Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                log.error("Failed to update ML Agent {}", (Object)agentId, (Object)cause);
                wrappedListener.onFailure(cause);
            } else {
                try {
                    UpdateResponse updateResponse = r.updateResponse();
                    if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                        log.info("Successfully updated ML agent {}", (Object)agentId);
                        wrappedListener.onResponse((Object)updateResponse);
                    }
                }
                catch (Exception e) {
                    log.error("Failed to update ML agent {}", (Object)agentId, (Object)e);
                    wrappedListener.onFailure(e);
                }
            }
        });
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

