/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InferenceDeviceInfo;
import software.amazon.awssdk.services.ec2.model.InferenceDeviceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceAcceleratorInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceAcceleratorInfo> {
    private static final SdkField<List<InferenceDeviceInfo>> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accelerators").getter(InferenceAcceleratorInfo.getter(InferenceAcceleratorInfo::accelerators)).setter(InferenceAcceleratorInfo.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators").unmarshallLocationName("accelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceDeviceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_INFERENCE_MEMORY_IN_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInferenceMemoryInMiB").getter(InferenceAcceleratorInfo.getter(InferenceAcceleratorInfo::totalInferenceMemoryInMiB)).setter(InferenceAcceleratorInfo.setter(Builder::totalInferenceMemoryInMiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInferenceMemoryInMiB").unmarshallLocationName("totalInferenceMemoryInMiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD, TOTAL_INFERENCE_MEMORY_IN_MIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceAcceleratorInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<InferenceDeviceInfo> accelerators;
    private final Integer totalInferenceMemoryInMiB;

    private InferenceAcceleratorInfo(BuilderImpl builder) {
        this.accelerators = builder.accelerators;
        this.totalInferenceMemoryInMiB = builder.totalInferenceMemoryInMiB;
    }

    public final boolean hasAccelerators() {
        return this.accelerators != null && !(this.accelerators instanceof SdkAutoConstructList);
    }

    public final List<InferenceDeviceInfo> accelerators() {
        return this.accelerators;
    }

    public final Integer totalInferenceMemoryInMiB() {
        return this.totalInferenceMemoryInMiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccelerators() ? this.accelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInferenceMemoryInMiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceAcceleratorInfo)) {
            return false;
        }
        InferenceAcceleratorInfo other = (InferenceAcceleratorInfo)obj;
        return this.hasAccelerators() == other.hasAccelerators() && Objects.equals(this.accelerators(), other.accelerators()) && Objects.equals(this.totalInferenceMemoryInMiB(), other.totalInferenceMemoryInMiB());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceAcceleratorInfo").add("Accelerators", this.hasAccelerators() ? this.accelerators() : null).add("TotalInferenceMemoryInMiB", (Object)this.totalInferenceMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accelerators": {
                return Optional.ofNullable(clazz.cast(this.accelerators()));
            }
            case "TotalInferenceMemoryInMiB": {
                return Optional.ofNullable(clazz.cast(this.totalInferenceMemoryInMiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Accelerators", ACCELERATORS_FIELD);
        map.put("TotalInferenceMemoryInMiB", TOTAL_INFERENCE_MEMORY_IN_MIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceAcceleratorInfo, T> g) {
        return obj -> g.apply((InferenceAcceleratorInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InferenceDeviceInfo> accelerators = DefaultSdkAutoConstructList.getInstance();
        private Integer totalInferenceMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceAcceleratorInfo model) {
            this.accelerators(model.accelerators);
            this.totalInferenceMemoryInMiB(model.totalInferenceMemoryInMiB);
        }

        public final List<InferenceDeviceInfo.Builder> getAccelerators() {
            List<InferenceDeviceInfo.Builder> result = InferenceDeviceInfoListCopier.copyToBuilder(this.accelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccelerators(Collection<InferenceDeviceInfo.BuilderImpl> accelerators) {
            this.accelerators = InferenceDeviceInfoListCopier.copyFromBuilder(accelerators);
        }

        @Override
        public final Builder accelerators(Collection<InferenceDeviceInfo> accelerators) {
            this.accelerators = InferenceDeviceInfoListCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(InferenceDeviceInfo ... accelerators) {
            this.accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<InferenceDeviceInfo.Builder> ... accelerators) {
            this.accelerators(Stream.of(accelerators).map(c -> (InferenceDeviceInfo)((InferenceDeviceInfo.Builder)InferenceDeviceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalInferenceMemoryInMiB() {
            return this.totalInferenceMemoryInMiB;
        }

        public final void setTotalInferenceMemoryInMiB(Integer totalInferenceMemoryInMiB) {
            this.totalInferenceMemoryInMiB = totalInferenceMemoryInMiB;
        }

        @Override
        public final Builder totalInferenceMemoryInMiB(Integer totalInferenceMemoryInMiB) {
            this.totalInferenceMemoryInMiB = totalInferenceMemoryInMiB;
            return this;
        }

        public InferenceAcceleratorInfo build() {
            return new InferenceAcceleratorInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceAcceleratorInfo> {
        public Builder accelerators(Collection<InferenceDeviceInfo> var1);

        public Builder accelerators(InferenceDeviceInfo ... var1);

        public Builder accelerators(Consumer<InferenceDeviceInfo.Builder> ... var1);

        public Builder totalInferenceMemoryInMiB(Integer var1);
    }
}

