/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CustomerGateway;
import software.amazon.awssdk.services.ec2.model.CustomerGatewayListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomerGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCustomerGatewaysResponse> {
    private static final SdkField<List<CustomerGateway>> CUSTOMER_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerGateways").getter(DescribeCustomerGatewaysResponse.getter(DescribeCustomerGatewaysResponse::customerGateways)).setter(DescribeCustomerGatewaysResponse.setter(Builder::customerGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewaySet").unmarshallLocationName("customerGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCustomerGatewaysResponse.memberNameToFieldInitializer();
    private final List<CustomerGateway> customerGateways;

    private DescribeCustomerGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.customerGateways = builder.customerGateways;
    }

    public final boolean hasCustomerGateways() {
        return this.customerGateways != null && !(this.customerGateways instanceof SdkAutoConstructList);
    }

    public final List<CustomerGateway> customerGateways() {
        return this.customerGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerGateways() ? this.customerGateways() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysResponse)) {
            return false;
        }
        DescribeCustomerGatewaysResponse other = (DescribeCustomerGatewaysResponse)((Object)obj);
        return this.hasCustomerGateways() == other.hasCustomerGateways() && Objects.equals(this.customerGateways(), other.customerGateways());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomerGatewaysResponse").add("CustomerGateways", this.hasCustomerGateways() ? this.customerGateways() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGateways": {
                return Optional.ofNullable(clazz.cast(this.customerGateways()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<CustomerGateway>>> map = new HashMap<String, SdkField<List<CustomerGateway>>>();
        map.put("CustomerGatewaySet", CUSTOMER_GATEWAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomerGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeCustomerGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CustomerGateway> customerGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysResponse model) {
            super(model);
            this.customerGateways(model.customerGateways);
        }

        public final List<CustomerGateway.Builder> getCustomerGateways() {
            List<CustomerGateway.Builder> result = CustomerGatewayListCopier.copyToBuilder(this.customerGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerGateways(Collection<CustomerGateway.BuilderImpl> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copyFromBuilder(customerGateways);
        }

        @Override
        public final Builder customerGateways(Collection<CustomerGateway> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copy(customerGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(CustomerGateway ... customerGateways) {
            this.customerGateways(Arrays.asList(customerGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(Consumer<CustomerGateway.Builder> ... customerGateways) {
            this.customerGateways(Stream.of(customerGateways).map(c -> (CustomerGateway)((CustomerGateway.Builder)CustomerGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCustomerGatewaysResponse build() {
            return new DescribeCustomerGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomerGatewaysResponse> {
        public Builder customerGateways(Collection<CustomerGateway> var1);

        public Builder customerGateways(CustomerGateway ... var1);

        public Builder customerGateways(Consumer<CustomerGateway.Builder> ... var1);
    }
}

