/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.mqtt5.packets.PubAckPacket;

public class PublishResult {
    private PublishResultType type;
    private PubAckPacket pubackData;

    public PublishResultType getType() {
        return this.type;
    }

    public Object getValue() {
        if (this.type == PublishResultType.NONE) {
            return null;
        }
        if (this.type == PublishResultType.PUBACK) {
            return this.getResultPubAck();
        }
        Log.log(Log.LogLevel.Error, Log.LogSubject.MqttClient, "PublishResult: Cannot get value - unknown type of: " + (Object)((Object)this.type));
        return null;
    }

    public PubAckPacket getResultPubAck() {
        return this.pubackData;
    }

    private PublishResult() {
        this.type = PublishResultType.NONE;
    }

    private PublishResult(PubAckPacket newPubackPacket) {
        this.type = PublishResultType.PUBACK;
        this.pubackData = newPubackPacket;
    }

    public static enum PublishResultType {
        NONE(0),
        PUBACK(1);

        private int result;
        private static Map<Integer, PublishResultType> enumMapping;

        private PublishResultType(int code) {
            this.result = code;
        }

        public int getValue() {
            return this.result;
        }

        public static PublishResultType getEnumValueFromInteger(int value) {
            PublishResultType enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal PublishResultType");
        }

        private static Map<Integer, PublishResultType> buildEnumMapping() {
            return Stream.of(PublishResultType.values()).collect(Collectors.toMap(PublishResultType::getValue, Function.identity()));
        }

        static {
            enumMapping = PublishResultType.buildEnumMapping();
        }
    }
}

