/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapDnsProviderService;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.spi.LdapDnsProviderResult;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public final class LdapCtxFactory
implements ObjectFactory,
InitialContextFactory {
    public static final String ADDRESS_TYPE = "URL";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (!LdapCtxFactory.isLdapRef(object)) {
            return null;
        }
        ldapURLContextFactory ldapURLContextFactory2 = new ldapURLContextFactory();
        String[] stringArray = LdapCtxFactory.getURLs((Reference)object);
        return ldapURLContextFactory2.getObjectInstance(stringArray, name, context, hashtable);
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        try {
            String string;
            String string2 = string = hashtable != null ? (String)hashtable.get("java.naming.provider.url") : null;
            if (string == null) {
                return new LdapCtx("", "localhost", 389, hashtable, false);
            }
            String[] stringArray = LdapURL.fromList(string);
            if (stringArray.length == 0) {
                throw new ConfigurationException("java.naming.provider.url property does not contain a URL");
            }
            return LdapCtxFactory.getLdapCtxInstance(stringArray, hashtable);
        }
        catch (LdapReferralException ldapReferralException) {
            if (hashtable != null && "throw".equals(hashtable.get("java.naming.referral"))) {
                throw ldapReferralException;
            }
            Control[] controlArray = hashtable != null ? (Control[])hashtable.get("java.naming.ldap.control.connect") : null;
            return (LdapCtx)ldapReferralException.getReferralContext(hashtable, controlArray);
        }
    }

    private static boolean isLdapRef(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        String string = LdapCtxFactory.class.getName();
        Reference reference = (Reference)object;
        return string.equals(reference.getFactoryClassName());
    }

    private static String[] getURLs(Reference reference) throws NamingException {
        String[] stringArray;
        int n = 0;
        String[] stringArray2 = new String[reference.size()];
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            stringArray = enumeration.nextElement();
            if (!(stringArray instanceof StringRefAddr) || !stringArray.getType().equals(ADDRESS_TYPE)) continue;
            stringArray2[n++] = (String)stringArray.getContent();
        }
        if (n == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (n == reference.size()) {
            return stringArray2;
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }

    public static DirContext getLdapCtxInstance(Object object, Hashtable<?, ?> hashtable) throws NamingException {
        if (object instanceof String) {
            return LdapCtxFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return LdapCtxFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("argument must be an LDAP URL String or array of them");
    }

    private static DirContext getUsingURL(String string, Hashtable<?, ?> hashtable) throws NamingException {
        try {
            LdapDnsProviderResult ldapDnsProviderResult = LdapDnsProviderService.getInstance().lookupEndpoints(string, hashtable);
            NamingException namingException = null;
            for (String string2 : ldapDnsProviderResult.getEndpoints()) {
                try {
                    LdapCtx ldapCtx = LdapCtxFactory.getLdapCtxFromUrl(ldapDnsProviderResult.getDomainName(), string, new LdapURL(string2), hashtable);
                    return ldapCtx;
                }
                catch (NamingException namingException2) {
                    namingException = namingException2;
                }
            }
            if (namingException != null) {
                throw namingException;
            }
            throw new NamingException("Could not resolve a valid ldap host");
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private static LdapCtx getLdapCtxFromUrl(String string, String string2, LdapURL ldapURL, Hashtable<?, ?> hashtable) throws NamingException {
        String string3 = ldapURL.getDN();
        String string4 = ldapURL.getHost();
        int n = ldapURL.getPort();
        LdapCtx ldapCtx = new LdapCtx(string3, string4, n, hashtable, ldapURL.useSsl());
        ldapCtx.setDomainName(string);
        ldapCtx.setProviderUrl(string2);
        return ldapCtx;
    }

    private static DirContext getUsingURLs(String[] stringArray, Hashtable<?, ?> hashtable) throws NamingException {
        NamingException namingException = null;
        for (String string : stringArray) {
            try {
                return LdapCtxFactory.getUsingURL(string, hashtable);
            }
            catch (NamingException namingException2) {
                namingException = namingException2;
            }
        }
        throw namingException;
    }

    public static Attribute createTypeNameAttr(Class<?> clazz) {
        Vector<String> vector = new Vector<String>(10);
        String[] stringArray = LdapCtxFactory.getTypeNames(clazz, vector);
        if (stringArray.length > 0) {
            BasicAttribute basicAttribute = new BasicAttribute(Obj.JAVA_ATTRIBUTES[6]);
            for (int i = 0; i < stringArray.length; ++i) {
                basicAttribute.add(stringArray[i]);
            }
            return basicAttribute;
        }
        return null;
    }

    private static String[] getTypeNames(Class<?> clazz, Vector<String> vector) {
        LdapCtxFactory.getClassesAux(clazz, vector);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            LdapCtxFactory.getClassesAux(classArray[i], vector);
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        for (String string : vector) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    private static void getClassesAux(Class<?> clazz, Vector<String> vector) {
        if (!vector.contains(clazz.getName())) {
            vector.addElement(clazz.getName());
        }
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            LdapCtxFactory.getTypeNames(clazz, vector);
        }
    }
}

