/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.CU;
import javajs.util.M4;
import javajs.util.V3;
import org.jmol.util.C;

public class Shader {
    private static final int SHADE_INDEX_MAX = 64;
    public static final int SHADE_INDEX_LAST = 63;
    public static final byte SHADE_INDEX_NORMAL = 52;
    public static final byte SHADE_INDEX_NOISY_LIMIT = 56;
    private float xLight;
    private float yLight;
    private float zLight;
    V3 lightSource = new V3();
    boolean specularOn = true;
    boolean usePhongExponent = false;
    int ambientPercent = 45;
    int diffusePercent = 84;
    int specularExponent = 6;
    int specularPercent = 22;
    int specularPower = 40;
    int phongExponent = 64;
    float ambientFraction = (float)this.ambientPercent / 100.0f;
    float diffuseFactor = (float)this.diffusePercent / 100.0f;
    float intenseFraction = (float)this.specularPower / 100.0f;
    float specularFactor = (float)this.specularPercent / 100.0f;
    private int[][] ashades = AU.newInt2(128);
    private int[][] ashadesGreyscale;
    boolean celOn;
    int celPower = 10;
    private int celRGB;
    private float celZ;
    private boolean useLight;
    public byte[] sphereShadeIndexes = new byte[65536];
    private int seed = 305419897;
    private static final int SLIM = 20;
    private static final int SDIM = 40;
    public static final int maxSphereCache = 128;
    public int[][] sphereShapeCache = AU.newInt2(128);
    public byte[][][] ellipsoidShades;
    public int nOut;
    public int nIn;

    public Shader() {
        this.setLightSource(-1.0f, -1.0f, 2.5f);
    }

    private void setLightSource(float x, float y, float z) {
        this.lightSource.set(x, y, z);
        this.lightSource.normalize();
        this.xLight = this.lightSource.x;
        this.yLight = this.lightSource.y;
        this.zLight = this.lightSource.z;
    }

    void setCel(boolean celShading, int celShadingPower, int argb) {
        celShading = celShading && celShadingPower != 0;
        int n = (argb = C.getArgb(C.getBgContrast(argb))) == -16777216 ? -16514044 : (argb = argb == -1 ? -2 : argb + 1);
        if (this.celOn == celShading && this.celRGB == argb && this.celPower == celShadingPower) {
            return;
        }
        this.celOn = celShading;
        this.celPower = celShadingPower;
        this.useLight = !this.celOn || celShadingPower > 0;
        this.celZ = 1.0f - (float)Math.pow(2.0, (float)(-Math.abs(celShadingPower)) / 10.0f);
        this.celRGB = argb;
        this.flushCaches();
    }

    void flushCaches() {
        this.checkShades(C.colixMax);
        int i = C.colixMax;
        while (--i >= 0) {
            this.ashades[i] = null;
        }
        this.calcSphereShading();
        i = 128;
        while (--i >= 0) {
            this.sphereShapeCache[i] = null;
        }
        this.ellipsoidShades = null;
    }

    public void setLastColix(int argb, boolean asGrey) {
        C.allocateColix(argb, true);
        this.checkShades(2047);
        if (asGrey) {
            C.setLastGrey(argb);
        }
        this.ashades[2047] = this.getShades2(argb, false);
    }

    int[] getShades(short colix) {
        this.checkShades(C.colixMax);
        colix = (short)(colix & 0xFFFF87FF);
        int[] shades = this.ashades[colix];
        if (shades == null) {
            this.ashades[colix] = this.getShades2(C.argbs[colix], false);
            shades = this.ashades[colix];
        }
        return shades;
    }

    int[] getShadesG(short colix) {
        int[] shadesGreyscale;
        this.checkShades(C.colixMax);
        colix = (short)(colix & 0xFFFF87FF);
        if (this.ashadesGreyscale == null) {
            this.ashadesGreyscale = AU.newInt2(this.ashades.length);
        }
        if ((shadesGreyscale = this.ashadesGreyscale[colix]) == null) {
            this.ashadesGreyscale[colix] = this.getShades2(C.argbs[colix], true);
            shadesGreyscale = this.ashadesGreyscale[colix];
        }
        return shadesGreyscale;
    }

    private void checkShades(int n) {
        if (this.ashades != null && this.ashades.length >= n) {
            return;
        }
        if (n == 2047) {
            ++n;
        }
        this.ashades = AU.arrayCopyII(this.ashades, n);
        if (this.ashadesGreyscale != null) {
            this.ashadesGreyscale = AU.arrayCopyII(this.ashadesGreyscale, n);
        }
    }

    private int[] getShades2(int rgb, boolean greyScale) {
        int i;
        int[] shades = new int[64];
        if (rgb == 0) {
            return shades;
        }
        float red0 = rgb >> 16 & 0xFF;
        float grn0 = rgb >> 8 & 0xFF;
        float blu0 = rgb & 0xFF;
        float red = 0.0f;
        float grn = 0.0f;
        float blu = 0.0f;
        float f = this.ambientFraction;
        while (true) {
            red = red0 * f + 0.5f;
            grn = grn0 * f + 0.5f;
            blu = blu0 * f + 0.5f;
            if (!(f > 0.0f) || !(red < 4.0f) || !(grn < 4.0f) || !(blu < 4.0f)) break;
            red0 += 1.0f;
            grn0 += 1.0f;
            blu0 += 1.0f;
            if (f < 0.1f) {
                f += 0.1f;
            }
            rgb = CU.rgb((int)Math.floor(red0), (int)Math.floor(grn0), (int)Math.floor(blu0));
        }
        f = (1.0f - f) / 52.0f;
        float redStep = red0 * f;
        float grnStep = grn0 * f;
        float bluStep = blu0 * f;
        if (this.celOn) {
            int max = 32;
            int _rgb = CU.rgb((int)Math.floor(red), (int)Math.floor(grn), (int)Math.floor(blu));
            if (this.celPower >= 0) {
                for (i = 0; i < max; ++i) {
                    shades[i] = _rgb;
                }
            }
            _rgb = CU.rgb((int)Math.floor(red += redStep * (float)max), (int)Math.floor(grn += grnStep * (float)max), (int)Math.floor(blu += bluStep * (float)max));
            while (i < 64) {
                shades[i] = _rgb;
                ++i;
            }
            shades[0] = shades[1] = this.celRGB;
        } else {
            while (i < 52) {
                shades[i] = CU.rgb((int)Math.floor(red), (int)Math.floor(grn), (int)Math.floor(blu));
                red += redStep;
                grn += grnStep;
                blu += bluStep;
                ++i;
            }
            shades[i++] = rgb;
            f = this.intenseFraction / (float)(64 - i);
            redStep = (255.5f - red) * f;
            grnStep = (255.5f - grn) * f;
            bluStep = (255.5f - blu) * f;
            while (i < 64) {
                shades[i] = CU.rgb((int)Math.floor(red += redStep), (int)Math.floor(grn += grnStep), (int)Math.floor(blu += bluStep));
                ++i;
            }
        }
        if (greyScale) {
            while (--i >= 0) {
                shades[i] = CU.toFFGGGfromRGB(shades[i]);
            }
        }
        return shades;
    }

    public int getShadeIndex(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return Math.round(this.getShadeF((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude)) * 63.0f);
    }

    public byte getShadeB(float x, float y, float z) {
        return (byte)Math.round(this.getShadeF(x, y, z) * 63.0f);
    }

    public int getShadeFp8(float x, float y, float z) {
        double magnitude = Math.sqrt(x * x + y * y + z * z);
        return (int)Math.floor(this.getShadeF((float)((double)x / magnitude), (float)((double)y / magnitude), (float)((double)z / magnitude)) * 63.0f * 256.0f);
    }

    private float getShadeF(float x, float y, float z) {
        float k_specular;
        float NdotL;
        float f = NdotL = this.useLight ? x * this.xLight + y * this.yLight + z * this.zLight : z;
        if (NdotL <= 0.0f) {
            return 0.0f;
        }
        float intensity = NdotL * this.diffuseFactor;
        if (this.specularOn && (k_specular = 2.0f * NdotL * z - this.zLight) > 0.0f) {
            if (this.usePhongExponent) {
                k_specular = (float)Math.pow(k_specular, this.phongExponent);
            } else {
                int n = this.specularExponent;
                while (--n >= 0 && k_specular > 1.0E-4f) {
                    k_specular *= k_specular;
                }
            }
            intensity += k_specular * this.specularFactor;
        }
        return this.celOn && z < this.celZ ? 0.0f : (intensity > 1.0f ? 1.0f : intensity);
    }

    public byte getShadeN(float x, float y, float z, float r) {
        int random16bit;
        int fp8ShadeIndex = (int)Math.floor(this.getShadeF(x / r, y / r, z / r) * 63.0f * 256.0f);
        int shadeIndex = fp8ShadeIndex >> 8;
        if (!this.useLight) {
            return (byte)shadeIndex;
        }
        if ((fp8ShadeIndex & 0xFF) > this.nextRandom8Bit()) {
            ++shadeIndex;
        }
        if ((random16bit = this.seed & 0xFFFF) < 21845 && shadeIndex > 0) {
            --shadeIndex;
        } else if (random16bit > 43690 && shadeIndex < 63) {
            ++shadeIndex;
        }
        return (byte)shadeIndex;
    }

    private synchronized void calcSphereShading() {
        float xF = -127.5f;
        float r2 = 16900.0f;
        for (int i = 0; i < 256; ++i) {
            float yF = -127.5f;
            float xF2 = xF * xF;
            for (int j = 0; j < 256; ++j) {
                byte shadeIndex = 0;
                float z2 = r2 - xF2 - yF * yF;
                if (z2 > 0.0f) {
                    float z = (float)Math.sqrt(z2);
                    shadeIndex = this.getShadeN(xF, yF, z, 130.0f);
                }
                this.sphereShadeIndexes[(j << 8) + i] = shadeIndex;
                yF += 1.0f;
            }
            xF += 1.0f;
        }
    }

    public int nextRandom8Bit() {
        int t = this.seed;
        this.seed = t = (t << 16) + (t << 1) + t & Integer.MAX_VALUE;
        return t >> 23;
    }

    public int getEllipsoidShade(float x, float y, float z, int radius, M4 mDeriv) {
        boolean outside;
        float tx = mDeriv.m00 * x + mDeriv.m01 * y + mDeriv.m02 * z + mDeriv.m03;
        float ty = mDeriv.m10 * x + mDeriv.m11 * y + mDeriv.m12 * z + mDeriv.m13;
        float tz = mDeriv.m20 * x + mDeriv.m21 * y + mDeriv.m22 * z + mDeriv.m23;
        float f = Math.min((float)radius / 2.0f, 45.0f) / (float)Math.sqrt(tx * tx + ty * ty + tz * tz);
        int i = (int)(-tx * f);
        int j = (int)(-ty * f);
        int k = (int)(tz * f);
        boolean bl = outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
        if (outside) {
            while (i % 2 == 0 && j % 2 == 0 && k % 2 == 0 && i + j + k > 0) {
                i >>= 1;
                j >>= 1;
                k >>= 1;
            }
            boolean bl2 = outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
        }
        if (outside) {
            ++this.nOut;
        } else {
            ++this.nIn;
        }
        return outside ? this.getShadeIndex(i, j, k) : this.ellipsoidShades[i + 20][j + 20][k];
    }

    public void createEllipsoidShades() {
        this.ellipsoidShades = new byte[40][40][40];
        for (int ii = 0; ii < 40; ++ii) {
            for (int jj = 0; jj < 40; ++jj) {
                for (int kk = 0; kk < 40; ++kk) {
                    this.ellipsoidShades[ii][jj][kk] = (byte)this.getShadeIndex(ii - 20, jj - 20, kk);
                }
            }
        }
    }
}

