/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.gephi.statistics.plugin.ConnectedComponents;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.ConnectedComponentPanel;
import org.openide.util.NbBundle;

public class ConnectedComponentUI
implements StatisticsUI {
    private ConnectedComponentPanel panel;
    private ConnectedComponents connectedComponents;

    public JPanel getSettingsPanel() {
        this.panel = new ConnectedComponentPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.connectedComponents = (ConnectedComponents)statistics;
        if (this.panel != null) {
            this.panel.setDirected(this.connectedComponents.isDirected());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.connectedComponents.setDirected(this.panel.isDirected());
        }
        this.connectedComponents = null;
        this.panel = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return ConnectedComponents.class;
    }

    public String getValue() {
        DecimalFormat df = new DecimalFormat("###.###");
        return df.format(this.connectedComponents.getConnectedComponentsCount());
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"ConnectedComponentUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_NETWORK_OVERVIEW;
    }

    public int getPosition() {
        return 900;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"ConnectedComponentUI.shortDescription");
    }
}

