/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import net.miginfocom.swing.MigLayout;
import org.gephi.datalab.plugin.manipulators.general.ManageColumnEstimators;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.types.TimeMap;
import org.openide.util.NbBundle;

public class ManageColumnEstimatorsUI
extends JPanel
implements ManipulatorUI {
    private ManageColumnEstimators manipulator;
    private ColumnEstimator[] columnsEstimators;
    private JPanel contentPanel;
    private JScrollPane contentScrollPane;
    private JLabel descriptionLabel;

    public ManageColumnEstimatorsUI() {
        this.initComponents();
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (ManageColumnEstimators)m;
        this.descriptionLabel.setText(this.manipulator.getDescription());
        this.refreshColumns();
    }

    public void unSetup() {
        Column[] columns = new Column[this.columnsEstimators.length];
        Estimator[] estimators = new Estimator[this.columnsEstimators.length];
        for (int i = 0; i < this.columnsEstimators.length; ++i) {
            columns[i] = this.columnsEstimators[i].column;
            estimators[i] = this.columnsEstimators[i].getEstimator();
        }
        this.manipulator.setup(columns, estimators);
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    private void refreshColumns() {
        List<Column> columns = this.manipulator.getColumns();
        this.columnsEstimators = new ColumnEstimator[columns.size()];
        this.contentPanel.removeAll();
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[pref!]"));
        for (int i = 0; i < this.columnsEstimators.length; ++i) {
            this.columnsEstimators[i] = new ColumnEstimator(columns.get(i));
            this.contentPanel.add((Component)this.columnsEstimators[i].label, "wrap");
            this.contentPanel.add((Component)this.columnsEstimators[i].comboBox, "wrap");
        }
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    private void initComponents() {
        this.contentScrollPane = new JScrollPane();
        this.contentPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.contentPanel.setLayout(new GridLayout(1, 0));
        this.contentScrollPane.setViewportView(this.contentPanel);
        this.descriptionLabel.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING, -1, 319, Short.MAX_VALUE).addComponent(this.contentScrollPane, GroupLayout.Alignment.LEADING, -1, 319, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentScrollPane, -1, 220, Short.MAX_VALUE).addContainerGap()));
    }

    private static class ColumnEstimator {
        private final JLabel label;
        private final JComboBox comboBox;
        private final Column column;

        public ColumnEstimator(Column column) {
            this.column = column;
            this.comboBox = new JComboBox();
            this.label = new JLabel(column.getTitle());
            this.initAvailableEstimators();
            Estimator currentEstimator = column.getEstimator();
            this.comboBox.setSelectedItem(new EstimatorWrapper(currentEstimator));
        }

        private void initAvailableEstimators() {
            Class type = this.column.getTypeClass();
            try {
                TimeMap dummy = (TimeMap)type.newInstance();
                for (Estimator estimator : Estimator.values()) {
                    if (!dummy.isSupported(estimator)) continue;
                    this.comboBox.addItem(new EstimatorWrapper(estimator));
                }
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }

        public Estimator getEstimator() {
            return ((EstimatorWrapper)this.comboBox.getSelectedItem()).estimator;
        }
    }

    private static class EstimatorWrapper {
        private final Estimator estimator;

        public EstimatorWrapper(Estimator estimator) {
            this.estimator = estimator;
        }

        public String toString() {
            if (this.estimator == null) {
                return "---";
            }
            try {
                return NbBundle.getMessage(ManageColumnEstimatorsUI.class, (String)("ManageColumnEstimatorsUI.estimator." + this.estimator.name()));
            }
            catch (MissingResourceException missingResourceException) {
                return this.estimator.name();
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.estimator != null ? this.estimator.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EstimatorWrapper other = (EstimatorWrapper)obj;
            return this.estimator == other.estimator;
        }
    }
}

