/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.DefaultPatternCompiler;
import io.cucumber.cucumberexpressions.PatternCompiler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;

final class PatternCompilerProvider {
    static PatternCompiler service;

    private PatternCompilerProvider() {
    }

    static synchronized PatternCompiler getCompiler() {
        if (service == null) {
            ServiceLoader<PatternCompiler> loader = ServiceLoader.load(PatternCompiler.class);
            Iterator<PatternCompiler> iterator = loader.iterator();
            PatternCompilerProvider.findPatternCompiler(iterator);
        }
        return service;
    }

    static void findPatternCompiler(Iterator<PatternCompiler> iterator) {
        if (iterator.hasNext()) {
            service = iterator.next();
            if (iterator.hasNext()) {
                PatternCompilerProvider.throwMoreThanOneCompilerException(iterator);
            }
        } else {
            service = new DefaultPatternCompiler();
        }
    }

    private static void throwMoreThanOneCompilerException(Iterator<PatternCompiler> iterator) {
        ArrayList allCompilers = new ArrayList();
        allCompilers.add(service.getClass());
        while (iterator.hasNext()) {
            allCompilers.add(iterator.next().getClass());
        }
        throw new IllegalStateException("More than one PatternCompiler: " + allCompilers);
    }
}

