// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2024, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================
// Author: Manuel Holtgrewe <manuel.holtgrewe@fu-berlin.de>
// ==========================================================================
// Tests for the random number generation code in seqan/random.
// ==========================================================================

#ifndef TEST_RANDOM_TEST_RANDOM_BASIC_H_
#define TEST_RANDOM_TEST_RANDOM_BASIC_H_

// Test GetDefaultRang and defaultRng().
SEQAN_DEFINE_TEST(test_default_rng)
{
    using namespace seqan2;

    // Test that calling the function works.
    typedef String<Dna> TTag;
    typedef typename GetDefaultRng<TTag>::Type TRng;
    TRng & rng = defaultRng(TTag());
    (void)rng;

    // Test that a reference is returned and the global state changes.
    typedef typename TRng::result_type TValue;
    TValue x1 = defaultRng(TTag())();
    TValue x2 = defaultRng(TTag())();
    TValue x3 = defaultRng(TTag())();
    SEQAN_ASSERT(x1 != x2 || x2 != x3);  // 3 times the same value is not probable!
}

#endif  // TEST_RANDOM_TEST_RANDOM_BASIC_H_
