% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration5.R
\name{JointPCAIntegration}
\alias{JointPCAIntegration}
\title{Seurat-Joint PCA Integration}
\usage{
JointPCAIntegration(
  object = NULL,
  assay = NULL,
  layers = NULL,
  orig = NULL,
  new.reduction = "integrated.dr",
  reference = NULL,
  features = NULL,
  normalization.method = c("LogNormalize", "SCT"),
  dims = 1:30,
  k.anchor = 20,
  scale.layer = "scale.data",
  dims.to.integrate = NULL,
  k.weight = 100,
  weight.reduction = NULL,
  sd.weight = 1,
  sample.tree = NULL,
  preserve.order = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{Seurat} object}

\item{assay}{Name of \code{Assay} in the \code{Seurat} object}

\item{layers}{Names of layers in \code{assay}}

\item{orig}{A \link[SeuratObject]{DimReduc} to correct}

\item{new.reduction}{Name of new integrated dimensional reduction}

\item{reference}{A reference \code{Seurat} object}

\item{features}{A vector of features to use for integration}

\item{normalization.method}{Name of normalization method used: LogNormalize
or SCT}

\item{dims}{Dimensions of dimensional reduction to use for integration}

\item{k.anchor}{How many neighbors (k) to use when picking anchors}

\item{scale.layer}{Name of scaled layer in \code{Assay}}

\item{dims.to.integrate}{Number of dimensions to return integrated values for}

\item{k.weight}{Number of neighbors to consider when weighting anchors}

\item{weight.reduction}{Dimension reduction to use when calculating anchor
weights. This can be one of:
\itemize{
   \item{A string, specifying the name of a dimension reduction present in
   all objects to be integrated}
   \item{A vector of strings, specifying the name of a dimension reduction to
   use for each object to be integrated}
   \item{A vector of \code{\link[SeuratObject]{DimReduc}} objects, specifying the object to
   use for each object in the integration}
   \item{NULL, in which case the full corrected space is used for computing
   anchor weights.}
}}

\item{sd.weight}{Controls the bandwidth of the Gaussian kernel for weighting}

\item{sample.tree}{Specify the order of integration. Order of integration
should be encoded in a matrix, where each row represents one of the pairwise
integration steps. Negative numbers specify a dataset, positive numbers
specify the integration results from a given row (the format of the merge
matrix included in the \code{\link{hclust}} function output). For example:
\code{matrix(c(-2, 1, -3, -1), ncol = 2)} gives:

\if{html}{\out{<div class="sourceCode">}}\preformatted{            [,1]  [,2]
       [1,]   -2   -3
       [2,]    1   -1
}\if{html}{\out{</div>}}

Which would cause dataset 2 and 3 to be integrated first, then the resulting
object integrated with dataset 1.

If NULL, the sample tree will be computed automatically.}

\item{preserve.order}{Do not reorder objects based on size for each pairwise
integration.}

\item{verbose}{Print progress}

\item{...}{Arguments passed on to \code{FindIntegrationAnchors}}
}
\description{
Seurat-Joint PCA Integration
}
\concept{integration}
