% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_cell_clusters}
\alias{plot_cell_clusters}
\title{Plots clusters of cells .}
\usage{
plot_cell_clusters(cds, x = 1, y = 2, color_by = "Cluster",
  markers = NULL, show_cell_names = FALSE, cell_size = 1.5,
  cell_name_size = 2, ...)
}
\arguments{
\item{cds}{CellDataSet for the experiment}

\item{x}{the column of reducedDimS(cds) to plot on the horizontal axis}

\item{y}{the column of reducedDimS(cds) to plot on the vertical axis}

\item{color_by}{the cell attribute (e.g. the column of pData(cds)) to map to each cell's color}

\item{markers}{a gene name or gene id to use for setting the size of each cell in the plot}

\item{show_cell_names}{draw the name of each cell in the plot}

\item{cell_size}{The size of the point for each cell}

\item{cell_name_size}{the size of cell name labels}

\item{...}{additional arguments passed into the scale_color_viridis function}
}
\value{
a ggplot2 plot object
}
\description{
Plots clusters of cells .
}
\examples{
\dontrun{
library(HSMMSingleCell)
HSMM <- load_HSMM()
HSMM <- reduceD
plot_cell_clusters(HSMM)
plot_cell_clusters(HSMM, color_by="Pseudotime")
plot_cell_clusters(HSMM, markers="MYH3")
}
}
