/* $Cambridge: hermes/src/prayer/cmd/cmd_rename_item.c,v 1.7 2009/08/28 12:47:51 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_rename_item(struct session *session)
{
    struct options *options = session->options;
    struct prefs *prefs = options->prefs;
    struct favourite_list *fl = options->favourite_list;
    struct request *request = session->request;
    struct pool *pool = request->pool;
    MAILSTREAM *stream;
    char *newname = NIL;
    char *parent;

    if (request->method == POST)
        request_decode_form(request);
    else
        request_decode_form(request);

    if (assoc_lookup(request->form, "cancel")) {
        session_message(session, "Rename operation cancelled");
        session_redirect(session, request, "folders");
        return;
    }

    newname=utf8_to_imaputf7(pool, assoc_lookup(request->form, "name"));
    if (!(session->rename_foldername && newname)) {
        session_redirect(session, request, "folders");
        return;
    }

    if ((parent = assoc_lookup(request->form, "parent")))
        string_canon_decode(parent);

    if (parent && parent[0])
        newname = pool_strcat3(request->pool, parent,
                               session->hiersep, newname);

    /* Protect against attempt to rename outside maildir */
    if (prefs->maildir && prefs->maildir[0] &&
        session->hiersep && session->hiersep[0]) {
        char *tmp = pool_strcat(request->pool,
                                prefs->maildir, session->hiersep);

        if (strncmp(newname, tmp, strlen(tmp)) != 0) {
            newname = pool_strcat3(request->pool, prefs->maildir,
                                   session->hiersep, newname);
        }
    }

    if (!strcasecmp(session->rename_foldername, "INBOX")) {
        session_alert(session, "Unable to rename inbox folder");
        session_redirect(session, request, "folders");
        return;
    }

    if (session->foldername && session->other_foldername &&
        !strcmp(session->foldername, session->other_foldername) &&
        !strcmp(session->foldername, session->rename_foldername)) {

        /* Attempt to rename current mailbox other than INBOX */
        /* Switch to inbox, shut down other stream */
        session_streams_change(session, "INBOX");

        ml_close(session, session->other_stream);
        session->other_stream = NIL;
    }
    stream = session->stream;

    ml_clear_error();
    ml_clear_have_close();
    ml_rename(session, stream,
              session_mailbox(session, pool,
                              session->rename_foldername),
              session_mailbox(session, pool, newname));
    if (ml_have_close()) {
        session_redirect(session, request, "restart");
        return;
    }

    if (ml_have_error()) {
        session_alert(session,
                      "Failed to rename mailbox: %s - %s",
                      utf8_from_imaputf7(pool, session->rename_foldername),
                      ml_errmsg());
    } else {
        session_message(session,
                        "Renamed mailbox %s to be %s",
                        utf8_from_imaputf7(pool, session->rename_foldername),
                        utf8_from_imaputf7(pool, newname));
        folderlist_rename(session->folderlist,
                          session->rename_foldername, newname);
    }

    if (favourite_rename(fl, session->rename_foldername, newname))
        options->save = T;

    session_redirect(session, request, "folders");
}
