; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v,+m -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v,+m -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+experimental-zvbb,+m -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+v,+experimental-zvbb,+m -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB

declare <vscale x 1 x i16> @llvm.vp.bswap.nxv1i16(<vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i16> @vp_bswap_nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i16> @llvm.vp.bswap.nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}

define <vscale x 1 x i16> @vp_bswap_nxv1i16_unmasked(<vscale x 1 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv1i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv1i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i16> @llvm.vp.bswap.nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i16> %v
}

declare <vscale x 2 x i16> @llvm.vp.bswap.nxv2i16(<vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i16> @vp_bswap_nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i16> @llvm.vp.bswap.nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}

define <vscale x 2 x i16> @vp_bswap_nxv2i16_unmasked(<vscale x 2 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv2i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv2i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i16> @llvm.vp.bswap.nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i16> %v
}

declare <vscale x 4 x i16> @llvm.vp.bswap.nxv4i16(<vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @vp_bswap_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i16> @llvm.vp.bswap.nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}

define <vscale x 4 x i16> @vp_bswap_nxv4i16_unmasked(<vscale x 4 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv4i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv4i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i16> @llvm.vp.bswap.nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i16> %v
}

declare <vscale x 8 x i16> @llvm.vp.bswap.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i16> @vp_bswap_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i16> @llvm.vp.bswap.nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

define <vscale x 8 x i16> @vp_bswap_nxv8i16_unmasked(<vscale x 8 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv8i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv8i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i16> @llvm.vp.bswap.nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i16> %v
}

declare <vscale x 16 x i16> @llvm.vp.bswap.nxv16i16(<vscale x 16 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @vp_bswap_nxv16i16(<vscale x 16 x i16> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i16> @llvm.vp.bswap.nxv16i16(<vscale x 16 x i16> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i16> %v
}

define <vscale x 16 x i16> @vp_bswap_nxv16i16_unmasked(<vscale x 16 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv16i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv16i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i16> @llvm.vp.bswap.nxv16i16(<vscale x 16 x i16> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i16> %v
}

declare <vscale x 32 x i16> @llvm.vp.bswap.nxv32i16(<vscale x 32 x i16>, <vscale x 32 x i1>, i32)

define <vscale x 32 x i16> @vp_bswap_nxv32i16(<vscale x 32 x i16> %va, <vscale x 32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 32 x i16> @llvm.vp.bswap.nxv32i16(<vscale x 32 x i16> %va, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i16> %v
}

define <vscale x 32 x i16> @vp_bswap_nxv32i16_unmasked(<vscale x 32 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv32i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv32i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 32 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 32 x i1> %head, <vscale x 32 x i1> poison, <vscale x 32 x i32> zeroinitializer
  %v = call <vscale x 32 x i16> @llvm.vp.bswap.nxv32i16(<vscale x 32 x i16> %va, <vscale x 32 x i1> %m, i32 %evl)
  ret <vscale x 32 x i16> %v
}

declare <vscale x 1 x i32> @llvm.vp.bswap.nxv1i32(<vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i32> @vp_bswap_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 8, v0.t
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v9, v9, a0, v0.t
; RV32-NEXT:    vsrl.vi v10, v8, 24, v0.t
; RV32-NEXT:    vor.vv v9, v9, v10, v0.t
; RV32-NEXT:    vand.vx v10, v8, a0, v0.t
; RV32-NEXT:    vsll.vi v10, v10, 8, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v10, v0.t
; RV32-NEXT:    vor.vv v8, v8, v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 8, v0.t
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v9, v9, a0, v0.t
; RV64-NEXT:    vsrl.vi v10, v8, 24, v0.t
; RV64-NEXT:    vor.vv v9, v9, v10, v0.t
; RV64-NEXT:    vand.vx v10, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v10, v10, 8, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV64-NEXT:    vor.vv v8, v8, v10, v0.t
; RV64-NEXT:    vor.vv v8, v8, v9, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i32> @llvm.vp.bswap.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}

define <vscale x 1 x i32> @vp_bswap_nxv1i32_unmasked(<vscale x 1 x i32> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv1i32_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 8
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsrl.vi v10, v8, 24
; RV32-NEXT:    vor.vv v9, v9, v10
; RV32-NEXT:    vand.vx v10, v8, a0
; RV32-NEXT:    vsll.vi v10, v10, 8
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv1i32_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 8
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsrl.vi v10, v8, 24
; RV64-NEXT:    vor.vv v9, v9, v10
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsll.vi v10, v10, 8
; RV64-NEXT:    vsll.vi v8, v8, 24
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv1i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i32> @llvm.vp.bswap.nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i32> %v
}

declare <vscale x 2 x i32> @llvm.vp.bswap.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @vp_bswap_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 8, v0.t
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v9, v9, a0, v0.t
; RV32-NEXT:    vsrl.vi v10, v8, 24, v0.t
; RV32-NEXT:    vor.vv v9, v9, v10, v0.t
; RV32-NEXT:    vand.vx v10, v8, a0, v0.t
; RV32-NEXT:    vsll.vi v10, v10, 8, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v10, v0.t
; RV32-NEXT:    vor.vv v8, v8, v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 8, v0.t
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v9, v9, a0, v0.t
; RV64-NEXT:    vsrl.vi v10, v8, 24, v0.t
; RV64-NEXT:    vor.vv v9, v9, v10, v0.t
; RV64-NEXT:    vand.vx v10, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v10, v10, 8, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV64-NEXT:    vor.vv v8, v8, v10, v0.t
; RV64-NEXT:    vor.vv v8, v8, v9, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i32> @llvm.vp.bswap.nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}

define <vscale x 2 x i32> @vp_bswap_nxv2i32_unmasked(<vscale x 2 x i32> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv2i32_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 8
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsrl.vi v10, v8, 24
; RV32-NEXT:    vor.vv v9, v9, v10
; RV32-NEXT:    vand.vx v10, v8, a0
; RV32-NEXT:    vsll.vi v10, v10, 8
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv2i32_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 8
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsrl.vi v10, v8, 24
; RV64-NEXT:    vor.vv v9, v9, v10
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsll.vi v10, v10, 8
; RV64-NEXT:    vsll.vi v8, v8, 24
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv2i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i32> @llvm.vp.bswap.nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i32> %v
}

declare <vscale x 4 x i32> @llvm.vp.bswap.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i32> @vp_bswap_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV32-NEXT:    vsrl.vi v10, v8, 8, v0.t
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v10, v10, a0, v0.t
; RV32-NEXT:    vsrl.vi v12, v8, 24, v0.t
; RV32-NEXT:    vor.vv v10, v10, v12, v0.t
; RV32-NEXT:    vand.vx v12, v8, a0, v0.t
; RV32-NEXT:    vsll.vi v12, v12, 8, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v12, v0.t
; RV32-NEXT:    vor.vv v8, v8, v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV64-NEXT:    vsrl.vi v10, v8, 8, v0.t
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v10, v10, a0, v0.t
; RV64-NEXT:    vsrl.vi v12, v8, 24, v0.t
; RV64-NEXT:    vor.vv v10, v10, v12, v0.t
; RV64-NEXT:    vand.vx v12, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v12, v12, 8, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV64-NEXT:    vor.vv v8, v8, v12, v0.t
; RV64-NEXT:    vor.vv v8, v8, v10, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i32> @llvm.vp.bswap.nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}

define <vscale x 4 x i32> @vp_bswap_nxv4i32_unmasked(<vscale x 4 x i32> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv4i32_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV32-NEXT:    vsrl.vi v10, v8, 8
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v10, v10, a0
; RV32-NEXT:    vsrl.vi v12, v8, 24
; RV32-NEXT:    vor.vv v10, v10, v12
; RV32-NEXT:    vand.vx v12, v8, a0
; RV32-NEXT:    vsll.vi v12, v12, 8
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv4i32_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; RV64-NEXT:    vsrl.vi v10, v8, 8
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vsrl.vi v12, v8, 24
; RV64-NEXT:    vor.vv v10, v10, v12
; RV64-NEXT:    vand.vx v12, v8, a0
; RV64-NEXT:    vsll.vi v12, v12, 8
; RV64-NEXT:    vsll.vi v8, v8, 24
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv4i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i32> @llvm.vp.bswap.nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i32> %v
}

declare <vscale x 8 x i32> @llvm.vp.bswap.nxv8i32(<vscale x 8 x i32>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i32> @vp_bswap_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; RV32-NEXT:    vsrl.vi v12, v8, 8, v0.t
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v12, v12, a0, v0.t
; RV32-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV32-NEXT:    vor.vv v12, v12, v16, v0.t
; RV32-NEXT:    vand.vx v16, v8, a0, v0.t
; RV32-NEXT:    vsll.vi v16, v16, 8, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    vor.vv v8, v8, v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; RV64-NEXT:    vsrl.vi v12, v8, 8, v0.t
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v12, v12, a0, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV64-NEXT:    vor.vv v12, v12, v16, v0.t
; RV64-NEXT:    vand.vx v16, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 8, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v8, v12, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i32> @llvm.vp.bswap.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

define <vscale x 8 x i32> @vp_bswap_nxv8i32_unmasked(<vscale x 8 x i32> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv8i32_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; RV32-NEXT:    vsrl.vi v12, v8, 8
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v12, v12, a0
; RV32-NEXT:    vsrl.vi v16, v8, 24
; RV32-NEXT:    vor.vv v12, v12, v16
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsll.vi v16, v16, 8
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv8i32_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; RV64-NEXT:    vsrl.vi v12, v8, 8
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vsrl.vi v16, v8, 24
; RV64-NEXT:    vor.vv v12, v12, v16
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsll.vi v16, v16, 8
; RV64-NEXT:    vsll.vi v8, v8, 24
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv8i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i32> @llvm.vp.bswap.nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i32> %v
}

declare <vscale x 16 x i32> @llvm.vp.bswap.nxv16i32(<vscale x 16 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i32> @vp_bswap_nxv16i32(<vscale x 16 x i32> %va, <vscale x 16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; RV32-NEXT:    vsrl.vi v16, v8, 8, v0.t
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v16, v16, a0, v0.t
; RV32-NEXT:    vsrl.vi v24, v8, 24, v0.t
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    vand.vx v24, v8, a0, v0.t
; RV32-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; RV64-NEXT:    vsrl.vi v16, v8, 8, v0.t
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vsrl.vi v24, v8, 24, v0.t
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    vand.vx v24, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 24, v0.t
; RV64-NEXT:    vor.vv v8, v8, v24, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 16 x i32> @llvm.vp.bswap.nxv16i32(<vscale x 16 x i32> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i32> %v
}

define <vscale x 16 x i32> @vp_bswap_nxv16i32_unmasked(<vscale x 16 x i32> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv16i32_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    lui a0, 16
; RV32-NEXT:    addi a0, a0, -256
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsrl.vi v24, v8, 24
; RV32-NEXT:    vor.vv v16, v16, v24
; RV32-NEXT:    vand.vx v24, v8, a0
; RV32-NEXT:    vsll.vi v24, v24, 8
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vor.vv v8, v8, v24
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv16i32_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    lui a0, 16
; RV64-NEXT:    addiw a0, a0, -256
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsrl.vi v24, v8, 24
; RV64-NEXT:    vor.vv v16, v16, v24
; RV64-NEXT:    vand.vx v24, v8, a0
; RV64-NEXT:    vsll.vi v24, v24, 8
; RV64-NEXT:    vsll.vi v8, v8, 24
; RV64-NEXT:    vor.vv v8, v8, v24
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv16i32_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 16 x i1> %head, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %v = call <vscale x 16 x i32> @llvm.vp.bswap.nxv16i32(<vscale x 16 x i32> %va, <vscale x 16 x i1> %m, i32 %evl)
  ret <vscale x 16 x i32> %v
}

declare <vscale x 1 x i64> @llvm.vp.bswap.nxv1i64(<vscale x 1 x i64>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i64> @vp_bswap_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a1, v0.t
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v10, v8, a2, v0.t
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v10, v10, a3, v0.t
; RV32-NEXT:    vor.vv v9, v10, v9, v0.t
; RV32-NEXT:    vsrl.vi v10, v8, 24, v0.t
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v10, v10, a4, v0.t
; RV32-NEXT:    vsrl.vi v11, v8, 8, v0.t
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v12, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v11, v11, v12, v0.t
; RV32-NEXT:    vor.vv v10, v11, v10, v0.t
; RV32-NEXT:    vor.vv v9, v10, v9, v0.t
; RV32-NEXT:    vsll.vx v10, v8, a1, v0.t
; RV32-NEXT:    vand.vx v11, v8, a3, v0.t
; RV32-NEXT:    vsll.vx v11, v11, a2, v0.t
; RV32-NEXT:    vor.vv v10, v10, v11, v0.t
; RV32-NEXT:    vand.vx v11, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v11, v11, 24, v0.t
; RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 8, v0.t
; RV32-NEXT:    vor.vv v8, v11, v8, v0.t
; RV32-NEXT:    vor.vv v8, v10, v8, v0.t
; RV32-NEXT:    vor.vv v8, v8, v9, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vand.vx v9, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v9, v9, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v10, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v10, v10, 8, v0.t
; RV64-NEXT:    vor.vv v9, v9, v10, v0.t
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v10, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v11, v8, a3, v0.t
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v11, v11, a4, v0.t
; RV64-NEXT:    vor.vv v10, v10, v11, v0.t
; RV64-NEXT:    vor.vv v9, v10, v9, v0.t
; RV64-NEXT:    vsrl.vx v10, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v11, v8, a4, v0.t
; RV64-NEXT:    vand.vx v11, v11, a3, v0.t
; RV64-NEXT:    vor.vv v10, v11, v10, v0.t
; RV64-NEXT:    vsrl.vi v11, v8, 24, v0.t
; RV64-NEXT:    vand.vx v11, v11, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v11, v0.t
; RV64-NEXT:    vor.vv v8, v8, v10, v0.t
; RV64-NEXT:    vor.vv v8, v9, v8, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 1 x i64> @llvm.vp.bswap.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}

define <vscale x 1 x i64> @vp_bswap_nxv1i64_unmasked(<vscale x 1 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv1i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vsrl.vx v9, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v10, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v10, v10, a3
; RV32-NEXT:    vor.vv v9, v10, v9
; RV32-NEXT:    vsrl.vi v10, v8, 24
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v10, v10, a4
; RV32-NEXT:    vsrl.vi v11, v8, 8
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v12, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v11, v11, v12
; RV32-NEXT:    vor.vv v10, v11, v10
; RV32-NEXT:    vor.vv v9, v10, v9
; RV32-NEXT:    vsll.vx v10, v8, a1
; RV32-NEXT:    vand.vx v11, v8, a3
; RV32-NEXT:    vsll.vx v11, v11, a2
; RV32-NEXT:    vor.vv v10, v10, v11
; RV32-NEXT:    vand.vx v11, v8, a4
; RV32-NEXT:    vsll.vi v11, v11, 24
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v11, v8
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv1i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vand.vx v9, v8, a1
; RV64-NEXT:    vsll.vi v9, v9, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsll.vi v10, v10, 8
; RV64-NEXT:    vor.vv v9, v9, v10
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v10, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v11, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v11, v11, a4
; RV64-NEXT:    vor.vv v10, v10, v11
; RV64-NEXT:    vor.vv v9, v10, v9
; RV64-NEXT:    vsrl.vx v10, v8, a2
; RV64-NEXT:    vsrl.vx v11, v8, a4
; RV64-NEXT:    vand.vx v11, v11, a3
; RV64-NEXT:    vor.vv v10, v11, v10
; RV64-NEXT:    vsrl.vi v11, v8, 24
; RV64-NEXT:    vand.vx v11, v11, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v11
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv1i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 1 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 1 x i1> %head, <vscale x 1 x i1> poison, <vscale x 1 x i32> zeroinitializer
  %v = call <vscale x 1 x i64> @llvm.vp.bswap.nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i1> %m, i32 %evl)
  ret <vscale x 1 x i64> %v
}

declare <vscale x 2 x i64> @llvm.vp.bswap.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i64> @vp_bswap_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsrl.vx v10, v8, a1, v0.t
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v12, v8, a2, v0.t
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v12, v12, a3, v0.t
; RV32-NEXT:    vor.vv v10, v12, v10, v0.t
; RV32-NEXT:    vsrl.vi v12, v8, 24, v0.t
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v12, v12, a4, v0.t
; RV32-NEXT:    vsrl.vi v14, v8, 8, v0.t
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v16, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v14, v14, v16, v0.t
; RV32-NEXT:    vor.vv v12, v14, v12, v0.t
; RV32-NEXT:    vor.vv v10, v12, v10, v0.t
; RV32-NEXT:    vsll.vx v12, v8, a1, v0.t
; RV32-NEXT:    vand.vx v14, v8, a3, v0.t
; RV32-NEXT:    vsll.vx v14, v14, a2, v0.t
; RV32-NEXT:    vor.vv v12, v12, v14, v0.t
; RV32-NEXT:    vand.vx v14, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v14, v14, 24, v0.t
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 8, v0.t
; RV32-NEXT:    vor.vv v8, v14, v8, v0.t
; RV32-NEXT:    vor.vv v8, v12, v8, v0.t
; RV32-NEXT:    vor.vv v8, v8, v10, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vand.vx v10, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v10, v10, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v12, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v12, v12, 8, v0.t
; RV64-NEXT:    vor.vv v10, v10, v12, v0.t
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v12, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v14, v8, a3, v0.t
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v14, v14, a4, v0.t
; RV64-NEXT:    vor.vv v12, v12, v14, v0.t
; RV64-NEXT:    vor.vv v10, v12, v10, v0.t
; RV64-NEXT:    vsrl.vx v12, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v14, v8, a4, v0.t
; RV64-NEXT:    vand.vx v14, v14, a3, v0.t
; RV64-NEXT:    vor.vv v12, v14, v12, v0.t
; RV64-NEXT:    vsrl.vi v14, v8, 24, v0.t
; RV64-NEXT:    vand.vx v14, v14, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v14, v0.t
; RV64-NEXT:    vor.vv v8, v8, v12, v0.t
; RV64-NEXT:    vor.vv v8, v10, v8, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 2 x i64> @llvm.vp.bswap.nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}

define <vscale x 2 x i64> @vp_bswap_nxv2i64_unmasked(<vscale x 2 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv2i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsrl.vx v10, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v12, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v12, v12, a3
; RV32-NEXT:    vor.vv v10, v12, v10
; RV32-NEXT:    vsrl.vi v12, v8, 24
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v12, v12, a4
; RV32-NEXT:    vsrl.vi v14, v8, 8
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v16, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v14, v14, v16
; RV32-NEXT:    vor.vv v12, v14, v12
; RV32-NEXT:    vor.vv v10, v12, v10
; RV32-NEXT:    vsll.vx v12, v8, a1
; RV32-NEXT:    vand.vx v14, v8, a3
; RV32-NEXT:    vsll.vx v14, v14, a2
; RV32-NEXT:    vor.vv v12, v12, v14
; RV32-NEXT:    vand.vx v14, v8, a4
; RV32-NEXT:    vsll.vi v14, v14, 24
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v14, v8
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv2i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vand.vx v10, v8, a1
; RV64-NEXT:    vsll.vi v10, v10, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v12, v8, a0
; RV64-NEXT:    vsll.vi v12, v12, 8
; RV64-NEXT:    vor.vv v10, v10, v12
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v12, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v14, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v14, v14, a4
; RV64-NEXT:    vor.vv v12, v12, v14
; RV64-NEXT:    vor.vv v10, v12, v10
; RV64-NEXT:    vsrl.vx v12, v8, a2
; RV64-NEXT:    vsrl.vx v14, v8, a4
; RV64-NEXT:    vand.vx v14, v14, a3
; RV64-NEXT:    vor.vv v12, v14, v12
; RV64-NEXT:    vsrl.vi v14, v8, 24
; RV64-NEXT:    vand.vx v14, v14, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v14
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vor.vv v8, v10, v8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv2i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 2 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 2 x i1> %head, <vscale x 2 x i1> poison, <vscale x 2 x i32> zeroinitializer
  %v = call <vscale x 2 x i64> @llvm.vp.bswap.nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i1> %m, i32 %evl)
  ret <vscale x 2 x i64> %v
}

declare <vscale x 4 x i64> @llvm.vp.bswap.nxv4i64(<vscale x 4 x i64>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i64> @vp_bswap_nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vsrl.vx v12, v8, a1, v0.t
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v16, v8, a2, v0.t
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v16, v16, a3, v0.t
; RV32-NEXT:    vor.vv v12, v16, v12, v0.t
; RV32-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v20, v16, a4, v0.t
; RV32-NEXT:    vsrl.vi v24, v8, 8, v0.t
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v16, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v24, v24, v16, v0.t
; RV32-NEXT:    vor.vv v20, v24, v20, v0.t
; RV32-NEXT:    vor.vv v12, v20, v12, v0.t
; RV32-NEXT:    vsll.vx v20, v8, a1, v0.t
; RV32-NEXT:    vand.vx v24, v8, a3, v0.t
; RV32-NEXT:    vsll.vx v24, v24, a2, v0.t
; RV32-NEXT:    vor.vv v20, v20, v24, v0.t
; RV32-NEXT:    vand.vx v24, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v24, v24, 24, v0.t
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 8, v0.t
; RV32-NEXT:    vor.vv v8, v24, v8, v0.t
; RV32-NEXT:    vor.vv v8, v20, v8, v0.t
; RV32-NEXT:    vor.vv v8, v8, v12, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vand.vx v12, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v12, v12, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v16, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 8, v0.t
; RV64-NEXT:    vor.vv v12, v12, v16, v0.t
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v16, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v20, v8, a3, v0.t
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v20, v20, a4, v0.t
; RV64-NEXT:    vor.vv v16, v16, v20, v0.t
; RV64-NEXT:    vor.vv v12, v16, v12, v0.t
; RV64-NEXT:    vsrl.vx v16, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v20, v8, a4, v0.t
; RV64-NEXT:    vand.vx v20, v20, a3, v0.t
; RV64-NEXT:    vor.vv v16, v20, v16, v0.t
; RV64-NEXT:    vsrl.vi v20, v8, 24, v0.t
; RV64-NEXT:    vand.vx v20, v20, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v20, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v12, v8, v0.t
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 4 x i64> @llvm.vp.bswap.nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}

define <vscale x 4 x i64> @vp_bswap_nxv4i64_unmasked(<vscale x 4 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv4i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vsrl.vx v12, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v16, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v16, v16, a3
; RV32-NEXT:    vor.vv v12, v16, v12
; RV32-NEXT:    vsrl.vi v16, v8, 24
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v16, v16, a4
; RV32-NEXT:    vsrl.vi v20, v8, 8
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v24, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v20, v20, v24
; RV32-NEXT:    vor.vv v16, v20, v16
; RV32-NEXT:    vor.vv v12, v16, v12
; RV32-NEXT:    vsll.vx v16, v8, a1
; RV32-NEXT:    vand.vx v20, v8, a3
; RV32-NEXT:    vsll.vx v20, v20, a2
; RV32-NEXT:    vor.vv v16, v16, v20
; RV32-NEXT:    vand.vx v20, v8, a4
; RV32-NEXT:    vsll.vi v20, v20, 24
; RV32-NEXT:    vand.vv v8, v8, v24
; RV32-NEXT:    vsll.vi v8, v8, 8
; RV32-NEXT:    vor.vv v8, v20, v8
; RV32-NEXT:    vor.vv v8, v16, v8
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv4i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vand.vx v12, v8, a1
; RV64-NEXT:    vsll.vi v12, v12, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsll.vi v16, v16, 8
; RV64-NEXT:    vor.vv v12, v12, v16
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v16, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v20, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v20, v20, a4
; RV64-NEXT:    vor.vv v16, v16, v20
; RV64-NEXT:    vor.vv v12, v16, v12
; RV64-NEXT:    vsrl.vx v16, v8, a2
; RV64-NEXT:    vsrl.vx v20, v8, a4
; RV64-NEXT:    vand.vx v20, v20, a3
; RV64-NEXT:    vor.vv v16, v20, v16
; RV64-NEXT:    vsrl.vi v20, v8, 24
; RV64-NEXT:    vand.vx v20, v20, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v20
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vor.vv v8, v12, v8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv4i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 4 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 4 x i1> %head, <vscale x 4 x i1> poison, <vscale x 4 x i32> zeroinitializer
  %v = call <vscale x 4 x i64> @llvm.vp.bswap.nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i1> %m, i32 %evl)
  ret <vscale x 4 x i64> %v
}

declare <vscale x 7 x i64> @llvm.vp.bswap.nxv7i64(<vscale x 7 x i64>, <vscale x 7 x i1>, i32)

define <vscale x 7 x i64> @vp_bswap_nxv7i64(<vscale x 7 x i64> %va, <vscale x 7 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv7i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 24
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 24 * vlenb
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsrl.vx v16, v8, a1, v0.t
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v24, v8, a2, v0.t
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v24, v24, a3, v0.t
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    slli a4, a4, 4
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 16
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v16, v16, a4, v0.t
; RV32-NEXT:    addi a5, sp, 16
; RV32-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsrl.vi v16, v8, 8, v0.t
; RV32-NEXT:    vsetvli a6, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a5), zero
; RV32-NEXT:    csrr a5, vlenb
; RV32-NEXT:    slli a5, a5, 3
; RV32-NEXT:    add a5, sp, a5
; RV32-NEXT:    addi a5, a5, 16
; RV32-NEXT:    vs8r.v v24, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; RV32-NEXT:    vsll.vx v24, v8, a1, v0.t
; RV32-NEXT:    vand.vx v16, v8, a3, v0.t
; RV32-NEXT:    vsll.vx v16, v16, a2, v0.t
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; RV32-NEXT:    vand.vx v16, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v16, v16, 24, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 8, v0.t
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    li a1, 24
; RV32-NEXT:    mul a0, a0, a1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv7i64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    addi a2, sp, 16
; RV64-NEXT:    vs8r.v v16, (a2) # Unknown-size Folded Spill
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vand.vx v16, v8, a3, v0.t
; RV64-NEXT:    vsll.vx v16, v16, a4, v0.t
; RV64-NEXT:    vor.vv v16, v24, v16, v0.t
; RV64-NEXT:    addi a5, sp, 16
; RV64-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV64-NEXT:    vsrl.vx v24, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v16, v8, a4, v0.t
; RV64-NEXT:    vand.vx v16, v16, a3, v0.t
; RV64-NEXT:    vor.vv v24, v16, v24, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV64-NEXT:    vand.vx v16, v16, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v8, v24, v0.t
; RV64-NEXT:    addi a0, sp, 16
; RV64-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv7i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 7 x i64> @llvm.vp.bswap.nxv7i64(<vscale x 7 x i64> %va, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x i64> %v
}

define <vscale x 7 x i64> @vp_bswap_nxv7i64_unmasked(<vscale x 7 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv7i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsrl.vx v16, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v24, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v24, v24, a3
; RV32-NEXT:    vor.vv v16, v24, v16
; RV32-NEXT:    addi a4, sp, 16
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vi v24, v8, 24
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v0, v24, a4
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vv v16, v16, v24
; RV32-NEXT:    vor.vv v16, v16, v0
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vl8r.v v0, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v0
; RV32-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; RV32-NEXT:    vand.vx v0, v8, a3
; RV32-NEXT:    vsll.vx v0, v0, a2
; RV32-NEXT:    vsll.vx v16, v8, a1
; RV32-NEXT:    vor.vv v16, v16, v0
; RV32-NEXT:    vand.vv v24, v8, v24
; RV32-NEXT:    vand.vx v8, v8, a4
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vsll.vi v24, v24, 8
; RV32-NEXT:    vor.vv v8, v8, v24
; RV32-NEXT:    vor.vv v8, v16, v8
; RV32-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv7i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1
; RV64-NEXT:    vsll.vi v16, v16, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0
; RV64-NEXT:    vsll.vi v24, v24, 8
; RV64-NEXT:    vor.vv v16, v16, v24
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v0, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v0, v0, a4
; RV64-NEXT:    vor.vv v24, v24, v0
; RV64-NEXT:    vor.vv v16, v24, v16
; RV64-NEXT:    vsrl.vx v24, v8, a2
; RV64-NEXT:    vsrl.vx v0, v8, a4
; RV64-NEXT:    vand.vx v0, v0, a3
; RV64-NEXT:    vor.vv v24, v0, v24
; RV64-NEXT:    vsrl.vi v0, v8, 24
; RV64-NEXT:    vand.vx v0, v0, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v0
; RV64-NEXT:    vor.vv v8, v8, v24
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv7i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 7 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 7 x i1> %head, <vscale x 7 x i1> poison, <vscale x 7 x i32> zeroinitializer
  %v = call <vscale x 7 x i64> @llvm.vp.bswap.nxv7i64(<vscale x 7 x i64> %va, <vscale x 7 x i1> %m, i32 %evl)
  ret <vscale x 7 x i64> %v
}

declare <vscale x 8 x i64> @llvm.vp.bswap.nxv8i64(<vscale x 8 x i64>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i64> @vp_bswap_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 24
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 24 * vlenb
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsrl.vx v16, v8, a1, v0.t
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v24, v8, a2, v0.t
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v24, v24, a3, v0.t
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    slli a4, a4, 4
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 16
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v16, v16, a4, v0.t
; RV32-NEXT:    addi a5, sp, 16
; RV32-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsrl.vi v16, v8, 8, v0.t
; RV32-NEXT:    vsetvli a6, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a5), zero
; RV32-NEXT:    csrr a5, vlenb
; RV32-NEXT:    slli a5, a5, 3
; RV32-NEXT:    add a5, sp, a5
; RV32-NEXT:    addi a5, a5, 16
; RV32-NEXT:    vs8r.v v24, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; RV32-NEXT:    vsll.vx v24, v8, a1, v0.t
; RV32-NEXT:    vand.vx v16, v8, a3, v0.t
; RV32-NEXT:    vsll.vx v16, v16, a2, v0.t
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; RV32-NEXT:    vand.vx v16, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v16, v16, 24, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vl8r.v v24, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 8, v0.t
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 4
; RV32-NEXT:    add a0, sp, a0
; RV32-NEXT:    addi a0, a0, 16
; RV32-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    li a1, 24
; RV32-NEXT:    mul a0, a0, a1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    addi a2, sp, 16
; RV64-NEXT:    vs8r.v v16, (a2) # Unknown-size Folded Spill
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vand.vx v16, v8, a3, v0.t
; RV64-NEXT:    vsll.vx v16, v16, a4, v0.t
; RV64-NEXT:    vor.vv v16, v24, v16, v0.t
; RV64-NEXT:    addi a5, sp, 16
; RV64-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV64-NEXT:    vsrl.vx v24, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v16, v8, a4, v0.t
; RV64-NEXT:    vand.vx v16, v16, a3, v0.t
; RV64-NEXT:    vor.vv v24, v16, v24, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV64-NEXT:    vand.vx v16, v16, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v8, v24, v0.t
; RV64-NEXT:    addi a0, sp, 16
; RV64-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 8 x i64> @llvm.vp.bswap.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

define <vscale x 8 x i64> @vp_bswap_nxv8i64_unmasked(<vscale x 8 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bswap_nxv8i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsrl.vx v16, v8, a1
; RV32-NEXT:    li a2, 40
; RV32-NEXT:    vsrl.vx v24, v8, a2
; RV32-NEXT:    lui a3, 16
; RV32-NEXT:    addi a3, a3, -256
; RV32-NEXT:    vand.vx v24, v24, a3
; RV32-NEXT:    vor.vv v16, v24, v16
; RV32-NEXT:    addi a4, sp, 16
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vi v24, v8, 24
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vand.vx v0, v24, a4
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    addi a5, sp, 8
; RV32-NEXT:    vsetvli a6, zero, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a5), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vv v16, v16, v24
; RV32-NEXT:    vor.vv v16, v16, v0
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vl8r.v v0, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v0
; RV32-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; RV32-NEXT:    vand.vx v0, v8, a3
; RV32-NEXT:    vsll.vx v0, v0, a2
; RV32-NEXT:    vsll.vx v16, v8, a1
; RV32-NEXT:    vor.vv v16, v16, v0
; RV32-NEXT:    vand.vv v24, v8, v24
; RV32-NEXT:    vand.vx v8, v8, a4
; RV32-NEXT:    vsll.vi v8, v8, 24
; RV32-NEXT:    vsll.vi v24, v24, 8
; RV32-NEXT:    vor.vv v8, v8, v24
; RV32-NEXT:    vor.vv v8, v16, v8
; RV32-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bswap_nxv8i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1
; RV64-NEXT:    vsll.vi v16, v16, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0
; RV64-NEXT:    vsll.vi v24, v24, 8
; RV64-NEXT:    vor.vv v16, v16, v24
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v0, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v0, v0, a4
; RV64-NEXT:    vor.vv v24, v24, v0
; RV64-NEXT:    vor.vv v16, v24, v16
; RV64-NEXT:    vsrl.vx v24, v8, a2
; RV64-NEXT:    vsrl.vx v0, v8, a4
; RV64-NEXT:    vand.vx v0, v0, a3
; RV64-NEXT:    vor.vv v24, v0, v24
; RV64-NEXT:    vsrl.vi v0, v8, 24
; RV64-NEXT:    vand.vx v0, v0, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v0
; RV64-NEXT:    vor.vv v8, v8, v24
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv8i64_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 8 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 8 x i1> %head, <vscale x 8 x i1> poison, <vscale x 8 x i32> zeroinitializer
  %v = call <vscale x 8 x i64> @llvm.vp.bswap.nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i1> %m, i32 %evl)
  ret <vscale x 8 x i64> %v
}

; Test splitting. Use i16 version for easier check.
declare <vscale x 64 x i16> @llvm.vp.bswap.nxv64i16(<vscale x 64 x i16>, <vscale x 64 x i1>, i32)

define <vscale x 64 x i16> @vp_bswap_nxv64i16(<vscale x 64 x i16> %va, <vscale x 64 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    vmv1r.v v24, v0
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    srli a2, a1, 1
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    slli a1, a1, 2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v8, v16, 8, v0.t
; CHECK-NEXT:    vsll.vi v16, v16, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v16, v8, v0.t
; CHECK-NEXT:    addi a2, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a2) # Unknown-size Folded Spill
; CHECK-NEXT:    bltu a0, a1, .LBB32_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB32_2:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vsrl.vi v16, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv64i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vmv1r.v v24, v0
; CHECK-ZVBB-NEXT:    csrr a1, vlenb
; CHECK-ZVBB-NEXT:    srli a2, a1, 1
; CHECK-ZVBB-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-ZVBB-NEXT:    slli a1, a1, 2
; CHECK-ZVBB-NEXT:    sub a2, a0, a1
; CHECK-ZVBB-NEXT:    sltu a3, a0, a2
; CHECK-ZVBB-NEXT:    addi a3, a3, -1
; CHECK-ZVBB-NEXT:    and a2, a3, a2
; CHECK-ZVBB-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v16, v16, v0.t
; CHECK-ZVBB-NEXT:    bltu a0, a1, .LBB32_2
; CHECK-ZVBB-NEXT:  # %bb.1:
; CHECK-ZVBB-NEXT:    mv a0, a1
; CHECK-ZVBB-NEXT:  .LBB32_2:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vmv1r.v v0, v24
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8, v0.t
; CHECK-ZVBB-NEXT:    ret
  %v = call <vscale x 64 x i16> @llvm.vp.bswap.nxv64i16(<vscale x 64 x i16> %va, <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i16> %v
}

define <vscale x 64 x i16> @vp_bswap_nxv64i16_unmasked(<vscale x 64 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bswap_nxv64i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    addi a3, a3, -1
; CHECK-NEXT:    and a2, a3, a2
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v24, v16, 8
; CHECK-NEXT:    vsll.vi v16, v16, 8
; CHECK-NEXT:    vor.vv v16, v16, v24
; CHECK-NEXT:    bltu a0, a1, .LBB33_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB33_2:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v24, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v24
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vp_bswap_nxv64i16_unmasked:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    csrr a1, vlenb
; CHECK-ZVBB-NEXT:    slli a1, a1, 2
; CHECK-ZVBB-NEXT:    sub a2, a0, a1
; CHECK-ZVBB-NEXT:    sltu a3, a0, a2
; CHECK-ZVBB-NEXT:    addi a3, a3, -1
; CHECK-ZVBB-NEXT:    and a2, a3, a2
; CHECK-ZVBB-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v16, v16
; CHECK-ZVBB-NEXT:    bltu a0, a1, .LBB33_2
; CHECK-ZVBB-NEXT:  # %bb.1:
; CHECK-ZVBB-NEXT:    mv a0, a1
; CHECK-ZVBB-NEXT:  .LBB33_2:
; CHECK-ZVBB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vrev8.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <vscale x 64 x i1> poison, i1 true, i32 0
  %m = shufflevector <vscale x 64 x i1> %head, <vscale x 64 x i1> poison, <vscale x 64 x i32> zeroinitializer
  %v = call <vscale x 64 x i16> @llvm.vp.bswap.nxv64i16(<vscale x 64 x i16> %va, <vscale x 64 x i1> %m, i32 %evl)
  ret <vscale x 64 x i16> %v
}
